package com.bonc.xcloud.sp_procedure.frontend.xcloud;

import com.bonc.xcloud.sp_procedure.frontend.Parser;
import com.bonc.xcloud.sp_procedure.frontend.Token;
import com.bonc.xcloud.sp_procedure.message.Message;
import com.bonc.xcloud.sp_procedure.message.MessageType;

/**
 * 错误处理
 */
public class ErrorHandler {
	
	private static final int MAX_ERRORS = 2500000;//最大的错误数
	
	private int errorCount = 0;//错误的个数
	
	/**
	 * 标记一个错误行
	 * @param token 错误的token
	 * @param errorCode 错误的描述
	 * @param parser 语法解析器(借助其中的消息处理器广播错误消息)
	 */
	public void flag(Token token, ParserErrorCode errorCode, 
			Parser parser){
		//获取过程名称
		String name = "";
		if(parser.getSymTabStack().getProgramId()!=null){
			name = parser.getSymTabStack().getProgramId().getName();
		}
		//广播消息
		parser.sendMessage(new Message(MessageType.SYNTAX_ERROR,
				new Object[]{token.getLineNum(),
					token.getPosition(),
					token.getText(),
					errorCode.toString(),name}));
		//判断是否超过最大错误数,如果超过强制退出
		if(++errorCount > MAX_ERRORS){
			abortTranslation(ParserErrorCode.TOO_MANY_ERRORS, parser);
		}
	}

	/**
	 * 强制退出
	 */
	public void abortTranslation(ParserErrorCode errorCode, Parser parser){
		//广播消息 
		String fatalText = "FATAL Error: "+ errorCode.toString();
		parser.sendMessage(new Message(MessageType.SYNTAX_ERROR,
				new Object[]{0,0,"",fatalText}));
		System.exit(0);
	}

	public int getErrorCount() {
		return errorCount;
	}

	
	
	
	
	
	
}
