package com.bonc.xcloud.sp_procedure.frontend.xcloud;

import com.bonc.xcloud.sp_procedure.frontend.EofToken;
import com.bonc.xcloud.sp_procedure.frontend.Source;
import com.bonc.xcloud.sp_procedure.frontend.Token;


/**
 * "符号Token，支持""转义
 */
public class DoubleQuoteToken extends XcloudToken{
	
	public static int maxLength = 6000;
	public static final int maxVarcharLength = Integer.MAX_VALUE;
	
	public DoubleQuoteToken(Source source) throws Exception {
		super(source);
		 
	}
	
	@Override
	public void extract() throws Exception {
		
		StringBuilder textBuffer = new StringBuilder();
		StringBuilder valueBuffer = new StringBuilder();
		 
		char currentChar = nextChar(); 
		textBuffer.append('"');
		
		do{
			//处理字符串换行
			if(currentChar=='\n'){
				textBuffer.append(currentChar);
				valueBuffer.append(currentChar);
				currentChar = nextChar();
			}
			//处理空白符
//			if(Character.isWhitespace(currentChar)){
//				currentChar = ' ';
//			}
			
			//处理普通字符
			if((currentChar !='"'&&(currentChar != Source.EOF))){
				 textBuffer.append(currentChar);
				 valueBuffer.append(currentChar);
				 currentChar = nextChar();
			}
			
			//
			if(currentChar == '"'){//处理为""""的情况
				 while ((currentChar == '"') && (peekChar() == '"')) {
	                    textBuffer.append("\"\"");
	                    valueBuffer.append("\""); // append single-quote
	                    currentChar = nextChar(); // consume pair of quotes
	                    currentChar = nextChar();
	             }
			}
		}while((currentChar != '"') && (currentChar != Source.EOF));
		
		if(currentChar == '"'){
			nextChar();
			textBuffer.append('"');
			type = XcloudTokenType.DOUBLEQUOTE;
			value = valueBuffer.toString();
		}
		else{
			type = XcloudTokenType.ERROR;
			value = ParserErrorCode.UNEXPECTED_EOF;
		}
		
		text = textBuffer.toString();
		
	}
	
	
	public static void main(String[] args) throws Exception{
		
		String sourceText = "select \"\"\"\" from dual";
		
		XcloudLexer lexer = new XcloudLexer(sourceText);
		
		Token currentToken = lexer.nextToken();
		
		while(!(currentToken instanceof EofToken)){
			System.out.println("Text == "+currentToken.getText()
					+"; Type == "+currentToken.getType()
					+"; Value == "+currentToken.getValue()+";");
			currentToken = lexer.nextToken();
		}
		
		
		
	}

}
