package com.bonc.xcloud.sp_procedure.frontend;

/**
 * Lexer扫描返回的最小语法单元，也是个必不可少的框架类
 */
public class Token {
	
	protected String text;// 字面文本
	
	protected Object value;// 值，如果是一些常量，直接可以算出值来的
	
	private Source source;//源文件
	
	private int lineNum;// 所在行
	
	private int position;// Token第一个字符所在的位置，即行中列位置
	
	protected TokenType type;// 语言相关的Token类型 
	
	public Token(Source source) throws Exception{
		
		this.source = source;
		
		this.lineNum = source.getLineNum();
		
		this.position = source.getCurrentPos();
		
		extract();
	}
	
	 /**
	  * 抽取构造一个完整的Token,构造完成后,把位置游标前移一步。
	  * 这里只是把字母作为Token的内容,由不同语言的子类实现真正的构造
	  * @throws Exception
	  */
	public void extract() throws Exception{
		
		text = Character.toString(currentChar());
	    value = null;

	    nextChar();  // consume current character
		
	};
	
	/**
	 * @return 当前字符
	 * @throws Exception 
	 */
	public char currentChar() throws Exception{
		return source.currentChar();
	};
	
	/**
	 * @return 继续扫描,得到下一个字符
	 * @throws Exception 
	 */
	public char nextChar() throws Exception{
		return source.nextChar();
	};
	
	/**
	 * 位置游标不变,返回下一个字符
	 * @return 下一个字符
	 * @throws Exception 
	 */
	public char peekChar() throws Exception{
		return source.peekChar();
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public Object getValue() {
		return value;
	}

	public void setValue(Object value) {
		this.value = value;
	}

	public Source getSource() {
		return source;
	}

	public void setSource(Source source) {
		this.source = source;
	}

	public int getLineNum() {
		return lineNum;
	}

	public void setLineNum(int lineNum) {
		this.lineNum = lineNum;
	}

	public int getPosition() {
		return position;
	}

	public void setPosition(int position) {
		this.position = position;
	}

	public TokenType getType() {
		return type;
	}

	public void setType(TokenType type) {
		this.type = type;
	};
	
}
