package com.bonc.xcloud.sp_procedure.frontend;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import com.bonc.xcloud.sp_procedure.message.Message;
import com.bonc.xcloud.sp_procedure.message.MessageHandler;
import com.bonc.xcloud.sp_procedure.message.MessageListener;
import com.bonc.xcloud.sp_procedure.message.MessageType;

public class StringSource extends Source{
	
	private List<String> sourceStringList;// 拆分后的源String

	private String line;// 当前行内容
	
	private int lineNum;// 当前行号
	
	private int currentPos;// 当前位置
	
	public StringSource(String sourceString){
		
		this.lineNum = 0;
		this.currentPos = -2;
		this.sourceStringList = Arrays.asList(sourceString.split(EOL+""));
	}
	
	@Override
	public boolean checkEncode() throws Exception {
		
		return true;
	}
	
	/**
	 * @return 当前字符
	 */
	@Override
	public char currentChar()throws Exception{
		
		// 第一次读??
	    if (currentPos == -2) {
	        readLine();
	        return nextChar();
	    }
	
	    // 文件结束?
	    else if (line == null) {
	        return EOF;
	    }
	
	    // 行结束?
	    else if ((currentPos == -1) || (currentPos == line.length())) {
	        return EOL;
	    }
	
	    // 超过一行，换一行再读?
	    else if (currentPos > line.length()) {
	        readLine();
	        return nextChar();
	    }
	
	    // 正常读取当前行的某一列的字符.
	    else {
	        return line.charAt(currentPos);
	    }
		
	};
	
	/**
	 * @return 继续扫描,得到下一个字符
	 */
	@Override
	public char nextChar()throws Exception{
		
		++currentPos;
		return currentChar();
		
	};
	
	/**
	 * 查看下一个字符,并保持当前字符不变
	 * @return 下一个字符
	 * @throws Exception
	 */
	@Override
	public char peekChar()throws Exception{
	    currentChar();
	    if (line == null) {
	        return EOF;
	    }
	
	    int nextPos = currentPos + 1;
	    return nextPos < line.length() ? line.charAt(nextPos) : EOL;
	}
	
	
	/**
	 * 查看当前字符后第index字符,保持当前字符不变
	 */
	public char peekChar(int index) throws Exception{
		
		currentChar();
	    if (line == null) {
	        return EOF;
	    }
	
	    int nextPos = currentPos + index;
	    return nextPos < line.length() ? line.charAt(nextPos) : EOL;
	}
	
	/**
	 * 读取一行
	 * @throws IOException
	 */
	private void readLine()throws IOException{
		
		if(lineNum >= sourceStringList.size()){
			line = null;
		}else{
			line = sourceStringList.get(lineNum);
		}
	    currentPos = -1;
	
	    if (line != null) {
	        ++lineNum;
	    }
	    
	    //发送消息给监听器
	    if (line != null) {
	        sendMessage(new Message(MessageType.SOURCE_LINE,
	                                new Object[] {lineNum, line}));
	    }
	}
	
	@Override
	public void addMessageListener(MessageListener listener) {
		
		messageHandler.addMessageListener(listener);
		
	}
	
	@Override
	public void removeMessageListener(MessageListener listener) {
		
		messageHandler.removeMessageListener(listener);
		
	}
	
	@Override
	public void sendMessage(Message message) {
		
		messageHandler.sendMessage(message);
		
	}
	
	@Override
	public int getLineNum() {
		return lineNum;
	}
	
	@Override
	public void setLineNum(int lineNum) throws Exception {
		this.lineNum = lineNum;
		
	}
	
	@Override
	public int getCurrentPos() {
		return currentPos;
	}

	@Override
	public void setCurrentPos(int current) throws Exception {
		this.currentPos = current;
		
	}
	public List<String> getSourceStringList() {
		return sourceStringList;
	}

	public void setSourceStringList(List<String> sourceStringList) {
		this.sourceStringList = sourceStringList;
	}

	public String getLine() {
		return line;
	}
	
	public void setLine(String line) {
		this.line = line;
	}
	
	
	@Override
	public String getOriginalStr(int fromlineNum, int fromPos, int endLineNum,
			int endPos) {
		
		String originalStr = "";
		
		//只有一行
		if(fromlineNum == endLineNum){
			String lineStr = sourceStringList.get(fromlineNum-1);
			originalStr = lineStr.substring(fromPos, endPos+1);
		}
		//多行的
		else if(fromlineNum < endLineNum){
			
			for(int i=fromlineNum;i<=endLineNum;i++){
				
				//第一行
				if(i == fromlineNum){
					String lineStr = sourceStringList.get(fromlineNum-1);
					originalStr += lineStr.substring(fromPos)+"\n";
				}
				//最后一行
				else if(i == endLineNum){
					String lineStr = sourceStringList.get(endLineNum - 1);
					originalStr += lineStr.substring(0,endPos+1);
				}
				//中间部分
				else{
					String lineStr = sourceStringList.get(i-1);
					originalStr += lineStr + "\n";
				}
			}
		}
		//有问题的
		else{
			return "";
		}
		return originalStr;
	}
	
	
	public static void main(String[] args) throws Exception{
		
		String sourceString = "declare"+"\n"
								+"\n"
								+"\n"
								+"b int := 1;"+"\n"
								+"begin"+"\n"
								+"b := 3;"+"\n"
								+"procDemo(1,b);"+"\n"
								+"random_num();"+"\n"
								+"\n"  
								+"end;"+"\n";
		
		Source StringSource = new StringSource(sourceString);
		
		
		
		do{
//			System.out.print(StringSource.currentChar());
//			System.out.println(source.getLineNum()+" "+source.getCurrentPos());
			StringSource.nextChar();
		}while(StringSource.currentChar()!=StringSource.EOF);
		
		
		
		
		
		
		
	}
	
	
	
	
	
}
