package com.bonc.xcloud.sp_procedure.frontend;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;

import com.bonc.xcloud.sp_procedure.message.Message;
import com.bonc.xcloud.sp_procedure.message.MessageHandler;
import com.bonc.xcloud.sp_procedure.message.MessageListener;
import com.bonc.xcloud.sp_procedure.message.MessageProducer;

public abstract class Source implements MessageProducer{
	
	public static final String fileSource = "FILE";
	public static final String stringSource = "STRING";
	
	public static final char EOL = '\n';      // 行结束符
    public static final char EOF = (char) 0;   //文件结束标识
    protected  MessageHandler messageHandler;// 消息处理器
    
    public static final String ENCODING = "UTF-8";//编码格式
    
    /**
     * 构造一个source
     * @param type source类型,可能是文件,也可能是个字符串
     * @param content 如果为文件,为在文件路径,如果为字符串,为字符串
     */
//    public static Source newInstance(String type,String content,MessageHandler messageHandler)throws Exception{
//    	
//    	if(type != null && type.equals(fileSource)){
//
//    		File file = new File(content);
//    		BufferedReader reader = new BufferedReader(
//					new InputStreamReader(new FileInputStream(file),"utf-8"));
//    		FileSource fileSource = new FileSource(reader);
//    		fileSource.setMessageHandler(messageHandler);
//    		if(!fileSource.checkEncode())
//    			throw new Exception("Coding format error");
//    		return fileSource;
//    	}
//    	
//    	if(type != null && type.equals(stringSource)){
//    		
//    		StringSource stringSource = new StringSource(content);
//    		stringSource.setMessageHandler(messageHandler);
//    		if(!stringSource.checkEncode())
//    			throw new Exception("Coding format error");
//    		return stringSource;
//    	}
//    	
//    	return null;
//    }
	
    /**
     * 构造一个source
     * @param type source类型,现在只能是字符串类型
     * @param content 如果为文件,为在文件路径,如果为字符串,为字符串
     */
    public static Source newInstance(String type,String content,MessageHandler messageHandler)throws Exception{
    	
    	if(type != null && type.equals(stringSource)){
    		
    		StringSource stringSource = new StringSource(content);
    		stringSource.setMessageHandler(messageHandler);
    		if(!stringSource.checkEncode())
    			throw new Exception("Coding format error");
    		return stringSource;
    	}
    		
    	return null;
    	
    }
    
    
    /**
     * 检查编码格式
     */
    public abstract boolean checkEncode() throws Exception;
    
	/**
	 * 获取当前字符
	 */
	public abstract char currentChar()throws Exception;
	
	/**
	 * 获取下一个字符
	 */
	public abstract char nextChar()throws Exception;
	
	/**
	 * 查看下一个字符,并保持当前字符不变
	 */
	public abstract char peekChar()throws Exception;
	
	/**
	 * 查看当前字符后第index字符,保持当前字符不变
	 */
	public abstract char peekChar(int index) throws Exception;
	
	/**
	 * 获取当前行内容
	 */
	public abstract String getLine() throws Exception;
	
	/**
	 * 设置当前行内容
	 */
	public abstract void setLine(String line) throws Exception;
	
	/**
	 * 获取当前行号
	 */
	public abstract int getLineNum() throws Exception;
	
	/**
	 * 设置当前行号
	 */
	public abstract void setLineNum(int lineNum) throws Exception;
	
	/**
	 * 获取当前位置
	 */
	public abstract int getCurrentPos() throws Exception;
	
	public MessageHandler getMessageHandler() {
		return messageHandler;
	}

	public void setMessageHandler(MessageHandler messageHandler) {
		this.messageHandler = messageHandler;
	}

	/**
	 * 设置当前位置
	 */
	public abstract void setCurrentPos(int current) throws Exception;
	
	@Override
	public void addMessageListener(MessageListener listener) {
		
		messageHandler.addMessageListener(listener);
		
	}

	@Override
	public void removeMessageListener(MessageListener listener) {
		
		messageHandler.removeMessageListener(listener);
		
	}

	@Override
	public void sendMessage(Message message) {
		
		messageHandler.sendMessage(message);
		
	}

	
	/**
	 * 获取源码片段，行号从1开始，位置从0开始，前后包含
	 */
	public abstract String getOriginalStr(int fromlineNum,int fromPos,int endLineNum,int endPos);
}
