package com.bonc.xcloud.sp_procedure.frontend;

import com.bonc.xcloud.sp_procedure.intermediate.SymTabStack;
import com.bonc.xcloud.sp_procedure.message.Message;
import com.bonc.xcloud.sp_procedure.message.MessageHandler;
import com.bonc.xcloud.sp_procedure.message.MessageListener;
import com.bonc.xcloud.sp_procedure.message.MessageProducer;

/**
 * 语言无关的Parser，有子类完成具体语言解析
 * 实现消息产生器接口
 */
public abstract class Parser implements MessageProducer{
	
//	protected static ICode iCode;// 语法树根节点
	
	protected SymTabStack symTabStack;// 生成的符号表栈
	
	protected Lexer lexer;// 扫描器Lexer，Parser找它要token
	
	protected  MessageHandler messageHandler ;// 消息处理器
	
//	static {
//		symTabStack = SymTabFactory.createSymTabStack();
//		messageHandler = new MessageHandler();
//	}
	
	public Parser(Lexer lexer){
		super();
		this.lexer = lexer;
	}
	
	/**
	 * 交由子类完成具体语言相关的解析过程，这个方法调用之后将会产生符号表和中间码iCode。
	 * @throws Exception
	 */
	public abstract void parse()throws Exception;
	
	/**
	 * @return 解析过程中的错误数
	 */
	public abstract int getErrorCount();
	
	/**
	 * @return 当前的Token
	 */
	public Token currentToken(){
		return lexer.currentToken();
	};
	
	/**
	 * @return 继续扫描,得到下一个Token
	 */
	public Token nextToken() throws Exception{
		return lexer.nextToken();
	}
	
	/**
	 * 读取下一个token,保持位置不变
	 */
	public Token peekToken() throws Exception{
		return lexer.peekToken();
	}

	/**
	 * 读取后面第 index 个token,保持位置不变
	 */
	public Token peekToken(int index) throws Exception{
		return lexer.peekToken(index);
	}
	
	@Override
	public void addMessageListener(MessageListener listener) {
		
		messageHandler.addMessageListener(listener);
		
	}
	
	@Override
	public void removeMessageListener(MessageListener listener) {
		
		messageHandler.removeMessageListener(listener);
		
	}
	
	@Override
	public void sendMessage(Message message) {
		
		messageHandler.sendMessage(message);
		
	}
	
	public Lexer getLexer() {
		return lexer;
	}

	public void setLexer(Lexer lexer) {
		this.lexer = lexer;
	}

	public MessageHandler getMessageHandler() {
		return messageHandler;
	}

	public void setMessageHandler(MessageHandler messageHandler) {
		this.messageHandler = messageHandler;
	}

	public SymTabStack getSymTabStack() {
		return symTabStack;
	}

	public void setSymTabStack(SymTabStack symTabStack) {
		this.symTabStack = symTabStack;
	}

//	public static ICode getiCode() {
//		return iCode;
//	}
//
//	public static void setiCode(ICode iCode) {
//		Parser.iCode = iCode;
//	}

	
	
	
	
	
}
