package com.bonc.xcloud.sp_procedure.frontend;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

import com.bonc.xcloud.sp_procedure.message.Message;
import com.bonc.xcloud.sp_procedure.message.MessageHandler;
import com.bonc.xcloud.sp_procedure.message.MessageListener;
import com.bonc.xcloud.sp_procedure.message.MessageType;

/**
 * 此框架类的每个对象代表一个源文件
 * 实现消息产生器接口
 */
public class FileSource extends Source{
	
	private BufferedReader reader;// 源文件reader
	
	private String line;// 当前行内容
	
	private int lineNum;// 当前行号
	
	private int currentPos;// 当前位置
	
	
	public FileSource(BufferedReader reader){
		
		this.lineNum = 0;
		this.currentPos = -2;
		this.reader = reader;
	}
	
	@Override
	public boolean checkEncode() throws Exception {
		
		return true;
	}
	
	
	/**
	 * @return 当前字符
	 */
	@Override
	public char currentChar()throws Exception{
		
		// 第一次读??
        if (currentPos == -2) {
            readLine();
            return nextChar();
        }

        // 文件结束?
        else if (line == null) {
            return EOF;
        }

        // 行结束?
        else if ((currentPos == -1) || (currentPos == line.length())) {
            return EOL;
        }

        // 超过一行，换一行再读?
        else if (currentPos > line.length()) {
            readLine();
            return nextChar();
        }

        // 正常读取当前行的某一列的字符.
        else {
            return line.charAt(currentPos);
        }
		
	};
	
	/**
	 * @return 继续扫描,得到下一个字符
	 */
	@Override
	public char nextChar()throws Exception{
		
		++currentPos;
		return currentChar();
		
	};
	
	/**
	 * 查看下一个字符,并保持当前字符不变
	 * @return 下一个字符
	 * @throws Exception
	 */
	@Override
	public char peekChar()throws Exception{
        currentChar();
        if (line == null) {
            return EOF;
        }

        int nextPos = currentPos + 1;
        return nextPos < line.length() ? line.charAt(nextPos) : EOL;
	}
	
	
	/**
	 * 查看当前字符后第index字符,保持当前字符不变
	 */
	public char peekChar(int index) throws Exception{
		
		currentChar();
        if (line == null) {
            return EOF;
        }

        int nextPos = currentPos + index;
        return nextPos < line.length() ? line.charAt(nextPos) : EOL;
	}

	
	/**
	 * 读取一行
	 * @throws IOException
	 */
	private void readLine()throws IOException{
		 
        line = reader.readLine();  
        currentPos = -1;

        if (line != null) {
            ++lineNum;
        }
        
        //发送消息给监听器
        if (line != null) {
            sendMessage(new Message(MessageType.SOURCE_LINE,
                                    new Object[] {lineNum, line}));
        }
	}
	
	@Override
	public void addMessageListener(MessageListener listener) {
		
		messageHandler.addMessageListener(listener);
		
	}

	@Override
	public void removeMessageListener(MessageListener listener) {
		
		messageHandler.removeMessageListener(listener);
		
	}

	@Override
	public void sendMessage(Message message) {
		
		messageHandler.sendMessage(message);
		
	}
	
	
	
	
	
	@Override
	public int getLineNum() {
		return lineNum;
	}
	
	@Override
	public void setLineNum(int lineNum) throws Exception {
		this.lineNum = lineNum;
		
	}
	
	
	@Override
	public int getCurrentPos() {
		return currentPos;
	}
	
	@Override
	public void setCurrentPos(int current) throws Exception {
		this.currentPos = current;
		
	}
	
	public BufferedReader getReader() {
		return reader;
	}

	public void setReader(BufferedReader reader) {
		this.reader = reader;
	}

	public String getLine() {
		return line;
	}

	public void setLine(String line) {
		this.line = line;
	}
	
	@Override
	public String getOriginalStr(int fromlineNum, int fromPos, int endLineNum,
			int endPos) {
		// TODO 自动生成的方法存根
		return "";
	}

	public static void main(String[] args) throws Exception{
//		
		BufferedReader reader =  new BufferedReader(
				new FileReader(
						new File("C:\\Documents and Settings\\Administrator\\桌面\\windows.txt")));
		FileSource source = new FileSource(reader);
		
		do{
//			System.out.print(source.currentChar());
//			System.out.println(source.getLineNum()+" "+source.getCurrentPos());
			source.nextChar();
		}while(source.currentChar()!=source.EOF);
		
//		System.out.println(Character.isWhitespace());
		
	}
	

}
