package com.bonc.xcloud.sp_procedure.base;

/**
 * 错误码段 0x130000-0x130FFF
 *
 */
public enum ErrorCode {
	// 存储过程使用的错误码范围: 0x130000 ~ 0x140000
	//	0x130000 ~ 0x131FFF 用这个
	//	0x132000 ~ 0x133FFF TaskManager用这个
	//	0x134000 ~ 0x140000 晓远用这个
	// TStatus ~   4: optional i32 error_code    // internal error code
	
	UNKNOWN(0x130000,"unknown error"),
	CONNECTION_USED_UP(0x130001,"connection used up"),
	SYNTAXTREE_PARSE_ERROR(0x130002,"parse syntaxtree error"),
	CONNECTION_CLOSED(0x130003,"connection for call procedure has been closed"),
	
	CALL_EXECUTE_TIMES(0x130004,"call funcation execute times"),
	NODE_INFO_ERROR(0x130005,"get the node infomation error"),
	PARSE_CALL_PROCEDURE_ERROR(0x130006,"invalid plsql statement"),
	PLSQL_ERROR(0x130007,"plsql exception"),
	QUERY_ERROR(0x130008,"query state error"),
	TASK_EXECUTE_ERROR(0x130009,"execute task exception"),
	CONNECTION_INTERRUPT(0x13000A,"connection interrupt"),
	
	//执行过程
	Storage_error(0x13000B,"Storage_error"),
	Program_error(0x13000C,"Program_error"),
	Rowtype_mismatch(0x13000D,"Rowtype_mismatch"),
	CURSOR_already_OPEN(0x13000E,"CURSOR_already_OPEN"),
	Access_INTO_null(0x13000F,"Access_INTO_null"),
	Collection_is_null(0x130010,"Collection_is_null"),
	Subscript_outside_limit(0x130011,"Subscript_outside_limit"),
	Subscript_beyond_count(0x130012,"Subscript_beyond_count"),
	LENGTH_TOO_LONG(0x130013,"Length_too_long"),
	Function_not_return(0x130014,"No_return_value"),
	TYPE_MISMATCH(0x130015,"Type_mismatch"),
	EXECUTE_IMMEDIATE_SQL_ERROR(0x130016,"Dynamic_SQL_ERROR"),
	EXECUTE_IMMEDIATE_ARGUMENT_MISMATH(0x130017,"Argument_mismatch"),
	PARAMETER_CHECKOUT_ERROR(0x130018,"Parameter_checkout_error"),
	Invalid_NUMBER(0x130019,"Invalid_NUMBER"),
	Zero_divide(0x13001A,"Zero_divide"),
	Too_many_rows(0x13001B,"Too_many_rows"),
	No_data_found(0x13001C,"No_data_found"),
	Invalid_CURSOR(0x13001D,"Invalid_CURSOR"),
	PARSE_ERROR(0x13001E,"Parse_error"),
	OTHERS(0x13001F,"OTHERS"),
	TooManyLocalCursor_ERROR(0x130020,"Too_Many_Local_Cursor"),
	TooManyGlobalCursor_ERROR(0x130021,"Too_Many_Global_Cursor"),
	ZeroNumCursor_ERROR(0x130022,"Zero_num_cursor"),
	XCloudIpNotExists_ERROR(0x130023,"Xcloud_ip_not_exists"),
	dbConfigurationParameter_ERROR(0x130024,"DbConfiguration_parameter_error"),
	//考虑到更新异常的时候，为了避免对ErrorCode的频繁修改
	//对每一个类型的异常分配一段异常码片段，增加新的异常，只需改所属片段就可以了
	
	
	
	NOTFOUNDCFGFILE_ERROR(0x131000,"not found the configuration file"),
	INVALIDCFGFILE_ERROR(0x131001,"invalid configuration file"),
	OBJECTISNULL_ERROR(0x131002,"not instantiate the object"),
	INVALIDPORT_ERROR(0x131003,"invalid port"),
	ILLEGALARGUMENT_ERROR(0x131004,"illegal parameter exception"),
	EMPTYPARAMETER_ERROR(0x131005,"empty parameter exception"),
	GETMETADATA_ERROR(0x131006,"get metadata exception"),
	SAVEORUPDATEMETADATA_ERROR(0x131007,"save or update metadata exception"),
	DELMETADATA_ERROR(0x131008,"delete metadata exception"), 
	TIMEOUT_ERROR(0x131009,"timeout exception"), 
	GETRESULTSETMETADATA_ERROR(0x13100A,"get resultset_metadata exception"),
	PARAMETERTYPE_ERROR(0x13100B,"parameter type exception"),
	RESULTMISS_ERROR(0x13100C,"missing result exception"),
	DATACODE_ERROR(0x13100D,"data compression exception"),
	//DATADECODE_ERROR(0x131013,"data compression exception"),
	CLOSE_ERROR(0x13100E,"close exception"),
	CANCELLD_ERROR(0x13100F,"cancel task exception"),
	REDOTASK_ERROR(0x131010,"redo task exception"),
	NOTFOUNDHOST_ERROR(0x131011,"can not found executable  node"), 
	CLASSNOFOUND_ERROR(0x131012,"the driver class not found exception"),
	APPRUNTIME_ERROR(0x131013,"app runtime exception"),
	GETCONNECTION_ERROR(0x131014,"the url,username or password error exception"),
	UNSUPPORTEDENCODING_ERROR(0x131015,"the file not support encoding "),
	DOCUMENT_ERROR(0x131016,"read inputstream error exception"),
	WRITEIO_ERROR(0x131017,"written to the file exception"),
	TASK_MISSING(0x131018,"task missing"),
	SSH_ERROR(0x131019,"SSH exception"),
	SPSemantics_ERROR(0x13101A,"storeProcedure semantics exception"),
	MapRemove_ERROR(0x13101B,"map remove task exception"),
	WorkPoolOrTaskMapIsNull_ERROR(0x13101C,"workPool or taskMap is null"),

	
	
	
	//Redis 异常码 0x131110 --- 0x131120
	REDISINTERRUPTED_ERROR(0x131110,"redis interrupted exception"),
	REDISCONNECTIONREFUSE_ERROR(0x131111,"redis connection refuse exception"),
	REDISTIMEOUT_ERROR(0x131112,"redis timeout exception"),
	REDISILLEGALARGUMENT_ERROR(0x131113,"redis illegal parameter exception"),
	REDISKEYNOTEXISTS_ERROR(0x131114,"redis key not exists exception"),
	REDISJSONTRANS_ERROR(0x131115,"redis json transform exception"),
	//zookeeper 异常码 0x131130 --- 0x131140
	ZKINTERRUPTED_ERROR(0x131130,"zookeeper interrupted exception"),
	ZKIO_ERROR(0x131131,"zookeeper io exception"),
	ZKTIMEOUT_ERROR(0x131132,"zookeeper timeout exception"),
	ZKEMPTYPARAMETER_ERROR(0x131133,"zookeeper empty parameter exception"),
	ZKRUNTIME_ERROR(0x131134,"the application is running exception"),
	ZKUNSUPPORTEDENCODING_ERROR(0x131135,"zookeeper encoding exception"),
	ZKILLEGALARGUMENT_ERROR(0x131136,"zookeeper illegal parameter exception"),
	ZKEEPER_ERROR(0x131137,"zookeeper error"),
	//hdfs异常码 0x131150 --- 0x131160
	HDFSILLEGALARGUMENT_ERROR(0x131150,"hdfs illegal parameter exception"),
	HDFSIO_ERROR(0x131151,"hdfs io exception"),
	HDFSUNSUPPORTEDENCODING_ERROR(0x131152,"hdfs encoding exception"),
	HDFSFILENOTFOUND_ERROR(0x131153,"hdfs file not found exception");
	
	
	private int errorcode;
	private String detailMessage;
	private ErrorCode(int error_code,String message) {
	  this.errorcode = error_code;
	  this.detailMessage = message;
	}
	public int getErrorCode(){
		return errorcode;
	}
	public String getHexErrorCode() {
		return "0x"+Integer.toHexString(errorcode);
	}
	public String getMessage() {
		return "[base]"+getHexErrorCode()+":"+detailMessage;
	}
	public String getDetailMessage() {
		return detailMessage;
	}
	
}