package com.bonc.xcloud.sp_procedure.base;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public abstract class DBObject implements Serializable,Cloneable
{
	
	private  PropertyChangeSupport listeners = new PropertyChangeSupport(this);

	private String name;
	
	private String ID;
	
	private String createTime;
	
	private String createUser;
	
	
	private String comment;
	
	protected Object parent;

	
	public Object getParent() {
		return parent;
	}




	public void setParent(Object parent) {
		this.parent = parent;
	}




	/*public boolean equals(Object obj)
	{
		boolean ret = false;
		if(obj != null && obj instanceof DBObject)
		{
			DBObject tmp = (DBObject) obj;
			ret = this.ID == null ? false:this.ID.equals(tmp.getID()); 
		}
		return ret;
	}
*/



	public String getName() {
		return name;
	}




	public void setName(String name) {
		this.name = name;
	}




	public String getID() {
		return ID;
	}




	public void setID(String iD) {
		ID = iD;
	}




	public String getCreateTime() {
		return createTime;
	}




	public void setCreateTime(String createTime) {
		this.createTime = createTime;
	}




	public String getCreateUser() {
		return createUser;
	}




	public void setCreateUser(String createUser) {
		this.createUser = createUser;
	}




	public String getComment() {
		return comment;
	}




	public void setComment(String comment) {
		this.comment = comment;
	}
	public DBObject()
	{
	}

	public void addPropertyChangeListener(PropertyChangeListener l)
	{
		listeners.addPropertyChangeListener(l);
	}

	public void removePropertyChangeListener(PropertyChangeListener l)
	{
		listeners.removePropertyChangeListener(l);
	}
	
	protected void firePropertyChange(String prop, Object old, Object newValue)
	{
		listeners.firePropertyChange(prop, old, newValue);
	}	
	
	@Override
	public DBObject clone() {
		DBObject clone = null;
		try {
			clone = (DBObject) super.clone();

			clone.listeners = new PropertyChangeSupport(clone);

		} catch (CloneNotSupportedException e) {
		}

		return clone;
	}
	
}
