package com.bonc.xcloud.sp_procedure.base;

public class DBConfiguration extends DBObject {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String dbUrl;

	private String userName;

	private String password;

	private String host;

	private int port;
	private String spIpAndPort;
	private int spPort;
	private String dbName;

	private String localName;

	private String dbType;
	private String dbDriver;

	private String memorySpace;

	// private int connectRetry;
	//
	// private int socketTimeOut;

	private String connectDirect;

	public String getLocalName() {

		return localName;
	}

	public void setLocalName(String localName) {
		this.localName = localName;
	}

	public DBConfiguration() {

	}

	public DBConfiguration(String dbType,String dbName,String host,int port,String spIpAndPort,String userName,String password,String connectDirect,
			String memorySpace) {
		this.dbType = dbType;
		this.userName = userName;
		this.password = password;
		this.dbName = dbName;
		this.host = host;
		this.port = port;
		this.spIpAndPort = spIpAndPort;
		this.connectDirect = connectDirect;
		this.memorySpace = memorySpace;
		if(host.equals("")||host==null){
			String spUrlStr = "";
			if(spIpAndPort.contains(",")){
				String[] spIpSplit = spIpAndPort.split(",");
				StringBuilder sp = new StringBuilder();
				for(String spIp:spIpSplit){
					sp.append("@").append(spIp).append("/").append(dbName);;
				}
				spUrlStr = sp.toString();
			}else{
				spUrlStr = "@"+spIpAndPort+"/"+dbName;
			}
		this.dbUrl ="jdbc:sp:"
				+spUrlStr;
		this.dbDriver = "com.bonc.xcloud.sp.jdbc.XCloudSPDriver";
		}else if(spIpAndPort.equals("")||spIpAndPort==null){
			String[] hostSplit = host.split(",");
			if (hostSplit.length == 1) {
			this.dbUrl = "jdbc:xcloud:@"
					+ host
					+ ":"
					+ port
					+ "/"
					+ dbName
					+ "?"
					+ "socketTimeOut=43200000";
			this.dbDriver = "com.bonc.xcloud.sp.jdbc.XCloudSPDriver";
			}else if (hostSplit.length > 1) {
				StringBuilder sb = new StringBuilder();
				sb.append("jdbc:xcloud:");
				for (String hostStr : hostSplit) {
					sb.append("@").append(hostStr).append(":").append(port)
							.append("/").append(dbName);
				}
				sb.append("?");
				sb.append("socketTimeOut=43200000");
				String urlStr = sb.toString();
				this.dbUrl = urlStr;
				this.dbDriver = "com.bonc.xcloud.sp.jdbc.XCloudSPDriver";
			}
		
		
		}else{
			String[] hostSplit = host.split(",");
			if (hostSplit.length == 1) {
				String spUrlStr = "";
				if(spIpAndPort.contains(",")){
					String[] spIpSplit = spIpAndPort.split(",");
					StringBuilder sp = new StringBuilder();
					for(String spIp:spIpSplit){
						sp.append("@").append(spIp).append("/").append(dbName);;
					}
					spUrlStr = sp.toString();
				}else{
					spUrlStr = "@"+spIpAndPort+"/"+dbName;
				}
			this.dbUrl = "jdbc:xcloud:@"
					+ host
					+ ":"
					+ port
					+ "/"
					+ dbName
					+ "?"
					+ "socketTimeOut=43200000"
					+"|jdbc:sp:"
					+spUrlStr;
			this.dbDriver = "com.bonc.xcloud.sp.jdbc.XCloudSPDriver";
			}else if (hostSplit.length > 1) {
				StringBuilder sb = new StringBuilder();
				sb.append("jdbc:xcloud:");
				for (String hostStr : hostSplit) {
					sb.append("@").append(hostStr).append(":").append(port)
							.append("/").append(dbName);
				}
				sb.append("?");
				sb.append("socketTimeOut=43200000");
				sb.append("|jdbc:sp:");
				if(spIpAndPort.contains(",")){
					String[] spIpSplit = spIpAndPort.split(",");
					for(String spIp:spIpSplit){
						sb.append("@").append(spIp).append("/").append(dbName);;
					}
				}else{
					sb.append("@").append(spIpAndPort).append("/").append(dbName);;
				}
				String urlStr = sb.toString();
				this.dbUrl = urlStr;
				this.dbDriver = "com.bonc.xcloud.sp.jdbc.XCloudSPDriver";
			}
		}
		
	
	}
	public DBConfiguration(String dbType, String dbName, String host, int port,
			String userName, String password, String connectDirect,
			String memorySpace) {
		this.dbType = dbType;
		this.dbName = dbName;
		this.host = host;
		this.port = port;
		this.userName = userName;
		this.password = password;
		// this.connectRetry=connectRetry;
		// this.socketTimeOut=socketTimeOut;
		this.connectDirect = connectDirect;
		this.memorySpace = memorySpace;
		String[] hostSplit = host.split(",");
		if (dbType.equalsIgnoreCase("ORACLE")) {
			this.dbUrl = "jdbc:oracle:thin:@" + host + ":" + port + ":"
					+ dbName;
			this.dbDriver = "oracle.jdbc.driver.OracleDriver";
		} else if (dbType.equalsIgnoreCase("XCLOUD")) {

			if (hostSplit.length == 1) {
				this.dbUrl = "jdbc:xcloud:@"
						+ host
						+ ":"
						+ port
						+ "/"
						+ dbName
						+ "?"
						+ "connectRetry=3&socketTimeOut=43200000&connectDirect="
						+ connectDirect
						+ "&buffMemory="
						+ Integer.parseInt(memorySpace.substring(0,
								memorySpace.length() - 1)) * 1024 * 1024;
				this.dbDriver = "com.bonc.xcloud.jdbc.XCloudDriver";
			} else if (hostSplit.length > 1) {
				StringBuilder sb = new StringBuilder();
				sb.append("jdbc:xcloud:");
				for (String hostStr : hostSplit) {
					sb.append("@").append(hostStr).append(":").append(port)
							.append("/").append(dbName);
				}
				sb.append("?");
				sb.append("connectRetry=").append("3");
				sb.append("&socketTimeOut=").append("43200000");
				sb.append("&connectDirect=").append(connectDirect);
				sb.append("&buffMemory=").append(
						Integer.parseInt(memorySpace.substring(0,
								memorySpace.length() - 1)) * 1024 * 1024);
				// sb.append("?connectRetry=3&socketTimeOut=1000&connectDirect=true");

				String urlStr = sb.toString();
				this.dbUrl = urlStr;
				this.dbDriver = "com.bonc.xcloud.jdbc.XCloudDriver";
			}

		} else if (dbType.equalsIgnoreCase("MYSQL")) {
			this.dbUrl = "jdbc:mysql://" + host + ":" + port + "/" + dbName
					+ "?useUnicode=false&characterEncoding=UTF-8";
			this.dbDriver = "com.mysql.jdbc.Driver";
		} else if (dbType.equalsIgnoreCase("db2")) {
			this.dbUrl = "jdbc:db2://" + host + ":" + port + "/" + dbName;
			this.dbDriver = "com.ibm.db2.jcc.DB2Driver";

		} else if (dbType.equalsIgnoreCase("SYSBASE")) {
			this.dbUrl = "jdbc:sybase:Tds:" + host + ":" + port + "/" + dbName;
			this.dbDriver = "com.sybase.jdbc2.jdbc.SybDriver";
		} else if (dbType.equalsIgnoreCase("HIVE")) {
			if(dbName==""||dbName==null||dbName.equals("")){
				dbName = "default";
			}
			this.dbUrl = "jdbc:hive2://" + host + ":" + port + "/" + dbName;
			this.dbDriver = "org.apache.hive.jdbc.HiveDriver";
		} else if (dbType.equalsIgnoreCase("H2")) {
			this.dbUrl = "jdbc:h2:tcp://" + host + "/./PLSQL";
			this.dbDriver = "org.h2.Driver";
		}

	}

	public DBConfiguration(String dbType, String dbDriver, String dbUrl,
			String userName, String password) {

		this.dbType = dbType;
		this.dbDriver = dbDriver;
		this.dbUrl = dbUrl;
		this.userName = userName;
		this.password = password;

	}

	public String getDbType() {

		return dbType;

	}

	public void setDbType(String dbType) {
		this.dbType = dbType;
	}

	public String getDbDriver() {
		return dbDriver;
	}

	public void setDbDriver(String dbDriver) {
		this.dbDriver = dbDriver;
	}

	public String getDbUrl() {
		return dbUrl;
	}

	public void setDbUrl(String dbUrl) {
		this.dbUrl = dbUrl;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getHost() {
		return host;
	}

	public void setHost(String host) {
		this.host = host;
	}

	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public String getDbName() {
		return dbName;
	}

	public void setDbName(String dbName) {
		this.dbName = dbName;
	}

	// public int getConnectRetry() {
	// return connectRetry;
	// }
	//
	// public void setConnectRetry(int connectRetry) {
	// this.connectRetry = connectRetry;
	// }
	//
	// public int getSocketTimeOut() {
	// return socketTimeOut;
	// }
	//
	// public void setSocketTimeOut(int socketTimeOut) {
	// this.socketTimeOut = socketTimeOut;
	// }

	public String getConnectDirect() {
		return connectDirect;
	}

	public void setConnectDirect(String connectDirect) {
		this.connectDirect = connectDirect;
	}

	public String getMemorySpace() {
		return memorySpace;
	}

	public void setMemorySpace(String memorySpace) {
		this.memorySpace = memorySpace;
	}

	public String getSpIpAndPort() {
		return spIpAndPort;
	}

	public void setSpIpAndPort(String spIpAndPort) {
		this.spIpAndPort = spIpAndPort;
	}

	public int getSpPort() {
		return spPort;
	}

	public void setSpPort(int spPort) {
		this.spPort = spPort;
	}

	/*
	 * public boolean equals(Object obj){ boolean ret = false; if(obj!=null &&
	 * obj instanceof DBConfiguration) {
	 * 
	 * DBConfiguration tmp = (DBConfiguration) obj;
	 * 
	 * if((null==this.getDbType()&&null==tmp.getDbType())||(null!=this.getDbType(
	 * )&&null!=tmp.getDbType()&&this.getDbType().equals(tmp.getDbType()))&&
	 * (null
	 * ==this.getDbDriver()&&null==tmp.getDbDriver())||(null!=this.getDbDriver
	 * ()&&
	 * null!=tmp.getDbDriver()&&this.getDbDriver().equals(tmp.getDbDriver()))&&
	 * (
	 * null==this.getDbName()&&null==tmp.getDbName())||(null!=this.getDbName()&&
	 * null!=tmp.getDbName()&&this.getDbName().equals(tmp.getDbName()))&&
	 * (null==
	 * this.getDbUrl()&&null==tmp.getDbUrl())||(null!=this.getDbUrl()&&null
	 * !=tmp.getDbUrl()&&this.getDbUrl().equals(tmp.getDbUrl()))&&
	 * (null==this.getHost
	 * ()&&null==tmp.getHost())||(null!=this.getHost()&&null!=
	 * tmp.getHost()&&this.getHost().equals(tmp.getHost()))&&
	 * (null==this.getUserName
	 * ()&&null==tmp.getUserName())||(null!=this.getUserName
	 * ()&&null!=tmp.getUserName
	 * ()&&this.getUserName().equals(tmp.getUserName()))&&
	 * this.getPort()==tmp.getPort()&&
	 * (null==this.getPassword()&&null==tmp.getPassword
	 * ())||(null!=this.getPassword
	 * ()&&null!=tmp.getPassword()&&this.getPassword().equals(tmp.getPassword())
	 * )){ ret = true; } }
	 * 
	 * return ret;
	 * 
	 * }
	 */

	/*
	 * @Override public int hashCode() {
	 * 
	 * int result = 20; result = result * 31 +
	 * (dbType==null?0:dbType.hashCode()); result = result * 31 +
	 * (dbDriver==null?0:dbDriver.hashCode()); result = result * 31 +
	 * (dbName==null?0:dbName.hashCode()); result = result * 31 +
	 * (dbUrl==null?0:dbUrl.hashCode()); result = result * 31 +
	 * (host==null?0:host.hashCode()); result = result * 31 +
	 * (userName==null?0:userName.hashCode()); result = result * 31 + port;
	 * result = result * 31 + (password==null?0:password.hashCode()); return
	 * result; }
	 */

}
