package com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud;

import java.util.HashMap;
import java.util.Map;

import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.IntermediateVariable;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.statement.Statement;

/**
 * 单步执行语句指针，用来标记执行语句的位置
 * @author zhangpan
 *
 */
public class RuntimeStatementPointer {
	
	/**
	 * 容器内的语句
	 */
	private Statement statement;
	
	/**
	 * 所执行语句在容器类语句中的位置，从0开始
	 */
	private int currentIndex;
	

	/**
	 * 计算中间值map
	 */
	private Map<IntermediateVariable, Object> intermediateValuesMap;
	
	/**
	 * 构造函数
	 */
	public RuntimeStatementPointer() {
		super();
	}
	
	public RuntimeStatementPointer(Statement statement) {
		super();
		this.statement = statement;
		this.intermediateValuesMap = new HashMap<IntermediateVariable, Object>();
	}
	/**
	 * 构造函数
	 * @param statement 容器类语句
	 * @param currentIndex 所执行语句在容器类语句中的位置，从0开始
	 */
	public RuntimeStatementPointer(Statement statement, int currentIndex) {
		super();
		this.statement = statement;
		this.currentIndex = currentIndex;
		this.intermediateValuesMap = new HashMap<IntermediateVariable, Object>();
	}
	
	/**
	 * 返回一个RuntimeStatementPointer实例
	 * @return
	 */
	public RuntimeStatementPointer newInstance(){
		return new RuntimeStatementPointer();
	}
	
	//-------get set-----------------
	public Statement getStatement() {
		return statement;
	}
	public void setStatement(Statement statement) {
		this.statement = statement;
	}
	public int getCurrentIndex() {
		return currentIndex;
	}
	public void setCurrentIndex(int currentIndex) {
		this.currentIndex = currentIndex;
	}
	public Map<IntermediateVariable, Object> getIntermediateValuesMap() {
		return intermediateValuesMap;
	}
	public void setIntermediateValuesMap(
			Map<IntermediateVariable, Object> intermediateValuesMap) {
		this.intermediateValuesMap = intermediateValuesMap;
	}	
}
