package com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud;

import java.util.Stack;

public class ProcExceptionMessage {
	
	public static String mainName = "_main";
	
	private String description = "";//描述，java异常信息，解析异常信息
	
	//异常堆栈，指执行报错位置
	private Stack<ProcedureExceptionRecord> exceptionRecords = 
			new Stack<ProcedureExceptionRecord>();

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Stack<ProcedureExceptionRecord> getExceptionRecords() {
		return exceptionRecords;
	}

	public void setExceptionRecords(Stack<ProcedureExceptionRecord> exceptionRecords) {
		this.exceptionRecords = exceptionRecords;
	}
	
	@Override
	public String toString() {
		
		String message = "";
		
		if(!"".equals(description)) message += description+" ";
		
		String errorStack = "";
		for(int i = 0;i<exceptionRecords.size();i++){
			ProcedureExceptionRecord  record = exceptionRecords.get(i);
			String procedureName = record.getProcedureName();
			Integer line = record.getLineNum();
			Integer column = record.getColumnNum();
			
			//无名称或者为_main的异常记录不显示
			if(procedureName == null || procedureName.equals(ProcedureExceptionRecord.mainName)){
				
				//行列信息缺失不显示
				if(line == null || column == null) continue;
				
				errorStack += "At "+"Line "+line+", Column "+column+""+"; ";
				
			}else{
				
				//行列信息缺失不显示
				if(line == null || column == null) continue;
				errorStack += "At "+procedureName.toUpperCase()+" Line "+line+", Column "+column+""+"; ";
			}
			
			
		}
		message += errorStack;
		
		return message;
	}
	
}
