package com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud;

import java.util.Stack;

import org.apache.log4j.Logger;

import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.expression.constantExpression.ConstantExpression;
//import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.expression.constantExpression.ConstantRecordExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.expression.variableExpression.VariableExpression;
//import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.expression.variableExpression.VariableFieldExpression;

/**
 * 函数调用上下文元素
 * 即Scope上下文栈
 */
public class FunctionCallContextItem {
	
	private static Logger logger = Logger.getLogger(FunctionCallContextItem.class);
	
	private Stack<ScopeContextItem> scopeContextStack;// Scope上下文栈
	
	/**
	 * 构造方法
	 */
	private FunctionCallContextItem(){
		scopeContextStack = new Stack<ScopeContextItem>();
	}
	
	/**
	 * 创建函数调用上下文元素实例
	 */
	public static FunctionCallContextItem newInstance(){
		return new FunctionCallContextItem();
	}
	
	/**
	 * 进入Scope,Scope上下文栈压栈
	 */
	public void onEnteringScope(){
		
		ScopeContextItem item = ScopeContextItem.newInstance();
		push(item);
		logger.debug("压入第  "+(scopeContextStack.size()-1)+" 层Scope");
	}
	
	/**
	 * 退出scope,scope上下文栈弹出
	 */
	public void onExitingScope(){
		
		pop();
		logger.debug("弹出第 "+ scopeContextStack.size() +" 层Scope");
	}
	
	/**
	 * 立即退出scope
	 */
	public void exitScopeImmediately(){
		pop();
		logger.debug("弹出第 "+ scopeContextStack.size() +" 层Scope");
	}
	
	/**
	 * 栈中加入一个变量及其值
	 */
	public boolean enterSingleVarValue(VariableExpression var, ConstantExpression value)throws Exception{
		
		return peek().enterSingleVarValue(var, value);
	}
	
	/**
	 * 设置栈中变量的值
	 */
	public boolean setVarValue(VariableExpression var, Object value)throws Exception{
		
		for(int i = scopeContextStack.size()-1; i >= 0 ; i--){
			ScopeContextItem item = scopeContextStack.get(i);
//			if(item.getVarValue(var) != null){
			if(item.setVarValue(var, value))return true;
//			}
		}
		if(var != null){ 
			logger.error("设置变量值 "+var.getVarName()+" 失败");
		}else{
			logger.error("设置变量值失败");
		}
		return false;
	}
	
	/**
	 * 获取栈中变量的值
	 */
	public ConstantExpression getVarValue(VariableExpression var) throws Exception{
		
//		for(int i = scopeContextStack.size()-1; i >= 0 ; i--){
//			ScopeContextItem item = scopeContextStack.get(i);
//			ConstantExpression value = item.getVarValue(var);
//			if(value != null) return value;
//		} 
//		
//		if(var != null){ 
//			logger.error("获取变量值 "+var.getVarName()+" 失败");
//		}else{
//			logger.error("获取变量值失败");
//		}
//		return null;
		
		/*for(int i = scopeContextStack.size()-1; i >= 0 ; i--){
			ScopeContextItem item = scopeContextStack.get(i);
			ConstantExpression value = null;
			if(var instanceof VariableFieldExpression){
				VariableFieldExpression varField = (VariableFieldExpression)var;
				VariableExpression var0 = varField.getVariableFieldsList().get(0);
				VariableExpression var1 = varField.getVariableFieldsList().get(1);
				
				ConstantRecordExpression constantRecord =(ConstantRecordExpression)
						(item.getVarValue(var0));

				
				
				for (int j = 0; j < varField.getVariableFieldsList().size()-1; j++) {
					if(j==0){
						constantRecord =(ConstantRecordExpression)
								(item.getVarValue(var0));
						value = constantRecord.getmap_values().get(varField.getVariableFieldsList().get(1));
					}else{
						constantRecord = (ConstantRecordExpression) value;
						value = constantRecord.getmap_values().get(varField.getVariableFieldsList().get(j+1));
						}
				}
				
				

				
//					if(constantRecord != null) {
//						value =	constantRecord.getmap_values().get(var1);
//					} 

		//		constantValue.setConstValue(value);
			}else{
				value = item.getVarValue(var);
			}
			if(value != null) return value;
		} 
	
		if(var != null){ 
			logger.error("获取变量值 "+var.getVarName()+" 失败");
			throw new Exception("获取变量值 "+var.getVarName()+" 失败");
		}else{
			logger.error("获取变量值失败");
			throw new Exception("获取变量值失败");
		}*/
		return null;
	}
	
	/**
	 * 取栈顶元素,不弹出
	 */
	private ScopeContextItem peek(){
		return scopeContextStack.peek();
	}
	
	/**
	 * 栈中压入一个元素
	 */
	private ScopeContextItem push(ScopeContextItem scopeContextItem){
		return scopeContextStack.push(scopeContextItem);
	}
	
	/**
	 * 取栈顶元素,并弹出
	 */
	private ScopeContextItem pop(){
		return scopeContextStack.pop();
	}
	
	
	public Stack<ScopeContextItem> getScopeContextStack() {
		return scopeContextStack;
	}

	public static void main(String[] args) {
		
		Stack<Integer> s = new Stack<Integer>();
		
		for(int i=0;i<10;i++){
			s.push(i);
		}
		
	}

	
	
	
	

}
