package com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud;

import java.util.List;
import java.util.Stack;

import org.apache.log4j.Logger;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.expression.ImplicitCursorAttributeExpression.ImplicitCursorAtrribute;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.expression.constantExpression.ConstantExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.expression.variableExpression.VariableExpression;
import com.bonc.xcloud.sp_procedure.base.DBConfiguration;
import com.bonc.xcloud.sp_procedure.base.ProcedureException;

/**
 * 函数调用上下文栈,
 * 为syntaxTree操作上下文提供接口
 */
public class FunctionCallContext {
	
	private static Logger logger = Logger.getLogger(FunctionCallContext.class);
	
	private Stack<FunctionCallContextItem> functionCallStack;// 函数调用上下文栈
	
	private ProcedureException exception;//异常
	
	private DBConfiguration dbConfiguration;
	
	private ImplicitCursorAtrribute implicitCursorAttribute;
	
	private String taskId;
	
	//单个过程中游标数量
	private int localCursorNum = 0;
	//单个游标最大数量
	public static int maxLocalCursorNum;
	

//	private Map<IntermediateVariable, Object> intermediateValuesMap;//计算中间值map
	
//	private Object functionReturnValue;//函数计算返回值
	
	public static final int intervalDS_DAY_MAX_PRECISION = 9; //interval day to second day最大精度
	public static final int intervalDS_SECOND_MAX_PRECISION = 9; //interval day to second second最大精度
	public static final int intervalYM_MAX_PRECISION = 9; //interval year to month year 最大精度
	public static final int timestamp_MAX_PRECISION = 9; //timestamp ff 最大精度
	
	/**
	 * 构造方法
	 */
	private FunctionCallContext(){
		functionCallStack = new Stack<FunctionCallContextItem>();
//		intermediateValuesMap = new HashMap<IntermediateVariable, Object>();
		this.implicitCursorAttribute = new ImplicitCursorAtrribute();
	}
	
	/**
	 * 创建函数调用上下文栈实例
	 */
	public static FunctionCallContext newInstance(){
		
		return new FunctionCallContext();
	}
	
	
	/**
	 * 进入函数,函数调用上下文栈压栈.<br/>
	 * 根据不同参数形式,将参数的对应的constant的值在此构造完成,字符串如下处理:<br/>
	 * 1.in 参数,值传递,长度与声明长度无关为值的长度,不用创建原值的代理,若为null/值为null,则不设置长度,默认为0,值为null.<br/>
	 *   如 a varchar(20):='ab',传递值为'ab',长度为20,b char(5):='ab',传递值为'ab   ',长度为5.<br/>
	 * 2.out 参数,值为null,长度为传入参数的声明长度,需要创建原值的代理,out参数只能是变量,因此不可能是null.<br/>
	 *   如 a varchar(20):='ab',传递值为null,长度为20,b char(5):='ab',传递值为null,长度为5.<br/>
	 * 3.in out 参数,值传递,长度为传入参数的声明长度,需要创建原值的代理,in out参数只能是变量,因此不可能是null.<br/>
	 *   如 a varchar(20):='ab',传递值为'ab',长度为20,b char(5):='ab',传递值为null,长度为5.<br/>
	 */
	public void onEnteringFunction(List<VariableExpression> arguments,List<ConstantExpression> values)throws Exception{
//		
//		//创建item,并压入栈
//		FunctionCallContextItem item = FunctionCallContextItem.newInstance();
//		push(item);
//		
//		logger.debug("压入第 "+(functionCallStack.size()-1)+" 层FunctionContext");
//		
//		if(arguments != null){
//			//进入一个scope
//			onEnteringScope();
//			//依次进栈
//			for(int i=0;i<arguments.size();i++){
//				VariableExpression argument = arguments.get(i);
//				ConstantExpression actualParameter = values.get(i);
//				
//				if(DefinitionImpl.IN_PARM.equals(argument.getAttribute(SyntaxTreeKeyImpl.DEFINITION))){
//					ConstantExpression valueActualParameter = ExpressionFactory.createNoValueConstantExpression(argument);
//					
//					//char/varchar设置长度为值的长度,与声明长度无关
//					if(TypeChecker.isString(valueActualParameter.getTypeSpec())){
//						valueActualParameter.setLength(actualParameter.getDataLength());
//					}
//					
//					if(TypeChecker.isTimestamp(valueActualParameter.getTypeSpec())) {
//						((ConstantTimestampExpression)valueActualParameter).setM_fractional_seconds_precision(
//								((ConstantTimestampExpression)actualParameter).getM_fractional_seconds_precision());
//					}
//					if(TypeChecker.isIntervalDS(valueActualParameter.getTypeSpec())) {
//						((ConstantIntervalDSExpression)valueActualParameter).setM_days_precision(
//								((ConstantIntervalDSExpression)actualParameter).getM_days_precision());
//						((ConstantIntervalDSExpression)valueActualParameter).setM_seconds_precision(
//								((ConstantIntervalDSExpression)actualParameter).getM_seconds_precision());
//					}
//					if(TypeChecker.isIntervalYM(valueActualParameter.getTypeSpec())) {
//						((ConstantIntervalYMExpression)valueActualParameter).setM_years_precision(
//								((ConstantIntervalYMExpression)actualParameter).getM_years_precision());
//					}
//					
//					//设置值
//					valueActualParameter.setConstValue(actualParameter.getConstValue());
//					item.enterSingleVarValue(argument, valueActualParameter);
//				}else{
//					ConstantExpression refActualParameter = ExpressionFactory.createRefConstantExpression(argument,actualParameter);
//					
//					if(argument.getAttribute(SyntaxTreeKeyImpl.DEFINITION).equals(DefinitionImpl.IN_OUT_PARM)){
//						
//						//char/varchar设置长度,长度为声明长度
//						if(TypeChecker.isString(refActualParameter.getTypeSpec())){
//							refActualParameter.setLength(actualParameter.getLength());
//						}
//						if(TypeChecker.isTimestamp(refActualParameter.getTypeSpec())) {
//							((ConstantTimestampExpression)refActualParameter).setM_fractional_seconds_precision(
//									((ConstantTimestampExpression)actualParameter).getM_fractional_seconds_precision());
//						}
//						if(TypeChecker.isIntervalDS(refActualParameter.getTypeSpec())) {
//							((ConstantIntervalDSExpression)refActualParameter).setM_days_precision(
//									((ConstantIntervalDSExpression)actualParameter).getM_days_precision());
//							((ConstantIntervalDSExpression)refActualParameter).setM_seconds_precision(
//									((ConstantIntervalDSExpression)actualParameter).getM_seconds_precision());
//						}
//						if(TypeChecker.isIntervalYM(refActualParameter.getTypeSpec())) {
//							((ConstantIntervalYMExpression)refActualParameter).setM_years_precision(
//									((ConstantIntervalYMExpression)actualParameter).getM_years_precision());
//						}
//						//设置值
//						refActualParameter.setConstValue(actualParameter.getConstValue());
//						
//					}else if(argument.getAttribute(SyntaxTreeKeyImpl.DEFINITION).equals(DefinitionImpl.OUT_PARM)){
//						
//						//char/varchar设置长度,长度为声明长度
//						if(TypeChecker.isString(refActualParameter.getTypeSpec())){
//							refActualParameter.setLength(actualParameter.getLength());
//						}
//						if(TypeChecker.isTimestamp(refActualParameter.getTypeSpec())) {
//							((ConstantTimestampExpression)refActualParameter).setM_fractional_seconds_precision(
//									((ConstantTimestampExpression)actualParameter).getM_fractional_seconds_precision());
//						}
//						if(TypeChecker.isIntervalDS(refActualParameter.getTypeSpec())) {
//							((ConstantIntervalDSExpression)refActualParameter).setM_days_precision(
//									((ConstantIntervalDSExpression)actualParameter).getM_days_precision());
//							((ConstantIntervalDSExpression)refActualParameter).setM_seconds_precision(
//									((ConstantIntervalDSExpression)actualParameter).getM_seconds_precision());
//						}
//						if(TypeChecker.isIntervalYM(refActualParameter.getTypeSpec())) {
//							((ConstantIntervalYMExpression)refActualParameter).setM_years_precision(
//									((ConstantIntervalYMExpression)actualParameter).getM_years_precision());
//						}
//					}
//					
//					item.enterSingleVarValue(argument, refActualParameter);
//				}
//			}
//		}
	}
	
	/**
	 * 进入scope,scope上下文栈压栈
	 */
	public void onEnteringScope(){
		peek().onEnteringScope();		
	}
	
	/**
	 * 退出函数,函数调用上下文栈弹出
	 */
	public void onExitingFunction(){
		pop();
		logger.debug("弹出第 "+functionCallStack.size()+" 层FunctionContext");
	}
	
	/**
	 * 退出scope,scope上下文栈弹出
	 */
	public void onExitingScope(){
		peek().onExitingScope();
	}
	
	/**
	 * 立即退出函数
	 */
	public void exitFunctionImmediately(){
		pop();
		logger.debug("弹出第 "+functionCallStack.size()+" 层FunctionContext");
	}
	
	/**
	 * 立即退出scope
	 */
	public void exitScopeImmediately(){
		
		if(!functionCallStack.isEmpty()){
			peek().onExitingScope();
		}
	}
	
	/**
	 * 栈中加入一个变量及其值
	 */
	public boolean enterSingleVarValue(VariableExpression var, ConstantExpression value)throws Exception{
		
		return peek().enterSingleVarValue(var, value);
	}
	
	/**
	 * 设置栈中变量的值
	 */
	public void setVarValue(VariableExpression var, Object value)throws Exception{
		
		peek().setVarValue(var, value);
	}
	
	/**
	 * 获取栈中变量的值
	 */
	public ConstantExpression getVarValue(VariableExpression var) throws Exception{
		
		ConstantExpression value = peek().getVarValue(var);
		return value;
	}
	
	/**
	 * 取栈顶元素,不弹出
	 */
	private FunctionCallContextItem peek(){
		return functionCallStack.peek();
	}
	
	/**
	 * 栈中压入一个元素
	 */
	private FunctionCallContextItem push(FunctionCallContextItem item){
		return functionCallStack.push(item);
	}
	
	/**
	 * 取栈顶元素,并弹出
	 */
	private FunctionCallContextItem pop(){
		return functionCallStack.pop();
	}

	public Stack<FunctionCallContextItem> getFunctionCallStack() {
		return functionCallStack;
	}

	public void setFunctionCallStack(
			Stack<FunctionCallContextItem> functionCallStack) {
		this.functionCallStack = functionCallStack;
	}
	
	/**
	 * 获取异常
	 */
	public ProcedureException getException() {
		return exception;
	}

	/**
	 * 设置异常
	 */
	public void setException(ProcedureException exception) {
		this.exception = exception;
	}
	
	/**
	 * 获取游标属性值
	 */
	public ImplicitCursorAtrribute getImplicitCursorAttribute() {
		return implicitCursorAttribute;
	}
	/**
	 * 设置游标属性值
	 * @param implicitCursorAttribute
	 */
	public void setImplicitCursorAttribute(
			ImplicitCursorAtrribute implicitCursorAttribute) {
		this.implicitCursorAttribute = implicitCursorAttribute;
	}

	public DBConfiguration getDbConfiguration() {
		return dbConfiguration;
	}

	public void setDbConfiguration(DBConfiguration dbConfiguration) {
		this.dbConfiguration = dbConfiguration;
	}

	public int getLocalCursorNum() {
		return localCursorNum;
	}

	public void setLocalCursorNum(int localCursorNum) {
		this.localCursorNum = localCursorNum;
	}

	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}
	
}
