package com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud;

import java.util.Stack;

import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.IntermediateVariable;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.SyntaxTree;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.statement.Statement;

/**
 * 单步执行语句栈
 * @author zhangpan
 *
 */
public class CallStack {
	
	/**
	 * 栈容器
	 */
	private Stack<RuntimeStatementPointer> callStack;
	
	
	/**
	 * 私有构造方法
	 */
	private CallStack(){
		callStack = new Stack<RuntimeStatementPointer>();
	}
	
	/**
	 * 返回一个CallStack实例
	 * @return
	 */
	public static CallStack newInstance(){
		return new CallStack();
	}
	
	/**
	 * 增加一个计算中间值
	 */
	public void addOrModefiyIntermediateValue(SyntaxTree key,Object value){
		callStack.peek().getIntermediateValuesMap().put(new IntermediateVariable(key), value);
	}
	
	/**
	 * 删除一个计算中间值
	 */
	public void removeIntermediateValue(SyntaxTree key){
		callStack.peek().getIntermediateValuesMap().remove(new IntermediateVariable(key));
	}
	
	/**
	 * 查找一个计算中间值
	 */
	public Object searchIntermediateValue(SyntaxTree key){
		
		return callStack.peek().getIntermediateValuesMap().get(new IntermediateVariable(key));
	}
	
	
//	/**
//	 * 封装语句到RuntimeStatementPointer，进栈,若已是栈顶返回false
//	 */
//	public boolean onEnteringCallStack(Statement statement){
//		
//		RuntimeStatementPointer ptr = callStack.size() == 0 ? null : callStack.peek();
//		
//		Statement stmt = ptr == null ? null : ptr.getStatement();
//		
//		//进入callStack
//		if(stmt == null){//栈中无元素,为根语句且初次调用
//			
//			RuntimeStatementPointer newptr = 
//					new RuntimeStatementPointer(statement,0);
//			
//			callStack.push(newptr);
//			
//			return true;
//			
//		}else if(stmt != statement ){//栈顶不是自己,为父语句初次调用
//			
//			RuntimeStatementPointer newptr = 
//					new RuntimeStatementPointer(statement,0);
//			
//			callStack.push(newptr);
//			
//			return true;
//			
//		}
//		return false;
//		
////		//判断栈中是否存在statement,如果没有压入一个
////		if(search(statement)== null){
////			//给statement加入ID属性
////			statement.setAttribute(SyntaxTreeKeyImpl.STATEMENT_ID, UUID.randomUUID().toString());
////			
////			RuntimeStatementPointer ptr = new RuntimeStatementPointer(statement,0);
////			push(ptr);
////			return true;
////		}
////		return false;
//	}	
	
//	/**
//	 * 语句出栈,未出栈判断是否未index+1,若出栈要给上层语句+1
//	 * @return RuntimeStatementPointer
//	 */
//	public boolean onExitingCallStack(Statement statement){
//		
//		RuntimeStatementPointer ptr = callStack.size() == 0 ? null : callStack.peek();
//		
//		Statement top = ptr == null ? null : ptr.getStatement();
//		
//		if(top == null) return true;
//		
//		//非栈顶则无需index + 1,
//		if(top != statement) return false;
//		
//		//为栈顶判断是否执行结束
//		next(ptr);
//		
//		int index = ptr.getCurrentIndex();
//		
//		//执行结束,要为上一层+1
//		if(index > statement.getSize() -1){
//		    
//			pop();
//			//给上层语句+1
//			RuntimeStatementPointer nextPtr = callStack.size() == 0 ? null : callStack.peek();
//			Statement nextTop = nextPtr == null ? null : nextPtr.getStatement();
//			if(nextPtr != null && !(nextTop instanceof WhileStatement)){
//				
//				next(nextPtr);
//			}
//			return true;
//		}else{
//			return false;
//		}
//		
////		//判断是否是TopStatement && 判断是否currentIndex == size-1
////		if(getTopStatement().getAttribute(SyntaxTreeKeyImpl.STATEMENT_ID)
////				.equals(statement.getAttribute(SyntaxTreeKeyImpl.STATEMENT_ID))){
////			
////			int currentIndex = getLocalStatementIndex(statement); 
////			
////			if(currentIndex >= statement.getSize()-1){
////				pop();
////				return true;
////			}
////		}
////		return false;
//	}
	
//	/**
//	 * 语句index+1
//	 * @return
//	 */
//	private boolean next(RuntimeStatementPointer ptr){
//		
//		//为栈顶判断是否执行结束
//		int index = ptr.getCurrentIndex();
//		Statement statement = ptr.getStatement();
//		
//		//executable块语句要进行异常处理,异常处理语句只有出异常的时候index才能指向该语句
//		if(statement instanceof ExecutableBlockStatement){
//			
//			if(index == 1){
//				ptr.setCurrentIndex(index + 2);
//			}else{
//				ptr.setCurrentIndex(index + 1);
//			}
//			
//		}else{
//			ptr.setCurrentIndex(index + 1);
//		}
//		return true;
//	}
	
	/**
	 * 判断语句是否为栈顶
	 * @param stmt
	 * @return
	 */
	public boolean isTopStatement(Statement stmt){
		//获取堆栈顶部的元素
		RuntimeStatementPointer ptr = peek();
		
		Statement top = ptr == null ? null : ptr.getStatement();
		
		//在栈顶则语句+1
		if(stmt!=null && stmt == top) return true;
		
		return false;
		
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
//	/**
//	 * 方法返回时,整个function出栈
//	 * @param returnValue
//	 * @return
//	 */
//		
//	public boolean onReturnFunction(ConstantExpression returnValue){
//		//找到上一层的function,设置返回值,(一直设置状态return到function)
//		int index=callStack.size()-1;
//		for(;index>=0;index--){
//			RuntimeStatementPointer ptr = callStack.get(index);
//			if(ptr.getStatement() instanceof FunctionDeclareStatement){
////				((FunctionDeclareStatement)ptr.getStatement()).setReturnValue(returnValue);
//				break;
//			}
//		}
//		if(index<0)
//			return false;
////		for(int size=callStack.size()-1;size>=index;size--){
////			RuntimeStatementPointer ptr = callStack.get(size);
////			ptr.getStatement().setStatus(StatementStatus.RETURN);
////		}
//		return true;
//	}
//	
//	
//	/**
//	 * 当遇到return语句时，调用该方法立即弹出该语句
//	 * @param statement
//	 * @return
//	 */
//	public boolean exitImmediately(Statement statement){
//		if(getTopStatement().getAttribute(SyntaxTreeKeyImpl.STATEMENT_ID)
//				.equals(statement.getAttribute(SyntaxTreeKeyImpl.STATEMENT_ID))){
//			pop();
//			return true;
//		}
//		return false;
//	}
		
	
	/**
	 * 获取栈顶层语句
	 * @return
	 */
	public Statement getTopStatement(){
		RuntimeStatementPointer ptr = peek();
		if(ptr != null)
			return ptr.getStatement();
		return null;
	}
	
	/**
	 * 获取栈底层语句
	 * @return
	 */
	public Statement getBottomStatement(){
		if(!this.callStack.empty()){
			RuntimeStatementPointer ptr = this.callStack.firstElement();
			
			return ptr.getStatement();
		}
		return null;
	}
	
	/**
	 * 获取栈顶层语句位置
	 * @return
	 */
	public int getTopStatementIndex(){
		RuntimeStatementPointer ptr = peek();
		if(ptr != null)
			return ptr.getCurrentIndex();
		return -1;
	}
	
//	/**
//	 * 获取当前语句位置
//	 * @return
//	 */
//	public int getLocalStatementIndex(Statement statement){
//		
//		RuntimeStatementPointer ptr = search(statement);
//		
//		if(ptr == null) return -1;
//		
//		return ptr.getCurrentIndex();
//	}
	
	public void push(RuntimeStatementPointer ptr){
		this.callStack.push(ptr);
	}
	public RuntimeStatementPointer pop(){
		if(this.callStack.empty()){
			return null;
		}
		RuntimeStatementPointer ptr = this.callStack.pop();
		return ptr;
	}
	public RuntimeStatementPointer peek(){
		if(this.callStack.empty()){
			return null;
		}
//		try{
			RuntimeStatementPointer ptr = this.callStack.peek();
			return ptr;
//		}catch(Exception e){
//			return null;
//		}
		
	}
//	private RuntimeStatementPointer search(Statement statement){
//		Object id = statement.getAttribute(SyntaxTreeKeyImpl.STATEMENT_ID);
//		if(id == null) return null;
//		
//		for(int i=callStack.size()-1;i>=0;i--){
//			RuntimeStatementPointer ptr = callStack.get(i);
//			if(ptr.getStatement().getAttribute(SyntaxTreeKeyImpl.STATEMENT_ID).equals(id)){
//				return ptr;
//			}
//		}
//		return null;
//	}
//	
//	/**
//	 * 查询指定语句最近的Procedure父类语句
//	 * @param statement statement为非Procedure语句
//	 * @return Procedure语句
//	 */
//	public ProcedureDeclareStatement searchParentProcedure(Statement statement){		
//		Object id = statement.getAttribute(SyntaxTreeKeyImpl.STATEMENT_ID);
//		if(id == null) return null;
//		
//		int i = callStack.size()-1;
//		
//		//找到当前语句的位置，返回其上一条索引值index
//		for(;i>=0;i--){
//			RuntimeStatementPointer ptr = callStack.get(i);
//			if(ptr.getStatement().getAttribute(SyntaxTreeKeyImpl.STATEMENT_ID).equals(id)){
//				i--;
//				break;
//			}
//		}
//		
//		//继续寻找父类Procedure
//		if(i>=0){
//			for(;i>=0;i--){
//				RuntimeStatementPointer ptr = callStack.get(i);
//				Statement target = ptr.getStatement();
//				if(target instanceof ProcedureDeclareStatement){
//					return (ProcedureDeclareStatement) target;
//				}
//			}
//		}
//		
//		return null;
//	}
	
	public Stack<RuntimeStatementPointer> getCallStack() {
		return callStack;
	}
}
