/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.type;

import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.type.NumStruForData;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCloudNumber {
    private static Logger logger = LoggerFactory.getLogger(XCloudNumber.class);
    public static int MAX_REAL_INDEX = 247;
    public static int TAIL_STEP = 4;
    public static int INT_BASE_SIZE = 3;
    public static int LONG_BASE_SIZE = 5;
    public static int DOUBLE_SPACE_BASE = 65;
    public static int HALF_S_NUM_BASE = 5000;
    public static int MAX_INDEX = 255;
    public static int MIN_INDEX = 0;
    public static int S_MAX_PRECISION = 38;
    public static int S_MIN_PRECISION = 1;
    public static int S_MAX_SCALE = 127;
    public static int S_MIN_SCALE = -84;
    public static int S_DEFAULT_PRECISION = 38;
    public static int S_DEFAULT_SCALE = 0;
    public static int S_POSITIVE_TAIL = 0;
    public static int S_NEGATIVE_TAIL = 10002;
    public static int S_POSITIVE_BASE = 1;
    public static int S_NEGATIVE_BASE = 10001;
    public static int S_POSITIVE_INDEX_BASE = 192;
    public static int S_NEGATIVE_INDEX_BASE = 63;
    public static int MAX_P_LENGTH = 11;
    public static int NUMBER_MEMORY_TAIL_LENTH = 11;
    public static int ZERO_INDEX_BASE = 128;
    public static int S_NUM_BASE = 10000;

    public static int calTailSize(int digitSize) {
        return 0 == digitSize % TAIL_STEP ? digitSize / TAIL_STEP : digitSize / TAIL_STEP + 1;
    }

    public static int getPositiveStorageIndex(int index) {
        return index + S_POSITIVE_INDEX_BASE;
    }

    public static int getNegativeStorageIndex(int index) {
        return S_NEGATIVE_INDEX_BASE - index;
    }

    public static int toStorage(int val, boolean sign) {
        return sign ? val + S_POSITIVE_BASE : S_NEGATIVE_BASE - val;
    }

    public static int toEnd(boolean sign) {
        return sign ? S_POSITIVE_TAIL : S_NEGATIVE_TAIL;
    }

    public static int toStorageIndex(int index, boolean sign) throws SQLException {
        if (sign) {
            if (index > MAX_INDEX - S_POSITIVE_INDEX_BASE) {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("ByteOrderConv::toStorageIndex - NUMBER_VALUE_OVERFLOW");
                logger.error(retMsg);
                ExceptionMgr.throwSQLExp(retMsg);
            }
            return XCloudNumber.getPositiveStorageIndex(index);
        }
        if (S_NEGATIVE_INDEX_BASE - index < MIN_INDEX) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("ByteOrderConv::toStorageIndex - NUMBER_VALUE_OVERFLOW");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        return XCloudNumber.getNegativeStorageIndex(index);
    }

    public static int find_last_not_of(String value, char ch, int index) throws SQLException {
        if (index > value.length() || index < 0) {
            index = value.length() - 1;
        }
        while (index != 0 && value.charAt(index) == ch) {
            --index;
        }
        return index;
    }

    public static int find_first_not_of(String value, char ch, int index) throws SQLException {
        int maxLen = value.length();
        if (index >= maxLen || index < 0) {
            return -1;
        }
        while (index < maxLen && value.charAt(index) == ch) {
            ++index;
        }
        return index;
    }

    public static void encodeDigitWithoutPrecision(String strPtr, NumStruForData numData, int startPos, int endPos, int tailStartPos, boolean sign) throws SQLException {
        int dStart = startPos;
        int tailPos = tailStartPos;
        boolean retPrec = false;
        boolean carry = false;
        boolean carryflag = false;
        int curTailCnt = 0;
        while (dStart <= endPos && tailPos < MAX_P_LENGTH) {
            int val = 0;
            int step = TAIL_STEP;
            while (step > 0) {
                if (dStart <= endPos && (strPtr.charAt(dStart) == '.' || strPtr.charAt(dStart) == '-' || strPtr.charAt(dStart) == '+')) {
                    ++dStart;
                    continue;
                }
                if (dStart < 0) {
                    ++dStart;
                    --step;
                    continue;
                }
                if (dStart <= endPos) {
                    int tmp = strPtr.charAt(dStart++) - 48;
                    val = val * 10 + tmp;
                } else {
                    val *= 10;
                }
                --step;
            }
            short numIndex = numData.getNumIndex();
            if (numIndex == ZERO_INDEX_BASE && val != 0) {
                numIndex = (short)XCloudNumber.toStorageIndex(-curTailCnt, sign);
                numData.setNumIndex(numIndex);
            }
            if (numData.getNumIndex() != ZERO_INDEX_BASE) {
                short numTail = (short)XCloudNumber.toStorage(val, sign);
                numData.setNumTail(numTail, tailPos++);
            }
            ++curTailCnt;
            if (dStart <= endPos) continue;
            break;
        }
        if (tailPos < MAX_P_LENGTH) {
            short numTail = (short)XCloudNumber.toEnd(sign);
            numData.setNumTail(numTail, tailPos);
        }
    }

    public static void encodeIntegerWithoutPrecision(NumStruForData numData, String strPtr, int strLen, int startPos, int endPos, boolean sign) throws SQLException {
        int retPrec = endPos - startPos + 1;
        int integerSize = XCloudNumber.calTailSize(endPos - startPos + 1);
        int end = endPos;
        int integerPos = integerSize - 1;
        while (integerPos >= 0) {
            int val;
            int step;
            int scale = 0;
            if (scale < 0) {
                step = TAIL_STEP;
                val = 0;
                int carry = 0;
                while (integerPos >= 0) {
                    while (step > 0 && end > startPos) {
                        while (scale < 0) {
                            --step;
                            if (0 != ++scale || --end + 1 >= strLen || strPtr.charAt(end + 1) == '\u0000') continue;
                            int tmp = strPtr.charAt(end + 1) - 48;
                            carry = tmp >= 5 ? 1 : 0;
                        }
                        retPrec = end - startPos + 1;
                        if (end < strLen) {
                            val = (int)((double)val + (double)(strPtr.charAt(end) - 48 + carry) * Math.pow(10.0, TAIL_STEP - step));
                        }
                        --endPos;
                        carry = 0;
                    }
                    numData.setNumTail((short)XCloudNumber.toStorage(val, sign), integerPos--);
                }
                if (end >= startPos) continue;
                break;
            }
            if (integerPos >= 0) {
                val = 0;
                for (step = TAIL_STEP; step > 0; --step) {
                    if (end < strLen && end >= startPos) {
                        int tmp = strPtr.charAt(end) - 48;
                        val = (int)((double)val + (double)tmp * Math.pow(10.0, TAIL_STEP - step));
                        --end;
                        continue;
                    }
                    --end;
                }
                numData.setNumTail((short)XCloudNumber.toStorage(val, sign), integerPos--);
            }
            if (end >= startPos) continue;
            break;
        }
    }

    public static void SetDataByStringWithoutPrecision(String strVal, NumStruForData numData, int startPos, int endPos, boolean sign, int pointPosition) throws SQLException {
        int uStartPos = startPos;
        int validStartPos = XCloudNumber.find_first_not_of(strVal, '0', uStartPos);
        if (validStartPos == -1) {
            numData.Init(true);
            return;
        }
        if (validStartPos != pointPosition) {
            int uEndPos;
            uStartPos = validStartPos;
            int n = uEndPos = pointPosition >= endPos ? XCloudNumber.find_last_not_of(strVal, ' ', endPos) : pointPosition - 1;
            if (uEndPos - uStartPos > MAX_REAL_INDEX) {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("ByteOrderConv::SetDataByStringWithoutPrecision - NUMBER_VALUE_EXCEED_PRECISION");
                logger.error(retMsg);
                ExceptionMgr.throwSQLExp(retMsg);
            }
            int integerSize = XCloudNumber.calTailSize(uEndPos - uStartPos + 1);
            numData.setNumIndex((short)XCloudNumber.toStorageIndex(integerSize, sign));
            if (sign && numData.getNumIndex() <= ZERO_INDEX_BASE || !sign && numData.getNumIndex() >= ZERO_INDEX_BASE - 1) {
                numData.Init(true);
                return;
            }
            if (integerSize > MAX_P_LENGTH) {
                uEndPos -= (integerSize - MAX_P_LENGTH) * TAIL_STEP;
            }
            int dEndPos = XCloudNumber.find_last_not_of(strVal, ' ', endPos);
            if ((dEndPos = XCloudNumber.find_last_not_of(strVal, '0', dEndPos)) < pointPosition) {
                if (integerSize <= MAX_P_LENGTH) {
                    uEndPos -= (uEndPos - dEndPos) / TAIL_STEP * TAIL_STEP;
                }
            } else if (pointPosition != strVal.length()) {
                int dStartPos = pointPosition + 1;
                int digitSize = XCloudNumber.calTailSize(dEndPos - dStartPos + 1);
                if (integerSize + digitSize > MAX_P_LENGTH) {
                    dEndPos = dStartPos + (MAX_P_LENGTH - integerSize) * TAIL_STEP;
                }
                XCloudNumber.encodeDigitWithoutPrecision(strVal, numData, dStartPos, dEndPos, integerSize, sign);
            }
            XCloudNumber.encodeIntegerWithoutPrecision(numData, strVal, strVal.length(), uStartPos, uEndPos, sign);
        } else {
            validStartPos = XCloudNumber.find_first_not_of(strVal, '0', pointPosition + 1);
            if (validStartPos == -1) {
                numData.Init(true);
                return;
            }
            int uEndPos = XCloudNumber.find_last_not_of(strVal, ' ', endPos);
            if ((uEndPos = XCloudNumber.find_last_not_of(strVal, '0', uEndPos)) == pointPosition) {
                numData.Init(true);
                return;
            }
            int tmpIndex = 0;
            int step = (validStartPos - pointPosition - 1) / TAIL_STEP;
            uStartPos = pointPosition + 1 + step * TAIL_STEP;
            numData.setNumIndex((short)XCloudNumber.toStorageIndex(tmpIndex -= step, sign));
            if (sign && numData.getNumIndex() <= ZERO_INDEX_BASE || !sign && numData.getNumIndex() >= ZERO_INDEX_BASE - 1) {
                numData.Init(true);
                return;
            }
            XCloudNumber.encodeDigitWithoutPrecision(strVal, numData, uStartPos, uEndPos, 0, sign);
        }
    }

    public static void encodeEIntegerWithoutPrecision(String strVal, NumStruForData numData, int startPos, int endPos, int pointPosition, int ePosition, boolean sign) throws SQLException {
        int diff = endPos - startPos + (pointPosition >= ePosition ? 1 : 0);
        int integerSize = diff == 0 ? 1 : XCloudNumber.calTailSize(diff);
        int end = endPos;
        int integerPos = integerSize - 1;
        while (integerPos >= 0) {
            if (integerPos < 0) continue;
            int step = TAIL_STEP;
            int val = 0;
            int base = 1;
            while (step > 0) {
                if (end >= startPos) {
                    if (end >= ePosition) {
                        base *= 10;
                        --end;
                        --step;
                        continue;
                    }
                    if (strVal.charAt(end) == '.') {
                        --end;
                        continue;
                    }
                    int tmp = strVal.charAt(end) - 48;
                    val += tmp * base;
                    base *= 10;
                    --end;
                }
                --step;
            }
            if (integerPos >= MAX_P_LENGTH) {
                --integerPos;
            } else {
                short tail = (short)XCloudNumber.toStorage(val, sign);
                numData.setNumTail(tail, integerPos--);
            }
            if (end >= startPos) continue;
            break;
        }
    }

    public static void setDataByPositiveEnotataionImpl(String strVal, NumStruForData numData, int uStartPos, int validStartPos, int uEndPos, int pointPosition, int ePosition, int exponent, boolean sign) throws SQLException {
        int offset = exponent % TAIL_STEP;
        int tempIndex = exponent / TAIL_STEP;
        int index = pointPosition >= strVal.length() ? XCloudNumber.calTailSize(ePosition - validStartPos + exponent) : (pointPosition < validStartPos ? (pointPosition + exponent < validStartPos ? 0 : XCloudNumber.calTailSize(exponent)) : XCloudNumber.calTailSize(pointPosition - validStartPos + exponent));
        short numIndex = (short)XCloudNumber.toStorageIndex(index, sign);
        numData.setNumIndex(numIndex);
        if (sign && numData.getNumIndex() <= ZERO_INDEX_BASE || !sign && numData.getNumIndex() >= ZERO_INDEX_BASE - 1) {
            numData.Init(true);
            return;
        }
        if (validStartPos > pointPosition && offset == 0) {
            uEndPos = XCloudNumber.find_last_not_of(strVal, '0', ePosition - 1);
            int dIndex = 0;
            int step = (validStartPos - pointPosition + 1) / TAIL_STEP;
            uStartPos = pointPosition + 1 + step * TAIL_STEP;
            dIndex -= step;
            XCloudNumber.encodeDigitWithoutPrecision(strVal, numData, uStartPos, uEndPos, 0, sign);
        } else if (pointPosition == -1 || pointPosition + exponent >= ePosition) {
            uStartPos = validStartPos;
            int tmpEndPos = XCloudNumber.find_last_not_of(strVal, '0', ePosition - 1);
            int digitSize = pointPosition >= ePosition ? 0 : tmpEndPos - pointPosition;
            int digitStepSize = digitSize / TAIL_STEP * TAIL_STEP;
            int endPos = uEndPos = pointPosition >= ePosition ? tmpEndPos + offset + (ePosition - 1 - tmpEndPos) % TAIL_STEP : pointPosition + digitStepSize + (digitSize % TAIL_STEP != 0 ? TAIL_STEP + offset : offset);
            XCloudNumber.encodeEIntegerWithoutPrecision(strVal, numData, uStartPos, endPos, pointPosition, ePosition, sign);
            if (index <= MAX_P_LENGTH) {
                numData.setNumTail((short)XCloudNumber.toEnd(sign), index);
            }
        } else {
            int dBeginPos = pointPosition + offset + 1;
            int endPos = XCloudNumber.find_last_not_of(strVal, '0', ePosition - 1);
            if (dBeginPos > endPos) {
                XCloudNumber.encodeEIntegerWithoutPrecision(strVal, numData, uStartPos, dBeginPos - 1, pointPosition, ePosition, sign);
            } else if (pointPosition - validStartPos + exponent > ePosition) {
                int step = XCloudNumber.calTailSize(endPos - validStartPos + offset - 1);
                int pos = validStartPos + step * TAIL_STEP;
                XCloudNumber.encodeEIntegerWithoutPrecision(strVal, numData, uStartPos, pos, pointPosition, ePosition, sign);
            } else {
                int digitSize;
                int integerSize = XCloudNumber.calTailSize(dBeginPos - uStartPos - 1);
                if (integerSize > MAX_P_LENGTH) {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("ByteOrderConv::setDataByPositiveEnotataionImpl - NUMBER_VALUE_EXCEED_PRECISION!");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                if (integerSize + (digitSize = XCloudNumber.calTailSize(endPos - dBeginPos + 1)) > MAX_P_LENGTH) {
                    endPos = dBeginPos + (MAX_P_LENGTH - integerSize) * TAIL_STEP;
                }
                XCloudNumber.encodeDigitWithoutPrecision(strVal, numData, dBeginPos, endPos, integerSize, sign);
                if (offset == 0) {
                    XCloudNumber.encodeEIntegerWithoutPrecision(strVal, numData, uStartPos, pointPosition - 1, pointPosition, ePosition, sign);
                } else {
                    XCloudNumber.encodeEIntegerWithoutPrecision(strVal, numData, uStartPos, dBeginPos - 1, pointPosition, ePosition, sign);
                }
            }
        }
    }

    public static void setDataByNegativeEnotataionImpl(String strVal, NumStruForData numData, int uStartPos, int validStartPos, int uEndPos, int pointPosition, int ePosition, int exponent, boolean sign) throws SQLException {
        int iEndPos = (pointPosition > ePosition ? ePosition : pointPosition) + exponent;
        if (iEndPos <= uStartPos) {
            int dIndex = 0;
            int step = (validStartPos - iEndPos - (pointPosition > ePosition ? 0 : 1)) / TAIL_STEP;
            uStartPos = iEndPos + step * TAIL_STEP + 1 - (pointPosition > validStartPos ? 1 : 0) - (strVal.charAt(uStartPos - 1) == '-' || strVal.charAt(uStartPos - 1) == '+' ? 1 : 0);
            short numIndex = (short)XCloudNumber.toStorageIndex(dIndex -= step, sign);
            numData.setNumIndex(numIndex);
            if (sign && numData.getNumIndex() <= ZERO_INDEX_BASE || !sign && numData.getNumIndex() >= ZERO_INDEX_BASE - 1) {
                numData.Init(true);
                return;
            }
            XCloudNumber.encodeDigitWithoutPrecision(strVal, numData, uStartPos, uEndPos, 0, sign);
        } else {
            int integerSize = XCloudNumber.calTailSize(iEndPos - uStartPos + 1);
            short numIndex = (short)XCloudNumber.toStorageIndex(integerSize, sign);
            numData.setNumIndex(numIndex);
            if (sign && numData.getNumIndex() <= ZERO_INDEX_BASE || !sign && numData.getNumIndex() >= ZERO_INDEX_BASE - 1) {
                numData.Init(true);
                return;
            }
            XCloudNumber.encodeDigitWithoutPrecision(strVal, numData, iEndPos, uEndPos, integerSize, sign);
            XCloudNumber.encodeEIntegerWithoutPrecision(strVal, numData, uStartPos, iEndPos - 1, pointPosition, ePosition, sign);
        }
    }

    public static void SetDataByEnotationStringWithoutPrecision(String strVal, NumStruForData numData, int startPos, boolean sign, int pointPosition, int ePosition) throws SQLException {
        int validStartPos;
        int uStartPos = startPos;
        uStartPos = validStartPos = XCloudNumber.find_first_not_of(strVal, '0', uStartPos);
        if (validStartPos == pointPosition) {
            uStartPos = validStartPos;
            validStartPos = XCloudNumber.find_first_not_of(strVal, '0', pointPosition + 1);
        }
        if (validStartPos == ePosition) {
            numData.Init(true);
            return;
        }
        int uEndPos = XCloudNumber.find_last_not_of(strVal, '0', strVal.length() - 1);
        String expStr = strVal.substring(ePosition + 1, strVal.length() - 1);
        if (expStr.startsWith("+")) {
            expStr = expStr.substring(1);
        }
        int exponent = Integer.valueOf(expStr);
        if (uEndPos == ePosition || exponent == 0) {
            XCloudNumber.SetDataByStringWithoutPrecision(strVal, numData, validStartPos, ePosition - 1, sign, pointPosition);
            return;
        }
        if (exponent >= 0) {
            XCloudNumber.setDataByPositiveEnotataionImpl(strVal, numData, uStartPos, validStartPos, uEndPos, pointPosition, ePosition, exponent, sign);
        } else {
            uEndPos = XCloudNumber.find_last_not_of(strVal, '0', ePosition - 1);
            XCloudNumber.setDataByNegativeEnotataionImpl(strVal, numData, uStartPos, validStartPos, uEndPos, pointPosition, ePosition, exponent, sign);
        }
    }

    public static byte[] bigDecimalToBytes(BigDecimal bigDecimal) throws SQLException {
        NumStruForData numData = new NumStruForData();
        String strVal = bigDecimal.toPlainString();
        if (0 == strVal.length()) {
            return numData.toBytes();
        }
        int pointPosition = 0;
        int ePosition = 0;
        boolean sign = true;
        boolean isEnotation = false;
        int startPos = 0;
        pointPosition = strVal.indexOf(46, startPos);
        if (-1 == pointPosition) {
            pointPosition = strVal.length();
        }
        int ePositionBegin = strVal.indexOf(101, startPos);
        int EPositionBegin = strVal.indexOf(69, startPos);
        if (ePositionBegin == -1 && EPositionBegin == -1) {
            isEnotation = false;
        } else if (ePositionBegin != -1) {
            isEnotation = true;
            ePosition = ePositionBegin;
        } else if (EPositionBegin != -1) {
            isEnotation = true;
            ePosition = EPositionBegin;
        }
        int posSignPostion = startPos;
        int negSignPostion = startPos;
        if (strVal.startsWith("-")) {
            startPos = negSignPostion + 1;
            sign = false;
        } else {
            sign = true;
            if (strVal.startsWith("+")) {
                startPos = posSignPostion + 1;
            }
        }
        numData.Init(sign);
        if (!isEnotation) {
            XCloudNumber.SetDataByStringWithoutPrecision(strVal, numData, startPos, strVal.length() - 1, sign, pointPosition);
        } else {
            XCloudNumber.SetDataByEnotationStringWithoutPrecision(strVal, numData, startPos, sign, pointPosition, ePosition);
        }
        return numData.toBytes();
    }
}

