/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.type;

import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.common.LobBuffer;
import com.bonc.xcloud.common.StmtInfoPack;
import com.bonc.xcloud.component.ServiceManager;
import com.bonc.xcloud.convert.CharactorSetConv;
import com.bonc.xcloud.enumdef.CharSet;
import com.bonc.xcloud.error.handle.ErrorHandler;
import com.bonc.xcloud.xserver.TLobResultSet;
import com.bonc.xcloud.xserver.TOpenLobResult;
import com.bonc.xcloud.xserver.TStatus;
import com.bonc.xcloud.xserver.TStatusCode;
import com.bonc.xcloud.xserver.TUniqueId;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCloudLOB {
    private static Logger logger = LoggerFactory.getLogger(XCloudLOB.class);
    private byte[] m_array = null;
    private LobBuffer.LOBSTORAGETYPE m_storageType;
    protected long m_lobLength;
    protected long m_lobCharLength;
    protected long m_initlobLength;
    protected long m_initlobCharLength;
    private ServiceManager m_serviceManager = null;
    private boolean m_isInit = false;
    private ByteBuffer m_handle = null;
    private ErrorHandler m_errorHandler = null;
    private TUniqueId m_lobHandle = null;
    private int startPos = 0;
    private byte[] m_clobReserveBuffer = null;
    private int[] m_lastLen = null;
    private StmtInfoPack m_stmtInfo = null;
    private CharSet m_cs = null;

    public XCloudLOB(byte[] array, int startPos, int realLen, ServiceManager serviceManager, LobBuffer.LOBSTORAGETYPE storageType, long lobLength, long lobCHLength, CharSet cs) throws SQLException {
        try {
            this.m_array = new byte[realLen];
        }
        catch (OutOfMemoryError ex) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloudLOB Allocate " + realLen + "bytes, out of Memory!");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        System.arraycopy(array, startPos, this.m_array, 0, realLen);
        this.m_cs = cs;
        this.m_serviceManager = serviceManager;
        this.m_storageType = storageType;
        this.m_initlobLength = this.m_lobLength = lobLength;
        this.m_initlobCharLength = this.m_lobCharLength = lobCHLength;
        this.m_isInit = false;
        this.m_errorHandler = new ErrorHandler();
        this.m_stmtInfo = new StmtInfoPack();
    }

    public void open() throws SQLException {
        if (LobBuffer.LOBSTORAGETYPE.INLINE == this.m_storageType) {
            this.m_isInit = true;
        } else if (LobBuffer.LOBSTORAGETYPE.LOCATOR == this.m_storageType) {
            if (!this.m_isInit) {
                this.m_handle = ByteBuffer.wrap(this.m_array, 0, this.m_array.length);
                TOpenLobResult tolr = this.m_serviceManager.openLobFile(this.m_handle, this.m_stmtInfo);
                if (TStatusCode.OK != tolr.getStatus().status_code) {
                    this.m_errorHandler.Handle(tolr.getStatus(), this.m_serviceManager.getConnInfoPack(), this.m_stmtInfo);
                }
                this.m_lobHandle = tolr.getLob_handle();
                StringBuffer queryID = new StringBuffer();
                queryID.append(Integer.toHexString(this.m_lobHandle.getIp())).append(":").append(Integer.toHexString(this.m_lobHandle.getTimestamp())).append(":").append(Integer.toHexString(this.m_lobHandle.getSeqno())).append(":").append(Integer.toHexString(this.m_lobHandle.getReserve()));
                this.m_stmtInfo.setCurrentQueryID(queryID.toString());
                this.m_isInit = true;
            }
        } else {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("lob open storageType is unknown");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
    }

    public void close() throws SQLException {
        if (this.m_isInit) {
            if (LobBuffer.LOBSTORAGETYPE.INLINE != this.m_storageType) {
                if (LobBuffer.LOBSTORAGETYPE.LOCATOR == this.m_storageType) {
                    TStatus ts = this.m_serviceManager.closeLobFile(this.m_lobHandle, this.m_stmtInfo);
                    if (TStatusCode.OK != ts.status_code) {
                        this.m_errorHandler.Handle(ts, this.m_serviceManager.getConnInfoPack(), this.m_stmtInfo);
                    }
                } else {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("lob open storageType is unknown");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
            }
            this.m_isInit = false;
            this.m_lobLength = this.m_initlobLength;
            this.m_lobCharLength = this.m_initlobCharLength;
            this.startPos = 0;
        }
    }

    public int read(byte[] buffer) throws SQLException {
        long readLen = 0L;
        int fetchSize = buffer.length;
        if (LobBuffer.LOBSTORAGETYPE.INLINE == this.m_storageType) {
            if (this.m_lobLength > 0L) {
                readLen = this.m_lobLength >= (long)fetchSize ? (long)fetchSize : this.m_lobLength;
                System.arraycopy(this.m_array, this.startPos, buffer, 0, (int)readLen);
                this.m_lobLength -= readLen;
                this.startPos = (int)((long)this.startPos + readLen);
            } else {
                readLen = -1L;
            }
        } else if (LobBuffer.LOBSTORAGETYPE.LOCATOR == this.m_storageType) {
            if (this.m_lobLength > 0L) {
                TLobResultSet rlrs = this.m_serviceManager.fetchLobData(this.m_lobHandle, fetchSize, this.m_stmtInfo);
                if (TStatusCode.OK != rlrs.getStatus().status_code) {
                    this.m_errorHandler.Handle(rlrs.getStatus(), this.m_serviceManager.getConnInfoPack(), this.m_stmtInfo);
                }
                if ((readLen = (long)rlrs.getPack().getLength()) > (long)fetchSize) {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("lob readLen is greater than fetchSize");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                System.arraycopy(rlrs.getPack().getDatas(), 0, buffer, 0, (int)readLen);
                this.m_lobLength -= readLen;
            } else {
                readLen = -1L;
            }
        } else {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("lob open storageType is unknown");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        return (int)readLen;
    }

    public int read(byte[] buffer, int start, int len) throws SQLException {
        if (buffer.length > start + len) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("BLOB read buffer is not enough");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        long readLen = 0L;
        int fetchSize = len;
        if (LobBuffer.LOBSTORAGETYPE.INLINE == this.m_storageType) {
            if (this.m_lobLength > 0L) {
                readLen = this.m_lobLength >= (long)fetchSize ? (long)fetchSize : this.m_lobLength;
                System.arraycopy(this.m_array, this.startPos, buffer, start, (int)readLen);
                this.m_lobLength -= readLen;
                this.startPos = (int)((long)this.startPos + readLen);
            } else {
                readLen = -1L;
            }
        } else if (LobBuffer.LOBSTORAGETYPE.LOCATOR == this.m_storageType) {
            if (this.m_lobLength > 0L) {
                TLobResultSet rlrs = this.m_serviceManager.fetchLobData(this.m_lobHandle, fetchSize, this.m_stmtInfo);
                if (TStatusCode.OK != rlrs.getStatus().status_code) {
                    this.m_errorHandler.Handle(rlrs.getStatus(), this.m_serviceManager.getConnInfoPack(), this.m_stmtInfo);
                }
                if ((readLen = (long)rlrs.getPack().getLength()) > (long)fetchSize) {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("lob readLen is greater than fetchSize");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                System.arraycopy(rlrs.getPack().getDatas(), 0, buffer, start, (int)readLen);
                this.m_lobLength -= readLen;
            } else {
                readLen = -1L;
            }
        } else {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("lob open storageType is unknown");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        return (int)readLen;
    }

    public int read(char[] buffer) throws SQLException {
        long readByteLen = 0L;
        String charset = "";
        int fetchSize = buffer.length;
        int readCharLen = 0;
        if (null == this.m_clobReserveBuffer) {
            this.m_clobReserveBuffer = new byte[CharactorSetConv.MAX_UTF8_LEN];
        }
        if (null == this.m_lastLen) {
            if (CharSet.GB18030 == this.m_cs) {
                this.m_lastLen = new int[2];
                this.m_lastLen[0] = 0;
                this.m_lastLen[1] = 0;
            } else if (CharSet.UTF8 == this.m_cs) {
                this.m_lastLen = new int[1];
                this.m_lastLen[0] = 0;
            }
        }
        if (LobBuffer.LOBSTORAGETYPE.INLINE == this.m_storageType) {
            if (this.m_lobCharLength > 0L) {
                readByteLen = this.m_lobLength >= (long)fetchSize ? (long)fetchSize : this.m_lobLength;
                int charLen = 0;
                if (CharSet.GB18030 == this.m_cs) {
                    charset = "GB18030";
                    charLen = CharactorSetConv.convGB18030BytesToJavaChars(this.m_array, this.startPos, (int)readByteLen, this.m_clobReserveBuffer, this.m_lastLen, buffer);
                } else if (CharSet.UTF8 == this.m_cs) {
                    charset = "UTF-8";
                    charLen = CharactorSetConv.convUTF8BytesToJavaChars(this.m_array, this.startPos, (int)readByteLen, this.m_clobReserveBuffer, this.m_lastLen, buffer);
                }
                if (0 == charLen) {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("the Clob byte stream is not long enough, or the data source does not conform to the " + charset + " character set specification, please check the data source");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                this.m_lobCharLength -= (long)charLen;
                this.m_lobLength -= readByteLen;
                readCharLen = charLen;
                this.startPos = (int)((long)this.startPos + readByteLen);
            } else {
                readCharLen = -1;
            }
        } else if (LobBuffer.LOBSTORAGETYPE.LOCATOR == this.m_storageType) {
            if (this.m_lobCharLength > 0L) {
                TLobResultSet rlrs = this.m_serviceManager.fetchLobData(this.m_lobHandle, fetchSize, this.m_stmtInfo);
                if (TStatusCode.OK != rlrs.getStatus().status_code) {
                    this.m_errorHandler.Handle(rlrs.getStatus(), this.m_serviceManager.getConnInfoPack(), this.m_stmtInfo);
                }
                if ((readByteLen = (long)rlrs.getPack().getLength()) > (long)fetchSize) {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("lob readLen is greater than fetchSize");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                int charLen = 0;
                if (CharSet.GB18030 == this.m_cs) {
                    charset = "GB18030";
                    charLen = CharactorSetConv.convGB18030BytesToJavaChars(rlrs.getPack().getDatas(), 0, (int)readByteLen, this.m_clobReserveBuffer, this.m_lastLen, buffer);
                } else if (CharSet.UTF8 == this.m_cs) {
                    charset = "UTF-8";
                    charLen = CharactorSetConv.convUTF8BytesToJavaChars(rlrs.getPack().getDatas(), 0, (int)readByteLen, this.m_clobReserveBuffer, this.m_lastLen, buffer);
                }
                if (0 == charLen) {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("the Clob byte stream is not long enough, or the data source does not conform to the " + charset + " character set specification, please check the data source");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                readCharLen = charLen;
                this.m_lobCharLength -= (long)charLen;
            } else {
                readCharLen = -1;
            }
        } else {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("lob open storageType is unknown");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        return readCharLen;
    }
}

