/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.type;

import com.bonc.xcloud.convert.ByteOrderConv;
import com.bonc.xcloud.type.BaseData;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class INTERVALDS
extends BaseData {
    public static final int TYPEID = -104;
    private static int MAXLEADPREC = 9;
    private static int MAXHOUR = 23;
    private static int MAXMINUTE = 59;
    private static int MAXSECOND = 59;
    private static int INTERVALDSMAXLENGTH = 12;
    private static int ASCII_POSITIVE = 43;
    private static int ASCII_NEGATIVE = 45;
    private static int MAXSECONDOFFSET = 4;
    private static int MAXMINUTEOFFSET = 5;
    private static int MAXHOUROFFSET = 6;
    private static int MAXPADDINGOFFSET = 7;
    private static int MAXDAYSOFFSET = 8;
    private static int INTERVALDSBASE = 60;
    private static int INTERVALDAYOFFSET = Integer.MIN_VALUE;
    private int m_day = 0;
    private int m_hour = 0;
    private int m_minute = 0;
    private int m_second = 0;
    private int m_fractional_seconds = 0;
    private String m_str = "";

    public INTERVALDS() {
        super(INTERVALDS._initIntervalDS());
    }

    public INTERVALDS(byte[] paramArrayOfByte) throws SQLException {
        super(paramArrayOfByte);
        this.toString(paramArrayOfByte);
    }

    public INTERVALDS(String paramString) throws SQLException {
        super(INTERVALDS.toBytes(paramString));
        this.toString(this.getBytes());
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public int getDay() {
        return this.m_day;
    }

    public int getHour() {
        return this.m_hour;
    }

    public int getMinute() {
        return this.m_minute;
    }

    public int getSecond() {
        return this.m_second;
    }

    public int getFractionalSeconds() {
        return this.m_fractional_seconds;
    }

    public static byte[] toBytes(String paramString) {
        String fractional_seconds_str;
        int i3;
        String str;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int fractional_seconds = 0;
        byte[] arrayOfByte = new byte[INTERVALDSMAXLENGTH];
        char first_c = (str = paramString.trim()).charAt(0);
        int i = first_c != ASCII_NEGATIVE && first_c != ASCII_POSITIVE ? 0 : 1;
        String str1 = (str = str.substring(i)).substring(0, i3 = str.indexOf(32));
        if (str1.length() > MAXLEADPREC) {
            throw new NumberFormatException();
        }
        day = Integer.valueOf(str1);
        String str2 = str.substring(i3 + 1);
        StringTokenizer localStringTokenizer = new StringTokenizer(str2, ":.");
        if (localStringTokenizer.hasMoreTokens()) {
            String second_str;
            String minute_str;
            String hour_str;
            try {
                hour_str = localStringTokenizer.nextToken();
                minute_str = localStringTokenizer.nextToken();
                second_str = localStringTokenizer.nextToken();
                fractional_seconds_str = localStringTokenizer.nextToken();
            }
            catch (Exception localException) {
                throw new NumberFormatException();
            }
            hour = Integer.valueOf(hour_str);
            minute = Integer.valueOf(minute_str);
            second = Integer.valueOf(second_str);
            if (hour > MAXHOUR) {
                throw new NumberFormatException();
            }
            if (minute > MAXMINUTE) {
                throw new NumberFormatException();
            }
            if (second > MAXSECOND) {
                throw new NumberFormatException();
            }
            if (fractional_seconds_str.length() > MAXLEADPREC) {
                throw new NumberFormatException();
            }
        } else {
            throw new NumberFormatException();
        }
        fractional_seconds = Integer.valueOf(fractional_seconds_str);
        if (first_c == ASCII_NEGATIVE) {
            day = -day;
            hour = -hour;
            minute = -minute;
            second = -second;
            fractional_seconds = -fractional_seconds;
        }
        byte[] fs_byte = ByteOrderConv.ConvIntToByteLE(fractional_seconds);
        for (int fs_idx = 0; fs_idx < 4; ++fs_idx) {
            arrayOfByte[fs_idx] = fs_byte[fs_idx];
        }
        arrayOfByte[INTERVALDS.MAXSECONDOFFSET] = (byte)(second + INTERVALDSBASE);
        arrayOfByte[INTERVALDS.MAXMINUTEOFFSET] = (byte)(minute + INTERVALDSBASE);
        arrayOfByte[INTERVALDS.MAXHOUROFFSET] = (byte)(hour + INTERVALDSBASE);
        arrayOfByte[INTERVALDS.MAXPADDINGOFFSET] = 0;
        byte[] day_byte = ByteOrderConv.ConvIntToByteLE(day);
        for (int day_idx = 0; day_idx < 4; ++day_idx) {
            arrayOfByte[INTERVALDS.MAXDAYSOFFSET + day_idx] = day_byte[day_idx];
        }
        return arrayOfByte;
    }

    public String toString(byte[] paramArrayOfByte) throws SQLException {
        if (paramArrayOfByte.length != 12) {
            throw new NumberFormatException();
        }
        int day = 0;
        byte padding = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int fractional_seconds = 0;
        fractional_seconds = ByteOrderConv.ConvByteToIntLE(paramArrayOfByte, 0);
        second = paramArrayOfByte[MAXSECONDOFFSET];
        minute = paramArrayOfByte[MAXMINUTEOFFSET];
        hour = paramArrayOfByte[MAXHOUROFFSET];
        padding = paramArrayOfByte[MAXPADDINGOFFSET];
        day = ByteOrderConv.ConvByteToIntLE(paramArrayOfByte, MAXDAYSOFFSET);
        boolean i = true;
        if (day < 0 || (hour -= INTERVALDSBASE) < 0 || (minute -= INTERVALDSBASE) < 0 || (second -= INTERVALDSBASE) < 0 || fractional_seconds < 0) {
            i = false;
            day = -day;
            hour = -hour;
            minute = -minute;
            second = -second;
            fractional_seconds = -fractional_seconds;
        }
        if (i) {
            this.m_str = new String(day + " " + hour + ":" + minute + ":" + second + "." + fractional_seconds);
            this.m_day = day;
            this.m_hour = hour;
            this.m_minute = minute;
            this.m_second = second;
            this.m_fractional_seconds = fractional_seconds;
        } else {
            this.m_str = new String("-" + day + " " + hour + ":" + minute + ":" + second + "." + fractional_seconds);
            this.m_day = -day;
            this.m_hour = -hour;
            this.m_minute = -minute;
            this.m_second = -second;
            this.m_fractional_seconds = -fractional_seconds;
        }
        return this.m_str;
    }

    private static byte[] _initIntervalDS() {
        byte[] arrayOfByte = new byte[INTERVALDSMAXLENGTH];
        for (int i = 0; i < INTERVALDSMAXLENGTH; ++i) {
            arrayOfByte[0] = 0;
        }
        return arrayOfByte;
    }

    @Override
    public String stringValue() {
        return this.m_str;
    }

    public String toString() {
        return this.m_str;
    }

    @Override
    public boolean isConvertibleTo(Class paramClass) {
        return paramClass.getName().compareTo("java.lang.String") == 0;
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this;
    }

    @Override
    public Object makeJdbcArray(int paramInt) {
        INTERVALDS[] arrayOfINTERVALDS = new INTERVALDS[paramInt];
        return arrayOfINTERVALDS;
    }
}

