/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.type;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public abstract class BaseData
implements Serializable {
    private byte[] m_data;

    public BaseData(byte[] paramArrayOfByte) {
        this.m_data = paramArrayOfByte;
    }

    public boolean equals(Object paramObject) {
        if (this == paramObject) {
            return true;
        }
        if (paramObject == null || !(paramObject instanceof BaseData)) {
            return false;
        }
        if (this.getClass() == paramObject.getClass()) {
            BaseData localBaseData = (BaseData)paramObject;
            if (this.m_data == null && localBaseData.m_data == null) {
                return true;
            }
            if (this.m_data == null && localBaseData.m_data != null || this.m_data != null && localBaseData.m_data == null) {
                return false;
            }
            if (this.m_data.length != localBaseData.m_data.length) {
                return false;
            }
            for (int i = 0; i < this.m_data.length; ++i) {
                if (this.m_data[i] == localBaseData.m_data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public byte[] shareBytes() {
        return this.m_data;
    }

    public long getLength() {
        if (null == this.m_data) {
            return 0L;
        }
        return this.m_data.length;
    }

    public void setBytes(byte[] paramArrayOfByte) {
        int i = paramArrayOfByte.length;
        this.m_data = new byte[i];
        System.arraycopy(paramArrayOfByte, 0, this.m_data, 0, i);
    }

    public void setShareBytes(byte[] paramArrayOfByte) {
        this.m_data = paramArrayOfByte;
    }

    public byte[] getBytes() {
        return this.m_data;
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.m_data);
    }

    public String stringValue() throws SQLException {
        throw new SQLException("Conversion to String failed");
    }

    public boolean booleanValue() throws SQLException {
        throw new SQLException("Conversion to boolean failed");
    }

    public int intValue() throws SQLException {
        throw new SQLException("Conversion to integer failed");
    }

    public long longValue() throws SQLException {
        throw new SQLException("Conversion to long failed");
    }

    public float floatValue() throws SQLException {
        throw new SQLException("Conversion to float failed");
    }

    public double doubleValue() throws SQLException {
        throw new SQLException("Conversion to double failed");
    }

    public byte byteValue() throws SQLException {
        throw new SQLException("Conversion to byte failed");
    }

    public BigDecimal bigDecimalValue() throws SQLException {
        throw new SQLException("Conversion to BigDecimal failed");
    }

    public Date dateValue() throws SQLException {
        throw new SQLException("Conversion to Date failed");
    }

    public Time timeValue() throws SQLException {
        throw new SQLException("Conversion to Time failed");
    }

    public Timestamp timestampValue() throws SQLException {
        throw new SQLException("Conversion to Timestamp failed");
    }

    public Reader characterStreamValue() throws SQLException {
        throw new SQLException("Conversion to character stream failed");
    }

    public InputStream asciiStreamValue() throws SQLException {
        throw new SQLException("Conversion to ascii stream failed");
    }

    public InputStream binaryStreamValue() throws SQLException {
        throw new SQLException("Conversion to binary stream failed");
    }

    public abstract boolean isConvertibleTo(Class var1);

    public abstract Object toJdbc() throws SQLException;

    public abstract Object makeJdbcArray(int var1);

    protected static int compareBytes(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2) {
        int left_len = paramArrayOfByte1.length;
        int right_len = paramArrayOfByte2.length;
        int min_len = Math.min(left_len, right_len);
        int left_data = 0;
        int right_data = 0;
        for (int index = 0; index < min_len; ++index) {
            left_data = paramArrayOfByte1[index] & 0xFF;
            right_data = paramArrayOfByte2[index] & 0xFF;
            if (left_data == right_data) continue;
            if (left_data < right_data) {
                return -1;
            }
            return 1;
        }
        if (left_len == right_len) {
            return 0;
        }
        if (left_len > right_len) {
            return 1;
        }
        return -1;
    }
}

