/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.sql.parser;

import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.log.XCloudJDBCLogger;
import com.bonc.xcloud.sp_procedure.frontend.Token;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudLexer;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sql.InsertIntoFromClient;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sql.InsertIntoFromCsv;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sql.InsertIntoFromValue;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.SyntaxTree;
import com.bonc.xcloud.sp_procedure.util.SingleSqlParseUtil;
import com.bonc.xcloud.sql.parser.ColumnInfo;
import com.bonc.xcloud.sql.parser.CommandContext;
import com.bonc.xcloud.sql.parser.IParser;
import com.bonc.xcloud.sql.parser.InsertStmtType;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserSQL
implements IParser {
    private static Logger logger = LoggerFactory.getLogger(ParserSQL.class);
    private boolean m_is_insert = false;
    private InsertStmtType m_insert_stmt_type = InsertStmtType.UNKNOWN;
    private static final String BATCH_TOKEN = "VALUES";
    private static final CommandContext.CmdType TYPE = CommandContext.CmdType.BATCH;
    private static final String ENCODE = "UTF-8";
    private static final String CLIENT_TOKEN = "CLIENT:";
    protected XCloudJDBCLogger m_jdbcLogger = null;

    private void parseBatchInsert(String command, CommandContext context, SyntaxTree tree) throws SQLException {
        int i;
        List value_list;
        this.m_insert_stmt_type = InsertStmtType.INSERT_VALUES_BATCH;
        InsertIntoFromValue insert_from_value = (InsertIntoFromValue)tree;
        List column_list = insert_from_value.getColumnList();
        if (column_list == null) {
            String throw_message = ExceptionMgr.getConvertedErrorMsg("Batch insert column list is null!");
            ExceptionMgr.throwSQLExp(throw_message);
        }
        if ((value_list = insert_from_value.getValueExpression()) == null) {
            String throw_message = ExceptionMgr.getConvertedErrorMsg("Batch insert values list is null!");
            ExceptionMgr.throwSQLExp(throw_message);
        }
        int cs = column_list.size();
        for (i = 0; i < value_list.size(); ++i) {
            if (cs == ((List)value_list.get(i)).size()) continue;
            String throw_message = ExceptionMgr.getConvertedErrorMsg("Batch insert column and value list not a same!");
            ExceptionMgr.throwSQLExp(throw_message);
        }
        for (i = 0; i < cs; ++i) {
            ColumnInfo info = null;
            String value = (String)((List)value_list.get(0)).get(i);
            if (value.trim().equals("''") || value.trim().toLowerCase().equals("null")) {
                info = new ColumnInfo(i, (String)column_list.get(i), null);
            } else {
                if (value.trim().startsWith("'") && value.trim().endsWith("'")) {
                    value = value.substring(value.indexOf("'") + 1, value.lastIndexOf("'"));
                }
                info = new ColumnInfo(i, (String)column_list.get(i), value);
            }
            context.addColumnInfo(info);
        }
        String cmd = "";
        String insertSQL = "";
        cmd = command.trim();
        String rex = "(?s)(VALUES)[\\s]*\\(.*\\)";
        Pattern par = Pattern.compile(rex, 2);
        Matcher mat = par.matcher(cmd);
        insertSQL = mat.replaceAll("");
        context.setCommandType(TYPE);
        context.setFileEncode(ENCODE);
        context.setCommand(command);
        context.setInsertSQL(insertSQL.trim());
    }

    private void parseNewClient(String command, CommandContext context, SyntaxTree tree) throws SQLException {
        this.m_insert_stmt_type = InsertStmtType.INSERT_CLIENT_NEW;
        InsertIntoFromCsv insert_from_client_new = (InsertIntoFromCsv)tree;
        String cmd = command.trim();
        String encode = insert_from_client_new.getEncodeChar();
        String filePath = insert_from_client_new.getFilePath();
        int index = CLIENT_TOKEN.length();
        filePath = filePath.substring(index);
        System.out.println("parseNewClient path:=" + filePath);
        context.setCommandType(CommandContext.CmdType.CLIENT_NEW);
        context.setCommand(command);
        if (encode != null) {
            context.setFileEncode(encode.trim());
        }
        context.setFilePath(filePath.trim());
        context.setInsertSQL(command);
    }

    private void parseOldClient(String command, CommandContext context, SyntaxTree tree) throws SQLException {
        this.m_insert_stmt_type = InsertStmtType.INSERT_CLIENT_OLD;
        String cmd = "";
        String encode = "GBK";
        String filePath = "";
        String insertSQL = "";
        InsertIntoFromClient insert_from_client = (InsertIntoFromClient)tree;
        filePath = insert_from_client.getFilePath();
        insertSQL = insert_from_client.toSql(null);
        System.out.println("parseOldClient path:=" + filePath);
        context.setCommandType(CommandContext.CmdType.CLIENT_OLD);
        context.setCommand(command);
        context.setFileEncode(encode.trim());
        context.setFilePath(filePath.trim());
        context.setInsertSQL(insertSQL.trim());
        context.setPrefix(insert_from_client.getAnnotation());
    }

    @Override
    public void doParser(String command, CommandContext context, boolean isNeedToCheck) throws SQLException {
        block9: {
            String throw_message;
            context.setInsertSQL(command);
            context.setCommandType(TYPE);
            if (command.length() == 0 || command == null) {
                throw_message = ExceptionMgr.getConvertedErrorMsg("Command is empty!");
                ExceptionMgr.throwSQLExp(throw_message);
            }
            if (context == null) {
                throw_message = ExceptionMgr.getConvertedErrorMsg("ParserSQL context is null!");
                ExceptionMgr.throwSQLExp(throw_message);
            }
            try {
                XcloudLexer sql_lex = new XcloudLexer(command);
                Token first_token = sql_lex.nextToken();
                if (first_token.getType() != XcloudTokenType.INSERT && first_token.getType() != XcloudTokenType.AT) {
                    return;
                }
                SyntaxTree tree = SingleSqlParseUtil.parseSql((String)command);
                if (tree instanceof InsertIntoFromValue) {
                    this.m_is_insert = true;
                    if (isNeedToCheck) {
                        this.parseBatchInsert(command, context, tree);
                    }
                    break block9;
                }
                if (tree instanceof InsertIntoFromClient) {
                    this.m_is_insert = true;
                    this.parseOldClient(command, context, tree);
                    break block9;
                }
                if (!(tree instanceof InsertIntoFromCsv)) break block9;
                InsertIntoFromCsv insert_from_csv = (InsertIntoFromCsv)tree;
                if (insert_from_csv.getFilePath().trim().toUpperCase().startsWith(CLIENT_TOKEN)) {
                    this.m_is_insert = true;
                    this.parseNewClient(command, context, tree);
                    break block9;
                }
                return;
            }
            catch (Exception e) {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("ParserSQL doParse Error:" + e.getMessage());
                XCloudJDBCLogger.Write_Log(retMsg);
                logger.error(retMsg);
            }
        }
    }

    public boolean isInsert() {
        return this.m_is_insert;
    }

    public InsertStmtType getInsertStmtType() {
        return this.m_insert_stmt_type;
    }
}

