/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.sp.jdbc;

import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.jdbc.XCloudStatement;
import com.bonc.xcloud.sp.common.ConnTarget;
import com.bonc.xcloud.sp.common.SQLParser;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCloudSPStatement
implements Statement {
    XCloudStatement m_xcloudStmt = null;
    XCloudStatement m_plStmt = null;
    public static Logger logger = LoggerFactory.getLogger(XCloudSPStatement.class);
    ConnTarget m_currentTarget = ConnTarget.XCLOUD;

    public XCloudSPStatement(XCloudStatement xcStmt, XCloudStatement plStmt) {
        this.m_xcloudStmt = xcStmt;
        this.m_plStmt = plStmt;
    }

    XCloudStatement Stmt() {
        return ConnTarget.XCLOUD == this.m_currentTarget ? this.m_xcloudStmt : this.m_plStmt;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet ret = null;
        String trimSQL = SQLParser.trimSQLComment(sql);
        if (SQLParser.isSPSupportSQL(trimSQL)) {
            if (logger.isInfoEnabled()) {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP Now is PL working...");
                logger.info(retMsg);
            }
            ret = this.m_plStmt.executeQuery(sql);
            this.m_currentTarget = ConnTarget.PLSQL;
        } else {
            if (logger.isInfoEnabled()) {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP Now is XCLOUD working...");
                logger.info(retMsg);
            }
            ret = this.m_xcloudStmt.executeQuery(sql);
            this.m_currentTarget = ConnTarget.XCLOUD;
        }
        return ret;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        int ret = 0;
        String trimSQL = SQLParser.trimSQLComment(sql);
        if (SQLParser.isSPSupportSQL(trimSQL)) {
            if (logger.isInfoEnabled()) {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP Now is PL working...");
                logger.info(retMsg);
            }
            ret = this.m_plStmt.executeUpdate(sql);
            this.m_currentTarget = ConnTarget.PLSQL;
        } else {
            if (logger.isInfoEnabled()) {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP Now is XCLOUD working...");
                logger.info(retMsg);
            }
            ret = this.m_xcloudStmt.executeUpdate(sql);
            this.m_currentTarget = ConnTarget.XCLOUD;
        }
        return ret;
    }

    @Override
    public void close() throws SQLException {
        this.m_plStmt.close();
        this.m_xcloudStmt.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new RuntimeException("[XCloudSPStatement getMaxFieldSize] Not Implemented yet.");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new RuntimeException("[XCloudSPStatement setMaxFieldSize] Not Implemented yet.");
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.m_xcloudStmt.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.m_xcloudStmt.setMaxRows(max);
        this.m_plStmt.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new RuntimeException("[XCloudSPStatement setEscapeProcessing] Not Implemented yet.");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.m_xcloudStmt.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.m_xcloudStmt.setQueryTimeout(seconds);
        this.m_plStmt.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.Stmt().cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.Stmt().getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.m_xcloudStmt.clearWarnings();
        this.m_plStmt.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new RuntimeException("[XCloudSPStatement setCursorName] Not Implemented yet.");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean ret = false;
        String trimSQL = SQLParser.trimSQLComment(sql);
        if (SQLParser.isSPSupportSQL(trimSQL)) {
            if (logger.isInfoEnabled()) {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP Now is PL working...");
                logger.info(retMsg);
            }
            ret = this.m_plStmt.execute(sql);
            this.m_currentTarget = ConnTarget.PLSQL;
        } else {
            if (logger.isInfoEnabled()) {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP Now is XCLOUD working...");
                logger.info(retMsg);
            }
            ret = this.m_xcloudStmt.execute(sql);
            this.m_currentTarget = ConnTarget.XCLOUD;
        }
        return ret;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.Stmt().getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int updateCount = this.Stmt().getUpdateCount();
        return updateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.Stmt().getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new RuntimeException("[XCloudSPStatement setFetchDirection] Not Implemented yet.");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.m_plStmt.setFetchSize(rows);
        this.m_xcloudStmt.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.Stmt().getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new RuntimeException("[XCloudSPStatement getResultSetConcurrency] Not Implemented yet.");
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new RuntimeException("[XCloudSPStatement getResultSetConcurrency] Not Implemented yet.");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (logger.isInfoEnabled()) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP Now is XCLOUD working...");
            logger.info(retMsg);
        }
        this.m_xcloudStmt.addBatch(sql);
        this.m_currentTarget = ConnTarget.XCLOUD;
    }

    @Override
    public void clearBatch() throws SQLException {
        if (logger.isInfoEnabled()) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP Now is XCLOUD working...");
            logger.info(retMsg);
        }
        this.m_currentTarget = ConnTarget.XCLOUD;
        this.m_xcloudStmt.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (logger.isInfoEnabled()) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP Now is XCLOUD working...");
            logger.info(retMsg);
        }
        this.m_currentTarget = ConnTarget.XCLOUD;
        return this.m_xcloudStmt.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        throw new RuntimeException("[XCloudSPStatement getConnection] Not Implemented yet.");
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new RuntimeException("[XCloudSPStatement getMoreResults] Not Implemented yet.");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new RuntimeException("[XCloudSPStatement getGeneratedKeys] Not Implemented yet.");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new RuntimeException("[XCloudSPStatement executeUpdate(String, int)] Not Implemented yet.");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new RuntimeException("[XCloudSPStatement executeUpdate(String, int[])] Not Implemented yet.");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new RuntimeException("[XCloudSPStatement executeUpdate(String, String[])] Not Implemented yet.");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new RuntimeException("[XCloudSPStatement executeUpdate(String, int)] Not Implemented yet.");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new RuntimeException("[XCloudSPStatement executeUpdate(String, int[])] Not Implemented yet.");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new RuntimeException("[XCloudSPStatement execute(String, String[])] Not Implemented yet.");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new RuntimeException("[XCloudSPStatement getResultSetHoldability] Not Implemented yet.");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_xcloudStmt.isClosed() && this.m_plStmt.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new RuntimeException("[XCloudSPStatement setPoolable] Not Implemented yet.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new RuntimeException("[XCloudSPStatement isPoolable] Not Implemented yet.");
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return this.Stmt().getLargeUpdateCount();
    }
}

