/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.sp.jdbc;

import com.bonc.xcloud.common.ConnInfo;
import com.bonc.xcloud.common.ConnInfoPack;
import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.jdbc.XCloudConnection;
import com.bonc.xcloud.jdbc.XCloudDriver;
import com.bonc.xcloud.log.XCloudJDBCLogger;
import com.bonc.xcloud.sp.common.ConnTarget;
import com.bonc.xcloud.sp.jdbc.XCloudSPConnection;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCloudSPDriver
implements Driver {
    private static Logger logger = LoggerFactory.getLogger(XCloudSPDriver.class);
    private int m_connectRetry = 3;
    private int m_socketTimeOut = 3600000;
    private boolean m_connectDirect = false;
    private int m_buffMemory = 0x400000;
    private int m_clientLoadBlockSize = 0x400000;
    private String m_metaStoreIP = null;
    private int m_metaStorePort = 0;
    private static final int MAX_BUFFER_SIZE = 0x20000000;
    private static XCloudJDBCLogger m_jdbcLogger = null;
    private static String XC_URL_PREFIX = "jdbc:xcloud:";
    private static String SP_URL_PREFIX = "jdbc:sp:";

    @Override
    public boolean acceptsURL(String arg0) throws SQLException {
        boolean ret = false;
        String[] firstTemp = arg0.split("\\|");
        if (firstTemp.length == 1) {
            ret = Pattern.matches(XC_URL_PREFIX + ".*", firstTemp[0]) || Pattern.matches(SP_URL_PREFIX + ".*", firstTemp[0]);
        } else if (firstTemp.length == 2) {
            ret = Pattern.matches(XC_URL_PREFIX + ".*", firstTemp[0]) || Pattern.matches(XC_URL_PREFIX + ".*", firstTemp[1]) || Pattern.matches(SP_URL_PREFIX + ".*", firstTemp[0]) || Pattern.matches(SP_URL_PREFIX + ".*", firstTemp[1]);
        } else {
            boolean bl = ret = Pattern.matches(XC_URL_PREFIX + ".*", firstTemp[0]) || Pattern.matches(SP_URL_PREFIX + ".*", firstTemp[0]);
            if (ret) {
                this.urlWrongThrow("No suitable driver found for url=[" + arg0 + "]");
            }
        }
        return ret;
    }

    public void urlWrongThrow(String info) throws SQLException {
        String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP " + info);
        logger.error(retMsg);
        ExceptionMgr.throwSQLExp(retMsg);
    }

    private ConnTarget acceptsURL(String arg0, ConnInfoPack infoPack) throws SQLException {
        byte[] bytes;
        String[] secondTemp;
        String[] firstTemp;
        ConnTarget conn_target = ConnTarget.XCLOUD;
        if (null == arg0 || 0 == arg0.length()) {
            this.urlWrongThrow("URL format not right ,check this content=[" + arg0 + "]");
        }
        if ((firstTemp = arg0.split("\\?")).length > 2) {
            this.urlWrongThrow("URL format not right ,check this content=[" + arg0 + "]");
        }
        if ((secondTemp = firstTemp[0].split(":@")).length != 2) {
            this.urlWrongThrow("URL format not right ,check this content=[" + firstTemp[0] + "]");
        }
        if (secondTemp[0].equals("jdbc:xcloud")) {
            conn_target = ConnTarget.XCLOUD;
        } else if (secondTemp[0].equals("jdbc:sp")) {
            conn_target = ConnTarget.PLSQL;
        } else {
            this.urlWrongThrow("URL format not right ,check this content=[" + secondTemp[0] + "]");
        }
        String[] thridTemp = secondTemp[1].split("@");
        if (thridTemp.length == 0) {
            this.urlWrongThrow("URL format not right ,check this content=[" + secondTemp[1] + "]");
        }
        for (int idx = 0; idx < thridTemp.length; ++idx) {
            ConnInfo info = new ConnInfo();
            String[] strTmp = thridTemp[idx].split("/");
            if (strTmp.length > 2) {
                this.urlWrongThrow("URL format not right ,check this content=[" + firstTemp[0] + "]");
            }
            if (strTmp.length == 1) {
                info.setDBName("");
            } else {
                info.setDBName(strTmp[1]);
            }
            try {
                bytes = strTmp[0].getBytes("US-ASCII");
                for (int i = 0; i < bytes.length; ++i) {
                    if (bytes[i] >= 46 && bytes[i] <= 58) continue;
                    this.urlWrongThrow("URL format not right ,check this content=[" + strTmp[0] + "]");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            strTmp = strTmp[0].split(":");
            if (strTmp.length != 2) {
                this.urlWrongThrow("URL format not right ,check this content=[" + strTmp[0] + "]");
            }
            info.setRemoteIP(strTmp[0]);
            info.setRemotePort(strTmp[1]);
            infoPack.addConnInfo(info);
        }
        if (firstTemp.length == 2) {
            String[] strTemp = firstTemp[1].split("&");
            for (int idx = 0; idx < strTemp.length; ++idx) {
                String[] temp = strTemp[idx].split("=");
                if (temp.length != 2) {
                    this.urlWrongThrow("URL format not right ,check this content=[" + strTemp[idx] + "]");
                }
                if (temp[0].trim().equalsIgnoreCase("connectRetry")) {
                    try {
                        infoPack.setConnectRetry(Integer.parseInt(temp[1].trim()));
                    }
                    catch (NumberFormatException e) {
                        this.urlWrongThrow("URL format not right, connectRetry value should be a number!");
                    }
                    continue;
                }
                if (temp[0].trim().equalsIgnoreCase("socketTimeOut")) {
                    try {
                        infoPack.setSocketTimeOut(Integer.parseInt(temp[1].trim()));
                    }
                    catch (NumberFormatException e) {
                        this.urlWrongThrow("URL format not right, socketTimeOut value should be a number!");
                    }
                    continue;
                }
                if (temp[0].trim().equalsIgnoreCase("connectDirect")) {
                    infoPack.setConnectDirect(Boolean.parseBoolean(temp[1].trim()));
                    continue;
                }
                if (temp[0].trim().equalsIgnoreCase("buffMemory")) {
                    if (conn_target == ConnTarget.PLSQL) {
                        this.urlWrongThrow("URL format not right, not support set buffer memory for SP");
                    }
                    try {
                        this.m_buffMemory = Integer.parseInt(temp[1].trim());
                        if (this.m_buffMemory > 0x20000000) {
                            this.urlWrongThrow("URL format not right, buffer memory > 256M, it's not support");
                        }
                        if (this.m_buffMemory <= Integer.MAX_VALUE) continue;
                        this.urlWrongThrow("URL format not right, buffer memory > Byte array can allocate size!");
                    }
                    catch (NumberFormatException e) {
                        this.urlWrongThrow("URL format not right, maxMemory value should be a number!");
                    }
                    continue;
                }
                if (temp[0].trim().equalsIgnoreCase("clientLoadBlockSize")) {
                    if (conn_target == ConnTarget.PLSQL) {
                        this.urlWrongThrow("URL format not right, not support set client Load block size for SP");
                    }
                    this.m_clientLoadBlockSize = Integer.parseInt(temp[1].trim());
                    if (this.m_clientLoadBlockSize < 0x20000000) continue;
                    this.urlWrongThrow("URL format not right, client Load Block Size > 256M, it's not support");
                    continue;
                }
                if (temp[0].trim().equalsIgnoreCase("fieldSensitive")) {
                    if (conn_target == ConnTarget.PLSQL) {
                        this.urlWrongThrow("URL format not right, not support set fieldSensitive for SP");
                    }
                    XCloudDriver.FIELD_SENSITIVE = Boolean.parseBoolean(temp[1].trim());
                    continue;
                }
                if (temp[0].trim().equalsIgnoreCase("MetaStoreIP")) {
                    if (conn_target == ConnTarget.PLSQL) {
                        this.urlWrongThrow("URL format not right, not support set MetaStoreIP for SP");
                    }
                    try {
                        bytes = temp[1].getBytes("US-ASCII");
                        for (int i = 0; i < bytes.length; ++i) {
                            if (bytes[i] >= 46 && bytes[i] <= 58) continue;
                            String retMsg = ExceptionMgr.getConvertedErrorMsg("URL format not right ,check this content=[" + temp[0] + "]");
                            logger.error(retMsg);
                            ExceptionMgr.throwSQLExp(retMsg);
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    this.m_metaStoreIP = temp[1].trim();
                    continue;
                }
                if (temp[0].trim().equalsIgnoreCase("MetaStorePort")) {
                    if (conn_target == ConnTarget.PLSQL) {
                        this.urlWrongThrow("URL format not right, not support set MetaStorePort for SP");
                    }
                    try {
                        this.m_metaStorePort = Integer.parseInt(temp[1].trim());
                    }
                    catch (NumberFormatException e) {
                        String retMsg = ExceptionMgr.getConvertedErrorMsg("URL format not right, metaStorePort value should be a number!");
                        ExceptionMgr.throwSQLExp(retMsg);
                    }
                    continue;
                }
                this.urlWrongThrow("URL format not right ,check this content=[" + strTemp[idx] + "]");
            }
        }
        return conn_target;
    }

    @Override
    public Connection connect(String arg0, Properties arg1) throws SQLException {
        if (!this.acceptsURL(arg0 = arg0.replaceAll("\r|\n|\t", ""))) {
            return null;
        }
        String[] firstTemp = arg0.split("\\|");
        if (firstTemp.length > 2) {
            this.urlWrongThrow("No suitable driver found for url=[" + arg0 + "]");
        }
        int urlCount = firstTemp.length;
        ConnInfoPack[] infoPack = new ConnInfoPack[urlCount];
        ConnTarget[] connTarget = new ConnTarget[urlCount];
        String url = null;
        int xcloudIndex = -1;
        int plIndex = -1;
        for (int i = 0; i < urlCount; ++i) {
            url = firstTemp[i];
            if (logger.isInfoEnabled()) {
                logger.info("Receive arg=[" + url + "]");
            }
            infoPack[i] = new ConnInfoPack();
            infoPack[i].setConnectDirect(this.m_connectDirect);
            infoPack[i].setConnectRetry(this.m_connectRetry);
            infoPack[i].setSocketTimeOut(this.m_socketTimeOut);
            connTarget[i] = this.acceptsURL(url, infoPack[i]);
            if (connTarget[i] == ConnTarget.XCLOUD) {
                xcloudIndex = i;
            } else if (connTarget[i] == ConnTarget.PLSQL) {
                plIndex = i;
            }
            infoPack[i].setURL(url);
            infoPack[i].setBuffMemory(this.m_buffMemory);
            infoPack[i].setClientLoadBlockSize(this.m_clientLoadBlockSize);
            infoPack[i].setDBUserName(arg1.getProperty("user"));
            infoPack[i].setDBPassWd(arg1.getProperty("password"));
            infoPack[i].setMetaStoreIP(this.m_metaStoreIP);
            infoPack[i].setMetaStorePort(this.m_metaStorePort);
            this.m_metaStoreIP = null;
            this.m_metaStorePort = 0;
        }
        if (xcloudIndex == 0 && plIndex == 1) {
            XCloudSPConnection conn = new XCloudSPConnection(infoPack[0], infoPack[1], m_jdbcLogger);
            if (logger.isInfoEnabled()) {
                String infoMsg = infoPack[0].getConnInfoPackMsg() + infoPack[1].getConnInfoPackMsg();
                logger.info(infoMsg);
                XCloudJDBCLogger.Write_Log(infoMsg);
            }
            return conn;
        }
        if (xcloudIndex == 0 && plIndex == -1) {
            XCloudConnection conn = new XCloudConnection(infoPack[0], m_jdbcLogger);
            conn.connectInit();
            infoPack[0].setCurrentConnID(System.identityHashCode(conn));
            if (logger.isInfoEnabled()) {
                String infoMsg = infoPack[0].getConnInfoPackMsg();
                logger.info(infoMsg);
                XCloudJDBCLogger.Write_Log(infoMsg);
            }
            return conn;
        }
        if (xcloudIndex == -1 && plIndex == 0) {
            XCloudConnection conn = new XCloudConnection(infoPack[0], m_jdbcLogger);
            conn.connectInit();
            if (logger.isInfoEnabled()) {
                String infoMsg = infoPack[0].getConnInfoPackMsg();
                logger.info(infoMsg);
                XCloudJDBCLogger.Write_Log(infoMsg);
            }
            infoPack[0].setCurrentConnID(System.identityHashCode(conn));
            return conn;
        }
        String retMsg = ExceptionMgr.getConvertedErrorMsg("No suitable driver found for url=[" + arg0 + "]");
        logger.error(retMsg);
        ExceptionMgr.throwSQLExp(retMsg);
        return null;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String arg0, Properties arg1) throws SQLException {
        return null;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(new XCloudSPDriver());
        }
        catch (SQLException e) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Can't Register XCloud SP Driver!");
            logger.error(retMsg);
            throw new RuntimeException(retMsg);
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            try {
                m_jdbcLogger = new XCloudJDBCLogger("./xcloud_jdbc.log");
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            m_jdbcLogger = new XCloudJDBCLogger("./xcloud_jdbc.log");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

