/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.sp.jdbc;

import com.bonc.xcloud.common.ConnInfoPack;
import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.jdbc.XCloudConnection;
import com.bonc.xcloud.jdbc.XCloudStatement;
import com.bonc.xcloud.log.XCloudJDBCLogger;
import com.bonc.xcloud.sp.common.SQLParser;
import com.bonc.xcloud.sp.jdbc.XCloudSPCallableStatement;
import com.bonc.xcloud.sp.jdbc.XCloudSPStatement;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCloudSPConnection
implements Connection {
    private XCloudConnection m_xcloudConn = null;
    private XCloudConnection m_plConn = null;
    public static Logger logger = LoggerFactory.getLogger(XCloudSPConnection.class);
    private XCloudJDBCLogger m_log = null;

    public XCloudSPConnection(ConnInfoPack xcloudConnInfoPack, ConnInfoPack plConnInfoPack, XCloudJDBCLogger jdbcLogger) throws SQLException {
        this.m_xcloudConn = new XCloudConnection(xcloudConnInfoPack, jdbcLogger);
        this.m_xcloudConn.connectInit();
        xcloudConnInfoPack.setCurrentConnID(System.identityHashCode(this.m_xcloudConn));
        String user_info = xcloudConnInfoPack.getCurrentRemoteIP() + ":" + xcloudConnInfoPack.getCurrentRemotePort() + ":" + xcloudConnInfoPack.getDBUserName();
        plConnInfoPack.setDBUserName(user_info);
        this.m_plConn = new XCloudConnection(plConnInfoPack, jdbcLogger);
        this.m_plConn.connectInit();
        plConnInfoPack.setCurrentConnID(System.identityHashCode(this.m_plConn));
        this.m_log = jdbcLogger;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection unwrap] Not Implemented yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection isWrapperFor] Not Implemented yet.");
    }

    @Override
    public Statement createStatement() throws SQLException {
        XCloudStatement xcStmt = (XCloudStatement)this.m_xcloudConn.createStatement();
        XCloudStatement plStmt = (XCloudStatement)this.m_plConn.createStatement();
        return new XCloudSPStatement(xcStmt, plStmt);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        String trimSQL = SQLParser.trimSQLComment(sql);
        if (SQLParser.isSPSupportSQL(trimSQL)) {
            if (logger.isInfoEnabled()) {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP Now is PL working...");
                logger.info(retMsg);
            }
            return this.m_plConn.prepareStatement(sql);
        }
        if (logger.isInfoEnabled()) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP Now is XCLOUD working...");
            logger.info(retMsg);
        }
        return this.m_xcloudConn.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        String trimSQL = SQLParser.trimSQLComment(sql);
        if (SQLParser.isSPSupportSQL(trimSQL)) {
            if (logger.isInfoEnabled()) {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP Now is PL working...");
                logger.info(retMsg);
            }
            return this.m_plConn.prepareCall(sql);
        }
        if (logger.isInfoEnabled()) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP Now is XCLOUD working...");
            logger.info(retMsg);
        }
        return new XCloudSPCallableStatement(this.m_xcloudConn, this.m_log, sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection nativeSQL] Not Implemented yet.");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
        throw new RuntimeException("[XCloudSPConnection rollback] Not Implemented yet.");
    }

    @Override
    public void close() throws SQLException {
        this.m_plConn.close();
        this.m_xcloudConn.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_plConn.isClosed() && this.m_xcloudConn.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.m_xcloudConn.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection setCatalog] Not Implemented yet.");
    }

    @Override
    public String getCatalog() throws SQLException {
        return "empty";
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection setTransactionIsolation] Not Implemented yet.");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning xcloudW = this.m_xcloudConn.getWarnings();
        SQLWarning plW = this.m_plConn.getWarnings();
        xcloudW.setNextWarning(plW);
        return xcloudW;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.m_plConn.clearWarnings();
        this.m_xcloudConn.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection createStatement(int, int)] Not Implemented yet.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection prepareStatement(String, int, int)] Not Implemented yet.");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection prepareCall(String, int, int)] Not Implemented yet.");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new RuntimeException("[XCloudSPConnection getTypeMap] Not Implemented yet.");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection setTypeMap] Not Implemented yet.");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection setHoldability] Not Implemented yet.");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new RuntimeException("[XCloudSPConnection setSavepoint] Not Implemented yet.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection setSavepoint] Not Implemented yet.");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection rollback] Not Implemented yet.");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection releaseSavepoint] Not Implemented yet.");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection createStatement(int, int, int)] Not Implemented yet.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection prepareStatement(String, int, int, int)] Not Implemented yet.");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection prepareCall(String, int, int, int)] Not Implemented yet.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection prepareStatement(String, int)] Not Implemented yet.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection prepareStatement(String, int[])] Not Implemented yet.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection prepareStatement(String, String[])] Not Implemented yet.");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new RuntimeException("[XCloudSPConnection createClob] Not Implemented yet.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new RuntimeException("[XCloudSPConnection createBlob] Not Implemented yet.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new RuntimeException("[XCloudSPConnection createNClob] Not Implemented yet.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new RuntimeException("[XCloudSPConnection createSQLXML] Not Implemented yet.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection isValid] Not Implemented yet.");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new RuntimeException("[XCloudSPConnection setClientInfo] Not Implemented yet.");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new RuntimeException("[XCloudSPConnection setClientInfo] Not Implemented yet.");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection getClientInfo] Not Implemented yet.");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new RuntimeException("[XCloudSPConnection getClientInfo] Not Implemented yet.");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection createArrayOf] Not Implemented yet.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new RuntimeException("[XCloudSPConnection createStruct] Not Implemented yet.");
    }
}

