/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.sp.common;

import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.sp_procedure.frontend.Token;
import com.bonc.xcloud.sp_procedure.frontend.TokenType;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudLexer;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLParser {
    public static Logger logger = LoggerFactory.getLogger(SQLParser.class);
    public static XcloudTokenType[] pl_create_match_type_prefix = new XcloudTokenType[]{XcloudTokenType.CREATE, XcloudTokenType.OR, XcloudTokenType.REPLACE};
    public static XcloudTokenType[] pl_match_type = new XcloudTokenType[]{XcloudTokenType.FUNCTION, XcloudTokenType.PROCEDURE, XcloudTokenType.PACKAGE};
    public static XcloudTokenType pl_drop_match_type = XcloudTokenType.DROP;

    public static String trimSQLComment(String sql) {
        int index;
        String ret = sql;
        if (sql.toLowerCase().startsWith("/*") && (index = sql.toLowerCase().indexOf("*/")) != -1) {
            ret = sql.substring(index + 2).trim();
        }
        return ret;
    }

    public static boolean isSPSupportDropSQL(String sql) throws SQLException {
        boolean ret = false;
        try {
            XcloudLexer sql_lexer = new XcloudLexer(sql);
            TokenType token_type = sql_lexer.nextToken().getType();
            if (token_type == pl_drop_match_type) {
                token_type = sql_lexer.nextToken().getType();
                for (XcloudTokenType type : pl_match_type) {
                    if (type != token_type) continue;
                    ret = true;
                }
            }
        }
        catch (Exception e) {
            String info = "SQL Parse Error";
            String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP " + info);
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        return ret;
    }

    public static boolean isSPSupportCallSQL(String sql) throws SQLException {
        boolean ret = false;
        XcloudTokenType token_type = XcloudTokenType.IDENTIFIER;
        try {
            XcloudLexer sql_lexer = new XcloudLexer(sql);
            Token first_token = sql_lexer.nextToken();
            String first = first_token.getText().toUpperCase();
            if (first.equals("{")) {
                Token second_token = sql_lexer.nextToken();
                if (second_token.getText().toUpperCase().equals("CALL") || second_token.getType() == XcloudTokenType.QUESTION_MARK) {
                    ret = true;
                }
            } else if (first.equals("CALL") || first_token.getType() == XcloudTokenType.QUESTION_MARK) {
                ret = true;
            }
        }
        catch (Exception e) {
            String info = "SQL Parse Error";
            String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP " + info);
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        return ret;
    }

    public static boolean isSPSupportCreateSQL(String sql) throws SQLException {
        boolean ret = false;
        XcloudTokenType token_type = XcloudTokenType.IDENTIFIER;
        try {
            int i;
            XcloudLexer sql_lexer = new XcloudLexer(sql);
            for (i = 0; i < pl_create_match_type_prefix.length; ++i) {
                token_type = sql_lexer.nextToken().getType();
                if (token_type == pl_create_match_type_prefix[i]) {
                    continue;
                }
                if (i == 1) {
                    for (XcloudTokenType type : pl_match_type) {
                        if (type != token_type) continue;
                        ret = true;
                    }
                }
                return ret;
            }
            if (i == pl_create_match_type_prefix.length) {
                token_type = sql_lexer.nextToken().getType();
                for (XcloudTokenType type : pl_match_type) {
                    if (type != token_type) continue;
                    ret = true;
                }
            }
        }
        catch (Exception e) {
            String info = "SQL Parse Error";
            String retMsg = ExceptionMgr.getConvertedErrorMsg("XCloud SP " + info);
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        return ret;
    }

    public static boolean isSPSupportSQL(String sql) throws SQLException {
        return SQLParser.isSPSupportDropSQL(sql) || SQLParser.isSPSupportCreateSQL(sql) || SQLParser.isSPSupportCallSQL(sql);
    }
}

