/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.log;

import com.bonc.xcloud.common.ExceptionMgr;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;

public class XCloudJDBCLogger {
    private static boolean m_isExit;
    private static OutputStreamWriter m_OutputStreamWriter;

    public XCloudJDBCLogger(String path) throws SQLException {
        File file = new File(path);
        if (!file.exists()) {
            m_isExit = false;
            return;
        }
        m_isExit = true;
        try {
            m_OutputStreamWriter = new OutputStreamWriter(new FileOutputStream(path, true));
        }
        catch (FileNotFoundException e) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Logger err:" + e.getMessage());
            ExceptionMgr.throwSQLExp(retMsg);
        }
    }

    public static boolean Write_Log(String infoString) throws SQLException {
        if (!m_isExit) {
            return false;
        }
        try {
            m_OutputStreamWriter.write(infoString + "\n");
            m_OutputStreamWriter.flush();
        }
        catch (Exception e) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Logger write err:" + e.getMessage());
            ExceptionMgr.throwSQLExp(retMsg);
        }
        return true;
    }

    protected void finalize() throws Throwable {
        m_OutputStreamWriter.close();
        super.finalize();
    }
}

