/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.loader;

import com.bonc.xcloud.common.ExceptionMgr;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;

public class FileIOServiceWithByteStream {
    private BufferedInputStream m_in_stream = null;
    private int m_clientLoadBlockSize = 0;
    private byte[] m_buffer = null;

    public void reset(String path, int clientLoadBlockSize) throws SQLException {
        try {
            this.m_in_stream = new BufferedInputStream(new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            String throw_message = ExceptionMgr.getConvertedErrorMsg("FileIOServiceWithByteStream :" + path + " is not file or is not exist...");
            ExceptionMgr.throwSQLExp(throw_message);
        }
        this.m_clientLoadBlockSize = clientLoadBlockSize;
        try {
            this.m_buffer = new byte[this.m_clientLoadBlockSize];
        }
        catch (OutOfMemoryError ex) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("FileIOServiceWithByteStream reset Allocate " + this.m_clientLoadBlockSize + "bytes, out of Memory, try smaller fetchsize!");
            ExceptionMgr.throwSQLExp(retMsg);
        }
    }

    public ByteBuffer readOneBlock() throws SQLException {
        int length = 0;
        ByteBuffer result = null;
        try {
            length = this.m_in_stream.read(this.m_buffer, 0, this.m_clientLoadBlockSize);
            if (-1 == length) {
                return result;
            }
            result = ByteBuffer.wrap(this.m_buffer, 0, length);
        }
        catch (IOException e) {
            String throw_message = ExceptionMgr.getConvertedErrorMsg("FileIOService readOneBlock : read error...");
            ExceptionMgr.throwSQLExp(throw_message);
        }
        return result;
    }

    public void closeFile() throws SQLException {
        try {
            this.m_in_stream.close();
        }
        catch (IOException e) {
            String throw_message = ExceptionMgr.getConvertedErrorMsg("FileIOService closeFile : error...");
            ExceptionMgr.throwSQLExp(throw_message);
        }
        this.m_in_stream = null;
    }
}

