/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.loader;

import com.bonc.xcloud.common.ExceptionMgr;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class FileIOService {
    private File m_file = null;
    private FileInputStream m_fis = null;
    private InputStreamReader m_isr = null;
    private BufferedReader m_reader = null;
    private String m_line = null;
    private int m_clientLoadBlockSize = 0;

    public void reset(String path, String encoding, int clientLoadBlockSize) throws SQLException {
        this.m_file = new File(path);
        this.m_clientLoadBlockSize = clientLoadBlockSize;
        if (!this.m_file.isFile() || !this.m_file.exists()) {
            String throw_message = ExceptionMgr.getConvertedErrorMsg("FileIOService reset:" + path + " is not file or is not exist...");
            ExceptionMgr.throwSQLExp(throw_message);
        }
        try {
            this.m_fis = new FileInputStream(this.m_file);
            this.m_isr = new InputStreamReader((InputStream)this.m_fis, encoding);
        }
        catch (UnsupportedEncodingException e) {
            String throw_message = ExceptionMgr.getConvertedErrorMsg("FileIOService reset: UnsupportedEncodingException");
            ExceptionMgr.throwSQLExp(throw_message);
        }
        catch (FileNotFoundException e) {
            String throw_message = ExceptionMgr.getConvertedErrorMsg("FileIOService reset:" + path + " is not file...");
            ExceptionMgr.throwSQLExp(throw_message);
        }
        this.m_reader = new BufferedReader(this.m_isr);
    }

    public String readOneBlock() throws SQLException {
        StringBuffer block = new StringBuffer();
        try {
            while ((this.m_line = this.m_reader.readLine()) != null) {
                this.m_line = this.m_line + "\n";
                block.append(this.m_line);
                if (block.length() <= this.m_clientLoadBlockSize) continue;
                break;
            }
        }
        catch (IOException e) {
            String throw_message = ExceptionMgr.getConvertedErrorMsg("FileIOService readOneBlock : read error...");
            ExceptionMgr.throwSQLExp(throw_message);
        }
        return block.toString();
    }

    public void closeFile() throws SQLException {
        try {
            this.m_reader.close();
            this.m_isr.close();
            this.m_fis.close();
        }
        catch (IOException e) {
            String throw_message = ExceptionMgr.getConvertedErrorMsg("FileIOService closeFile : error...");
            ExceptionMgr.throwSQLExp(throw_message);
        }
        this.m_reader = null;
        this.m_isr = null;
        this.m_fis = null;
        this.m_file = null;
    }
}

