/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.loader;

import com.bonc.xcloud.common.ExceptionMgr;
import java.sql.SQLException;

public class BytePtr {
    private byte[] m_ptr;
    private int m_len;

    public BytePtr(int size) throws SQLException {
        try {
            this.m_ptr = new byte[size];
        }
        catch (OutOfMemoryError ex) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("[BytePtr]Allocate " + size + "bytes, out of Memory, try smaller fetchsize!");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        this.m_len = size;
    }

    public byte[] getByte() {
        return this.m_ptr;
    }

    public void setByte(byte[] b) {
        System.arraycopy(this.m_ptr, 0, b, 0, this.m_len);
    }

    public int getSize() {
        return this.m_len;
    }
}

