/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.jdbc;

import com.bonc.xcloud.common.BufferFactory;
import com.bonc.xcloud.common.CancelSignal;
import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.common.LobBuffer;
import com.bonc.xcloud.common.LocalBuffer;
import com.bonc.xcloud.common.MemoryInfoMgr;
import com.bonc.xcloud.common.NumberBuffer;
import com.bonc.xcloud.common.StmtInfoPack;
import com.bonc.xcloud.common.TimeOutTask;
import com.bonc.xcloud.component.ServiceManager;
import com.bonc.xcloud.context.builder.BatchInsertContentBuilder;
import com.bonc.xcloud.convert.ByteOrderConv;
import com.bonc.xcloud.enumdef.SQLType;
import com.bonc.xcloud.error.handle.ErrorHandler;
import com.bonc.xcloud.jdbc.XCloudConnection;
import com.bonc.xcloud.jdbc.XCloudDummyResultSet;
import com.bonc.xcloud.jdbc.XCloudResultSet;
import com.bonc.xcloud.loader.CommandParser;
import com.bonc.xcloud.loader.FileIOServiceWithByteStream;
import com.bonc.xcloud.log.XCloudJDBCLogger;
import com.bonc.xcloud.metadata.domain.DataBaseMetaData;
import com.bonc.xcloud.sql.parser.ColumnInfo;
import com.bonc.xcloud.sql.parser.CommandContext;
import com.bonc.xcloud.sql.parser.InsertStmtType;
import com.bonc.xcloud.sql.parser.ParserSQL;
import com.bonc.xcloud.sql.parser.SqlBuilder;
import com.bonc.xcloud.xserver.TQuery;
import com.bonc.xcloud.xserver.TRequestResult;
import com.bonc.xcloud.xserver.TResultSetMetaData;
import com.bonc.xcloud.xserver.TRowCountResult;
import com.bonc.xcloud.xserver.TStatus;
import com.bonc.xcloud.xserver.TStatusCode;
import com.bonc.xcloud.xserver.TStmtType;
import com.bonc.xcloud.xserver.TUniqueId;
import com.bonc.xcloud.xserver.TXcloudVersion;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCloudStatement
implements Statement {
    private static Logger logger = LoggerFactory.getLogger(XCloudStatement.class);
    private XCloudConnection m_xc = null;
    protected ServiceManager m_servicemanager = null;
    protected ArrayList<TUniqueId> m_hdList = null;
    protected long m_updateCount = -1L;
    protected long m_executeResult = 0L;
    private XCloudResultSet m_xcrs = null;
    protected TUniqueId m_queryhandle = null;
    protected DataBaseMetaData m_dbmd = null;
    private int m_fetchSize = 0;
    private CancelSignal<Boolean> m_isCancel;
    protected ErrorHandler m_errorHandler = null;
    private boolean isClosed = true;
    private MemoryInfoMgr m_memInfo = null;
    protected int m_clientLoadBlockSize = 0;
    private FileIOServiceWithByteStream m_fileService = null;
    private CommandParser m_commandParser = null;
    private Thread m_timeOutTimer = null;
    private int m_stmtQueryTimeOut = 0;
    private CancelSignal<Boolean> m_isTimeOut = null;
    protected CommandContext m_last_context = null;
    protected int m_insert_current_row = 0;
    protected BatchInsertContentBuilder m_content_builder = null;
    protected boolean m_is_batch = false;
    protected boolean m_first_batch = true;
    protected String m_sql = "";
    protected XCloudJDBCLogger m_jdbcLogger = null;
    protected static int VARCHAR_MAX_SIZE = 512;
    protected static int INT_SIZE = 4;
    protected static int LONG_SIZE = 8;
    protected static int DOUBLE_SIZE = 8;
    protected static int DATE_SIZE = 8;
    protected static int TIMESTAMP_SIZE = 12;
    protected static int INTERVALYM_SIZE = 8;
    protected static int INTERVALDS_SIZE = 12;
    private StmtInfoPack m_stmtInfoPack;
    private int m_maxRows = 0;

    public XCloudStatement(XCloudConnection xc, XCloudJDBCLogger jdbcLogger) throws SQLException {
        String retMsg;
        if (xc == null) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("Connection is empty!");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        if (xc.getServiceManager() == null) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("ServcieManager is empty!");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        if (xc.getDBMD() == null) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("DataBaseMetaData is empty!");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        this.m_xc = xc;
        this.m_servicemanager = xc.getServiceManager();
        this.m_dbmd = xc.getDBMD();
        this.m_hdList = xc.getQueryHandleList();
        this.m_jdbcLogger = jdbcLogger;
        this.m_errorHandler = new ErrorHandler();
        this.isClosed = false;
        this.m_isCancel = new CancelSignal();
        this.m_isCancel.setValue(false);
        this.m_memInfo = xc.getMemoryInfoMgr();
        this.m_clientLoadBlockSize = xc.getConnInfoPack().getClientLoadBlockSize();
        this.m_fileService = new FileIOServiceWithByteStream();
        this.m_commandParser = new CommandParser();
        this.m_isTimeOut = new CancelSignal();
        this.m_isTimeOut.setValue(false);
        this.m_stmtInfoPack = new StmtInfoPack();
    }

    private void checkConnStatus() throws SQLException {
        String retMsg = ExceptionMgr.getConvertedErrorMsg("Connection has closed");
        if (this.m_servicemanager == null) {
            logger.error(retMsg);
            ExceptionMgr.throwSQLRecoverableExp(retMsg);
        }
        if (!this.m_servicemanager.isOpen()) {
            logger.error(retMsg);
            ExceptionMgr.throwSQLRecoverableExp(retMsg);
        }
    }

    protected void releaseLastResult() throws SQLException {
        if (null != this.m_queryhandle) {
            TStatus ts = this.m_servicemanager.close(this.m_queryhandle, ServiceManager.CloseUser.RES);
            TStatusCode tsc = ts.getStatus_code();
            if (TStatusCode.OK != tsc) {
                this.m_errorHandler.Handle(ts, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
            }
            this.m_queryhandle.setReserve(-1);
        }
    }

    private void checkSQLStatus() throws SQLException {
        String retMsg = ExceptionMgr.getConvertedErrorMsg("SQL handle has closed");
        if (this.m_queryhandle == null) {
            logger.error(retMsg);
            ExceptionMgr.throwSQLRecoverableExp(retMsg);
        }
        if (this.m_queryhandle.getReserve() == -1) {
            logger.error(retMsg);
            ExceptionMgr.throwSQLRecoverableExp(retMsg);
        }
    }

    protected void checkExecuteStatus() throws SQLException {
        if (this.isClosed) {
            this.checkSQLStatus();
        }
        this.checkConnStatus();
    }

    protected void writerLog(String methodName) throws SQLException {
        XCloudJDBCLogger.Write_Log(ExceptionMgr.getConvertedJDBCCallerMsg(methodName));
        if (logger.isDebugEnabled()) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg(methodName);
            logger.debug(retMsg);
        }
    }

    protected void checkCancel() throws SQLException {
        if (this.m_isCancel.getValue().booleanValue()) {
            StringBuffer cancelMsg = new StringBuffer();
            cancelMsg.append("Remote IP = [" + this.m_servicemanager.getConnInfoPack().getCurrentRemoteIP() + "] \n");
            cancelMsg.append("Thread ID = [" + Thread.currentThread().getId() + "] \n");
            cancelMsg.append("Conn   ID = [" + this.m_servicemanager.getConnInfoPack().getCurrentConnID() + "] \n");
            cancelMsg.append("Query  ID = [" + this.getStmtInfoPack().getCurrentQueryID() + "] \n");
            cancelMsg.append("Err msg   = [Statement cancel signal interrupt!] \n");
            XCloudJDBCLogger.Write_Log(cancelMsg.toString());
            if (logger.isWarnEnabled()) {
                logger.warn(cancelMsg.toString());
            }
            if (this.m_stmtQueryTimeOut > 0) {
                this.m_timeOutTimer.stop();
            }
            ExceptionMgr.throwSQLExp(cancelMsg.toString());
        }
    }

    protected void checkQueryTimeOut() throws SQLException {
        if (this.m_isTimeOut.getValue().booleanValue()) {
            StringBuffer timeOutMsg = new StringBuffer();
            timeOutMsg.append("Remote IP = [" + this.m_servicemanager.getConnInfoPack().getCurrentRemoteIP() + "] \n");
            timeOutMsg.append("Thread ID = [" + Thread.currentThread().getId() + "] \n");
            timeOutMsg.append("Conn   ID = [" + this.m_servicemanager.getConnInfoPack().getCurrentConnID() + "] \n");
            timeOutMsg.append("Query  ID = [" + this.getStmtInfoPack().getCurrentQueryID() + "] \n");
            timeOutMsg.append("Err msg   = [Statement query timeout, timeout: " + this.m_stmtQueryTimeOut + "] \n");
            XCloudJDBCLogger.Write_Log(timeOutMsg.toString());
            if (logger.isWarnEnabled()) {
                logger.warn(timeOutMsg.toString());
            }
            ExceptionMgr.throwSQLExp(timeOutMsg.toString());
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new RuntimeException("[XCloudStatement unwrap] [XCloudStatement unwrap] Not Implemented yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new RuntimeException("[XCloudStatement isWrapperFor] Not Implemented yet.");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        String retMsg;
        this.releaseLastResult();
        this.writerLog("executeQuery");
        if (this.m_is_batch) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("in Batch Operation");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        this.checkExecuteStatus();
        if (sql == null || sql.length() == 0) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("SQL is empty!");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        ResultSet ret = null;
        int status = this.executeSQL(sql);
        if (0 == status) {
            ret = this.m_xcrs;
        } else if (1 == status) {
            ret = new XCloudDummyResultSet(SQLType.SQL_DML);
        } else if (2 == status) {
            ret = new XCloudDummyResultSet(SQLType.SQL_DDL);
        }
        return ret;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        boolean hasResultSet;
        String retMsg;
        this.releaseLastResult();
        this.writerLog("executeUpdate");
        if (this.m_is_batch) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("in Batch Operation");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        this.checkExecuteStatus();
        if (sql == null || sql.length() == 0) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("SQL is empty!");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        if (hasResultSet = this.execute(sql)) {
            return 0;
        }
        if (this.m_executeResult > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)this.m_executeResult;
    }

    @Override
    public void close() throws SQLException {
        if (this.m_servicemanager == null) {
            return;
        }
        if (!this.m_servicemanager.isOpen()) {
            this.objRelease();
            return;
        }
        TStatusCode tsc = TStatusCode.OK;
        TUniqueId queryhandle = null;
        for (int i = 0; i < this.m_hdList.size(); ++i) {
            TStatus ts;
            queryhandle = this.m_hdList.get(i);
            if (-1 == queryhandle.getReserve()) continue;
            if (logger.isInfoEnabled()) {
                logger.info("Statement close queryID=[" + this.getStmtInfoPack().getCurrentQueryID() + "]");
            }
            if (TStatusCode.OK != (tsc = (ts = this.m_servicemanager.close(queryhandle, ServiceManager.CloseUser.STMT)).getStatus_code())) {
                this.m_errorHandler.Handle(ts, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
            }
            queryhandle.setReserve(-1);
        }
        this.objRelease();
        this.writerLog("close");
    }

    private void objRelease() {
        if (this.m_hdList != null && this.m_hdList.size() != 0) {
            this.m_hdList.clear();
        }
        this.m_hdList = null;
        this.isClosed = true;
        this.m_dbmd = null;
        this.m_errorHandler = null;
        this.m_servicemanager = null;
        this.m_xcrs = null;
        if (this.m_timeOutTimer != null) {
            this.m_timeOutTimer.stop();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.writerLog("getMaxFieldSize");
        this.checkExecuteStatus();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new RuntimeException("[XCloudStatement setMaxFieldSize] Not Implemented yet.");
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.writerLog("getMaxRows");
        this.checkExecuteStatus();
        return this.m_maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.writerLog("setMaxRows");
        this.checkExecuteStatus();
        this.m_maxRows = max;
    }

    protected MemoryInfoMgr getMemoryInfoMgr() {
        return this.m_memInfo;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new RuntimeException("[XCloudStatement setEscapeProcessing] Not Implemented yet.");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.writerLog("getQueryTimeout");
        this.checkExecuteStatus();
        return this.m_stmtQueryTimeOut;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.writerLog("setQueryTimeout");
        this.checkExecuteStatus();
        this.m_stmtQueryTimeOut = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        this.writerLog("cancel");
        this.checkExecuteStatus();
        this.m_isCancel.setValue(true);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.writerLog("getWarnings");
        this.checkExecuteStatus();
        return this.m_errorHandler.getSQLWarning();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.writerLog("clearWarnings");
        this.checkExecuteStatus();
        this.m_errorHandler.clearSQLWarning();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new RuntimeException("[XCloudStatement setCursorName] Not Implemented yet.");
    }

    private int executeClientLoad() throws SQLException {
        TStatus tmp_close_status;
        this.writerLog("executeClientLoad");
        this.checkExecuteStatus();
        TXcloudVersion tcv = this.m_xc.getConnInfoPack().getXCloudVersion();
        if (tcv.getFirst() >= 2 && tcv.getSecond() > 3) {
            this.queryBookState();
        }
        int ret = 0;
        TStatus tmp_load_status = null;
        ByteBuffer content = this.m_fileService.readOneBlock();
        ArrayList<ByteBuffer> l_bb = new ArrayList<ByteBuffer>();
        while (content != null) {
            l_bb.add(content);
            tmp_load_status = this.m_servicemanager.sendData_binarys(this.m_queryhandle, this.m_stmtInfoPack, l_bb, false);
            if (TStatusCode.OK != tmp_load_status.status_code) {
                this.m_fileService.closeFile();
                this.m_errorHandler.Handle(tmp_load_status, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("send content length=[" + content.remaining() + "]");
            }
            content = this.m_fileService.readOneBlock();
            l_bb.clear();
        }
        tmp_load_status = this.m_servicemanager.sendData_binarys(this.m_queryhandle, this.m_stmtInfoPack, null, true);
        if (TStatusCode.OK != tmp_load_status.status_code) {
            this.m_fileService.closeFile();
            this.m_errorHandler.Handle(tmp_load_status, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
        }
        this.m_fileService.closeFile();
        TStatus tmp_ts = this.queryState();
        TRowCountResult tmp_trcr = this.m_servicemanager.getRowCount(this.m_queryhandle, this.m_stmtInfoPack);
        if (TStatusCode.OK != tmp_trcr.getStatus().status_code) {
            this.m_errorHandler.Handle(tmp_trcr.getStatus(), this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack, tmp_trcr.getLog_path());
        }
        this.m_executeResult = this.m_updateCount = tmp_trcr.getRowcount();
        if (logger.isDebugEnabled()) {
            logger.debug("Update Count=[" + this.m_updateCount + "]");
        }
        if ((tmp_close_status = this.m_servicemanager.close(this.m_queryhandle, ServiceManager.CloseUser.STMT)).getStatus_code() != TStatusCode.OK) {
            this.m_errorHandler.Handle(tmp_close_status, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
        }
        this.m_hdList.remove(this.m_queryhandle);
        ret = 1;
        return ret;
    }

    protected int executeSQL(String sql) throws SQLException {
        this.writerLog("executeSQL");
        this.checkExecuteStatus();
        Boolean isClientLoad = false;
        Boolean isExplain = false;
        ParserSQL parser_sql = new ParserSQL();
        CommandContext context = new CommandContext();
        parser_sql.doParser(sql, context, false);
        if (parser_sql.isInsert() && (parser_sql.getInsertStmtType() == InsertStmtType.INSERT_CLIENT_NEW || parser_sql.getInsertStmtType() == InsertStmtType.INSERT_CLIENT_OLD)) {
            this.m_fileService.reset(context.getFilePath(), this.m_clientLoadBlockSize);
            isClientLoad = true;
            SqlBuilder bur = new SqlBuilder();
            sql = bur.toSQL(context);
        }
        if (sql == null || sql.length() == 0) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("SQL is empty!");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        StringBuffer exeMsg = new StringBuffer();
        exeMsg.append("\n");
        exeMsg.append("Execute JID = [").append(Thread.currentThread().getId());
        exeMsg.append(",");
        exeMsg.append(this.m_servicemanager.getConnInfoPack().getCurrentConnID()).append("] \n");
        exeMsg.append("Execute SQL = [").append("\n").append(sql).append("\n]\n");
        this.m_stmtInfoPack.setCurrentExecuteSQL(sql);
        XCloudJDBCLogger.Write_Log(exeMsg.toString());
        if (logger.isDebugEnabled()) {
            logger.debug(exeMsg.toString());
        }
        if (sql.toLowerCase().indexOf("explain") != -1 || sql.toLowerCase().indexOf("profiling") != -1) {
            this.m_fetchSize = 1;
            isExplain = true;
        }
        boolean ret = false;
        TQuery tmp_query = new TQuery(sql);
        int fetchSize = this.m_fetchSize;
        if (this.m_maxRows != 0) {
            if (fetchSize > 0 && this.m_maxRows < fetchSize) {
                fetchSize = this.m_maxRows;
            } else if (fetchSize == 0 && this.m_maxRows < 5000) {
                fetchSize = this.m_maxRows;
            }
        }
        if (fetchSize != 0) {
            XCloudJDBCLogger.Write_Log("Fetch Size=[" + fetchSize + "] Max Rows=[" + this.m_maxRows + "]");
            if (logger.isDebugEnabled()) {
                logger.debug("Fetch Size=[" + fetchSize + "] Max Rows=[" + this.m_maxRows + "]");
            }
        }
        if (isClientLoad.booleanValue()) {
            tmp_query.configuration = new HashMap<String, String>();
            tmp_query.configuration.put("CLIENT_LOAD", "");
        }
        return this.executeTQuery(tmp_query, isExplain);
    }

    protected int executeTQuery(TQuery query, Boolean isExplain) throws SQLException {
        TStatus tmp_close_status;
        int ret = 0;
        this.m_stmtInfoPack.setCurrentExecuteTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        TRequestResult tmp_result = this.m_servicemanager.execute(query, this.m_stmtInfoPack);
        this.m_queryhandle = tmp_result.getQuery_handle();
        if (TStatusCode.OK != tmp_result.getStatus().status_code && TStatusCode.EXEC_READY != tmp_result.getStatus().status_code) {
            this.m_errorHandler.Handle(tmp_result.getStatus(), this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
        }
        this.m_hdList.add(this.m_queryhandle);
        StringBuffer resMsg = new StringBuffer();
        resMsg.append("\n");
        resMsg.append("Result JID   = [").append(Thread.currentThread().getId());
        resMsg.append(",");
        resMsg.append(this.m_servicemanager.getConnInfoPack().getCurrentConnID()).append("] \n");
        resMsg.append("Result QID   = [").append(this.getStmtInfoPack().getCurrentQueryID()).append("] \n");
        resMsg.append("Result Type  = [").append(tmp_result.getType().toString()).append("] \n");
        resMsg.append("Result Code  = [").append(tmp_result.getStatus().status_code.toString()).append("] \n");
        resMsg.append("Result Encode= [").append(this.m_dbmd.getServerEncode()).append("] \n");
        resMsg.append("Execute SQL  = [").append(this.getStmtInfoPack().getCurrentExecuteSQL()).append("] \n");
        logger.info(resMsg.toString());
        if (tmp_result.getType() == TStmtType.CLIENT_LOAD) {
            return this.executeClientLoad();
        }
        TStatus tmp_ts = this.queryState();
        if (tmp_result.getType() == TStmtType.SELECT || tmp_result.getType() == TStmtType.SETOP || tmp_result.getType() == TStmtType.STORE_PROCEDURE || tmp_result.getType() == TStmtType.GENERAL_MANAGEMENT_COMMAND) {
            if (tmp_ts.getStatus_code() == TStatusCode.EXEC_READY || tmp_ts.getStatus_code() == TStatusCode.EXEC_COMPLETE || tmp_ts.getStatus_code() == TStatusCode.OK) {
                int isGMCNullResult = this.executeSQLQuery(isExplain, tmp_result.getType());
                if (-1 == isGMCNullResult) {
                    TStatus tmp_close_status2 = this.m_servicemanager.close(this.m_queryhandle, ServiceManager.CloseUser.STMT);
                    if (tmp_close_status2.getStatus_code() != TStatusCode.OK) {
                        this.m_errorHandler.Handle(tmp_close_status2, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
                    }
                    this.m_hdList.remove(this.m_queryhandle);
                    this.m_updateCount = -1L;
                    this.m_executeResult = 0L;
                    ret = 2;
                    return ret;
                }
            } else {
                this.m_errorHandler.Handle(tmp_ts, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
            }
            this.m_updateCount = -1L;
            this.m_executeResult = 0L;
            ret = 0;
            return ret;
        }
        if (tmp_result.getType() == TStmtType.UPDATETABLE || tmp_result.getType() == TStmtType.DELETETABLE || tmp_result.getType() == TStmtType.INSERT || tmp_result.getType() == TStmtType.EXPORT || tmp_result.getType() == TStmtType.MERGE_INTO) {
            if (tmp_ts.getStatus_code() == TStatusCode.EXEC_READY || tmp_ts.getStatus_code() == TStatusCode.EXEC_COMPLETE || tmp_ts.getStatus_code() == TStatusCode.OK) {
                this.executeSQLUpdate();
            } else {
                this.m_errorHandler.Handle(tmp_ts, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
            }
            ret = 1;
            return ret;
        }
        if (tmp_result.getType() == TStmtType.CREATE_INDEX) {
            if (tmp_ts.getStatus_code() == TStatusCode.EXEC_READY || tmp_ts.getStatus_code() == TStatusCode.EXEC_COMPLETE || tmp_ts.getStatus_code() == TStatusCode.OK) {
                XCloudJDBCLogger.Write_Log("CreateIndex OK!");
                if (logger.isDebugEnabled()) {
                    logger.debug("CreateIndex OK!");
                }
            } else {
                this.m_errorHandler.Handle(tmp_ts, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
            }
        }
        if ((tmp_close_status = this.m_servicemanager.close(this.m_queryhandle, ServiceManager.CloseUser.STMT)).getStatus_code() != TStatusCode.OK) {
            this.m_errorHandler.Handle(tmp_close_status, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
        }
        this.m_hdList.remove(this.m_queryhandle);
        this.m_updateCount = -1L;
        this.m_executeResult = 0L;
        ret = 2;
        return ret;
    }

    protected TStatus queryState() throws SQLException {
        TStatus tmp_ts;
        block4: {
            this.writerLog("queryState");
            tmp_ts = null;
            if (this.m_stmtQueryTimeOut > 0) {
                this.m_timeOutTimer = new Thread(new TimeOutTask(this.m_isTimeOut, this.m_stmtQueryTimeOut * 1000));
                this.m_timeOutTimer.start();
            }
            do {
                tmp_ts = this.m_servicemanager.queryState(this.m_queryhandle, this.m_stmtInfoPack);
                this.checkCancel();
                if (this.m_stmtQueryTimeOut > 0) {
                    this.checkQueryTimeOut();
                }
                if (tmp_ts.getStatus_code() == TStatusCode.OK || tmp_ts.getStatus_code() == TStatusCode.EXEC_COMPLETE || tmp_ts.getStatus_code() == TStatusCode.EXEC_PENDING || tmp_ts.getStatus_code() == TStatusCode.EXEC_READY || tmp_ts.getStatus_code() == TStatusCode.EXEC_RESOURCE_BOOK_PENDING) continue;
                if (this.m_stmtQueryTimeOut > 0) {
                    this.m_timeOutTimer.stop();
                }
                this.m_errorHandler.Handle(tmp_ts, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
            } while (tmp_ts.getStatus_code() == TStatusCode.EXEC_PENDING || tmp_ts.getStatus_code() == TStatusCode.EXEC_RESOURCE_BOOK_PENDING);
            if (this.m_stmtQueryTimeOut <= 0) break block4;
            this.m_timeOutTimer.stop();
        }
        return tmp_ts;
    }

    protected TStatus queryBookState() throws SQLException {
        TStatus tmp_ts;
        block4: {
            this.writerLog("queryBookState");
            tmp_ts = null;
            if (this.m_stmtQueryTimeOut > 0) {
                this.m_timeOutTimer = new Thread(new TimeOutTask(this.m_isTimeOut, this.m_stmtQueryTimeOut * 1000));
                this.m_timeOutTimer.start();
            }
            do {
                tmp_ts = this.m_servicemanager.queryState(this.m_queryhandle, this.m_stmtInfoPack);
                this.checkCancel();
                if (this.m_stmtQueryTimeOut > 0) {
                    this.checkQueryTimeOut();
                }
                if (tmp_ts.getStatus_code() == TStatusCode.OK || tmp_ts.getStatus_code() == TStatusCode.EXEC_COMPLETE || tmp_ts.getStatus_code() == TStatusCode.EXEC_PENDING || tmp_ts.getStatus_code() == TStatusCode.EXEC_READY || tmp_ts.getStatus_code() == TStatusCode.EXEC_RESOURCE_BOOK_PENDING) continue;
                if (this.m_stmtQueryTimeOut > 0) {
                    this.m_timeOutTimer.stop();
                }
                this.m_errorHandler.Handle(tmp_ts, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
            } while (tmp_ts.getStatus_code() == TStatusCode.EXEC_RESOURCE_BOOK_PENDING);
            if (this.m_stmtQueryTimeOut <= 0) break block4;
            this.m_timeOutTimer.stop();
        }
        return tmp_ts;
    }

    protected int executeSQLQuery(boolean isExplain, TStmtType sType) throws SQLException {
        this.writerLog("executeSQLQuery");
        TResultSetMetaData tmp_trsmd = this.m_servicemanager.getResultsetMetaData(this.m_queryhandle, this.m_stmtInfoPack);
        if (TStatusCode.OK != tmp_trsmd.getStatus().status_code) {
            this.m_errorHandler.Handle(tmp_trsmd.getStatus(), this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
        }
        if (sType == TStmtType.GENERAL_MANAGEMENT_COMMAND && 0 == tmp_trsmd.columndescs.size()) {
            return -1;
        }
        BufferFactory tmp_bf = new BufferFactory(this.m_servicemanager, this.m_dbmd.isLE());
        for (int i = 0; i < tmp_trsmd.columndescs.size(); ++i) {
            tmp_bf.produce(i + 1, tmp_trsmd.columndescs.get((int)i).coltype, tmp_trsmd.columndescs.get(i).getColwidth());
            String metaInfo = "Col Name=[" + tmp_trsmd.columndescs.get(i).getColname() + "] Type=[" + tmp_trsmd.columndescs.get(i).getColtype().toString() + "] Width=[" + tmp_trsmd.columndescs.get(i).getColwidth() + "]";
            XCloudJDBCLogger.Write_Log(metaInfo);
            if (!logger.isDebugEnabled()) continue;
            logger.debug(metaInfo);
        }
        int jdbc_fetchSize = 0;
        if (!isExplain && TStmtType.STORE_PROCEDURE != sType) {
            this.m_memInfo.calcEffectiveRows(tmp_trsmd);
            jdbc_fetchSize = this.m_fetchSize != 0 && this.m_fetchSize < this.m_memInfo.getEfftRows() ? this.m_fetchSize : this.m_memInfo.getEfftRows();
        } else if (isExplain) {
            this.m_memInfo.calcEffectiveRowsExplain(tmp_trsmd);
            jdbc_fetchSize = this.m_memInfo.getEfftRows();
        } else if (TStmtType.STORE_PROCEDURE == sType) {
            jdbc_fetchSize = 1;
        }
        HashMap colMap = tmp_bf.getBuffers();
        String columnInfo = null;
        for (int i = 0; i < tmp_trsmd.columndescs.size(); ++i) {
            int maxSpace = 0;
            switch (tmp_trsmd.columndescs.get((int)i).coltype) {
                case NULLTYPE: {
                    maxSpace = 0;
                    break;
                }
                case INTEGER: {
                    maxSpace = INT_SIZE * jdbc_fetchSize;
                    columnInfo = "Type=[INTEGER], Col idx=[" + i + "], Allocate DataSpace=[" + maxSpace + "]" + ", BVSpace=[" + this.m_memInfo.getColumnBvCnt() + "]";
                    XCloudJDBCLogger.Write_Log(columnInfo);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug(columnInfo);
                    break;
                }
                case LONG: 
                case DATETIME: 
                case DOUBLE: {
                    maxSpace = DATE_SIZE * jdbc_fetchSize;
                    columnInfo = "Type=[LONG or DOUBLE or DATETIME], Col idx=[" + i + "], Allocate DataSpace=[" + maxSpace + "]" + ", BVSpace=[" + this.m_memInfo.getColumnBvCnt() + "]";
                    XCloudJDBCLogger.Write_Log(columnInfo);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug(columnInfo);
                    break;
                }
                case CHAR: {
                    maxSpace = ((LocalBuffer)colMap.get(i + 1)).GetTypeSize() * jdbc_fetchSize;
                    columnInfo = "Type=[CHAR], Col idx=[" + i + "], Allocate DataSpace=[" + maxSpace + "]" + ", BVSpace=[" + this.m_memInfo.getColumnBvCnt() + "]";
                    XCloudJDBCLogger.Write_Log(columnInfo);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug(columnInfo);
                    break;
                }
                case VARCHAR: {
                    int maxTypeSize = ((LocalBuffer)colMap.get(i + 1)).GetTypeSize();
                    if (0 == maxTypeSize || maxTypeSize > VARCHAR_MAX_SIZE) {
                        maxTypeSize = VARCHAR_MAX_SIZE;
                    }
                    maxSpace = (maxTypeSize + 4) * jdbc_fetchSize + 4;
                    columnInfo = "Type=[VARCHAR], Col idx=[" + i + "], Allocate DataSpace=[" + maxSpace + "]" + ", BVSpace=[" + this.m_memInfo.getColumnBvCnt() + "]";
                    XCloudJDBCLogger.Write_Log(columnInfo);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug(columnInfo);
                    break;
                }
                case YMINTERVAL: {
                    maxSpace = INTERVALYM_SIZE * jdbc_fetchSize;
                    columnInfo = "Type=[YMINTERVAL], Col idx=[" + i + "], Allocate DataSpace=[" + maxSpace + "]" + ", BVSpace=[" + this.m_memInfo.getColumnBvCnt() + "]";
                    XCloudJDBCLogger.Write_Log(columnInfo);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug(columnInfo);
                    break;
                }
                case DSINTERVAL: {
                    maxSpace = INTERVALDS_SIZE * jdbc_fetchSize;
                    columnInfo = "Type=[DSINTERVAL], Col idx=[" + i + "], Allocate DataSpace=[" + maxSpace + "]" + ", BVSpace=[" + this.m_memInfo.getColumnBvCnt() + "]";
                    XCloudJDBCLogger.Write_Log(columnInfo);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug(columnInfo);
                    break;
                }
                case TIMESTAMP: {
                    maxSpace = TIMESTAMP_SIZE * jdbc_fetchSize;
                    columnInfo = "Type=[TIMESTAMP], Col idx=[" + i + "], Allocate DataSpace=[" + maxSpace + "]" + ", BVSpace=[" + this.m_memInfo.getColumnBvCnt() + "]";
                    XCloudJDBCLogger.Write_Log(columnInfo);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug(columnInfo);
                    break;
                }
                case NUMBER: {
                    maxSpace = NumberBuffer.size * jdbc_fetchSize;
                    columnInfo = "Type=[NUMBER], Col idx=[" + i + "], Allocate DataSpace=[" + maxSpace + "]" + ", BVSpace=[" + this.m_memInfo.getColumnBvCnt() + "]";
                    XCloudJDBCLogger.Write_Log(columnInfo);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug(columnInfo);
                    break;
                }
                case BLOB: {
                    int maxTypeSize = LobBuffer.LOB_INLINE_SIZE + LobBuffer.LOB_INFO_SIZE;
                    maxSpace = (maxTypeSize + 4) * jdbc_fetchSize + 4;
                    columnInfo = "Type=[BLOB], Col idx=[" + i + "], Allocate DataSpace=[" + maxSpace + "]" + ", BVSpace=[" + this.m_memInfo.getColumnBvCnt() + "]";
                    XCloudJDBCLogger.Write_Log(columnInfo);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug(columnInfo);
                    break;
                }
                case CLOB: {
                    int maxTypeSize = LobBuffer.LOB_INLINE_SIZE + LobBuffer.LOB_INFO_SIZE;
                    maxSpace = (maxTypeSize + 4) * jdbc_fetchSize + 4;
                    columnInfo = "Type=[CLOB], Col idx=[" + i + "], Allocate DataSpace=[" + maxSpace + "]" + ", BVSpace=[" + this.m_memInfo.getColumnBvCnt() + "]";
                    XCloudJDBCLogger.Write_Log(columnInfo);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug(columnInfo);
                    break;
                }
            }
            if (null != ((LocalBuffer)colMap.get(i + 1)).getArray() || null != ((LocalBuffer)colMap.get(i + 1)).getBV()) continue;
            ((LocalBuffer)colMap.get(i + 1)).AllocateArray(maxSpace, (jdbc_fetchSize + 8) / 8);
        }
        this.m_xcrs = new XCloudResultSet(this, tmp_trsmd, tmp_bf, this.m_queryhandle, jdbc_fetchSize, this.m_jdbcLogger);
        this.m_xcrs.setCancelSignal(this.m_isCancel);
        return 0;
    }

    protected void executeSQLUpdate() throws SQLException {
        TStatus tmp_close_status;
        this.writerLog("executeSQLUpdate");
        TRowCountResult tmp_trcr = this.m_servicemanager.getRowCount(this.m_queryhandle, this.m_stmtInfoPack);
        if (TStatusCode.OK != tmp_trcr.getStatus().status_code) {
            this.m_errorHandler.Handle(tmp_trcr.getStatus(), this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack, tmp_trcr.getLog_path());
        }
        this.m_executeResult = this.m_updateCount = tmp_trcr.getRowcount();
        XCloudJDBCLogger.Write_Log("Update Count=[" + this.m_updateCount + "]");
        if (logger.isDebugEnabled()) {
            logger.debug("Update Count=[" + this.m_updateCount + "]");
        }
        if ((tmp_close_status = this.m_servicemanager.close(this.m_queryhandle, ServiceManager.CloseUser.STMT)).getStatus_code() != TStatusCode.OK) {
            this.m_errorHandler.Handle(tmp_close_status, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
        }
        this.m_hdList.remove(this.m_queryhandle);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        String retMsg;
        this.releaseLastResult();
        this.writerLog("execute");
        if (this.m_is_batch) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("in Batch Operation");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        this.checkExecuteStatus();
        if (sql == null || sql.length() == 0) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("SQL is empty!");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        boolean ret = false;
        int status = this.executeSQL(sql);
        if (0 == status) {
            ret = true;
            return ret;
        }
        return ret;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.writerLog("getResultSet");
        this.checkExecuteStatus();
        return this.m_xcrs;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.writerLog("getUpdateCount");
        this.checkExecuteStatus();
        int Count = 0;
        Count = this.m_updateCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (this.m_updateCount < 0L ? (this.m_updateCount == -2L ? -2 : -1) : (int)this.m_updateCount);
        this.m_updateCount -= Integer.MAX_VALUE;
        return Count;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.writerLog("getMoreResults");
        this.checkExecuteStatus();
        this.m_updateCount = -1L;
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new RuntimeException("[XCloudStatement setFetchDirection] Not Implemented yet.");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.writerLog("getFetchDirection");
        this.checkExecuteStatus();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.writerLog("setFetchSize");
        this.checkExecuteStatus();
        if (rows < 0) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Fetch size < 0 !");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        this.m_fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.writerLog("getFetchSize");
        this.checkExecuteStatus();
        return this.m_fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new RuntimeException("[XCloudStatement getResultSetConcurrency] Not Implemented yet.");
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new RuntimeException("[XCloudStatement getResultSetType] Not Implemented yet.");
    }

    private void cmpColumnInfo(ArrayList<ColumnInfo> last_column_list, ArrayList<ColumnInfo> this_column_list) throws SQLException {
        if (last_column_list.size() != this_column_list.size()) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("batch insert must be same column");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        for (int i = 0; i < this_column_list.size(); ++i) {
            ColumnInfo this_column = this_column_list.get(i);
            ColumnInfo last_column = last_column_list.get(i);
            if (this_column.getColumnName().equals(last_column.getColumnName())) continue;
            String retMsg = ExceptionMgr.getConvertedErrorMsg("batch insert must be same column");
            ExceptionMgr.throwSQLExp(retMsg);
        }
    }

    protected void sendSQL(String sql) throws SQLException {
        TXcloudVersion tcv;
        StringBuffer exeMsg = new StringBuffer();
        exeMsg.append("\n");
        exeMsg.append("Execute JID = [").append(Thread.currentThread().getId());
        exeMsg.append(",");
        exeMsg.append(this.m_servicemanager.getConnInfoPack().getCurrentConnID()).append("] \n");
        exeMsg.append("Execute SQL = [").append("\n").append(sql).append("\n]\n");
        this.m_stmtInfoPack.setCurrentExecuteSQL(sql);
        XCloudJDBCLogger.Write_Log(exeMsg.toString());
        if (logger.isDebugEnabled()) {
            logger.debug(exeMsg.toString());
        }
        TQuery tmp_query = new TQuery(sql);
        this.m_stmtInfoPack.setCurrentExecuteTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        TRequestResult tmp_result = this.m_servicemanager.execute(tmp_query, this.m_stmtInfoPack);
        this.m_queryhandle = tmp_result.getQuery_handle();
        if (TStatusCode.OK != tmp_result.getStatus().status_code) {
            this.m_errorHandler.Handle(tmp_result.getStatus(), this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
        }
        if (tmp_result.getType() != TStmtType.CLIENT_LOAD) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("sendSQL: SQL Type is not Insert!");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        if ((tcv = this.m_xc.getConnInfoPack().getXCloudVersion()).getFirst() >= 2 && tcv.getSecond() > 3) {
            TStatus tmp_ts = this.queryBookState();
        }
        this.m_hdList.add(this.m_queryhandle);
        StringBuffer resMsg = new StringBuffer();
        resMsg.append("\n");
        resMsg.append("Result JID   = [").append(Thread.currentThread().getId());
        resMsg.append(",");
        resMsg.append(this.m_servicemanager.getConnInfoPack().getCurrentConnID()).append("] \n");
        resMsg.append("Result QID   = [").append(this.getStmtInfoPack().getCurrentQueryID()).append("] \n");
        resMsg.append("Result Type  = [").append(tmp_result.getType().toString()).append("] \n");
        resMsg.append("Result Code  = [").append(tmp_result.getStatus().status_code.toString()).append("] \n");
        resMsg.append("Result Encode= [").append(this.m_dbmd.getServerEncode()).append("] \n");
        logger.debug(resMsg.toString());
    }

    protected void printBuffer(List<ByteBuffer> list_buffer) throws SQLException {
        System.out.println("=======================================================");
        System.out.println("list_buffer.size:" + list_buffer.size());
        for (int i = 0; i < list_buffer.size(); ++i) {
            int length;
            System.out.println("**************************************************");
            ByteBuffer bb = list_buffer.get(i);
            byte[] array = bb.array();
            for (int pos = bb.position(); pos < bb.limit(); pos += length) {
                length = ByteOrderConv.ConvByteToIntLE(array, pos);
                pos += 4;
                String value = "";
                try {
                    value = new String(array, pos, length, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                System.out.print(value + "\t");
            }
            System.out.println();
            System.out.println("**************************************************");
        }
        System.out.println("=======================================================");
    }

    protected void executeBatchSQL(boolean isSendSQL, String sql) throws SQLException {
        TStatus tmp_close_status;
        List<ByteBuffer> buffer;
        TStatus result_status = null;
        if (!isSendSQL) {
            this.sendSQL(sql);
            while (this.m_content_builder.generateOneRow()) {
                buffer = this.m_content_builder.getBuffer();
                result_status = this.m_servicemanager.sendData_binarys(this.m_queryhandle, this.m_stmtInfoPack, buffer, false);
                if (TStatusCode.OK != result_status.status_code) {
                    this.m_errorHandler.Handle(result_status, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
                }
                this.m_content_builder.clearBuffer();
            }
        }
        if (this.m_content_builder == null) {
            System.out.println("null of builder");
        }
        if ((buffer = this.m_content_builder.getBuffer()).size() != 0) {
            result_status = this.m_servicemanager.sendData_binarys(this.m_queryhandle, this.m_stmtInfoPack, buffer, false);
            if (TStatusCode.OK != result_status.status_code) {
                this.m_errorHandler.Handle(result_status, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
            }
            this.m_content_builder.clearBuffer();
        }
        result_status = this.m_servicemanager.sendData_binarys(this.m_queryhandle, this.m_stmtInfoPack, null, true);
        if (TStatusCode.OK != result_status.status_code) {
            this.m_errorHandler.Handle(result_status, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
        }
        TStatus tmp_ts = this.queryState();
        TRowCountResult tmp_trcr = this.m_servicemanager.getRowCount(this.m_queryhandle, this.m_stmtInfoPack);
        if (TStatusCode.OK != tmp_trcr.getStatus().status_code) {
            this.m_errorHandler.Handle(tmp_trcr.getStatus(), this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack, tmp_trcr.getLog_path());
        }
        this.m_updateCount = tmp_trcr.getRowcount();
        if (logger.isDebugEnabled()) {
            logger.debug("Update Count=[" + this.m_updateCount + "]");
        }
        if ((tmp_close_status = this.m_servicemanager.close(this.m_queryhandle, ServiceManager.CloseUser.STMT)).getStatus_code() != TStatusCode.OK) {
            this.m_errorHandler.Handle(tmp_close_status, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
        }
        this.m_hdList.remove(this.m_queryhandle);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.m_is_batch = true;
        ParserSQL batch_par = new ParserSQL();
        CommandContext tmp_context = new CommandContext();
        batch_par.doParser(sql, tmp_context, true);
        if (!batch_par.isInsert() || batch_par.isInsert() && batch_par.getInsertStmtType() != InsertStmtType.INSERT_VALUES_BATCH) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("addBatch : sql only support insert batch:" + sql + "--insert:[" + batch_par.isInsert() + "] type[" + (Object)((Object)batch_par.getInsertStmtType()) + "]");
        }
        SqlBuilder sql_builder = new SqlBuilder();
        this.m_sql = sql_builder.toSQL(tmp_context);
        if (this.m_insert_current_row == 0) {
            this.m_last_context = tmp_context;
        } else {
            this.cmpColumnInfo(this.m_last_context.getAllColumnInfo(), tmp_context.getAllColumnInfo());
        }
        ++this.m_insert_current_row;
        if (this.m_first_batch) {
            this.sendSQL(this.m_sql);
            this.m_first_batch = false;
            this.m_content_builder = new BatchInsertContentBuilder(this.m_clientLoadBlockSize, this.m_last_context.getAllColumnInfo(), this.m_xc.getServerCharset());
        }
        for (int i = 0; i < tmp_context.getAllColumnInfo().size(); ++i) {
            this.m_content_builder.setObject(i + 1, 12, tmp_context.getAllColumnInfo().get(i).getColumnValue());
        }
        while (this.m_content_builder.generateOneRow()) {
            List<ByteBuffer> buffer = this.m_content_builder.getBuffer();
            TStatus result_status = this.m_servicemanager.sendData_binarys(this.m_queryhandle, this.m_stmtInfoPack, buffer, false);
            if (TStatusCode.OK != result_status.status_code) {
                this.m_errorHandler.Handle(result_status, this.m_servicemanager.getConnInfoPack(), this.m_stmtInfoPack);
            }
            this.m_content_builder.clearBuffer();
        }
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (!this.m_is_batch) {
            int[] ret = new int[]{};
            return ret;
        }
        this.executeBatchSQL(!this.m_first_batch, this.m_sql);
        this.m_first_batch = true;
        int[] ret = new int[(int)this.m_updateCount];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = -2;
        }
        return ret;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.m_xc;
    }

    public StmtInfoPack getStmtInfoPack() {
        return this.m_stmtInfoPack;
    }

    public void setStmtInfoPack(StmtInfoPack stmtInfo) {
        this.m_stmtInfoPack = stmtInfo;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new RuntimeException("[XCloudStatement getMoreResults] Not Implemented yet.");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new RuntimeException("[XCloudStatement getGeneratedKeys] Not Implemented yet.");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new RuntimeException("[XCloudStatement executeUpdate] Not Implemented yet.");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new RuntimeException("[XCloudStatement executeUpdate] Not Implemented yet.");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new RuntimeException("[XCloudStatement executeUpdate] Not Implemented yet.");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new RuntimeException("[XCloudStatement execute] Not Implemented yet.");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new RuntimeException("[XCloudStatement execute] Not Implemented yet.");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new RuntimeException("[XCloudStatement execute] Not Implemented yet.");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new RuntimeException("[XCloudStatement getResultSetHoldability] Not Implemented yet.");
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.writerLog("isClosed");
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new RuntimeException("[XCloudStatement setPoolable] Not Implemented yet.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new RuntimeException("[XCloudStatement isPoolable] Not Implemented yet.");
    }

    protected ServiceManager getServiceManager() {
        return this.m_servicemanager;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.writerLog("getLargeUpdateCount:" + this.m_updateCount);
        this.checkExecuteStatus();
        return this.m_updateCount;
    }
}

