/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.jdbc;

import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.jdbc.XCloudDriver;
import com.bonc.xcloud.xserver.TResultSetMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCloudResultSetMetaData
implements ResultSetMetaData {
    private static Logger logger = LoggerFactory.getLogger(XCloudResultSetMetaData.class);
    private TResultSetMetaData m_trsmd = null;

    public XCloudResultSetMetaData() {
        this.m_trsmd = new TResultSetMetaData();
    }

    public XCloudResultSetMetaData(TResultSetMetaData trsmd) {
        this.m_trsmd = trsmd;
    }

    protected void writerLog(String methodName) throws SQLException {
        if (logger.isDebugEnabled()) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg(methodName);
            logger.debug(retMsg);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new RuntimeException("[XCloudResultSetMetaData unwrap] Not Implemented yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new RuntimeException("[XCloudResultSetMetaData isWrapperFor] Not Implemented yet.");
    }

    @Override
    public int getColumnCount() throws SQLException {
        this.writerLog("getColumnCount");
        return this.m_trsmd.columndescs.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        throw new RuntimeException("[XCloudResultSetMetaData isAutoIncrement] Not Implemented yet.");
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        throw new RuntimeException("[XCloudResultSetMetaData isCaseSensitive] Not Implemented yet.");
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        throw new RuntimeException("[XCloudResultSetMetaData isSearchable] Not Implemented yet.");
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        throw new RuntimeException("[XCloudResultSetMetaData isCurrency] Not Implemented yet.");
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.writerLog("isNullable");
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.writerLog("isSigned");
        return true;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.writerLog("getColumnDisplaySize");
        return this.m_trsmd.columndescs.get(column - 1).getColwidth();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        this.writerLog("getColumnLabel");
        String columnLabel = null;
        if (column > this.m_trsmd.columndescs.size()) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Column index out of range");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        String alisaName = null;
        alisaName = this.m_trsmd.columndescs.get(column - 1).getAliasname();
        columnLabel = alisaName != null ? alisaName : this.getColumnName(column);
        if (columnLabel == null) {
            return "";
        }
        return columnLabel;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.writerLog("getColumnName");
        String columnName = null;
        if (column > this.m_trsmd.columndescs.size()) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Column index out of range");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        if (XCloudDriver.FIELD_SENSITIVE) {
            columnName = this.m_trsmd.columndescs.get(column - 1).getColname();
            if (columnName == null) {
                return "";
            }
        } else {
            return this.getColumnLabel(column);
        }
        return columnName;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.writerLog("getSchemaName");
        String schemaName = null;
        if (column > this.m_trsmd.columndescs.size()) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Column index out of range");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        if ((schemaName = this.m_trsmd.columndescs.get(column - 1).getSchemaname()) == null) {
            return "";
        }
        return schemaName;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        String retMsg;
        this.writerLog("getPrecision");
        int precision = 0;
        if (column > this.m_trsmd.columndescs.size()) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("Column index out of range");
            logger.error(retMsg);
        }
        switch (this.m_trsmd.columndescs.get(column - 1).getColtype()) {
            case CHAR: 
            case VARCHAR: 
            case DATETIME: {
                precision = this.m_trsmd.columndescs.get((int)(column - 1)).colwidth;
                break;
            }
            case DOUBLE: {
                precision = 16;
                break;
            }
            case YMINTERVAL: {
                if (this.m_trsmd.columndescs.get(column - 1).getColprecisionsSize() != 1) {
                    retMsg = ExceptionMgr.getConvertedErrorMsg("YMINTERVAL precision is wrong");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                precision = this.m_trsmd.columndescs.get(column - 1).getColprecisions().get(0);
                break;
            }
            case DSINTERVAL: {
                if (this.m_trsmd.columndescs.get(column - 1).getColprecisionsSize() != 2) {
                    retMsg = ExceptionMgr.getConvertedErrorMsg("DSINTERVAL precision is wrong");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                precision = this.m_trsmd.columndescs.get(column - 1).getColprecisions().get(0);
                break;
            }
            case NUMBER: {
                if (this.m_trsmd.columndescs.get(column - 1).getColprecisionsSize() != 2) break;
                precision = this.m_trsmd.columndescs.get(column - 1).getColprecisions().get(0);
                break;
            }
            case TIMESTAMP: {
                precision = 0;
                break;
            }
            case BLOB: 
            case CLOB: {
                precision = -1;
                break;
            }
        }
        return precision;
    }

    @Override
    public int getScale(int column) throws SQLException {
        String retMsg;
        this.writerLog("getScale");
        int scale = 0;
        if (column > this.m_trsmd.columndescs.size()) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("Column index out of range");
            logger.error(retMsg);
        }
        switch (this.m_trsmd.columndescs.get(column - 1).getColtype()) {
            case CHAR: 
            case VARCHAR: 
            case DATETIME: {
                scale = 0;
                break;
            }
            case DOUBLE: {
                scale = 16;
                break;
            }
            case YMINTERVAL: {
                scale = 0;
                break;
            }
            case DSINTERVAL: {
                if (this.m_trsmd.columndescs.get(column - 1).getColprecisionsSize() != 2) {
                    retMsg = ExceptionMgr.getConvertedErrorMsg("DSINTERVAL scale is wrong");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                scale = this.m_trsmd.columndescs.get(column - 1).getColprecisions().get(1);
                break;
            }
            case TIMESTAMP: {
                if (this.m_trsmd.columndescs.get(column - 1).getColprecisionsSize() != 1) {
                    retMsg = ExceptionMgr.getConvertedErrorMsg("TIMESTAMP scale is wrong");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                scale = this.m_trsmd.columndescs.get(column - 1).getColprecisions().get(0);
                break;
            }
            case NUMBER: {
                if (this.m_trsmd.columndescs.get(column - 1).getColprecisionsSize() != 2) break;
                scale = this.m_trsmd.columndescs.get(column - 1).getColprecisions().get(1);
                break;
            }
        }
        return scale;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.writerLog("getTableName");
        String tableName = null;
        if (column > this.m_trsmd.columndescs.size()) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Column index out of range");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        if ((tableName = this.m_trsmd.columndescs.get(column - 1).getTablename()) == null) {
            return "";
        }
        return tableName;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.writerLog("getCatalogName");
        String catalogName = null;
        if (column > this.m_trsmd.columndescs.size()) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Column index out of range");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        if ((catalogName = this.m_trsmd.columndescs.get(column - 1).getCatalogname()) == null) {
            return "";
        }
        return catalogName;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.writerLog("getColumnType");
        int ct = 0;
        if (column > this.m_trsmd.columndescs.size()) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Column index out of range");
            logger.error(retMsg);
        }
        switch (this.m_trsmd.columndescs.get(column - 1).getColtype()) {
            case INTEGER: {
                ct = 4;
                break;
            }
            case LONG: {
                ct = -5;
                break;
            }
            case DOUBLE: {
                ct = 8;
                break;
            }
            case CHAR: {
                ct = 1;
                break;
            }
            case VARCHAR: {
                ct = 12;
                break;
            }
            case NULLTYPE: {
                ct = 0;
                break;
            }
            case DATETIME: {
                ct = 91;
                break;
            }
            case TIMESTAMP: {
                ct = 93;
                break;
            }
            case YMINTERVAL: {
                ct = -103;
                break;
            }
            case DSINTERVAL: {
                ct = -104;
                break;
            }
            case NUMBER: {
                ct = 2;
                break;
            }
            case BLOB: {
                ct = 2004;
                break;
            }
            case CLOB: {
                ct = 2005;
                break;
            }
            default: {
                ct = 1111;
            }
        }
        return ct;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.writerLog("getColumnTypeName");
        String ret = "";
        if (column > this.m_trsmd.columndescs.size()) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Column index out of range");
            logger.error(retMsg);
        }
        switch (this.m_trsmd.columndescs.get(column - 1).getColtype()) {
            case INTEGER: {
                ret = "INTEGER";
                break;
            }
            case LONG: {
                ret = "LONG";
                break;
            }
            case DOUBLE: {
                ret = "DOUBLE";
                break;
            }
            case CHAR: {
                ret = "CHAR";
                break;
            }
            case VARCHAR: {
                ret = "VARCHAR";
                break;
            }
            case NULLTYPE: {
                ret = "NULLTYPE";
                break;
            }
            case DATETIME: {
                ret = "DATETIME";
                break;
            }
            case YMINTERVAL: {
                ret = "INTERVALYM";
                break;
            }
            case DSINTERVAL: {
                ret = "INTERVALDS";
                break;
            }
            case TIMESTAMP: {
                ret = "TIMESTAMP";
                break;
            }
            case NUMBER: {
                ret = "NUMBER";
                break;
            }
            case BLOB: {
                ret = "BLOB";
                break;
            }
            case CLOB: {
                ret = "CLOB";
                break;
            }
            default: {
                ret = "UNKNOWN";
            }
        }
        return ret;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.writerLog("isWritable");
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new RuntimeException("[XCloudResultSetMetaData isDefinitelyWritable] Not Implemented yet.");
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.writerLog("getColumnClassName");
        return "Empty";
    }
}

