/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.jdbc;

import com.bonc.xcloud.common.BufferFactory;
import com.bonc.xcloud.common.CancelSignal;
import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.common.LocalBuffer;
import com.bonc.xcloud.common.MemoryInfoMgr;
import com.bonc.xcloud.common.NumberBuffer;
import com.bonc.xcloud.component.ServiceManager;
import com.bonc.xcloud.convert.ByteOrderConv;
import com.bonc.xcloud.enumdef.CursorModeType;
import com.bonc.xcloud.error.handle.ErrorHandler;
import com.bonc.xcloud.jdbc.XCloudResultSetMetaData;
import com.bonc.xcloud.jdbc.XCloudStatement;
import com.bonc.xcloud.log.XCloudJDBCLogger;
import com.bonc.xcloud.type.INTERVALDS;
import com.bonc.xcloud.type.INTERVALYM;
import com.bonc.xcloud.util.NullValue;
import com.bonc.xcloud.xserver.TColumnDesc;
import com.bonc.xcloud.xserver.TMemDataPack;
import com.bonc.xcloud.xserver.TResultSet;
import com.bonc.xcloud.xserver.TResultSetMetaData;
import com.bonc.xcloud.xserver.TStatus;
import com.bonc.xcloud.xserver.TStatusCode;
import com.bonc.xcloud.xserver.TUniqueId;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCloudResultSet
implements ResultSet {
    private static Logger logger = LoggerFactory.getLogger(XCloudResultSet.class);
    private TResultSetMetaData m_trsmd = null;
    private BufferFactory m_bf = null;
    private TUniqueId m_tqueryhandle = null;
    private ServiceManager m_servicemanager = null;
    private CursorModeType m_mode = CursorModeType.FORWARD;
    private ErrorHandler m_errorHandler = null;
    byte[] arr = null;
    private LZ4FastDecompressor m_decompressor = null;
    private boolean m_hasMaxRowLimit = false;
    private int m_maxRowLimit = 0;
    private int m_fetchSize = 0;
    byte[] decompressed = null;
    private CancelSignal<Boolean> m_isCancel;
    private MemoryInfoMgr m_memInfo = null;
    private boolean wasNull = false;
    private boolean isProcedure = false;
    private boolean hasDealStoreProcedure = false;
    private XCloudJDBCLogger m_jdbcLogger = null;
    private boolean isClosed = true;
    private XCloudStatement m_xs;
    private Map<String, String> m_fieldNameMap = null;
    private TColumnDesc[] m_fakeFields = null;

    public void setProcedure() {
        this.isProcedure = true;
    }

    public void setHasDealProcedure() {
        this.hasDealStoreProcedure = true;
    }

    public XCloudResultSet(XCloudStatement xs, TResultSetMetaData trsmd, BufferFactory bf, TUniqueId tuid, int fetchSize, XCloudJDBCLogger jdbcLogger) throws SQLException {
        this.m_xs = xs;
        this.m_trsmd = trsmd;
        this.m_errorHandler = new ErrorHandler();
        this.m_decompressor = LZ4Factory.fastestInstance().fastDecompressor();
        this.m_tqueryhandle = tuid;
        this.m_bf = bf;
        this.arr = new byte[4];
        if (0 != fetchSize) {
            this.m_fetchSize = fetchSize;
        }
        if (this.m_xs.getMaxRows() > 0) {
            this.m_hasMaxRowLimit = true;
            this.m_maxRowLimit = this.m_xs.getMaxRows();
        }
        this.m_memInfo = this.m_xs.getMemoryInfoMgr();
        this.m_jdbcLogger = jdbcLogger;
        this.m_servicemanager = this.m_xs.getServiceManager();
        this.isClosed = false;
    }

    public void setCancelSignal(CancelSignal<Boolean> isCancel) {
        if (logger.isDebugEnabled()) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("setCancelSignal");
            logger.debug(retMsg);
        }
        this.m_isCancel = isCancel;
    }

    public void setQueryHandle(TUniqueId tuid) {
        if (logger.isDebugEnabled()) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("setQueryHandle");
            logger.debug(retMsg);
        }
        this.m_tqueryhandle = tuid;
    }

    public TUniqueId getQueryHandle() {
        return this.m_tqueryhandle;
    }

    public void setFieldNameMapping(Map<String, String> map) {
        this.m_fieldNameMap = map;
    }

    protected void checkConnStatus() throws SQLException {
        String retMsg = ExceptionMgr.getConvertedErrorMsg("Connection has closed");
        if (this.m_servicemanager == null) {
            logger.error(retMsg);
            ExceptionMgr.throwSQLRecoverableExp(retMsg);
        }
        if (!this.m_servicemanager.isOpen()) {
            logger.error(retMsg);
            ExceptionMgr.throwSQLRecoverableExp(retMsg);
        }
    }

    private void checkSQLStatus() throws SQLException {
        String retMsg = ExceptionMgr.getConvertedErrorMsg("SQL handle has closed");
        if (this.m_tqueryhandle == null) {
            logger.error(retMsg);
            ExceptionMgr.throwSQLRecoverableExp(retMsg);
        }
        if (this.m_tqueryhandle.getReserve() == -1) {
            logger.error(retMsg);
            ExceptionMgr.throwSQLRecoverableExp(retMsg);
        }
    }

    protected void checkRsStatus(boolean isNormal_API) throws SQLException {
        String msg = "Loss of the ResultSet";
        if (isNormal_API) {
            msg = "ResultSet has closed";
        }
        String retMsg = ExceptionMgr.getConvertedErrorMsg(msg);
        logger.error(retMsg);
        if (this.m_tqueryhandle == null) {
            if (isNormal_API) {
                ExceptionMgr.throwSQLRecoverableExp(retMsg);
            }
            ExceptionMgr.throwSQLExp(retMsg);
        }
        if (this.m_tqueryhandle.getReserve() == -1) {
            if (isNormal_API) {
                ExceptionMgr.throwSQLRecoverableExp(retMsg);
            }
            ExceptionMgr.throwSQLExp(retMsg);
        }
    }

    private void checkExecuteStatus(boolean isNormal_API) throws SQLException {
        if (this.isClosed) {
            this.checkRsStatus(isNormal_API);
        }
        this.checkSQLStatus();
        this.checkConnStatus();
    }

    protected void writerLog(String methodName) throws SQLException {
        XCloudJDBCLogger.Write_Log(ExceptionMgr.getConvertedJDBCCallerMsg(methodName));
        if (logger.isDebugEnabled()) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg(methodName);
            logger.debug(retMsg);
        }
    }

    protected void checkCancel() throws SQLException {
        if (this.m_isCancel.getValue().booleanValue()) {
            StringBuffer cancelMsg = new StringBuffer();
            cancelMsg.append("Remote IP = [" + this.m_servicemanager.getConnInfoPack().getCurrentRemoteIP() + "] \n");
            cancelMsg.append("Thread ID = [" + Thread.currentThread().getId() + "] \n");
            cancelMsg.append("Conn   ID = [" + this.m_servicemanager.getConnInfoPack().getCurrentConnID() + "] \n");
            cancelMsg.append("Query  ID = [" + this.m_xs.getStmtInfoPack().getCurrentQueryID() + "] \n");
            cancelMsg.append("Err msg   = [ResultSet cancel signal interrupt!] \n");
            XCloudJDBCLogger.Write_Log(cancelMsg.toString());
            if (logger.isWarnEnabled()) {
                logger.warn(cancelMsg.toString());
            }
            ExceptionMgr.throwSQLExp(cancelMsg.toString());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new RuntimeException("[XCloudResultSet isWrapperFor] Not Implemented yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new RuntimeException("[XCloudResultSet unwrap] Not Implemented yet.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean next() throws SQLException {
        this.writerLog("next");
        this.checkExecuteStatus(true);
        this.checkCancel();
        if (this.m_hasMaxRowLimit) {
            if (this.m_maxRowLimit <= 0) {
                return false;
            }
            --this.m_maxRowLimit;
        }
        if (this.m_bf.isLastRow()) {
            TMemDataPack tmp_tmdp;
            this.m_bf.Reset();
            TResultSet tmp_tResultSet = this.m_servicemanager.fetchResultSet_N(this.m_tqueryhandle, this.m_fetchSize, this.m_xs.getStmtInfoPack());
            if (TStatusCode.OK != tmp_tResultSet.getStatus().getStatus_code() && TStatusCode.EXEC_READY != tmp_tResultSet.getStatus().getStatus_code() && TStatusCode.EXEC_COMPLETE != tmp_tResultSet.getStatus().getStatus_code()) {
                this.m_errorHandler.Handle(tmp_tResultSet.getStatus(), this.m_servicemanager.getConnInfoPack(), this.m_xs.getStmtInfoPack());
            }
            if (null == (tmp_tmdp = tmp_tResultSet.getPack()) || 0 == tmp_tmdp.num_rows) {
                return false;
            }
            this.m_bf.SetRowCount(tmp_tmdp.getNum_rows());
            int column_count = 0;
            column_count = this.isProcedure ? tmp_tmdp.getDataSize() : tmp_tmdp.getDataSize() - 1;
            String info = "num_rows=[" + this.m_bf.GetRowCount() + "] column_count=[" + column_count + "]";
            XCloudJDBCLogger.Write_Log(info);
            if (logger.isDebugEnabled()) {
                logger.debug(info);
            }
            info = null;
            HashMap tmp_lbs = this.m_bf.getBuffers();
            block14: for (int i = 0; i < column_count; ++i) {
                String retMsg;
                int local_col_index = i / 2 + 1;
                int allLen = 0;
                switch (((LocalBuffer)tmp_lbs.get(local_col_index)).getDBType()) {
                    case NULLTYPE: {
                        continue block14;
                    }
                    case INTEGER: {
                        if (i % 2 == 0) {
                            allLen = this.m_bf.GetRowCount() % 8 == 0 ? this.m_bf.GetRowCount() / 8 : this.m_bf.GetRowCount() / 8 + 1;
                            info = "Type=[INTEGER-BV], Col idx=[" + local_col_index + "], real len =[" + allLen + "]";
                            break;
                        }
                        allLen = 4 * this.m_bf.GetRowCount();
                        info = "Type=[INTEGER-Data], Col idx=[" + local_col_index + "], real len =[" + allLen + "]";
                        break;
                    }
                    case DOUBLE: 
                    case DATETIME: 
                    case LONG: {
                        if (i % 2 == 0) {
                            allLen = this.m_bf.GetRowCount() % 8 == 0 ? this.m_bf.GetRowCount() / 8 : this.m_bf.GetRowCount() / 8 + 1;
                            info = "Type=[DOUBLE or LONG-BV], Col idx=[" + local_col_index + "], real len =[" + allLen + "]";
                            break;
                        }
                        allLen = 8 * this.m_bf.GetRowCount();
                        info = "Type=[DOUBLE or LONG-Data], Col idx=[" + local_col_index + "], real len =[" + allLen + "]";
                        break;
                    }
                    case YMINTERVAL: {
                        if (i % 2 == 0) {
                            allLen = this.m_bf.GetRowCount() % 8 == 0 ? this.m_bf.GetRowCount() / 8 : this.m_bf.GetRowCount() / 8 + 1;
                            info = "Type=[YMINTERVAL], Col idx=[" + local_col_index + "], real len =[" + allLen + "]";
                            break;
                        }
                        allLen = 8 * this.m_bf.GetRowCount();
                        info = "Type=[YMINTERVAL], Col idx=[" + local_col_index + "], real len =[" + allLen + "]";
                        break;
                    }
                    case DSINTERVAL: {
                        if (i % 2 == 0) {
                            allLen = this.m_bf.GetRowCount() % 8 == 0 ? this.m_bf.GetRowCount() / 8 : this.m_bf.GetRowCount() / 8 + 1;
                            info = "Type=[DSINTERVAL], Col idx=[" + local_col_index + "], real len =[" + allLen + "]";
                            break;
                        }
                        allLen = 12 * this.m_bf.GetRowCount();
                        info = "Type=[DSINTERVAL], Col idx=[" + local_col_index + "], real len =[" + allLen + "]";
                        break;
                    }
                    case TIMESTAMP: {
                        if (i % 2 == 0) {
                            allLen = this.m_bf.GetRowCount() % 8 == 0 ? this.m_bf.GetRowCount() / 8 : this.m_bf.GetRowCount() / 8 + 1;
                            info = "Type=[TIMESTAMP], Col idx=[" + local_col_index + "], real len =[" + allLen + "]";
                            break;
                        }
                        allLen = 12 * this.m_bf.GetRowCount();
                        info = "Type=[TIMESTAMP], Col idx=[" + local_col_index + "], real len =[" + allLen + "]";
                        break;
                    }
                    case NUMBER: {
                        if (i % 2 == 0) {
                            allLen = this.m_bf.GetRowCount() % 8 == 0 ? this.m_bf.GetRowCount() / 8 : this.m_bf.GetRowCount() / 8 + 1;
                            info = "Type=[NUMBER], Col idx=[" + local_col_index + "], real len =[" + allLen + "]";
                            break;
                        }
                        allLen = NumberBuffer.size * this.m_bf.GetRowCount();
                        info = "Type=[NUMBER], Col idx=[" + local_col_index + "], real len =[" + allLen + "]";
                        break;
                    }
                    case CHAR: {
                        if (i % 2 == 0) {
                            allLen = this.m_bf.GetRowCount() % 8 == 0 ? this.m_bf.GetRowCount() / 8 : this.m_bf.GetRowCount() / 8 + 1;
                            info = "Type=[CHAR-BV], Col idx=[" + local_col_index + "], real len =[" + allLen + "]";
                            break;
                        }
                        allLen = ((LocalBuffer)tmp_lbs.get(local_col_index)).GetTypeSize() * this.m_bf.GetRowCount();
                        info = "Type=[CHAR-Data], Col idx=[" + local_col_index + "], real len =[" + allLen + "]";
                        break;
                    }
                    case BLOB: 
                    case CLOB: 
                    case VARCHAR: {
                        if (i % 2 == 0) {
                            allLen = this.m_bf.GetRowCount() % 8 == 0 ? this.m_bf.GetRowCount() / 8 : this.m_bf.GetRowCount() / 8 + 1;
                            info = "Type=[VARCHAR-BV], Col idx=[" + local_col_index + "], real len =[" + allLen + "]";
                            break;
                        }
                        if (tmp_tmdp.data.get(i).array().length > 4) {
                            int preMaxLen;
                            allLen = this.m_bf.isServerLE() ? ByteOrderConv.ConvByteToIntLE(tmp_tmdp.data.get(i).array(), tmp_tmdp.data.get(i).array().length - 4) : tmp_tmdp.data.get(i).getInt(tmp_tmdp.data.get(i).array().length - 4);
                            if (allLen > (preMaxLen = ((LocalBuffer)this.m_bf.getBuffers().get(local_col_index)).getArray().length)) {
                                ((LocalBuffer)this.m_bf.getBuffers().get(local_col_index)).resizeArray(allLen);
                            }
                            info = "Type=[VARCHAR or LOB-Data], Col idx=[" + local_col_index + "], real len =[" + allLen + "]";
                            break;
                        }
                        String retMsg2 = ExceptionMgr.getConvertedErrorMsg("Varchar Column length <= 4");
                        logger.error(retMsg2);
                        ExceptionMgr.throwSQLExp(retMsg2);
                    }
                }
                XCloudJDBCLogger.Write_Log(info);
                if (logger.isDebugEnabled()) {
                    logger.debug(info);
                }
                if (i % 2 == 0) {
                    this.decompressed = ((LocalBuffer)this.m_bf.getBuffers().get(local_col_index)).getBV();
                } else {
                    ((LocalBuffer)this.m_bf.getBuffers().get(local_col_index)).setArraySize(allLen);
                    this.decompressed = ((LocalBuffer)this.m_bf.getBuffers().get(local_col_index)).getArray();
                }
                try {
                    this.m_decompressor.decompress(tmp_tmdp.data.get(i).array(), 0, this.decompressed, 0, allLen);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    retMsg = ExceptionMgr.getConvertedErrorMsg("\nArrayIndexOutOfBoundsException when lz4 decompress.\ni=" + i + ", allLen=" + allLen + ", maxLen=" + this.decompressed.length);
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                catch (LZ4Exception e) {
                    retMsg = ExceptionMgr.getConvertedErrorMsg("\nLZ4Exception when lz4 decompress.\ni=" + i + ", colIdx=" + local_col_index + ", type=" + (Object)((Object)((LocalBuffer)this.m_bf.getBuffers().get(local_col_index)).getDBType()));
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                if (i % 2 == 0) continue;
                ((LocalBuffer)this.m_bf.getBuffers().get(local_col_index)).arrayUpdate();
            }
        }
        this.m_bf.moveCursor(this.m_mode);
        return true;
    }

    @Override
    public void close() throws SQLException {
        if (this.m_servicemanager == null) {
            return;
        }
        if (!this.m_servicemanager.isOpen()) {
            this.objRelease();
            return;
        }
        if (null != this.m_tqueryhandle && -1 != this.m_tqueryhandle.getReserve()) {
            TStatus ts = this.m_servicemanager.close(this.m_tqueryhandle, ServiceManager.CloseUser.RES);
            if (ts.getStatus_code() != TStatusCode.OK) {
                this.m_errorHandler.Handle(ts, this.m_servicemanager.getConnInfoPack(), this.m_xs.getStmtInfoPack());
            }
            this.m_tqueryhandle.setReserve(-1);
        }
        this.objRelease();
        this.writerLog("close");
    }

    private void objRelease() {
        this.arr = null;
        this.decompressed = null;
        this.m_bf = null;
        this.m_decompressor = null;
        this.m_errorHandler = null;
        this.m_fakeFields = null;
        if (this.m_fieldNameMap != null && this.m_fieldNameMap.size() != 0) {
            this.m_fieldNameMap.clear();
        }
        this.m_fieldNameMap = null;
        this.m_servicemanager = null;
        this.m_trsmd = null;
        this.isClosed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.writerLog("wasNull");
        this.checkExecuteStatus(false);
        return this.wasNull;
    }

    @Override
    public String getString(int colIndex) throws SQLException {
        this.writerLog("[getString(" + Integer.toString(colIndex) + ")] " + "[cur row(" + Integer.toString(this.m_bf.GetCursor()) + ")]");
        this.checkExecuteStatus(false);
        if (this.m_bf.GetCursor() == 0) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("Result Set Already Used Up");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        NullValue isNull = new NullValue(false);
        Object ob = this.m_bf.get(colIndex, 1, isNull);
        this.wasNull = isNull.getValue();
        if (isNull.getValue()) {
            return null;
        }
        return (String)ob;
    }

    public INTERVALYM getINTERVALYM(int colIndex) throws SQLException {
        String retMsg;
        if (logger.isDebugEnabled()) {
            retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("getINTERVALYM");
            logger.debug(retMsg);
        }
        if (this.m_bf.GetCursor() == 0) {
            retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("Result Set Already Used Up");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        NullValue isNull = new NullValue(false);
        Object ob = this.m_bf.get(colIndex, -103, isNull);
        this.wasNull = isNull.getValue();
        return (INTERVALYM)ob;
    }

    public INTERVALYM getINTERVALYM(String columnLabel) throws SQLException {
        this.writerLog("getINTERVALYM");
        return this.getINTERVALYM(this.findColumn(columnLabel));
    }

    public INTERVALDS getINTERVALDS(int colIndex) throws SQLException {
        String retMsg;
        if (logger.isDebugEnabled()) {
            retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("getINTERVALDS");
            logger.debug(retMsg);
        }
        if (this.m_bf.GetCursor() == 0) {
            retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("Result Set Already Used Up");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        NullValue isNull = new NullValue(false);
        Object ob = this.m_bf.get(colIndex, -104, isNull);
        this.wasNull = isNull.getValue();
        return (INTERVALDS)ob;
    }

    public INTERVALDS getINTERVALDS(String columnLabel) throws SQLException {
        this.writerLog("getINTERVALDS");
        return this.getINTERVALDS(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getBoolean] Not Implemented yet.");
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getByte] Not Implemented yet.");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.writerLog("getShort");
        this.checkExecuteStatus(false);
        if (this.m_bf.GetCursor() == 0) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("Result Set Already Used Up");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        NullValue isNull = new NullValue(false);
        short ret = this.m_bf.getShort(columnIndex, isNull);
        this.wasNull = isNull.getValue();
        return ret;
    }

    @Override
    public int getInt(int colIndex) throws SQLException {
        this.writerLog("getInt");
        this.checkExecuteStatus(false);
        if (this.m_bf.GetCursor() == 0) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("Result Set Already Used Up");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        NullValue isnull = new NullValue(false);
        int ret = this.m_bf.getInt(colIndex, isnull);
        this.wasNull = isnull.getValue();
        return ret;
    }

    @Override
    public long getLong(int colIndex) throws SQLException {
        this.writerLog("getLong");
        this.checkExecuteStatus(false);
        if (this.m_bf.GetCursor() == 0) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("Result Set Already Used Up");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        NullValue wasnull = new NullValue(false);
        long ret = this.m_bf.getLong(colIndex, wasnull);
        this.wasNull = wasnull.getValue();
        return ret;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getFloat] Not Implemented yet.");
    }

    @Override
    public double getDouble(int colIndex) throws SQLException {
        this.writerLog("getDouble");
        this.checkExecuteStatus(false);
        if (this.m_bf.GetCursor() == 0) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("Result Set Already Used Up");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        NullValue isnull = new NullValue(false);
        double ret = this.m_bf.getDouble(colIndex, isnull);
        this.wasNull = isnull.getValue();
        return ret;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getBigDecimal] Not Implemented yet.");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getBytes] Not Implemented yet.");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.writerLog("getDate");
        this.checkExecuteStatus(false);
        if (this.m_bf.GetCursor() == 0) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("Result Set Already Used Up");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        NullValue isNull = new NullValue(false);
        Object ob = this.m_bf.get(columnIndex, 93, isNull);
        Date date = null;
        if (ob != null) {
            String type = ob.getClass().getName();
            if (type == "java.sql.Timestamp") {
                Timestamp timestamp = (Timestamp)ob;
                int year = timestamp.getYear();
                int mouth = timestamp.getMonth();
                int day = timestamp.getDate();
                date = new Date(year, mouth, day);
            } else {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("Not Support Type");
                ExceptionMgr.throwSQLExp(retMsg);
            }
        }
        this.wasNull = isNull.getValue();
        return date;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getTime] Not Implemented yet.");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.writerLog("getTimestamp");
        this.checkExecuteStatus(false);
        if (this.m_bf.GetCursor() == 0) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("Result Set Already Used Up");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        NullValue isNull = new NullValue(false);
        Object ob = this.m_bf.get(columnIndex, 93, isNull);
        this.wasNull = isNull.getValue();
        return (Timestamp)ob;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getAsciiStream] Not Implemented yet.");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getUnicodeStream] Not Implemented yet.");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getBinaryStream] Not Implemented yet.");
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.writerLog("getString(" + columnLabel + ")");
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getBoolean] Not Implemented yet.");
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getByte] Not Implemented yet.");
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.writerLog("getShort");
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.writerLog("getInt");
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.writerLog("getLong");
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getFloat] Not Implemented yet.");
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.writerLog("getDouble");
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getBigDecimal] Not Implemented yet.");
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getBytes] Not Implemented yet.");
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.writerLog("getDate");
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getTime] Not Implemented yet.");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.writerLog("getTimestamp");
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getAsciiStream] Not Implemented yet.");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getUnicodeStream] Not Implemented yet.");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getBinaryStream] Not Implemented yet.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.writerLog("getWarnings");
        return this.m_errorHandler.getSQLWarning();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.writerLog("clearWarnings");
        this.m_errorHandler.clearSQLWarning();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new RuntimeException("[XCloudResultSet getCursorName] Not Implemented yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TResultSetMetaData getInternalMetaData() throws SQLException {
        XCloudResultSet xCloudResultSet = this;
        synchronized (xCloudResultSet) {
            if (this.m_trsmd == null) {
                this.m_trsmd = this.m_servicemanager.getResultsetMetaData(this.m_tqueryhandle, this.m_xs.getStmtInfoPack());
                if (TStatusCode.OK != this.m_trsmd.getStatus().getStatus_code()) {
                    this.m_errorHandler.Handle(this.m_trsmd.getStatus(), this.m_servicemanager.getConnInfoPack(), this.m_xs.getStmtInfoPack());
                }
            }
        }
        return this.m_trsmd;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.writerLog("getMetaData");
        this.checkExecuteStatus(true);
        return new XCloudResultSetMetaData(this.getInternalMetaData());
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.writerLog("getObject");
        this.checkExecuteStatus(false);
        if (this.m_bf.GetCursor() == 0) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("Result Set Already Used Up");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        NullValue isNull = new NullValue(false);
        Object ret = this.m_bf.get(columnIndex, 2000, isNull);
        this.wasNull = isNull.getValue();
        return ret;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.writerLog("getObject");
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkExecuteStatus(false);
        TResultSetMetaData meta = this.getInternalMetaData();
        int i = 0;
        List<TColumnDesc> desc = this.m_trsmd.columndescs;
        String name = columnLabel.toUpperCase();
        for (int idx = 0; idx < desc.size() && !desc.get(idx).getAliasname().toUpperCase().equals(name) && !desc.get(idx).getColname().equals(name); ++idx) {
            ++i;
        }
        if (i >= this.m_trsmd.columndescs.size()) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("\u201d" + columnLabel + "\u201d" + ": Invalid identifier");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        return i + 1;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getCharacterStream] Not Implemented yet.");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getCharacterStream] Not Implemented yet.");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.writerLog("getBigDecimal");
        this.checkExecuteStatus(false);
        if (this.m_bf.GetCursor() == 0) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("Result Set Already Used Up");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        NullValue isNull = new NullValue(false);
        Object ob = this.m_bf.get(columnIndex, 2, isNull);
        this.wasNull = isNull.getValue();
        return (BigDecimal)ob;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.writerLog("getBigDecimal");
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new RuntimeException("[XCloudResultSet isBeforeFirst] Not Implemented yet.");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new RuntimeException("[XCloudResultSet isAfterLast] Not Implemented yet.");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new RuntimeException("[XCloudResultSet isFirst] Not Implemented yet.");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new RuntimeException("[XCloudResultSet isLast] Not Implemented yet.");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new RuntimeException("[XCloudResultSet beforeFirst] Not Implemented yet.");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new RuntimeException("[XCloudResultSet afterLast] Not Implemented yet.");
    }

    @Override
    public boolean first() throws SQLException {
        throw new RuntimeException("[XCloudResultSet first] Not Implemented yet.");
    }

    @Override
    public boolean last() throws SQLException {
        throw new RuntimeException("[XCloudResultSet last] Not Implemented yet.");
    }

    @Override
    public int getRow() throws SQLException {
        throw new RuntimeException("[XCloudResultSet getRow] Not Implemented yet.");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new RuntimeException("[XCloudResultSet absolute] Not Implemented yet.");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new RuntimeException("[XCloudResultSet relative] Not Implemented yet.");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new RuntimeException("[XCloudResultSet previous] Not Implemented yet.");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new RuntimeException("[XCloudResultSet setFetchDirection] Not Implemented yet.");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.writerLog("setFetchSize");
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.writerLog("getFetchSize");
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        this.writerLog("getType");
        this.checkExecuteStatus(true);
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new RuntimeException("[XCloudResultSet getConcurrency] Not Implemented yet.");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new RuntimeException("[XCloudResultSet rowUpdated] Not Implemented yet.");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new RuntimeException("[XCloudResultSet rowInserted] Not Implemented yet.");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new RuntimeException("[XCloudResultSet rowDeleted] Not Implemented yet.");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateNull] Not Implemented yet.");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBoolean] Not Implemented yet.");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateByte] Not Implemented yet.");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateShort] Not Implemented yet.");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateInt] Not Implemented yet.");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateFloat] Not Implemented yet.");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateFloat] Not Implemented yet.");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateDouble] Not Implemented yet.");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBigDecimal] Not Implemented yet.");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateString] Not Implemented yet.");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBytes] Not Implemented yet.");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateDate] Not Implemented yet.");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateTime] Not Implemented yet.");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateTimestamp] Not Implemented yet.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateAsciiStream] Not Implemented yet.");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBinaryStream] Not Implemented yet.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateCharacterStream] Not Implemented yet.");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateObject] Not Implemented yet.");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateObject] Not Implemented yet.");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateNull] Not Implemented yet.");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBoolean] Not Implemented yet.");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateByte] Not Implemented yet.");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateShort] Not Implemented yet.");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateInt] Not Implemented yet.");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateLong] Not Implemented yet.");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateFloat] Not Implemented yet.");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateDouble] Not Implemented yet.");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBigDecimal] Not Implemented yet.");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateString] Not Implemented yet.");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBytes] Not Implemented yet.");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateDate] Not Implemented yet.");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateTime] Not Implemented yet.");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateTimestamp] Not Implemented yet.");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateAsciiStream] Not Implemented yet.");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBinaryStream] Not Implemented yet.");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateCharacterStream] Not Implemented yet.");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateObject] Not Implemented yet.");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateObject] Not Implemented yet.");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new RuntimeException("[XCloudResultSet insertRow] Not Implemented yet.");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateRow] Not Implemented yet.");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new RuntimeException("[XCloudResultSet deleteRow] Not Implemented yet.");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new RuntimeException("[XCloudResultSet refreshRow] Not Implemented yet.");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new RuntimeException("[XCloudResultSet cancelRowUpdates] Not Implemented yet.");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new RuntimeException("[XCloudResultSet moveToInsertRow] Not Implemented yet.");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new RuntimeException("[XCloudResultSet moveToCurrentRow] Not Implemented yet.");
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.m_xs;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getObject] Not Implemented yet.");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getRef] Not Implemented yet.");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.writerLog("getBlob");
        this.checkExecuteStatus(false);
        if (this.m_bf.GetCursor() == 0) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("Result Set Already Used Up");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        NullValue isNull = new NullValue(false);
        Object ob = this.m_bf.get(columnIndex, 2004, isNull);
        this.wasNull = isNull.getValue();
        return (Blob)ob;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.writerLog("getClob");
        this.checkExecuteStatus(false);
        if (this.m_bf.GetCursor() == 0) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("Result Set Already Used Up");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        NullValue isNull = new NullValue(false);
        Object ob = this.m_bf.get(columnIndex, 2005, isNull);
        this.wasNull = isNull.getValue();
        return (Clob)ob;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getArray] Not Implemented yet.");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getObject] Not Implemented yet.");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getRef] Not Implemented yet.");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        this.writerLog("getBlob");
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        this.writerLog("getClob");
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getArray] Not Implemented yet.");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getDate] Not Implemented yet.");
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getDate] Not Implemented yet.");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getTime] Not Implemented yet.");
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getTime] Not Implemented yet.");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getTimestamp] Not Implemented yet.");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getTimestamp] Not Implemented yet.");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getURL] Not Implemented yet.");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getURL] Not Implemented yet.");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateRef] Not Implemented yet.");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateRef] Not Implemented yet.");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBlob] Not Implemented yet.");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBlob] Not Implemented yet.");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateClob] Not Implemented yet.");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateClob] Not Implemented yet.");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateArray] Not Implemented yet.");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateArray] Not Implemented yet.");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getRowId] Not Implemented yet.");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getRowId] Not Implemented yet.");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateRowId] Not Implemented yet.");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateRowId] Not Implemented yet.");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new RuntimeException("[XCloudResultSet getHoldability] Not Implemented yet.");
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.writerLog("isClosed");
        if (this.m_tqueryhandle == null) {
            return true;
        }
        return -1 == this.m_tqueryhandle.getReserve();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateNString] Not Implemented yet.");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateNString] Not Implemented yet.");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateNClob] Not Implemented yet.");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateNClob] Not Implemented yet.");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getNClob] Not Implemented yet.");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getNClob] Not Implemented yet.");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getSQLXML] Not Implemented yet.");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getSQLXML] Not Implemented yet.");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateSQLXML] Not Implemented yet.");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateSQLXML] Not Implemented yet.");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getNString] Not Implemented yet.");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getNString] Not Implemented yet.");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getNCharacterStream] Not Implemented yet.");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new RuntimeException("[XCloudResultSet getNCharacterStream] Not Implemented yet.");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateNCharacterStream] Not Implemented yet.");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateNCharacterStream] Not Implemented yet.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateAsciiStream] Not Implemented yet.");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBinaryStream] Not Implemented yet.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateCharacterStream] Not Implemented yet.");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateAsciiStream] Not Implemented yet.");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBinaryStream] Not Implemented yet.");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateCharacterStream] Not Implemented yet.");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBlob] Not Implemented yet.");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBlob] Not Implemented yet.");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateClob] Not Implemented yet.");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateClob] Not Implemented yet.");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateNClob] Not Implemented yet.");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateNClob] Not Implemented yet.");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateNCharacterStream] Not Implemented yet.");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateNCharacterStream] Not Implemented yet.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateAsciiStream] Not Implemented yet.");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBinaryStream] Not Implemented yet.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateCharacterStream] Not Implemented yet.");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateAsciiStream] Not Implemented yet.");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBinaryStream] Not Implemented yet.");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateCharacterStream] Not Implemented yet.");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBlob] Not Implemented yet.");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateBlob] Not Implemented yet.");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateClob] Not Implemented yet.");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateClob] Not Implemented yet.");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateNClob] Not Implemented yet.");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudResultSet updateNClob] Not Implemented yet.");
    }
}

