/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.jdbc;

import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.jdbc.XCloudConnection;
import com.bonc.xcloud.jdbc.XCloudParameterMetaData;
import com.bonc.xcloud.jdbc.XCloudStatement;
import com.bonc.xcloud.log.XCloudJDBCLogger;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCloudPreparedStatement
extends XCloudStatement
implements PreparedStatement {
    private static Logger logger = LoggerFactory.getLogger(XCloudPreparedStatement.class);
    private String m_original_sql = null;
    private final HashMap<Integer, String> parameters = new HashMap();
    private XCloudParameterMetaData m_paramMetaData = null;
    private ResultSetMetaData pstmtResultMetaData;

    public XCloudPreparedStatement(XCloudConnection xc, XCloudJDBCLogger jdbcLogger) throws SQLException {
        super(xc, jdbcLogger);
    }

    public XCloudPreparedStatement(XCloudConnection xc, String sql, XCloudJDBCLogger jdbcLogger) throws SQLException {
        super(xc, jdbcLogger);
        if (sql == null || sql.length() == 0) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("SQL is empty!");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        this.m_original_sql = sql;
        this.m_paramMetaData = new XCloudParameterMetaData(this.getParamCount(sql));
        if (logger.isInfoEnabled()) {
            logger.info("Prepared Statement SQL=[" + this.m_original_sql + "]");
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.releaseLastResult();
        this.writerLog("executeQuery");
        this.checkExecuteStatus();
        String compose_sql = this.executeImmediate();
        ResultSet retSet = this.executeQuery(compose_sql);
        if (retSet.getClass().getName() != "com.bonc.xcloud.jdbc.XCloudDummyResultSet" && this.pstmtResultMetaData == null && retSet != null) {
            this.pstmtResultMetaData = retSet.getMetaData();
        }
        return retSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.releaseLastResult();
        this.writerLog("executeUpdate");
        this.checkExecuteStatus();
        String compose_sql = this.executeImmediate();
        int ret = this.executeUpdate(compose_sql);
        if (this.pstmtResultMetaData == null && ret >= 0 && this.getResultSet() != null) {
            this.pstmtResultMetaData = this.getResultSet().getMetaData();
        }
        return ret;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setNull] Not Implemented yet.");
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setBoolean] Not Implemented yet.");
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setByte] Not Implemented yet.");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setShort] Not Implemented yet.");
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.writerLog("setInt");
        this.checkExecuteStatus();
        this.fieldCheck(parameterIndex);
        this.parameters.put(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.writerLog("setLong");
        this.checkExecuteStatus();
        this.fieldCheck(parameterIndex);
        this.parameters.put(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.writerLog("setFloat");
        this.checkExecuteStatus();
        this.fieldCheck(parameterIndex);
        this.parameters.put(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.writerLog("setDouble");
        this.checkExecuteStatus();
        this.fieldCheck(parameterIndex);
        this.parameters.put(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setBigDecimal] Not Implemented yet.");
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.writerLog("setString");
        this.checkExecuteStatus();
        this.fieldCheck(parameterIndex);
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    continue block7;
                }
                case '\r': {
                    sb.append('\\');
                    sb.append('r');
                    continue block7;
                }
                case '\\': {
                    sb.append('\\');
                    sb.append('\\');
                    continue block7;
                }
                case '\'': {
                    sb.append('\\');
                    sb.append('\'');
                    continue block7;
                }
                case '\"': {
                    sb.append('\\');
                    sb.append('\"');
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        this.parameters.put(parameterIndex, "'" + sb.toString() + "'");
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setBytes] Not Implemented yet.");
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.fieldCheck(parameterIndex);
        this.parameters.put(parameterIndex, "'" + String.valueOf(x) + "'");
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setTime] Not Implemented yet.");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setTimestamp] Not Implemented yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setAsciiStream] Not Implemented yet.");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setUnicodeStream] Not Implemented yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setBinaryStream] Not Implemented yet.");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.writerLog("clearParameters");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setObject] Not Implemented yet.");
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.writerLog("setObject");
        this.checkExecuteStatus();
        this.fieldCheck(parameterIndex);
        if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, ((Double)x).intValue());
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).intValue());
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, ((Long)x).intValue());
        } else if (x instanceof String) {
            this.setString(parameterIndex, ((String)x).intern());
        } else {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Set object not supported this type!");
            ExceptionMgr.throwSQLExp(retMsg);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.releaseLastResult();
        this.writerLog("execute");
        this.checkExecuteStatus();
        String compose_sql = this.executeImmediate();
        boolean ret = this.execute(compose_sql);
        if (this.pstmtResultMetaData == null && ret && this.getResultSet() != null) {
            this.pstmtResultMetaData = this.getResultSet().getMetaData();
        }
        return ret;
    }

    @Override
    public void addBatch() throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement addBatch] Not Implemented yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setRef] Not Implemented yet.");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setBlob] Not Implemented yet.");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setClob] Not Implemented yet.");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setArray] Not Implemented yet.");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkExecuteStatus();
        if (this.pstmtResultMetaData == null) {
            ExceptionMgr.throwSQLExp("Statement handle not executed:getMetaData");
        }
        return this.pstmtResultMetaData;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setTime] Not Implemented yet.");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setTimestamp] Not Implemented yet.");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setNull] Not Implemented yet.");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setURL] Not Implemented yet.");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.writerLog("getParameterMetaData");
        this.checkExecuteStatus();
        return this.m_paramMetaData;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setRowId] Not Implemented yet.");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setNString] Not Implemented yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setNCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setNClob] Not Implemented yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setClob] Not Implemented yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setBlob] Not Implemented yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setNClob] Not Implemented yet.");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setSQLXML] Not Implemented yet.");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setObject] Not Implemented yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setAsciiStream] Not Implemented yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setBinaryStream] Not Implemented yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setAsciiStream] Not Implemented yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setBinaryStream] Not Implemented yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setNCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setClob] Not Implemented yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setBlob] Not Implemented yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudPreparedStatement setNClob] Not Implemented yet.");
    }

    private String updateSql(String sql, HashMap<Integer, String> parameters) {
        StringBuffer newSql = new StringBuffer(sql);
        int paramLoc = 1;
        while (this.getCharIndexFromSqlByParamLocation(sql, '?', paramLoc) > 0) {
            if (parameters.containsKey(paramLoc)) {
                int tt = this.getCharIndexFromSqlByParamLocation(newSql.toString(), '?', 1);
                newSql.deleteCharAt(tt);
                newSql.insert(tt, parameters.get(paramLoc));
            }
            ++paramLoc;
        }
        return newSql.toString();
    }

    private int getCharIndexFromSqlByParamLocation(String sql, char cchar, int paramLoc) {
        int signalCount = 0;
        int charIndex = -1;
        int num = 0;
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c == '\'' || c == '\\') {
                ++signalCount;
                continue;
            }
            if (c != cchar || signalCount % 2 != 0 || ++num != paramLoc) continue;
            charIndex = i;
            break;
        }
        return charIndex;
    }

    private String executeImmediate() throws SQLException {
        if (this.m_original_sql == null || this.m_original_sql.length() == 0) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("SQL is empty!");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        String compose_sql = "";
        compose_sql = this.m_original_sql.contains("?") ? this.updateSql(this.m_original_sql, this.parameters) : this.m_original_sql;
        String Msg = "executeImmediate SQL:[" + compose_sql + "]";
        logger.info(Msg);
        return compose_sql;
    }

    private void fieldCheck(int parameterIndex) throws SQLException {
        String retMsg;
        if (this.m_original_sql == null || this.m_original_sql.length() == 0) {
            retMsg = "JDBC error msg =[SQL is empty!]";
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        if (parameterIndex == 0 || !this.m_original_sql.contains("?")) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("Invalid field index!");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
    }

    private int getParamCount(String sql) {
        int Count = 0;
        int signalCount = 0;
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c == '\'' || c == '\\') {
                ++signalCount;
                continue;
            }
            if (c != '?' || signalCount % 2 != 0) continue;
            ++Count;
        }
        return Count;
    }
}

