/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.jdbc;

import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.context.builder.BatchInsertContentBuilder;
import com.bonc.xcloud.enumdef.JavaTypeEnum;
import com.bonc.xcloud.enumdef.SQLType;
import com.bonc.xcloud.jdbc.XCloudConnection;
import com.bonc.xcloud.jdbc.XCloudDummyResultSet;
import com.bonc.xcloud.jdbc.XCloudParameterMetaData;
import com.bonc.xcloud.jdbc.XCloudStatement;
import com.bonc.xcloud.log.XCloudJDBCLogger;
import com.bonc.xcloud.sql.parser.CommandContext;
import com.bonc.xcloud.xserver.TStatus;
import com.bonc.xcloud.xserver.TStatusCode;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCloudInsertPreparedStatement
extends XCloudStatement
implements PreparedStatement {
    private static Logger logger = LoggerFactory.getLogger(XCloudStatement.class);
    private CommandContext m_sql_parser = null;
    private String m_sql = "";

    public XCloudInsertPreparedStatement(XCloudConnection xc, XCloudJDBCLogger jdbcLogger, CommandContext sqlParser, String sql) throws SQLException {
        super(xc, jdbcLogger);
        this.m_sql_parser = sqlParser;
        this.m_sql = sql;
        this.m_content_builder = new BatchInsertContentBuilder(this.m_clientLoadBlockSize, this.m_sql_parser.getAllColumnInfo(), xc.getServerCharset());
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.releaseLastResult();
        if (this.m_is_batch) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("in Batch Operation");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        this.executeBatchSQL(false, this.m_sql);
        return new XCloudDummyResultSet(SQLType.SQL_DML);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.releaseLastResult();
        if (this.m_is_batch) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("in Batch Operation");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        this.executeBatchSQL(false, this.m_sql);
        if (this.m_updateCount > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)this.m_updateCount;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.m_content_builder.setObject(parameterIndex, sqlType, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setBoolean] Not Implemented yet.");
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setByte] Not Implemented yet.");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setShort] Not Implemented yet.");
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.m_content_builder.setObject(parameterIndex, 4, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.m_content_builder.setObject(parameterIndex, -5, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setFloat] Not Implemented yet.");
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.m_content_builder.setObject(parameterIndex, 8, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setBigDecimal] Not Implemented yet.");
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.m_content_builder.setObject(parameterIndex, 12, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setBytes] Not Implemented yet.");
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.m_content_builder.setObject(parameterIndex, 91, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setTime] Not Implemented yet.");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.m_content_builder.setObject(parameterIndex, 93, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setAsciiStream] Not Implemented yet.");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setUnicodeStream] Not Implemented yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setBinaryStream] Not Implemented yet.");
    }

    @Override
    public void clearParameters() throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setObject] Not Implemented yet.");
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        int t = 0;
        String type_full_name = x.getClass().getName();
        int first_point = type_full_name.lastIndexOf(".");
        String type_name = type_full_name.substring(first_point + 1);
        JavaTypeEnum type_to_enum = JavaTypeEnum.valueOf(type_name);
        switch (type_to_enum) {
            case Long: {
                t = -5;
                break;
            }
            case Double: {
                t = 8;
                break;
            }
            case String: {
                t = 12;
                break;
            }
            case Integer: {
                t = 4;
                break;
            }
            case Date: {
                t = 91;
                break;
            }
            case Timestamp: {
                t = 93;
                break;
            }
            default: {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("Not Support Type");
                ExceptionMgr.throwSQLExp(retMsg);
                break;
            }
        }
        this.m_content_builder.setObject(parameterIndex, t, x);
    }

    @Override
    public boolean execute() throws SQLException {
        this.releaseLastResult();
        if (this.m_is_batch) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("in Batch Operation");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        this.executeBatchSQL(false, this.m_sql);
        return false;
    }

    @Override
    public void addBatch() throws SQLException {
        this.m_is_batch = true;
        if (this.m_first_batch) {
            this.sendSQL(this.m_sql);
            this.m_first_batch = false;
        }
        while (this.m_content_builder.generateOneRow()) {
            List<ByteBuffer> buffer = this.m_content_builder.getBuffer();
            TStatus result_status = this.m_servicemanager.sendData_binarys(this.m_queryhandle, this.getStmtInfoPack(), buffer, false);
            if (TStatusCode.OK != result_status.status_code) {
                this.m_errorHandler.Handle(result_status, this.m_servicemanager.getConnInfoPack(), this.getStmtInfoPack());
            }
            this.m_content_builder.clearBuffer();
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setRef] Not Implemented yet.");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setBlob] Not Implemented yet.");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setClob] Not Implemented yet.");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setArray] Not Implemented yet.");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setDate] Not Implemented yet.");
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setTime] Not Implemented yet.");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setTimestamp(,,,)] Not Implemented yet.");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setNull] Not Implemented yet.");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setURL] Not Implemented yet.");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new XCloudParameterMetaData(this.m_sql_parser.getAllColumnInfo().size());
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setRowId] Not Implemented yet.");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setNString] Not Implemented yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setNCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setNClob] Not Implemented yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setClob] Not Implemented yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setBlob] Not Implemented yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setNClob] Not Implemented yet.");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setSQLXML] Not Implemented yet.");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setObject] Not Implemented yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setAsciiStream] Not Implemented yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setBinaryStream] Not Implemented yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setAsciiStream] Not Implemented yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setBinaryStream] Not Implemented yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setNCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setClob] Not Implemented yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setBlob] Not Implemented yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudInsertPreparedStatement setNClob] Not Implemented yet.");
    }
}

