/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.jdbc;

import com.bonc.xcloud.common.BasicNetInfo;
import com.bonc.xcloud.common.ConnInfo;
import com.bonc.xcloud.common.ConnInfoPack;
import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.jdbc.XCloudConnection;
import com.bonc.xcloud.log.XCloudJDBCLogger;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCloudDriver
implements Driver {
    private static Logger logger = LoggerFactory.getLogger(XCloudDriver.class);
    private String m_url = null;
    private int m_connectRetry = 3;
    private int m_socketTimeOut = 3600000;
    private boolean m_connectDirect = false;
    private boolean m_throwInsufficientMemoryExceptionSwitch = true;
    private int m_buffMemory = 0x400000;
    private int m_clientLoadBlockSize = 0x400000;
    private static final int MAX_BUFFER_SIZE = 0x20000000;
    private static XCloudJDBCLogger m_jdbcLogger = null;
    private static String m_mac_addr = null;
    private String m_metaStoreIP = null;
    private int m_metaStorePort = 0;
    private static String URL_PREFIX = "jdbc:xcloud:";
    public static boolean FIELD_SENSITIVE = true;

    @Override
    public boolean acceptsURL(String arg0) throws SQLException {
        return Pattern.matches(URL_PREFIX + ".*", arg0);
    }

    private boolean checkURL(String arg0, ConnInfoPack infoPack) throws SQLException {
        String retMsg;
        String[] thridTemp;
        String[] secondTemp;
        boolean ret = true;
        if (null == arg0 || 0 == arg0.length()) {
            ret = false;
            return ret;
        }
        String[] firstTemp = arg0.split("\\?");
        if (firstTemp.length > 2) {
            String retMsg2 = ExceptionMgr.getConvertedErrorMsg("URL format not right ,check this content=[" + arg0 + "]");
            logger.error(retMsg2);
            ExceptionMgr.throwSQLExp(retMsg2);
        }
        if ((secondTemp = firstTemp[0].split(":@")).length != 2) {
            String retMsg3 = ExceptionMgr.getConvertedErrorMsg("URL format not right ,check this content=[" + firstTemp[0] + "]");
            logger.error(retMsg3);
            ExceptionMgr.throwSQLExp(retMsg3);
        }
        if ((thridTemp = secondTemp[1].split("@")).length == 0) {
            String retMsg4 = ExceptionMgr.getConvertedErrorMsg("URL format not right ,check this content=[" + secondTemp[1] + "]");
            logger.error(retMsg4);
            ExceptionMgr.throwSQLExp(retMsg4);
        }
        for (int idx = 0; idx < thridTemp.length; ++idx) {
            ConnInfo info = new ConnInfo();
            String[] strTmp = thridTemp[idx].split("/");
            if (strTmp.length > 2) {
                retMsg = ExceptionMgr.getConvertedErrorMsg("URL format not right ,check this content=[" + firstTemp[0] + "]");
                logger.error(retMsg);
                ExceptionMgr.throwSQLExp(retMsg);
            }
            if (strTmp.length == 1) {
                info.setDBName("");
            } else {
                info.setDBName(strTmp[1]);
            }
            strTmp = strTmp[0].split(":");
            if (strTmp.length != 2) {
                retMsg = ExceptionMgr.getConvertedErrorMsg("URL format not right ,check this content=[" + strTmp[0] + "]");
                logger.error(retMsg);
                ExceptionMgr.throwSQLExp(retMsg);
            }
            info.setRemoteIP(strTmp[0]);
            info.setRemotePort(strTmp[1]);
            infoPack.addConnInfo(info);
        }
        if (firstTemp.length == 2) {
            String[] strTemp = firstTemp[1].split("&");
            for (int idx = 0; idx < strTemp.length; ++idx) {
                String retMsg5;
                String[] temp = strTemp[idx].split("=");
                if (temp.length != 2) {
                    retMsg = ExceptionMgr.getConvertedErrorMsg("URL format not right ,check this content=[" + strTemp[idx] + "]");
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                if (temp[0].trim().equalsIgnoreCase("connectRetry")) {
                    try {
                        this.m_connectRetry = Integer.parseInt(temp[1].trim());
                    }
                    catch (NumberFormatException e) {
                        retMsg5 = ExceptionMgr.getConvertedErrorMsg("URL format not right, connectRetry value should be a number!");
                        ExceptionMgr.throwSQLExp(retMsg5);
                    }
                    continue;
                }
                if (temp[0].trim().equalsIgnoreCase("socketTimeOut")) {
                    try {
                        this.m_socketTimeOut = Integer.parseInt(temp[1].trim());
                    }
                    catch (NumberFormatException e) {
                        retMsg5 = ExceptionMgr.getConvertedErrorMsg("URL format not right, socketTimeOut value should be a number!");
                        ExceptionMgr.throwSQLExp(retMsg5);
                    }
                    continue;
                }
                if (temp[0].trim().equalsIgnoreCase("connectDirect")) {
                    this.m_connectDirect = Boolean.parseBoolean(temp[1].trim());
                    continue;
                }
                if (temp[0].trim().equalsIgnoreCase("throwInsufficientMemoryExceptionSwitch")) {
                    this.m_throwInsufficientMemoryExceptionSwitch = Boolean.parseBoolean(temp[1].trim());
                    continue;
                }
                if (temp[0].trim().equalsIgnoreCase("buffMemory")) {
                    try {
                        this.m_buffMemory = Integer.parseInt(temp[1].trim());
                        if (this.m_buffMemory > 0x20000000) {
                            retMsg = ExceptionMgr.getConvertedErrorMsg("URL format not right, buffer memory > 256M, it's not support");
                            ExceptionMgr.throwSQLExp(retMsg);
                        }
                        if (this.m_buffMemory <= Integer.MAX_VALUE) continue;
                        retMsg = ExceptionMgr.getConvertedErrorMsg("URL format not right, buffer memory > Byte array can allocate size!");
                        ExceptionMgr.throwSQLExp(retMsg);
                    }
                    catch (NumberFormatException e) {
                        retMsg5 = ExceptionMgr.getConvertedErrorMsg("URL format not right, maxMemory value should be a number!");
                        ExceptionMgr.throwSQLExp(retMsg5);
                    }
                    continue;
                }
                if (temp[0].trim().equalsIgnoreCase("clientLoadBlockSize")) {
                    this.m_clientLoadBlockSize = Integer.parseInt(temp[1].trim());
                    if (this.m_clientLoadBlockSize < 0x20000000) continue;
                    retMsg = ExceptionMgr.getConvertedErrorMsg("URL format not right, client Load Block Size > 256M, it's not support");
                    ExceptionMgr.throwSQLExp(retMsg);
                    continue;
                }
                if (temp[0].trim().equalsIgnoreCase("FieldSensitive")) {
                    FIELD_SENSITIVE = Boolean.parseBoolean(temp[1].trim());
                    continue;
                }
                if (temp[0].trim().equalsIgnoreCase("MetaStoreIP")) {
                    this.m_metaStoreIP = temp[1].trim();
                    continue;
                }
                if (temp[0].trim().equalsIgnoreCase("MetaStorePort")) {
                    try {
                        this.m_metaStorePort = Integer.parseInt(temp[1].trim());
                    }
                    catch (NumberFormatException e) {
                        retMsg5 = ExceptionMgr.getConvertedErrorMsg("URL format not right, MetaStorePort value should be a number!");
                        ExceptionMgr.throwSQLExp(retMsg5);
                    }
                    continue;
                }
                retMsg = ExceptionMgr.getConvertedErrorMsg("URL format not right ,check this content=[" + temp[1] + "]");
                ExceptionMgr.throwSQLExp(retMsg);
            }
        }
        this.m_url = firstTemp[0];
        return ret;
    }

    @Override
    public Connection connect(String arg0, Properties arg1) throws SQLException {
        ConnInfoPack infoPack = new ConnInfoPack();
        if (logger.isInfoEnabled()) {
            logger.info("Receive arg=[" + arg0 + "]");
        }
        if (!this.acceptsURL(arg0 = arg0.replaceAll("\r|\n|\t", ""))) {
            return null;
        }
        if (!this.checkURL(arg0, infoPack)) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("No suitable driver found for url=[" + arg0 + "]");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        infoPack.setURL(arg0);
        infoPack.setConnectRetry(this.m_connectRetry);
        infoPack.setSocketTimeOut(this.m_socketTimeOut);
        infoPack.setConnectDirect(this.m_connectDirect);
        infoPack.setBuffMemory(this.m_buffMemory);
        infoPack.setClientLoadBlockSize(this.m_clientLoadBlockSize);
        infoPack.setDBUserName(arg1.getProperty("user"));
        infoPack.setDBPassWd(arg1.getProperty("password"));
        infoPack.setMetaStoreIP(this.m_metaStoreIP);
        infoPack.setMetaStorePort(this.m_metaStorePort);
        infoPack.setMac(m_mac_addr);
        infoPack.setThrowInsufficientMemoryExceptionSwitch(this.m_throwInsufficientMemoryExceptionSwitch);
        this.m_metaStoreIP = null;
        this.m_metaStorePort = 0;
        XCloudConnection conn = new XCloudConnection(infoPack, m_jdbcLogger);
        conn.connectInit();
        infoPack.setCurrentConnID(System.identityHashCode(conn));
        if (logger.isInfoEnabled()) {
            String infoMsg = infoPack.getConnInfoPackMsg();
            logger.info(infoMsg);
            XCloudJDBCLogger.Write_Log(infoMsg);
        }
        return conn;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String arg0, Properties arg1) throws SQLException {
        return null;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(new XCloudDriver());
        }
        catch (SQLException e) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Can't Register Driver!");
            logger.error(retMsg);
            throw new RuntimeException(retMsg);
        }
        try {
            m_mac_addr = BasicNetInfo.getLocalMac();
        }
        catch (SQLException e) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("get MAC addr err");
            logger.error(retMsg);
            throw new RuntimeException(retMsg);
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            try {
                m_jdbcLogger = new XCloudJDBCLogger("./xcloud_jdbc.log");
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            m_jdbcLogger = new XCloudJDBCLogger("./xcloud_jdbc.log");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

