/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.jdbc;

import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.enumdef.SQLType;
import com.bonc.xcloud.jdbc.XCloudConnection;
import com.bonc.xcloud.jdbc.XCloudDummyResultSet;
import com.bonc.xcloud.jdbc.XCloudResultSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCloudDatabaseMetaData
implements DatabaseMetaData {
    private static Logger logger = LoggerFactory.getLogger(XCloudDatabaseMetaData.class);
    private XCloudConnection m_belongingCon;
    private int m_firstversion = 0;
    private int m_secondversion = 0;
    private int m_thirdversion = 0;
    private String m_username = "";

    public XCloudDatabaseMetaData(XCloudConnection con, int firstversion, int secondversion, int thirdversion) {
        this.m_belongingCon = con;
        this.m_firstversion = firstversion;
        this.m_secondversion = secondversion;
        this.m_thirdversion = thirdversion;
    }

    public void setUserName(String userName) {
        this.m_username = userName;
    }

    protected void writerLog(String methodName) {
        if (logger.isDebugEnabled()) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg(methodName);
            logger.debug(retMsg);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData unwrap] Not Implemented yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData isWrapperFor] Not Implemented yet.");
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData allProceduresAreCallable] Not Implemented yet.");
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData allTablesAreSelectable] Not Implemented yet.");
    }

    @Override
    public String getURL() throws SQLException {
        return this.m_belongingCon.getConnInfoPack().getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        this.writerLog("getUserName");
        return this.m_username;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData isReadOnly] Not Implemented yet.");
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData nullsAreSortedHigh] Not Implemented yet.");
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData nullsAreSortedLow] Not Implemented yet.");
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData nullsAreSortedAtStart] Not Implemented yet.");
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData nullsAreSortedAtEnd] Not Implemented yet.");
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        this.writerLog("getDatabaseProductName");
        return "XCloud";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        this.writerLog("getDatabaseProductVersion");
        String version = this.m_belongingCon.getServiceManager().getBEVersion();
        return version;
    }

    @Override
    public String getDriverName() throws SQLException {
        this.writerLog("getDriverName");
        return "XCloud JDBC Drvier";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        this.writerLog("getDriverVersion");
        return this.m_firstversion + "." + this.m_secondversion + "." + this.m_thirdversion;
    }

    @Override
    public int getDriverMajorVersion() {
        this.writerLog("getDriverMajorVersion");
        return this.m_firstversion;
    }

    @Override
    public int getDriverMinorVersion() {
        this.writerLog("getDriverMinorVersion");
        return this.m_secondversion;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData usesLocalFiles] Not Implemented yet.");
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData usesLocalFilePerTable] Not Implemented yet.");
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.writerLog("supportsMixedCaseIdentifiers");
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        this.writerLog("storesUpperCaseIdentifiers");
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        this.writerLog("storesLowerCaseIdentifiers");
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.writerLog("storesMixedCaseIdentifiers");
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.writerLog("supportsMixedCaseQuotedIdentifiers");
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        this.writerLog("storesUpperCaseQuotedIdentifiers");
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        this.writerLog("storesLowerCaseQuotedIdentifiers");
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.writerLog("storesMixedCaseQuotedIdentifiers");
        return true;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        this.writerLog("getIdentifierQuoteString");
        return " ";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getSQLKeywords] Not Implemented yet.");
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getNumericFunctions] Not Implemented yet.");
    }

    @Override
    public String getStringFunctions() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getStringFunctions] Not Implemented yet.");
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getSystemFunctions] Not Implemented yet.");
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getTimeDateFunctions] Not Implemented yet.");
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getSearchStringEscape] Not Implemented yet.");
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getExtraNameCharacters] Not Implemented yet.");
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsAlterTableWithAddColumn] Not Implemented yet.");
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsAlterTableWithDropColumn] Not Implemented yet.");
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsColumnAliasing] Not Implemented yet.");
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData nullPlusNonNullIsNull] Not Implemented yet.");
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsConvert] Not Implemented yet.");
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsConvert] Not Implemented yet.");
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsTableCorrelationNames] Not Implemented yet.");
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsDifferentTableCorrelationNames] Not Implemented yet.");
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsExpressionsInOrderBy] Not Implemented yet.");
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsOrderByUnrelated] Not Implemented yet.");
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsGroupBy] Not Implemented yet.");
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsGroupByUnrelated] Not Implemented yet.");
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsGroupByBeyondSelect] Not Implemented yet.");
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsLikeEscapeClause] Not Implemented yet.");
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        this.writerLog("supportsMultipleResultSets");
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsMultipleTransactions] Not Implemented yet.");
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsNonNullableColumns] Not Implemented yet.");
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsMinimumSQLGrammar] Not Implemented yet.");
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsCoreSQLGrammar] Not Implemented yet.");
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsExtendedSQLGrammar] Not Implemented yet.");
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsANSI92EntryLevelSQL] Not Implemented yet.");
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsANSI92IntermediateSQL] Not Implemented yet.");
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsANSI92FullSQL] Not Implemented yet.");
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsIntegrityEnhancementFacility] Not Implemented yet.");
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsOuterJoins] Not Implemented yet.");
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsFullOuterJoins] Not Implemented yet.");
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsLimitedOuterJoins] Not Implemented yet.");
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        this.writerLog("getSchemaTerm");
        String ret = "schema";
        return ret;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getProcedureTerm] Not Implemented yet.");
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getCatalogTerm] Not Implemented yet.");
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData isCatalogAtStart] Not Implemented yet.");
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getCatalogSeparator] Not Implemented yet.");
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsSchemasInDataManipulation] Not Implemented yet.");
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsSchemasInProcedureCalls] Not Implemented yet.");
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        this.writerLog("supportsSchemasInTableDefinitions");
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsSchemasInIndexDefinitions] Not Implemented yet.");
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsSchemasInPrivilegeDefinitions] Not Implemented yet.");
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsCatalogsInDataManipulation] Not Implemented yet.");
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsCatalogsInProcedureCalls] Not Implemented yet.");
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        this.writerLog("supportsCatalogsInTableDefinitions");
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsCatalogsInIndexDefinitions] Not Implemented yet.");
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsCatalogsInPrivilegeDefinitions] Not Implemented yet.");
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsPositionedDelete] Not Implemented yet.");
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsPositionedUpdate] Not Implemented yet.");
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsSelectForUpdate] Not Implemented yet.");
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsStoredProcedures] Not Implemented yet.");
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsSubqueriesInComparisons] Not Implemented yet.");
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsSubqueriesInExists] Not Implemented yet.");
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsSubqueriesInIns] Not Implemented yet.");
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsSubqueriesInQuantifieds] Not Implemented yet.");
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsCorrelatedSubqueries] Not Implemented yet.");
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsUnion] Not Implemented yet.");
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsUnionAll] Not Implemented yet.");
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsOpenCursorsAcrossCommit] Not Implemented yet.");
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsOpenCursorsAcrossRollback] Not Implemented yet.");
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsOpenStatementsAcrossCommit] Not Implemented yet.");
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsOpenStatementsAcrossRollback] Not Implemented yet.");
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxBinaryLiteralLength] Not Implemented yet.");
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxCharLiteralLength] Not Implemented yet.");
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxColumnNameLength] Not Implemented yet.");
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxColumnsInGroupBy] Not Implemented yet.");
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxColumnsInIndex] Not Implemented yet.");
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        this.writerLog("getMaxColumnsInOrderBy");
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxColumnsInSelect] Not Implemented yet.");
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxColumnsInTable] Not Implemented yet.");
    }

    @Override
    public int getMaxConnections() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxConnections] Not Implemented yet.");
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxCursorNameLength] Not Implemented yet.");
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxIndexLength] Not Implemented yet.");
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxSchemaNameLength] Not Implemented yet.");
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxProcedureNameLength] Not Implemented yet.");
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxCatalogNameLength] Not Implemented yet.");
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxRowSize] Not Implemented yet.");
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData doesMaxRowSizeIncludeBlobs] Not Implemented yet.");
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxStatementLength] Not Implemented yet.");
    }

    @Override
    public int getMaxStatements() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxStatements] Not Implemented yet.");
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxTableNameLength] Not Implemented yet.");
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxTablesInSelect] Not Implemented yet.");
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getMaxUserNameLength] Not Implemented yet.");
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getDefaultTransactionIsolation] Not Implemented yet.");
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsTransactionIsolationLevel] Not Implemented yet.");
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsDataDefinitionAndDataManipulationTransactions] Not Implemented yet.");
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsDataManipulationTransactionsOnly] Not Implemented yet.");
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData dataDefinitionCausesTransactionCommit] Not Implemented yet.");
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData dataDefinitionIgnoredInTransactions] Not Implemented yet.");
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        this.writerLog("getProcedures");
        return null;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getProcedureColumns] Not Implemented yet.");
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        this.writerLog("getTables");
        boolean hasWhere = false;
        String schemaCompareOperator = "like";
        String tableCompareOperator = "like";
        String sql = "select table_cat as TABLE_CAT, schema_name as TABLE_SCHEM, table_name as TABLE_NAME, table_type as TABLE_TYPE, table_comment as REMARKS, type_cat as TYPE_CAT, type_schem as TYPE_SCHEM, type_name as TYPE_NAME, self_referencing_col_name as SELF_REFERENCING_COL_NAME, ref_generation as REF_GENERATION from v$user_tables ";
        if (schemaPattern != null) {
            if (schemaPattern.indexOf("%") == -1) {
                schemaCompareOperator = "=";
            }
            sql = sql + "where schema_name " + schemaCompareOperator + " '" + schemaPattern + "' ";
            hasWhere = true;
        }
        if (tableNamePattern != null) {
            if (tableNamePattern.indexOf("%") == -1) {
                tableCompareOperator = "=";
            }
            sql = hasWhere ? sql + "and table_name " + tableCompareOperator + " '" + tableNamePattern + "' " : sql + "where table_name " + tableCompareOperator + " '" + tableNamePattern + "' ";
        }
        Statement stmt = this.m_belongingCon.createStatement();
        XCloudResultSet rs = (XCloudResultSet)stmt.executeQuery(sql);
        return rs;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        this.writerLog("getSchemas");
        Statement stmt = this.m_belongingCon.createStatement();
        XCloudResultSet rs = (XCloudResultSet)stmt.executeQuery("select schema_name as TABLE_SCHEM, table_catalog as TABLE_CATALOG from v$user_schemas");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("schema_name".toUpperCase(), "TABLE_SCHEM");
        map.put("table_catalog".toUpperCase(), "TABLE_CATALOG");
        rs.setFieldNameMapping(map);
        return rs;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        this.writerLog("getCatalogs");
        Statement stmt = this.m_belongingCon.createStatement();
        XCloudResultSet rs = (XCloudResultSet)stmt.executeQuery("select table_catalog as TABLE_CAT from v$user_schemas");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table_catalog".toUpperCase(), "TABLE_CAT");
        rs.setFieldNameMapping(map);
        return rs;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        this.writerLog("getTableTypes");
        Statement stmt = this.m_belongingCon.createStatement();
        XCloudResultSet rs = (XCloudResultSet)stmt.executeQuery("select distinct type_name as TYPE_NAME from  v$user_tables");
        return rs;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String retMsg;
        this.writerLog("getColumns");
        if (schemaPattern == null) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("SchemaPattern currently only support full schema name.");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        if (tableNamePattern == null) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("TableNamePattern currently only support full table name.");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        Statement stmt = this.m_belongingCon.createStatement();
        XCloudResultSet rs = (XCloudResultSet)stmt.executeQuery("select table_cat as TABLE_CAT, schema_name as TABLE_SCHEM, table_name as TABLE_NAME, column_name as COLUMN_NAME, jdbc_data_type as DATA_TYPE, data_type as TYPE_NAME, data_size as COLUMN_SIZE, buffer_length as BUFFER_LENGTH, decimal_digits as DECIMAL_DIGITS, num_prec_radix as NUM_PREC_RADIX, nullable as NULLABLE, column_comment as REMARKS, column_def as COLUMN_DEF, sql_data_type as SQL_DATA_TYPE, sql_datetime_sub as SQL_DATETIME_SUB, char_octet_length as CHAR_OCTET_LENGTH, ordinal_position as ORDINAL_POSITION, is_nullable as IS_NULLABLE, scope_catlog as SCOPE_CATLOG, scope_schema as SCOPE_SCHEMA, scope_table as SCOPE_TABLE, source_data_type as SOURCE_DATA_TYPE, is_autoincrement as IS_AUTOINCREMENT from v$user_tab_columns where schema_name = '" + schemaPattern.toUpperCase() + "' and table_name = '" + tableNamePattern.toUpperCase() + "'");
        return rs;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getColumnPrivileges] Not Implemented yet.");
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getTablePrivileges] Not Implemented yet.");
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getBestRowIdentifier] Not Implemented yet.");
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getVersionColumns] Not Implemented yet.");
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        this.writerLog("getPrimaryKeys");
        return new XCloudDummyResultSet(SQLType.SQL_NULL);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        this.writerLog("getImportedKeys");
        return new XCloudDummyResultSet(SQLType.SQL_NULL);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getExportedKeys] Not Implemented yet.");
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getCrossReference] Not Implemented yet.");
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        Statement stmt = this.m_belongingCon.createStatement();
        String sql = "select 'INT',-1,10,null,null,null,1,0,0,0,0,0,'INT',0,0,null,null,10 from dual \nunion all \nselect 'LONG',-4,19,null,null,null,1,0,0,0,0,0,'LONG',0,0,null,null,10 from dual \nunion all \nselect 'DOUBLE',7,17,null,null,null,1,0,3,0,1,0,'DOUBLE',-84,127,null,null,10 from dual \nunion all \nselect 'NUMBER',-6,38,null,null,(3),1,0,3,0,1,0,'NUMBER',-84,127,null,null,10 from dual \nunion all \nselect 'DECIMAL',-5,38,null,null,(3),1,0,3,0,1,0,'NUMBER',-84,127,null,null,10 from dual \nunion all \nselect 'CHAR',1,6000,null,null,null,1,1,3,0,0,0,'CHAR',0,0,null,null,10 from dual \nunion all \nselect 'VARCHAR',11,6000,null,null,null,1,1,3,0,0,0,'VARCHAR',0,0,null,null,10 from dual \nunion all \nselect 'VARCHAR2',12,6000,null,null,null,1,1,3,0,0,0,'VARCHAR',0,0,null,null,10 from dual \nunion all \nselect 'TIMESTAMP',0,9,null,null,null,1,0,3,0,0,0,'TIMESTAMP',0,0,null,null,10 from dual \nunion all \nselect 'DATE',91,7,null,null,null,1,0,3,0,0,0,'DATE',0,0,null,null,10 from dual \nunion all \nselect 'INTERVAL',92,7,null,null,null,1,0,3,0,0,0,'DATE',0,0,null,null,10 from dual \nunion all \nselect 'BLOB',2004,-1,null,null,null,1,0,0,0,0,0,'BLOB',0,0,null,null,10 from dual \nunion all \nselect 'CLOB',2005,-1,null,null,null,1,1,0,0,0,0,'CLOB',0,0,null,null,10 from dual \n";
        ResultSet ret = stmt.executeQuery(sql);
        return ret;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        this.writerLog("getIndexInfo");
        return new XCloudDummyResultSet(SQLType.SQL_NULL);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsResultSetType] Not Implemented yet.");
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsResultSetConcurrency] Not Implemented yet.");
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData ownUpdatesAreVisible] Not Implemented yet.");
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData ownDeletesAreVisible] Not Implemented yet.");
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData ownInsertsAreVisible] Not Implemented yet.");
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData othersUpdatesAreVisible] Not Implemented yet.");
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData othersDeletesAreVisible] Not Implemented yet.");
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData othersInsertsAreVisible] Not Implemented yet.");
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData updatesAreDetected] Not Implemented yet.");
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData deletesAreDetected] Not Implemented yet.");
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData insertsAreDetected] Not Implemented yet.");
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        this.writerLog("supportsBatchUpdates");
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getUDTs] Not Implemented yet.");
    }

    @Override
    public Connection getConnection() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getConnection] Not Implemented yet.");
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsSavepoints] Not Implemented yet.");
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsNamedParameters] Not Implemented yet.");
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsMultipleOpenResults] Not Implemented yet.");
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsGetGeneratedKeys] Not Implemented yet.");
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getSuperTypes] Not Implemented yet.");
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getSuperTables] Not Implemented yet.");
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getAttributes] Not Implemented yet.");
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsResultSetHoldability] Not Implemented yet.");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getResultSetHoldability] Not Implemented yet.");
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getDatabaseMajorVersion] Not Implemented yet.");
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getDatabaseMinorVersion] Not Implemented yet.");
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        this.writerLog("getJDBCMajorVersion");
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        this.writerLog("getJDBCMinorVersion");
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getDatabaseMinorVersion] Not Implemented yet.");
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData locatorsUpdateCopy] Not Implemented yet.");
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsStatementPooling] Not Implemented yet.");
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getRowIdLifetime] Not Implemented yet.");
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        this.writerLog("getSchemas(String catalog, String schemaPattern)");
        String sql = "select schema_name as TABLE_SCHEM, table_catalog as TABLE_CATALOG from v$user_schemas ";
        if (null != schemaPattern) {
            sql = sql + "where schema_name like'" + schemaPattern.toUpperCase() + "'";
        }
        Statement stmt = this.m_belongingCon.createStatement();
        XCloudResultSet rs = (XCloudResultSet)stmt.executeQuery(sql);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("schema_name".toUpperCase(), "TABLE_SCHEM");
        map.put("table_catalog".toUpperCase(), "TABLE_CATALOG");
        rs.setFieldNameMapping(map);
        return rs;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData supportsStoredFunctionsUsingCallSyntax] Not Implemented yet.");
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData autoCommitFailureClosesAllResultSets] Not Implemented yet.");
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getClientInfoProperties] Not Implemented yet.");
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getFunctions] Not Implemented yet.");
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw new RuntimeException("[XCloudDatabaseMetaData getFunctionColumns] Not Implemented yet.");
    }
}

