/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.jdbc;

import com.bonc.xcloud.common.ConnInfo;
import com.bonc.xcloud.common.ConnInfoPack;
import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.common.MemoryInfoMgr;
import com.bonc.xcloud.common.VersionInfo;
import com.bonc.xcloud.component.ServiceManager;
import com.bonc.xcloud.error.handle.ErrorHandler;
import com.bonc.xcloud.jdbc.XCloudCallableStatement;
import com.bonc.xcloud.jdbc.XCloudDatabaseMetaData;
import com.bonc.xcloud.jdbc.XCloudInsertPreparedStatement;
import com.bonc.xcloud.jdbc.XCloudPreparedStatement;
import com.bonc.xcloud.jdbc.XCloudStatement;
import com.bonc.xcloud.log.XCloudJDBCLogger;
import com.bonc.xcloud.metadata.domain.DataBaseMetaData;
import com.bonc.xcloud.sql.parser.CommandContext;
import com.bonc.xcloud.sql.parser.InsertStmtType;
import com.bonc.xcloud.sql.parser.ParserSQL;
import com.bonc.xcloud.sql.parser.SqlBuilder;
import com.bonc.xcloud.xserver.TDBMetaResult;
import com.bonc.xcloud.xserver.TJDBCVersion;
import com.bonc.xcloud.xserver.TLoginInfo;
import com.bonc.xcloud.xserver.TLoginResult;
import com.bonc.xcloud.xserver.TNetworkAddress;
import com.bonc.xcloud.xserver.TStatus;
import com.bonc.xcloud.xserver.TStatusCode;
import com.bonc.xcloud.xserver.TUniqueId;
import com.bonc.xcloud.xserver.TUserInfo;
import com.bonc.xcloud.xserver.TXcloudVersion;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCloudConnection
implements Connection {
    private static Logger logger = LoggerFactory.getLogger(XCloudConnection.class);
    private ServiceManager m_serviceManager = null;
    private DataBaseMetaData m_dbmd = null;
    private ErrorHandler m_errorHandler = null;
    boolean isClosed = false;
    boolean isConnected = false;
    private TJDBCVersion m_tjdbcv;
    private MemoryInfoMgr memInfo = null;
    private ConnInfoPack m_infoPack = null;
    private static XCloudJDBCLogger m_jdbcLogger = null;
    ArrayList<ArrayList<TUniqueId>> m_hdList = null;
    private static String ServerCharset = null;

    public String getServerCharset() {
        return ServerCharset;
    }

    public XCloudConnection() {
    }

    public XCloudConnection(ConnInfoPack infoPack, XCloudJDBCLogger jdbcLogger) throws SQLException {
        this.m_infoPack = infoPack;
        this.memInfo = new MemoryInfoMgr(infoPack.getBuffMemory());
        this.m_errorHandler = new ErrorHandler();
        m_jdbcLogger = jdbcLogger;
        this.m_serviceManager = new ServiceManager(this.m_infoPack, jdbcLogger);
        this.m_tjdbcv = new TJDBCVersion(VersionInfo.getFirstversion(), VersionInfo.getSecondversion(), VersionInfo.getThirdversion());
        this.m_hdList = new ArrayList();
    }

    public void connectInit() throws SQLException {
        this.memInfo.setThrowInsufficientMemoryExceptionSwitch(this.m_infoPack.getThrowInsufficientMemoryExceptionSwitch());
        this.checkIsSP();
        int connListSize = this.m_infoPack.getInfoListSize();
        int retryCnt = this.m_infoPack.getConnectRetry();
        String mac_addr = this.m_infoPack.getMac();
        for (int connList_idx = 0; connList_idx < connListSize; ++connList_idx) {
            ConnInfo info = this.m_infoPack.getConnInfo(connList_idx);
            if (logger.isInfoEnabled()) {
                StringBuffer entryMsg = new StringBuffer();
                entryMsg.append("The entrance node of balance connect is: ");
                entryMsg.append(info);
            }
            if (this.isConnected) continue;
            for (int retryCnt_idx = 0; retryCnt_idx < retryCnt; ++retryCnt_idx) {
                try {
                    if (!this.m_serviceManager.ConnectServer(info)) continue;
                    TUserInfo user = new TUserInfo(this.m_infoPack.getDBUserName(), this.m_infoPack.getDBPassWd(), info.getDBName());
                    if (this.m_infoPack.getMetaStoreIP() != null && this.m_infoPack.getMetaStorePort() != 0) {
                        TNetworkAddress Tna = new TNetworkAddress(this.m_infoPack.getMetaStoreIP(), this.m_infoPack.getMetaStorePort());
                        user.setMetastore_address(Tna);
                    }
                    TLoginResult tlr = null;
                    if (!this.m_infoPack.getConnectDirect()) {
                        while (true) {
                            if (TStatusCode.OK != (tlr = this.login_new(user, mac_addr, true)).getStatus().getStatus_code()) {
                                this.m_errorHandler.Handle(tlr.getStatus(), this.m_infoPack);
                            }
                            this.checkVersion(tlr);
                            int try_times = 0;
                            if (!this.ConnectLoadBalancingServer(tlr, info, try_times)) continue;
                            tlr = this.login_new(user, mac_addr, false);
                            if (TStatusCode.OK == tlr.getStatus().getStatus_code()) break;
                            if (logger.isInfoEnabled()) {
                                StringBuffer entryMsg = new StringBuffer();
                                entryMsg.append("The attempt node(failed) of balance connect is: ");
                                entryMsg.append(this.m_infoPack.getCurrentRemoteIP());
                                entryMsg.append(":");
                                entryMsg.append(this.m_infoPack.getCurrentRemotePort());
                                entryMsg.append("\n");
                                logger.info(entryMsg.toString());
                            }
                            if (TStatusCode.SESSION_SERVER_THREAD_POOL_EXHAUSTED == tlr.getStatus().getStatus_code()) {
                                Thread.sleep(2000L);
                                continue;
                            }
                            this.m_errorHandler.Handle(tlr.getStatus(), this.m_infoPack);
                        }
                        this.m_infoPack.setCurrentRemoteIP(this.m_infoPack.getCurrentRemoteIP());
                        this.m_infoPack.setCurrentRemotePort(this.m_infoPack.getCurrentRemotePort());
                    } else {
                        this.m_infoPack.setCurrentRemoteIP(info.getRemoteIp());
                        this.m_infoPack.setCurrentRemotePort(info.getRemotePort());
                        tlr = this.login_new(user, mac_addr, false);
                        if (TStatusCode.OK != tlr.getStatus().getStatus_code()) {
                            this.m_errorHandler.Handle(tlr.getStatus(), this.m_infoPack);
                        }
                        this.checkVersion(tlr);
                    }
                    this.m_infoPack.setCurrentRemoteIP(this.m_infoPack.getCurrentRemoteIP());
                    this.m_infoPack.setCurrentRemotePort(this.m_infoPack.getCurrentRemotePort());
                    break;
                }
                catch (Exception te) {
                    StringBuffer errorMsg;
                    this.m_serviceManager.Disconnect();
                    if (te.getMessage().contains("session server thread pool exhausted") || te.getMessage().contains("SESSION_SERVER_THREAD_POOL_EXHAUSTED")) {
                        if (connList_idx != connListSize - 1) break;
                        errorMsg = new StringBuffer();
                        errorMsg.append("The session server thread pool is exhausted:\n" + te.getMessage());
                        ExceptionMgr.throwSQLExp(errorMsg.toString());
                    }
                    if (te.getMessage().contains("ERROR-393225") && !te.getMessage().contains("No authorization to access this PU.")) {
                        errorMsg = new StringBuffer();
                        errorMsg.append("The user or password is invalid:\n" + te.getMessage());
                        ExceptionMgr.throwSQLExp(errorMsg.toString());
                    }
                    if (retryCnt_idx != retryCnt - 1) {
                        StringBuffer retryLog = new StringBuffer();
                        retryLog.append(info.getRemoteIp()).append(":").append(info.getRemotePort()).append(" Connection failed,  try again...(").append(retryCnt_idx + 1).append(")");
                        if (!logger.isErrorEnabled()) continue;
                        logger.error(retryLog.toString());
                        XCloudJDBCLogger.Write_Log(retryLog.toString());
                        continue;
                    }
                    if (connList_idx != connListSize - 1) continue;
                    if (te instanceof TException) {
                        ExceptionMgr.throwError((TException)((Object)te), this.m_infoPack, null);
                    }
                    errorMsg = new StringBuffer();
                    errorMsg.append("The last time to try connect to server failed:\n" + te.getMessage());
                    ExceptionMgr.throwSQLExp(errorMsg.toString());
                }
            }
            try {
                TDBMetaResult tdbmr = this.m_serviceManager.getDBMeta();
                ServerCharset = tdbmr.getLanguage_encode();
                XCloudJDBCLogger.Write_Log("Connection get CharSet : " + ServerCharset);
                if (TStatusCode.OK != tdbmr.getStatus().getStatus_code()) {
                    this.m_errorHandler.Handle(tdbmr.getStatus(), this.m_infoPack);
                }
                this.m_dbmd = new DataBaseMetaData(tdbmr);
                this.isConnected = true;
                continue;
            }
            catch (Exception e) {
                if (connList_idx != connListSize - 1) continue;
                ExceptionMgr.throwSQLExp(e.toString());
            }
        }
    }

    private TLoginResult login_new(TUserInfo user, String mac_addr, boolean flag) throws SQLException {
        TLoginInfo tli = new TLoginInfo(this.m_tjdbcv, user, flag);
        tli.setMac_addr(mac_addr);
        TLoginResult tlr = this.m_serviceManager.login_new(tli);
        return tlr;
    }

    protected DataBaseMetaData getDBMD() {
        return this.m_dbmd;
    }

    protected ServiceManager getServiceManager() {
        return this.m_serviceManager;
    }

    protected MemoryInfoMgr getMemoryInfoMgr() {
        return this.memInfo;
    }

    protected ConnInfoPack getConnInfoPack() {
        return this.m_infoPack;
    }

    protected void checkConnStatus() throws SQLException {
        if (this.isClosed) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Connection has closed");
            logger.error(retMsg);
            ExceptionMgr.throwSQLRecoverableExp(retMsg);
        }
    }

    protected void writerLog(String methodName) throws SQLException {
        XCloudJDBCLogger.Write_Log(ExceptionMgr.getConvertedJDBCCallerMsg(methodName));
        if (logger.isDebugEnabled()) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg(methodName);
            logger.debug(retMsg);
        }
    }

    protected ArrayList<TUniqueId> getQueryHandleList() throws SQLException {
        ArrayList<TUniqueId> hdList = new ArrayList<TUniqueId>();
        if (this.m_hdList != null) {
            this.m_hdList.add(hdList);
        } else {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("QueryHandleList has empty!");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        return hdList;
    }

    private void checkIsSP() {
        String url = this.m_infoPack.getURL();
        String[] firstTemp = url.split(":");
        this.m_infoPack.setIsSP(firstTemp[1].equalsIgnoreCase("sp"));
    }

    private void checkVersion(TLoginResult tLResult) throws SQLException {
        TXcloudVersion txv;
        if (this.m_infoPack.getIsSP()) {
            return;
        }
        if (!tLResult.isSetXcloud_version()) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("current JDBC version only support CirroData 2.6 or more");
            logger.error(retMsg);
            ExceptionMgr.throwSQLRecoverableExp(retMsg);
        }
        if ((txv = tLResult.getXcloud_version()).getFirst() >= 2 && txv.getSecond() >= 6) {
            this.m_infoPack.setXCloudVersion(txv);
        } else {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("current JDBC version only support CirroData 2.6 or more");
            logger.error(retMsg);
            ExceptionMgr.throwSQLRecoverableExp(retMsg);
        }
    }

    private boolean ConnectLoadBalancingServer(TLoginResult t_lr, ConnInfo usedInfo, int try_times) throws SQLException {
        this.writerLog("ConnectLoadBalancingServer");
        this.checkConnStatus();
        TNetworkAddress tna = t_lr.getServer_address();
        String username = this.m_infoPack.getDBUserName();
        String passwd = this.m_infoPack.getDBPassWd();
        int socketTime = this.m_infoPack.getSocketTimeOut();
        String mac_addr = this.m_infoPack.getMac();
        boolean ret = false;
        if (try_times > 20) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Retry ConnectLoadBalancingServer 20 times, please check IP give back is ok");
            ExceptionMgr.throwSQLExp(retMsg);
        }
        TUserInfo tui = new TUserInfo(username, passwd, usedInfo.getDBName());
        TLoginResult tlr = null;
        TStatus ts = this.m_serviceManager.logout();
        if (TStatusCode.OK != ts.getStatus_code()) {
            this.m_errorHandler.Handle(ts, this.m_infoPack);
        }
        try {
            this.m_serviceManager.Disconnect();
        }
        catch (Exception e) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg(ExceptionMgr.getStackTrace(e));
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        ConnInfo newInfo = new ConnInfo();
        newInfo.setDBName(usedInfo.getDBName());
        newInfo.setRemoteIP(tna.getHostname());
        newInfo.setRemotePort(String.valueOf(tna.getPort()));
        try {
            this.m_serviceManager.ConnectServer(newInfo);
        }
        catch (Exception e) {
            if (newInfo.getRemoteIp().toUpperCase().equals(usedInfo.getRemoteIp().toUpperCase())) {
                String errorInfo = "[ConnectLoadBalancingServer] " + usedInfo.getRemoteIp() + " can not connect and if it's the last time try to connect, maybe connect retry will stop";
                XCloudJDBCLogger.Write_Log(errorInfo);
                logger.error(errorInfo);
                return ret;
            }
            String errorInfo = "[ConnectLoadBalancingServer] " + newInfo.getRemoteIp() + "[" + newInfo.getRemotePort() + "]" + " can not connect and if it's the last time try to connect, maybe connect retry will stop";
            XCloudJDBCLogger.Write_Log(errorInfo);
            logger.error(errorInfo);
            try {
                this.m_serviceManager.ConnectServer(usedInfo);
                TLoginInfo tli = new TLoginInfo(this.m_tjdbcv, tui, true);
                tli.setMac_addr(mac_addr);
                tlr = this.m_serviceManager.login_new(tli);
                if (TStatusCode.OK != tlr.getStatus().getStatus_code()) {
                    this.m_errorHandler.Handle(tlr.getStatus(), this.m_infoPack);
                }
                return this.ConnectLoadBalancingServer(tlr, usedInfo, ++try_times);
            }
            catch (Exception e1) {
                String errorInfo2 = "[ConnectLoadBalancingServer] IP:" + usedInfo.getRemoteIp() + " used to be connected cannot connect to," + "and if it's the last time try to connect, maybe connect retry will stop";
                XCloudJDBCLogger.Write_Log(errorInfo2);
                logger.error(errorInfo2);
                return ret;
            }
        }
        usedInfo.setIsUsed(true);
        this.m_infoPack.setCurrentRemoteIP(newInfo.getRemoteIp());
        this.m_infoPack.setCurrentRemotePort(newInfo.getRemotePort());
        ret = true;
        return ret;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new RuntimeException("[XCloudConnection unwrap] Not Implemented yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new RuntimeException("[XCloudConnection isWrapperFor] Not Implemented yet.");
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.writerLog("createStatement");
        this.checkConnStatus();
        return new XCloudStatement(this, m_jdbcLogger);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.writerLog("prepareStatement");
        this.checkConnStatus();
        ParserSQL batch_par = new ParserSQL();
        CommandContext context = new CommandContext();
        batch_par.doParser(sql, context, true);
        if (batch_par.isInsert()) {
            if (batch_par.getInsertStmtType() != InsertStmtType.INSERT_VALUES_BATCH) {
                String throw_message = ExceptionMgr.getConvertedErrorMsg("preparedstatement SQL only support batch insert");
                ExceptionMgr.throwSQLExp(throw_message);
            }
            SqlBuilder sb = new SqlBuilder();
            String build_sql = sb.toSQL(context);
            return new XCloudInsertPreparedStatement(this, m_jdbcLogger, context, build_sql);
        }
        return new XCloudPreparedStatement(this, sql, m_jdbcLogger);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkConnStatus();
        ParserSQL batch_par = new ParserSQL();
        CommandContext context = new CommandContext();
        batch_par.doParser(sql, context, true);
        if (batch_par.getInsertStmtType() == InsertStmtType.INSERT_CLIENT_NEW || batch_par.getInsertStmtType() == InsertStmtType.INSERT_CLIENT_OLD || batch_par.getInsertStmtType() == InsertStmtType.INSERT_VALUES_BATCH) {
            String throw_message = ExceptionMgr.getConvertedErrorMsg("prepareCall SQL not support batch insert");
            ExceptionMgr.throwSQLExp(throw_message);
        }
        if (sql.startsWith("{") && sql.endsWith("}")) {
            sql = sql.substring(1, sql.length() - 1);
        }
        return new XCloudCallableStatement(this, sql, m_jdbcLogger);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new RuntimeException("[XCloudConnection nativeSQL] Not Implemented yet.");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.writerLog("setAutoCommit");
        this.checkConnStatus();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.writerLog("getAutoCommit");
        return true;
    }

    @Override
    public void commit() throws SQLException {
        this.writerLog("commit");
        this.checkConnStatus();
    }

    @Override
    public void rollback() throws SQLException {
        this.writerLog("rollback");
        this.checkConnStatus();
    }

    @Override
    public void close() throws SQLException {
        String retMsg;
        this.writerLog("close");
        if (this.m_serviceManager == null) {
            return;
        }
        if (!this.m_serviceManager.isOpen()) {
            this.objRelease();
            return;
        }
        this.m_hdList.clear();
        TStatus ts = null;
        try {
            ts = this.m_serviceManager.logout();
            if (TStatusCode.OK != ts.getStatus_code()) {
                String throwMsg = ExceptionMgr.getErrorContent(Thread.currentThread().getId(), this.m_infoPack.getCurrentConnID(), this.m_infoPack.getCurrentRemoteIP(), "", ts.status_code.toString(), ts.error_msgs.toString(), "", "", this.m_infoPack.getSessionID());
                logger.error(throwMsg);
            }
        }
        catch (Exception e) {
            retMsg = ExceptionMgr.getConvertedErrorMsg(e.getMessage());
            logger.error(retMsg);
        }
        try {
            this.m_serviceManager.Disconnect();
        }
        catch (Exception e) {
            retMsg = ExceptionMgr.getConvertedErrorMsg(ExceptionMgr.getStackTrace(e));
            logger.error(retMsg);
        }
        this.objRelease();
    }

    private void objRelease() {
        if (this.m_hdList != null && this.m_hdList.size() != 0) {
            this.m_hdList.clear();
        }
        this.m_hdList = null;
        this.isClosed = true;
        this.m_dbmd = null;
        this.m_errorHandler = null;
        this.m_serviceManager = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.writerLog("isClosed");
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.writerLog("getMetaData");
        this.checkConnStatus();
        XCloudDatabaseMetaData xcdbmd = new XCloudDatabaseMetaData(this, VersionInfo.getFirstversion(), VersionInfo.getSecondversion(), VersionInfo.getThirdversion());
        xcdbmd.setUserName(this.m_infoPack.getDBUserName());
        return xcdbmd;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.writerLog("setReadOnly");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.writerLog("isReadOnly");
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new RuntimeException("[XCloudConnection setCatalog] Not Implemented yet.");
    }

    @Override
    public String getCatalog() throws SQLException {
        this.writerLog("getCatalog");
        return "Empty";
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        throw new RuntimeException("[XCloudConnection setTransactionIsolation] Not Implemented yet.");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.writerLog("getTransactionIsolation");
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.writerLog("getWarnings");
        return this.m_errorHandler.getSQLWarning();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.writerLog("clearWarnings");
        this.m_errorHandler.clearSQLWarning();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.writerLog("createStatement");
        this.checkConnStatus();
        if (1003 != resultSetType) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("ResultSet Type Not Support yet, Type = [TYPE_FORWARD_ONLY]");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.writerLog("prepareStatement");
        this.checkConnStatus();
        return new XCloudPreparedStatement(this, sql, m_jdbcLogger);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new RuntimeException("[XCloudConnection prepareCall] Not Implemented yet.");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new RuntimeException("[XCloudConnection getTypeMap] Not Implemented yet.");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new RuntimeException("[XCloudConnection setTypeMap] Not Implemented yet.");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new RuntimeException("[XCloudConnection setHoldability] Not Implemented yet.");
    }

    @Override
    public int getHoldability() throws SQLException {
        this.writerLog("getHoldability");
        return 0;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new RuntimeException("[XCloudConnection setSavepoint] Not Implemented yet.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new RuntimeException("[XCloudConnection setSavepoint] Not Implemented yet.");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new RuntimeException("[XCloudConnection rollback] Not Implemented yet.");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new RuntimeException("[XCloudConnection releaseSavepoint] Not Implemented yet.");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new RuntimeException("[XCloudConnection createStatement] Not Implemented yet.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new RuntimeException("[XCloudConnection prepareStatement] Not Implemented yet.");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new RuntimeException("[XCloudConnection prepareCall] Not Implemented yet.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new RuntimeException("[XCloudConnection prepareStatement] Not Implemented yet.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new RuntimeException("[XCloudConnection prepareStatement] Not Implemented yet.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new RuntimeException("[XCloudConnection prepareStatement] Not Implemented yet.");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new RuntimeException("[XCloudConnection createClob] Not Implemented yet.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new RuntimeException("[XCloudConnection createBlob] Not Implemented yet.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new RuntimeException("[XCloudConnection createNClob] Not Implemented yet.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new RuntimeException("[XCloudConnection createSQLXML] Not Implemented yet.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.writerLog("isValid");
        boolean ret = false;
        try {
            String ver = this.m_serviceManager.getBEVersion();
            ret = true;
        }
        catch (SQLException e) {
            return ret;
        }
        return ret;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (logger.isDebugEnabled()) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("setClientInfo");
            logger.debug(retMsg);
        }
        HashMap<String, ClientInfoStatus> retException = new HashMap<String, ClientInfoStatus>();
        retException.put(name, ClientInfoStatus.REASON_UNKNOWN);
        throw new SQLClientInfoException(retException, new Throwable("Not Implemented yet."));
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (logger.isDebugEnabled()) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("setClientInfo");
            logger.debug(retMsg);
        }
        HashMap<String, ClientInfoStatus> retException = new HashMap<String, ClientInfoStatus>();
        Enumeration<?> propEnum = properties.propertyNames();
        while (propEnum.hasMoreElements()) {
            String key = (String)propEnum.nextElement();
            retException.put(key, ClientInfoStatus.REASON_UNKNOWN);
        }
        throw new SQLClientInfoException(retException, new Throwable("Not Implemented yet."));
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.writerLog("getClientInfo");
        this.checkConnStatus();
        return "Empty";
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new RuntimeException("[XCloudConnection getClientInfo] Not Implemented yet.");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new RuntimeException("[XCloudConnection createArrayOf] Not Implemented yet.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new RuntimeException("[XCloudConnection createStruct] Not Implemented yet.");
    }
}

