/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.jdbc;

import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.jdbc.XCloudCallParameterMetaData;
import com.bonc.xcloud.jdbc.XCloudConnection;
import com.bonc.xcloud.jdbc.XCloudDummyCSResultSet;
import com.bonc.xcloud.jdbc.XCloudPreparedStatement;
import com.bonc.xcloud.jdbc.XCloudResultSet;
import com.bonc.xcloud.log.XCloudJDBCLogger;
import com.bonc.xcloud.type.INTERVALDS;
import com.bonc.xcloud.type.INTERVALYM;
import com.bonc.xcloud.xserver.TQuery;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCloudCallableStatement
extends XCloudPreparedStatement
implements CallableStatement {
    private static Logger logger = LoggerFactory.getLogger(XCloudCallableStatement.class);
    HashMap<String, String> m_configure_map = null;
    LinkedList<Integer> m_user_param_desc_index = null;
    LinkedList<String> m_user_param_desc_name = null;
    String m_sql = "";
    int param_index_count = 0;
    int param_name_count = 0;
    int out_index = 1;
    HashSet<Integer> m_in_set_index = null;
    HashSet<String> m_in_set_name_index = null;
    HashMap<Integer, Integer> m_out_map_index = null;
    HashMap<String, Integer> m_out_map_name_index = null;
    boolean atLeastOneNamedParameter = false;
    boolean atLeastOneOrdinalParameter = false;

    public XCloudCallableStatement(XCloudConnection xc, String sql, XCloudJDBCLogger jdbcLogger) throws SQLException {
        super(xc, jdbcLogger);
        this.m_sql = sql;
        this.m_configure_map = new HashMap();
        this.m_in_set_index = new HashSet();
        this.m_in_set_name_index = new HashSet();
        this.m_out_map_index = new HashMap();
        this.m_out_map_name_index = new HashMap();
        this.m_user_param_desc_index = new LinkedList();
        this.m_user_param_desc_name = new LinkedList();
    }

    private void putIndexInfo() {
        Integer param_index_c = this.param_index_count;
        String user_param_desc = "";
        for (Integer s : this.m_user_param_desc_index) {
            user_param_desc = user_param_desc + s;
            user_param_desc = user_param_desc + ":";
        }
        for (Integer s : this.m_in_set_index) {
            if (this.m_user_param_desc_index.contains(s)) continue;
            user_param_desc = user_param_desc + s;
            user_param_desc = user_param_desc + ":";
        }
        if (user_param_desc.length() > 0) {
            user_param_desc = user_param_desc.substring(0, user_param_desc.length() - 1);
            this.m_configure_map.put("user_param_desc", user_param_desc);
        }
        this.m_configure_map.put("index_param_count", param_index_c.toString());
    }

    private void putNameInfo() {
        Integer param_name_c = this.param_name_count;
        String user_param_name_desc = "";
        for (String s : this.m_user_param_desc_name) {
            user_param_name_desc = user_param_name_desc + s;
            user_param_name_desc = user_param_name_desc + ":";
        }
        for (String s : this.m_in_set_name_index) {
            if (this.m_user_param_desc_name.contains(s)) continue;
            user_param_name_desc = user_param_name_desc + s;
            user_param_name_desc = user_param_name_desc + ":";
        }
        if (user_param_name_desc.length() > 0) {
            user_param_name_desc = user_param_name_desc.substring(0, user_param_name_desc.length() - 1);
            this.m_configure_map.put("user_param_name_desc", user_param_name_desc);
        }
        this.m_configure_map.put("name_param_count", param_name_c.toString());
    }

    private TQuery getTQuery() {
        TQuery query = new TQuery();
        this.putNameInfo();
        this.putIndexInfo();
        query.configuration = this.m_configure_map;
        query.stmt = this.m_sql;
        return query;
    }

    public void printConfigureMap() {
        this.getTQuery();
        Iterator<String> it = this.m_configure_map.keySet().iterator();
        System.out.println("========================================================");
        while (it.hasNext()) {
            String key = it.next();
            System.out.print(key + "=");
            System.out.println(this.m_configure_map.get(key));
        }
        System.out.println("========================================================");
        for (Integer key : this.m_out_map_index.keySet()) {
            System.out.print(key + "=");
            System.out.println(this.m_out_map_index.get(key));
        }
        for (String key : this.m_out_map_name_index.keySet()) {
            System.out.print(key + "=");
            System.out.println(this.m_out_map_name_index.get(key));
        }
        System.out.println("========================================================");
    }

    public void logConfigureMap() {
        this.getTQuery();
        StringBuffer bb = new StringBuffer();
        bb.append("\n");
        bb.append("========================================================\n");
        for (String key : this.m_configure_map.keySet()) {
            bb.append(key + "=");
            bb.append(this.m_configure_map.get(key) + "\n");
        }
        bb.append("========================================================\n");
        for (Integer key : this.m_out_map_index.keySet()) {
            bb.append(key + "=");
            bb.append(this.m_out_map_index.get(key) + "\n");
        }
        for (String key : this.m_out_map_name_index.keySet()) {
            bb.append(key + "=");
            bb.append(this.m_out_map_name_index.get(key) + "\n");
        }
        bb.append("========================================================\n");
        if (logger.isInfoEnabled()) {
            logger.info(bb.toString());
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.writerLog("CallableStatement::executeQuery");
        if (this.atLeastOneNamedParameter && this.atLeastOneOrdinalParameter) {
            String retMsg = "Ordinal binding and Named binding cannot be combined!";
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        this.logConfigureMap();
        int ret = this.executeTQuery(this.getTQuery(), false);
        XCloudDummyCSResultSet result = null;
        if (ret == 0) {
            ((XCloudResultSet)this.getResultSet()).setProcedure();
            ((XCloudResultSet)this.getResultSet()).next();
            result = new XCloudDummyCSResultSet();
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.writerLog("CallableStatement::executeUpdate");
        if (this.atLeastOneNamedParameter && this.atLeastOneOrdinalParameter) {
            String retMsg = "Ordinal binding and Named binding cannot be combined!";
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        this.logConfigureMap();
        int ret = this.executeTQuery(this.getTQuery(), false);
        if (0 == ret) {
            ((XCloudResultSet)this.getResultSet()).setProcedure();
            ((XCloudResultSet)this.getResultSet()).next();
            return ret;
        }
        if (1 == ret) {
            if (this.m_executeResult > Integer.MAX_VALUE) {
                return -1;
            }
            return (int)this.m_executeResult;
        }
        return 0;
    }

    private int checkGetIndex(String parameterName) {
        int ret = -1;
        if (null == this.m_out_map_name_index.get(parameterName)) {
            return ret;
        }
        ret = this.m_out_map_name_index.get(parameterName);
        return ret;
    }

    private int checkGetIndex(int parameterIndex) throws SQLException {
        if (parameterIndex <= 0 || null == this.m_out_map_index.get(parameterIndex)) {
            String retMsg = "invalid column index";
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        int index = this.m_out_map_index.get(parameterIndex);
        return index;
    }

    private boolean set(int parameterIndex) {
        if (null == this.m_out_map_index.get(parameterIndex)) {
            if (!this.m_in_set_index.contains(parameterIndex)) {
                this.m_in_set_index.add(parameterIndex);
                ++this.param_index_count;
            }
            return false;
        }
        if (!this.m_in_set_index.contains(parameterIndex)) {
            this.m_in_set_index.add(parameterIndex);
        }
        return true;
    }

    private boolean set(String parameterName) {
        if (null == this.m_out_map_name_index.get(parameterName)) {
            if (!this.m_in_set_name_index.contains(parameterName)) {
                this.m_in_set_name_index.add(parameterName);
                ++this.param_name_count;
            }
            return false;
        }
        if (!this.m_in_set_name_index.contains(parameterName)) {
            this.m_in_set_name_index.add(parameterName);
        }
        return true;
    }

    private void setValue(int parameterIndex, String value, String javaType) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        if (parameterIndex <= 0) {
            String retMsg = "invalid column index";
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        boolean isRegisterOut = this.set(parameterIndex);
        String p_index = "p" + parameterIndex;
        this.composeIninfo(p_index, value, javaType, false, isRegisterOut);
    }

    private void setValue(String parameterName, String value, String javaType) throws SQLException {
        this.atLeastOneNamedParameter = true;
        boolean isRegisterOut = this.set(parameterName);
        this.composeIninfo(parameterName, value, javaType, true, isRegisterOut);
    }

    private void composeIninfo(String name, String value, String javaType, boolean isCallNameFunction, boolean isRegisterOut) {
        String value_key = name + ".value";
        String intype_key = name + ".intype";
        String outtype_key = name + ".outtype";
        String out_key = name + ".out";
        String null_key = name + ".null";
        String isname_key = name + ".name";
        if (isCallNameFunction) {
            this.m_configure_map.put(isname_key, "true");
        } else {
            this.m_configure_map.put(isname_key, "false");
        }
        if (null == value) {
            this.m_configure_map.put(null_key, "true");
            this.m_configure_map.put(value_key, "");
        } else {
            this.m_configure_map.put(null_key, "false");
            this.m_configure_map.put(value_key, value);
        }
        this.m_configure_map.put(intype_key, javaType);
        if (!isRegisterOut) {
            this.m_configure_map.put(outtype_key, "");
            this.m_configure_map.put(out_key, "false");
        }
    }

    private void composeOutInfo(String name, String javaType, boolean isCallNameFunction, boolean isSetIn) {
        String value_key = name + ".value";
        String intype_key = name + ".intype";
        String outtype_key = name + ".outtype";
        String out_key = name + ".out";
        String null_key = name + ".null";
        String isname_key = name + ".name";
        if (isCallNameFunction) {
            this.m_configure_map.put(isname_key, "true");
        } else {
            this.m_configure_map.put(isname_key, "false");
        }
        this.m_configure_map.put(outtype_key, javaType);
        this.m_configure_map.put(out_key, "true");
        if (!isSetIn) {
            this.m_configure_map.put(value_key, "");
            this.m_configure_map.put(intype_key, "");
            this.m_configure_map.put(null_key, "false");
        }
    }

    private void registerOut(String parameterName, String javaType) throws SQLException {
        this.atLeastOneNamedParameter = true;
        boolean isSetIn = this.register(parameterName);
        this.composeOutInfo(parameterName, javaType, true, isSetIn);
    }

    private boolean register(String parameterName) {
        boolean ret = false;
        if (null == this.m_out_map_name_index.get(parameterName)) {
            this.m_out_map_name_index.put(parameterName, this.out_index);
            ++this.out_index;
            if (!this.m_in_set_name_index.contains(parameterName)) {
                ++this.param_name_count;
                ret = false;
            } else {
                ret = true;
            }
        } else {
            ret = false != this.m_in_set_name_index.contains(parameterName);
        }
        if (!this.m_user_param_desc_name.contains(parameterName)) {
            this.m_user_param_desc_name.addLast(parameterName);
        }
        return ret;
    }

    private void registerOut(int parameterIndex, String javaType) throws SQLException {
        if (parameterIndex <= 0) {
            String retMsg = "invalid column index";
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        boolean isSetIn = this.register(parameterIndex);
        String p_index = "p" + parameterIndex;
        this.composeOutInfo(p_index, javaType, false, isSetIn);
    }

    private boolean register(int parameterIndex) {
        boolean ret = false;
        if (null == this.m_out_map_index.get(parameterIndex)) {
            this.m_out_map_index.put(parameterIndex, this.out_index);
            ++this.out_index;
            if (!this.m_in_set_index.contains(parameterIndex)) {
                ++this.param_index_count;
                ret = false;
            } else {
                ret = true;
            }
        } else {
            ret = false != this.m_in_set_index.contains(parameterIndex);
        }
        if (!this.m_user_param_desc_index.contains(parameterIndex)) {
            this.m_user_param_desc_index.addLast(parameterIndex);
        }
        return ret;
    }

    private String getStrSQLType(int sqlType) throws SQLException {
        String type_str = "";
        switch (sqlType) {
            case 1: 
            case 12: {
                type_str = "java.lang.String";
                break;
            }
            case 4: {
                type_str = "java.lang.Integer";
                break;
            }
            case -5: {
                type_str = "java.lang.Long";
                break;
            }
            case 8: {
                type_str = "java.lang.Double";
                break;
            }
            case 91: 
            case 93: {
                type_str = "java.sql.Timestamp";
                break;
            }
            case -104: {
                type_str = "com.bonc.xcloud.type.INTERVALDS";
                break;
            }
            case -103: {
                type_str = "com.bonc.xcloud.type.INTERVALYM";
                break;
            }
            case 2: {
                type_str = "java.math.BigDecimal";
                break;
            }
            default: {
                logger.error("setNull type not support yet");
                ExceptionMgr.throwSQLExp("setNull type not support yet");
            }
        }
        return type_str;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        String type_str = this.getStrSQLType(sqlType);
        this.setValue(parameterIndex, null, type_str);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setBoolean] Not Implemented yet.");
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setByte] Not Implemented yet.");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setShort] Not Implemented yet.");
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        String javaType = "java.lang.Integer";
        Integer value = x;
        this.setValue(parameterIndex, value.toString(), javaType);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        String javaType = "java.lang.Long";
        Long value = x;
        this.setValue(parameterIndex, value.toString(), javaType);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setFloat] Not Implemented yet.");
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        String javaType = "java.lang.Double";
        Double value = x;
        this.setValue(parameterIndex, value.toString(), javaType);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        String javaType = "java.math.BigDecimal";
        String value = x.toString();
        this.setValue(parameterIndex, value, javaType);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        String javaType = "java.lang.String";
        this.setValue(parameterIndex, x, javaType);
    }

    public void setINTERVALYM(int parameterIndex, INTERVALYM x) throws SQLException {
        String javaType = "com.bonc.xcloud.type.INTERVALYM";
        this.setValue(parameterIndex, x.toString(), javaType);
    }

    public INTERVALYM getINTERVALYM(int paramInt) throws SQLException {
        int index = this.checkGetIndex(paramInt);
        return ((XCloudResultSet)this.getResultSet()).getINTERVALYM(index);
    }

    public void setINTERVALDS(int parameterIndex, INTERVALDS x) throws SQLException {
        String javaType = "com.bonc.xcloud.type.INTERVALDS";
        this.setValue(parameterIndex, x.toString(), javaType);
    }

    public INTERVALDS getINTERVALDS(int paramInt) throws SQLException {
        int index = this.checkGetIndex(paramInt);
        return ((XCloudResultSet)this.getResultSet()).getINTERVALDS(index);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setBytes] Not Implemented yet.");
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setDate] Not Implemented yet.");
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setTime] Not Implemented yet.");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        String javaType = "java.sql.Timestamp";
        String value = x.toString();
        this.setValue(parameterIndex, value, javaType);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setAsciiStream] Not Implemented yet.");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setUnicodeStream] Not Implemented yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setBinaryStream] Not Implemented yet.");
    }

    @Override
    public void clearParameters() throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement clearParameters] Not Implemented yet.");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setObject] Not Implemented yet.");
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x instanceof Integer) {
            this.setInt(parameterIndex, (int)((Integer)x));
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (long)((Long)x));
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (double)((Double)x));
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else {
            String retMsg = "setObject not yet support type...";
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.writerLog("CallableStatement::execute");
        if (this.atLeastOneNamedParameter && this.atLeastOneOrdinalParameter) {
            String retMsg = "Ordinal binding and Named binding cannot be combined!";
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        this.logConfigureMap();
        int ret = this.executeTQuery(this.getTQuery(), false);
        if (0 == ret) {
            ((XCloudResultSet)this.getResultSet()).setProcedure();
            ((XCloudResultSet)this.getResultSet()).next();
            return true;
        }
        return false;
    }

    @Override
    public void addBatch() throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement addBatch] Not Implemented yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setRef] Not Implemented yet.");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setBlob] Not Implemented yet.");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setClob] Not Implemented yet.");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setArray] Not Implemented yet.");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getResultSet().getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setDate] Not Implemented yet.");
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setTime] Not Implemented yet.");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setTimestamp] Not Implemented yet.");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setNull] Not Implemented yet.");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setURL] Not Implemented yet.");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new XCloudCallParameterMetaData(this.getResultSet().getMetaData(), this.m_out_map_index, this.param_index_count, this.atLeastOneNamedParameter);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setRowId] Not Implemented yet.");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setNString] Not Implemented yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setNCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setNClob] Not Implemented yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setClob] Not Implemented yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setBlob] Not Implemented yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setNClob] Not Implemented yet.");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setSQLXML] Not Implemented yet.");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setObject] Not Implemented yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setAsciiStream] Not Implemented yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setBinaryStream] Not Implemented yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setAsciiStream] Not Implemented yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setBinaryStream] Not Implemented yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setNCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setClob] Not Implemented yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setBlob] Not Implemented yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setNClob] Not Implemented yet.");
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        Integer value = sqlType;
        this.registerOut(parameterIndex, value.toString());
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement registerOutParameter] Not Implemented yet.");
    }

    @Override
    public boolean wasNull() throws SQLException {
        return ((XCloudResultSet)this.getResultSet()).wasNull();
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        int index = this.checkGetIndex(parameterIndex);
        return this.getResultSet().getString(index);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getBoolean] Not Implemented yet.");
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getByte] Not Implemented yet.");
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getShort] Not Implemented yet.");
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        int index = this.checkGetIndex(parameterIndex);
        return this.getResultSet().getInt(index);
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        int index = this.checkGetIndex(parameterIndex);
        return this.getResultSet().getLong(index);
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getFloat] Not Implemented yet.");
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        int index = this.checkGetIndex(parameterIndex);
        return this.getResultSet().getDouble(index);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getBigDecimal] Not Implemented yet.");
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getBytes] Not Implemented yet.");
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getDate] Not Implemented yet.");
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getTime] Not Implemented yet.");
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        int index = this.checkGetIndex(parameterIndex);
        return this.getResultSet().getTimestamp(index);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        int index = this.checkGetIndex(parameterIndex);
        return this.getResultSet().getObject(index);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        int index = this.checkGetIndex(parameterIndex);
        return ((XCloudResultSet)this.getResultSet()).getBigDecimal(index);
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getObject] Not Implemented yet.");
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getRef] Not Implemented yet.");
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getBlob] Not Implemented yet.");
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getClob] Not Implemented yet.");
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getArray] Not Implemented yet.");
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getDate] Not Implemented yet.");
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getTime] Not Implemented yet.");
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getTimestamp] Not Implemented yet.");
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement registerOutParameter] Not Implemented yet.");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        Integer value = sqlType;
        this.registerOut(parameterName, value.toString());
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement registerOutParameter] Not Implemented yet.");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement registerOutParameter] Not Implemented yet.");
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getURL] Not Implemented yet.");
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setURL] Not Implemented yet.");
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        String type_str = this.getStrSQLType(sqlType);
        this.setValue(parameterName, null, type_str);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setBoolean] Not Implemented yet.");
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setByte] Not Implemented yet.");
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setShort] Not Implemented yet.");
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        String javaType = "java.lang.Integer";
        Integer value = x;
        this.setValue(parameterName, value.toString(), javaType);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        String javaType = "java.lang.Long";
        Long value = x;
        this.setValue(parameterName, value.toString(), javaType);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setFloat] Not Implemented yet.");
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        String javaType = "java.lang.Double";
        Double value = x;
        this.setValue(parameterName, value.toString(), javaType);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        String javaType = "java.math.BigDecimal";
        String value = x.toString();
        this.setValue(parameterName, value, javaType);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        String javaType = "java.lang.String";
        this.setValue(parameterName, x, javaType);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setBytes] Not Implemented yet.");
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setDate] Not Implemented yet.");
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setTime] Not Implemented yet.");
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        String javaType = "java.sql.Timestamp";
        String value = x.getYear() + 1900 + "/" + (x.getMonth() + 1) + "/" + x.getDate() + " " + x.getHours() + ":" + x.getMinutes() + ":" + x.getSeconds();
        this.setValue(parameterName, value, javaType);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setAsciiStream] Not Implemented yet.");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setBinaryStream] Not Implemented yet.");
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setObject] Not Implemented yet.");
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setObject] Not Implemented yet.");
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        if (x instanceof Integer) {
            this.setInt(parameterName, (int)((Integer)x));
        } else if (x instanceof Long) {
            this.setLong(parameterName, (long)((Long)x));
        } else if (x instanceof Double) {
            this.setDouble(parameterName, (double)((Double)x));
        } else if (x instanceof String) {
            this.setString(parameterName, (String)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterName, (Timestamp)x);
        } else {
            String retMsg = "setObject not yet support type...";
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setDate] Not Implemented yet.");
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setTime] Not Implemented yet.");
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setTimestamp] Not Implemented yet.");
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setNull] Not Implemented yet.");
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        int index = this.checkGetIndex(parameterName);
        if (-1 == index) {
            return this.getResultSet().getString(parameterName);
        }
        return this.getResultSet().getString(index);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getBoolean] Not Implemented yet.");
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getByte] Not Implemented yet.");
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getShort] Not Implemented yet.");
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        int index = this.checkGetIndex(parameterName);
        if (-1 == index) {
            return this.getResultSet().getInt(parameterName);
        }
        return this.getResultSet().getInt(index);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        int index = this.checkGetIndex(parameterName);
        if (-1 == index) {
            return this.getResultSet().getLong(parameterName);
        }
        return this.getResultSet().getLong(index);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getFloat] Not Implemented yet.");
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        int index = this.checkGetIndex(parameterName);
        if (-1 == index) {
            return this.getResultSet().getDouble(parameterName);
        }
        return this.getResultSet().getDouble(index);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getBytes] Not Implemented yet.");
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getDate] Not Implemented yet.");
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getTime] Not Implemented yet.");
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        int index = this.checkGetIndex(parameterName);
        if (-1 == index) {
            return this.getResultSet().getTimestamp(parameterName);
        }
        return this.getResultSet().getTimestamp(index);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        int index = this.checkGetIndex(parameterName);
        if (-1 == index) {
            return this.getResultSet().getObject(parameterName);
        }
        return this.getResultSet().getObject(index);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        int index = this.checkGetIndex(parameterName);
        if (-1 == index) {
            return this.getResultSet().getBigDecimal(parameterName);
        }
        return this.getResultSet().getBigDecimal(index);
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getObject] Not Implemented yet.");
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getRef] Not Implemented yet.");
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getBlob] Not Implemented yet.");
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getClob] Not Implemented yet.");
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getArray] Not Implemented yet.");
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getDate] Not Implemented yet.");
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getTime] Not Implemented yet.");
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getTimestamp] Not Implemented yet.");
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getURL] Not Implemented yet.");
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getRowId] Not Implemented yet.");
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getRowId] Not Implemented yet.");
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setRowId] Not Implemented yet.");
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setNString] Not Implemented yet.");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setNCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setNClob] Not Implemented yet.");
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setClob] Not Implemented yet.");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setBlob] Not Implemented yet.");
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setNClob] Not Implemented yet.");
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getNClob] Not Implemented yet.");
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getNClob] Not Implemented yet.");
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setSQLXML] Not Implemented yet.");
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getSQLXML] Not Implemented yet.");
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getSQLXML] Not Implemented yet.");
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getNString] Not Implemented yet.");
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getNString] Not Implemented yet.");
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getNCharacterStream] Not Implemented yet.");
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getNCharacterStream] Not Implemented yet.");
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getCharacterStream] Not Implemented yet.");
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement getCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setBlob] Not Implemented yet.");
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setClob] Not Implemented yet.");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setAsciiStream] Not Implemented yet.");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setBinaryStream] Not Implemented yet.");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setAsciiStream] Not Implemented yet.");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setBinaryStream] Not Implemented yet.");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setNCharacterStream] Not Implemented yet.");
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setClob] Not Implemented yet.");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setBlob] Not Implemented yet.");
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw new RuntimeException("[XCloudCallableStatement setNClob] Not Implemented yet.");
    }
}

