/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.jdbc;

import com.bonc.xcloud.common.ExceptionMgr;
import java.sql.ParameterMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCloudCallParameterMetaData
implements ParameterMetaData {
    private static Logger logger = LoggerFactory.getLogger(XCloudCallParameterMetaData.class);
    private ResultSetMetaData m_trsmd = null;
    private int m_paramCount = 0;
    private HashMap<Integer, Integer> m_out_map_index = null;
    private boolean m_atLeastOneNamedParameter = false;

    protected void writerLog(String methodName) throws SQLException {
        if (logger.isDebugEnabled()) {
            String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg(methodName);
            logger.debug(retMsg);
        }
    }

    private int checkGetIndex(int parameterIndex) throws SQLException {
        if (parameterIndex <= 0 || null == this.m_out_map_index.get(parameterIndex)) {
            String retMsg = "invalid column index";
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        int index = this.m_out_map_index.get(parameterIndex);
        return index;
    }

    public XCloudCallParameterMetaData(ResultSetMetaData rsmd, HashMap<Integer, Integer> out_map_index, int count, boolean atLeastOneNamedParameter) {
        this.m_trsmd = rsmd;
        this.m_out_map_index = out_map_index;
        this.m_paramCount = count;
        this.m_atLeastOneNamedParameter = atLeastOneNamedParameter;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return null;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.m_paramCount;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        return 0;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            throw new RuntimeException("[XCloudCallParameterMetaData getParameterType] Not Support.");
        }
        this.writerLog("getParameterType");
        int column = this.checkGetIndex(param);
        return this.m_trsmd.getColumnType(column);
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            throw new RuntimeException("[XCloudCallParameterMetaData getPrecision] Not Support.");
        }
        this.writerLog("getPrecision");
        int column = this.checkGetIndex(param);
        return this.m_trsmd.getPrecision(column);
    }

    @Override
    public int getScale(int param) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            throw new RuntimeException("[XCloudCallParameterMetaData getScale] Not Support.");
        }
        this.writerLog("getScale");
        int column = this.checkGetIndex(param);
        return this.m_trsmd.getScale(column);
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return 0;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return false;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        if (this.m_atLeastOneNamedParameter) {
            throw new RuntimeException("[XCloudCallParameterMetaData getParameterTypeName] Not Support.");
        }
        this.writerLog("getParameterTypeName");
        int column = this.checkGetIndex(param);
        return this.m_trsmd.getColumnTypeName(column);
    }
}

