/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.error.handle;

import com.bonc.xcloud.common.ConnInfoPack;
import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.common.StmtInfoPack;
import com.bonc.xcloud.xserver.TStatus;
import com.bonc.xcloud.xserver.TStatusCode;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandler {
    private static Logger logger = LoggerFactory.getLogger(ErrorHandler.class);
    private SQLWarning m_warning = null;

    public SQLWarning getSQLWarning() {
        return this.m_warning;
    }

    public void clearSQLWarning() {
        this.m_warning = null;
    }

    public void Handle(TStatus ts, ConnInfoPack infoPack) throws SQLException {
        this.Handle(ts, infoPack, null, null);
    }

    public void Handle(TStatus ts, ConnInfoPack infoPack, StmtInfoPack stmtInfoPack) throws SQLException {
        this.Handle(ts, infoPack, stmtInfoPack, null);
    }

    public void Handle(TStatus ts, ConnInfoPack infoPack, StmtInfoPack stmtInfo, String log_path) throws SQLException {
        if (ts.status_code == TStatusCode.EXEC_INSERTWARN) {
            String error_message = null;
            error_message = null == log_path ? ts.error_message : error_message + ":=" + log_path;
            if (null == this.m_warning) {
                this.m_warning = new SQLWarning(error_message, ts.sql_state, ts.error_code);
            } else {
                SQLWarning nextW = new SQLWarning(error_message, ts.sql_state, ts.error_code);
                this.m_warning.setNextWarning(nextW);
            }
        } else {
            String throwMsg = null;
            throwMsg = stmtInfo == null ? ExceptionMgr.getErrorContent(Thread.currentThread().getId(), infoPack.getCurrentConnID(), infoPack.getCurrentRemoteIP(), "", ts.status_code.toString(), ts.error_msgs.toString(), "", "", infoPack.getSessionID()) : ExceptionMgr.getErrorContent(Thread.currentThread().getId(), infoPack.getCurrentConnID(), infoPack.getCurrentRemoteIP(), stmtInfo.getCurrentQueryID(), ts.status_code.toString(), ts.error_msgs.toString(), stmtInfo.getCurrentExecuteTime(), stmtInfo.getCurrentExecuteSQL(), infoPack.getSessionID());
            logger.error("\n" + throwMsg.toString() + "\n");
            ExceptionMgr.throwSQLExp(throwMsg.toString(), ts.sql_state, ts.error_code);
        }
    }
}

