/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.convert;

import com.bonc.xcloud.common.ExceptionMgr;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharactorSetConv {
    private static Logger logger = LoggerFactory.getLogger(CharactorSetConv.class);
    public static int MAX_UTF8_LEN = 6;

    public static final boolean check90toBF(byte paramByte) {
        return (paramByte & 0xFFFFFFC0) == -128 && (paramByte & 0x30) != 0;
    }

    public static final boolean check80to9F(byte paramByte) {
        return (paramByte & 0xFFFFFFE0) == -128;
    }

    public static final boolean check80to8F(byte paramByte) {
        return (paramByte & 0xFFFFFFF0) == -128;
    }

    public static final boolean checkA0toBF(byte paramByte) {
        return (paramByte & 0xFFFFFFE0) == -96;
    }

    public static final boolean check80toBF(byte paramByte) {
        return (paramByte & 0xFFFFFFC0) == -128;
    }

    public static final char conv3ByteAL32UTF8toUTF16(byte paramByte1, byte paramByte2, byte paramByte3) {
        if (!(paramByte1 == -32 && CharactorSetConv.checkA0toBF(paramByte2) && CharactorSetConv.check80toBF(paramByte3) || paramByte1 >= -31 && paramByte1 <= -20 && CharactorSetConv.check80toBF(paramByte2) && CharactorSetConv.check80toBF(paramByte3) || paramByte1 == -19 && CharactorSetConv.check80to9F(paramByte2) && CharactorSetConv.check80toBF(paramByte3) || paramByte1 >= -18 && paramByte1 <= -17 && CharactorSetConv.check80toBF(paramByte2) && CharactorSetConv.check80toBF(paramByte3))) {
            return '\ufffd';
        }
        return (char)((paramByte1 & 0xF) << 12 | (paramByte2 & 0x3F) << 6 | paramByte3 & 0x3F);
    }

    public static int getUTF8Len(byte first) {
        byte i1 = first;
        int i3 = i1 & 0xF0;
        switch (i3 / 16) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 1;
            }
            case 12: 
            case 13: {
                return 2;
            }
            case 14: {
                return 3;
            }
            case 15: {
                return 4;
            }
        }
        return 1;
    }

    public static final char conv2ByteUTFtoUTF16(byte paramByte1, byte paramByte2) {
        if (paramByte1 < -62 || paramByte1 > -33 || !CharactorSetConv.check80toBF(paramByte2)) {
            return '\ufffd';
        }
        return (char)((paramByte1 & 0x1F) << 6 | paramByte2 & 0x3F);
    }

    public static final int conv4ByteAL32UTF8toUTF16(byte paramByte1, byte paramByte2, byte paramByte3, byte paramByte4, char[] paramArrayOfChar, int paramInt) {
        if (!(paramByte1 == -16 && CharactorSetConv.check90toBF(paramByte2) && CharactorSetConv.check80toBF(paramByte3) && CharactorSetConv.check80toBF(paramByte4) || paramByte1 >= -15 && paramByte1 <= -13 && CharactorSetConv.check80toBF(paramByte2) && CharactorSetConv.check80toBF(paramByte3) && CharactorSetConv.check80toBF(paramByte4) || paramByte1 == -12 && CharactorSetConv.check80to8F(paramByte2) && CharactorSetConv.check80toBF(paramByte3) && CharactorSetConv.check80toBF(paramByte4))) {
            paramArrayOfChar[paramInt] = 65533;
            return 1;
        }
        paramArrayOfChar[paramInt] = (char)((((paramByte1 & 7) << 2 | paramByte2 >>> 4 & 3) - 1 & 0xF) << 6 | (paramByte2 & 0xF) << 2 | paramByte3 >>> 4 & 3 | 0xD800);
        paramArrayOfChar[paramInt + 1] = (char)((paramByte3 & 0xF) << 6 | paramByte4 & 0x3F | 0xDC00);
        return 2;
    }

    public static int convUTF8BytesToOneJavaChars(byte[] bytes, int utf8Len, char[] charBuffer, int charBufferPos) throws SQLException {
        int c = 0;
        if (utf8Len > bytes.length || utf8Len < 1) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("CharactorSetConv::convUTF8BytesToOneJavaChars - utf8Len=" + utf8Len);
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        boolean j = false;
        if (1 == utf8Len) {
            byte i1 = bytes[0];
            int i3 = (i1 & 0xF0) / 16;
            charBuffer[charBufferPos] = i3 >= 0 && i3 <= 7 ? (int)(i1 & 0xFFFFFFFF) : 65533;
            return 1;
        }
        if (2 == utf8Len) {
            charBuffer[charBufferPos] = CharactorSetConv.conv2ByteUTFtoUTF16(bytes[0], bytes[1]);
            return 1;
        }
        if (3 == utf8Len) {
            charBuffer[charBufferPos] = CharactorSetConv.conv3ByteAL32UTF8toUTF16(bytes[0], bytes[1], bytes[2]);
            return 1;
        }
        if (4 == utf8Len) {
            if (charBufferPos + 1 == charBuffer.length) {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("CharactorSetConv::convUTF8BytesToOneJavaChars user buffer is not enough.");
                logger.error(retMsg);
                ExceptionMgr.throwSQLExp(retMsg);
            }
            return CharactorSetConv.conv4ByteAL32UTF8toUTF16(bytes[0], bytes[1], bytes[2], bytes[3], charBuffer, charBufferPos);
        }
        if (5 == utf8Len) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("CharactorSetConv::convUTF8BytesToOneJavaChars not support 5 utf8length yet.");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        } else if (6 == utf8Len) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("CharactorSetConv::convUTF8BytesToOneJavaChars not support 6 utf8length yet.");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        return c;
    }

    public static int convUTF8BytesToJavaChars(byte[] serverBytes, int sStartPos, int sLen, byte[] bytesFromLastTime, int[] lLen, char[] clientBuffer) throws SQLException {
        if (lLen.length != 1 || bytesFromLastTime.length != MAX_UTF8_LEN) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("CharactorSetConv::convUTF8BytesToJavaChars buffer alloc wrong.");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        boolean retCharLen = false;
        byte[] reserve = new byte[MAX_UTF8_LEN];
        int utf8Len = 0;
        int lastLen = lLen[0];
        lLen[0] = 0;
        boolean lastToReadFromNew = false;
        int reservePos = 0;
        int lastBytesPos = 0;
        int serverBytePos = sStartPos;
        sLen = serverBytePos + sLen;
        int charBufferPos = 0;
        int charBufferLen = clientBuffer.length;
        if (lastLen != 0) {
            utf8Len = CharactorSetConv.getUTF8Len(bytesFromLastTime[0]);
            if (lastLen + sLen < utf8Len) {
                lastBytesPos = lastLen;
                while (serverBytePos < sLen) {
                    if (lastBytesPos == MAX_UTF8_LEN) {
                        String retMsg = ExceptionMgr.getConvertedErrorMsg("CharactorSetConv::convUTF8BytesToJavaChars please check server transfer bytesStream");
                        logger.error(retMsg);
                        ExceptionMgr.throwSQLExp(retMsg);
                    }
                    bytesFromLastTime[lastBytesPos++] = serverBytes[serverBytePos++];
                }
                lLen[0] = lastBytesPos;
                return 0;
            }
            while (lastBytesPos < lastLen) {
                reserve[reservePos++] = bytesFromLastTime[lastBytesPos++];
            }
            int serverBytesTobeRead = serverBytePos + utf8Len - lastLen;
            while (serverBytePos < serverBytesTobeRead) {
                reserve[reservePos++] = serverBytes[serverBytePos++];
            }
            int needCharSize = 1;
            if (utf8Len > 3) {
                needCharSize = 2;
            }
            if (charBufferPos + needCharSize <= charBufferLen) {
                int len = CharactorSetConv.convUTF8BytesToOneJavaChars(reserve, utf8Len, clientBuffer, charBufferPos);
                charBufferPos += len;
            } else {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("CharactorSetConv::convUTF8BytesToJavaChars please check server transfer bytesStream");
                logger.error(retMsg);
                ExceptionMgr.throwSQLExp(retMsg);
            }
        }
        while (serverBytePos < sLen) {
            utf8Len = CharactorSetConv.getUTF8Len(serverBytes[serverBytePos]);
            if (serverBytePos + utf8Len > sLen) {
                lastBytesPos = 0;
                while (serverBytePos < sLen) {
                    bytesFromLastTime[lastBytesPos++] = serverBytes[serverBytePos++];
                }
                lLen[0] = lastBytesPos;
                return charBufferPos;
            }
            lLen[0] = 0;
            reservePos = 0;
            while (reservePos < utf8Len) {
                reserve[reservePos++] = serverBytes[serverBytePos++];
            }
            int needCharSize = 1;
            if (utf8Len > 3) {
                needCharSize = 2;
            }
            if (charBufferPos + needCharSize <= charBufferLen) {
                int len = CharactorSetConv.convUTF8BytesToOneJavaChars(reserve, utf8Len, clientBuffer, charBufferPos);
                charBufferPos += len;
                continue;
            }
            String retMsg = ExceptionMgr.getConvertedErrorMsg("CharactorSetConv::convUTF8BytesToJavaChars please check server transfer bytesStream");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        return charBufferPos;
    }

    public static int convGB18030BytesToJavaChars(byte[] serverBytes, int sStartPos, int sLen, byte[] bytesFromLastTime, int[] lLen, char[] clientBuffer) throws SQLException {
        if (lLen.length != 2) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("CharactorSetConv::convGB18030BytesToJavaChars buffer alloc wrong.");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        int resultCharSize = 0;
        int realStartPos = sStartPos;
        int lastGB18030Lenth = lLen[1];
        int bytesFromLastTimeLastLength = lLen[0];
        if (lastGB18030Lenth <= bytesFromLastTimeLastLength && 6 != lastGB18030Lenth && 0 != lastGB18030Lenth && 0 != bytesFromLastTimeLastLength) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("CharactorSetConv::convGB18030BytesToJavaChars last byte size wrong.");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        boolean isEmpty = true;
        if (0 != lastGB18030Lenth) {
            byte[] temp;
            isEmpty = false;
            if (6 == lastGB18030Lenth) {
                lastGB18030Lenth = CharactorSetConv.getGB18030Len(bytesFromLastTime[0], serverBytes[sStartPos]);
            }
            if (2 == lastGB18030Lenth) {
                temp = new byte[]{bytesFromLastTime[0], serverBytes[sStartPos]};
                ++sStartPos;
                resultCharSize += CharactorSetConv.convertByteListToJavaChars(temp, "GB18030", clientBuffer);
            } else if (4 == lastGB18030Lenth) {
                temp = new byte[4];
                for (int i = 0; i < bytesFromLastTimeLastLength; ++i) {
                    temp[i] = bytesFromLastTime[i];
                }
                int addLength = 4 - bytesFromLastTimeLastLength;
                for (int i = 0; i < addLength; ++i) {
                    temp[bytesFromLastTimeLastLength] = serverBytes[sStartPos];
                    ++sStartPos;
                    ++bytesFromLastTimeLastLength;
                }
                resultCharSize += CharactorSetConv.convertByteListToJavaChars(temp, "GB18030", clientBuffer);
            } else {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("CharactorSetConv::convGB18030BytesToJavaChars last byte size wrong.");
                logger.error(retMsg);
                ExceptionMgr.throwSQLExp(retMsg);
            }
        }
        lLen[1] = CharactorSetConv.calculateBytelistToGB18030ExcessLength(serverBytes, sStartPos, realStartPos + sLen - 1, lLen);
        for (int i = 0; i < lLen[0]; ++i) {
            bytesFromLastTime[i] = serverBytes[realStartPos + sLen - lLen[0] + i];
        }
        return CharactorSetConv.convertByteListToJavaChars(serverBytes, sStartPos, realStartPos + sLen - lLen[0] - 1, "GB18030", clientBuffer, isEmpty);
    }

    public static int convertByteListToJavaChars(byte[] bytelist, int startIndex, int endIndex, String charSet, char[] result, boolean isEmpty) throws SQLException {
        String retMsg;
        char[] temp_charList = null;
        try {
            temp_charList = new String(bytelist, startIndex, endIndex - startIndex + 1, charSet).toCharArray();
        }
        catch (UnsupportedEncodingException e) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("lob data encode type is unknown");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        int counter = 0;
        if (!isEmpty) {
            ++counter;
        }
        if (temp_charList.length + counter > result.length) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("CharactorSetConv::convertByteListToJavaChars please check server transfer bytesStream");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        char[] arr$ = temp_charList;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            char c;
            result[counter] = c = arr$[i$];
            ++counter;
        }
        return counter;
    }

    public static int convertByteListToJavaChars(byte[] bytelist, String charSet, char[] result) throws SQLException {
        char[] temp_charList = null;
        try {
            temp_charList = new String(bytelist, charSet).toCharArray();
        }
        catch (UnsupportedEncodingException e) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("lob data encode type is unknown");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        result[0] = temp_charList[0];
        return 1;
    }

    public static boolean isSingleByteGB18030(byte first) {
        return (first = (byte)(first & 0xFF)) >= 0 && first <= 127;
    }

    public static int getGB18030Len(byte first, byte second) throws SQLException {
        int GBLength = 0;
        if (first >= -127 && first <= -2) {
            if (second >= 64 && second < 127) {
                GBLength = 2;
            } else if (second > -129 && second <= -2) {
                GBLength = 2;
            } else if (second >= 48 && second <= 57) {
                GBLength = 4;
            }
        }
        if (0 == GBLength) {
            ExceptionMgr.throwSQLExp("Error coding GB18030: JDBC failed to calculate GB18030 charset length ,due to the wrong byte . first byte: " + first + " second byte: " + second);
        }
        return GBLength;
    }

    public static int calculateBytelistToGB18030ExcessLength(byte[] data, int startIndex, int endIndex, int[] lastLength) throws SQLException {
        int singleLength = 0;
        lastLength[0] = 0;
        for (int i = startIndex; i <= endIndex; i += singleLength) {
            if (i <= endIndex) {
                if (CharactorSetConv.isSingleByteGB18030(data[i])) {
                    singleLength = 1;
                    if (endIndex != i) continue;
                    lastLength[0] = 0;
                    return 0;
                }
                if (i + 1 < endIndex) {
                    singleLength = CharactorSetConv.getGB18030Len(data[i], data[i + 1]);
                    lastLength[0] = endIndex + 1 - i;
                    continue;
                }
                if (i + 1 == endIndex) {
                    singleLength = CharactorSetConv.getGB18030Len(data[i], data[i + 1]);
                    lastLength[0] = endIndex + 1 - i;
                    if (2 == singleLength) {
                        lastLength[0] = 0;
                        return 0;
                    }
                    return singleLength;
                }
                lastLength[0] = 1;
                return 6;
            }
            lastLength[0] = 0;
            return 0;
        }
        return singleLength;
    }
}

