/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.convert;

import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.common.NumberBuffer;
import com.bonc.xcloud.type.XCloudNumber;
import com.bonc.xcloud.util.NumberTypeInfo;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteOrderConv {
    private static Logger logger = LoggerFactory.getLogger(ByteOrderConv.class);

    public static short ConvByteToShortLE(byte[] data_array, int pos) throws SQLException {
        if (data_array.length - pos < 2) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("ByteOrderConv::ConvByteToShortLE - because length < 2 !");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        short value = 0;
        int x = 255;
        for (int i = 0; i < 2; ++i) {
            value = (short)(value | data_array[pos + 2 - 1 - i] << 8 * (1 - i) & x << 8 * (1 - i));
        }
        return value;
    }

    public static int ConvByteToIntLE(byte[] data_array, int pos) throws SQLException {
        if (data_array.length - pos < 4) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("ByteOrderConv::ConvByteToIntLE - because length < 4 !");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        int value = 0;
        int x = 255;
        for (int i = 0; i < 4; ++i) {
            value |= data_array[pos + 4 - 1 - i] << 8 * (3 - i) & x << 8 * (3 - i);
        }
        return value;
    }

    public static long ConvByteToLongLE(byte[] data_array, int pos) throws SQLException {
        if (data_array.length - pos < 8) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("ByteOrderConv::ConvByteToLongLE - because length < 8 !");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        long value = 0L;
        long x = 255L;
        for (int i = 0; i < 8; ++i) {
            value |= (long)data_array[pos + 8 - 1 - i] << 8 * (7 - i) & x << 8 * (7 - i);
        }
        return value;
    }

    public static Timestamp convByteToTimestampBaseDate(byte[] data_array, int pos) throws SQLException {
        if (data_array.length - pos < 8) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("ByteOrderConv::ConvByteToLongLE - because length < 8 !");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        byte second = data_array[pos + 1];
        byte minute = data_array[pos + 2];
        byte hour = data_array[pos + 3];
        byte date = data_array[pos + 4];
        byte month = data_array[pos + 5];
        int yearl = data_array[pos + 6];
        int yearh = data_array[pos + 7];
        if (yearl < 0) {
            yearl = 256 + yearl;
        }
        int year = yearh;
        year <<= 8;
        Timestamp timestamp = new Timestamp((year |= yearl) - 1900, month - 1, date, hour, minute, second, 0);
        return timestamp;
    }

    public static Timestamp convByteToTimestamp(byte[] data_array, int pos) throws SQLException {
        if (data_array.length - pos < 12) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("ByteOrderConv::ConvByteToLongLE - because length < 12 !");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        byte second = data_array[pos + 1];
        byte minute = data_array[pos + 2];
        byte hour = data_array[pos + 3];
        byte date = data_array[pos + 4];
        byte month = data_array[pos + 5];
        int yearl = data_array[pos + 6];
        int yearh = data_array[pos + 7];
        int fractional_seconds = ByteOrderConv.ConvByteToIntLE(data_array, pos + 8);
        if (yearl < 0) {
            yearl = 256 + yearl;
        }
        int year = yearh;
        year <<= 8;
        Timestamp timestamp = new Timestamp((year |= yearl) - 1900, month - 1, date, hour, minute, second, fractional_seconds);
        return timestamp;
    }

    public static BigDecimal convToBigDecimal(NumberTypeInfo nti) throws SQLException {
        BigDecimal bd = new BigDecimal(0);
        for (int i = 0; i < nti.sig_count; ++i) {
            int e = nti.exp - i - 1;
            BigDecimal temp = new BigDecimal(10000);
            if (e >= 0) {
                temp = temp.pow(e);
            } else {
                temp = temp.pow(-e);
                BigDecimal temp2 = new BigDecimal(1);
                temp = temp2.divide(temp);
            }
            temp = temp.multiply(new BigDecimal(nti.sig_list.get(i).shortValue()));
            bd = bd.add(temp);
        }
        if (nti.sign == NumberTypeInfo.SIGN.NAGETIVE) {
            BigDecimal temp2 = new BigDecimal(-1);
            bd = bd.multiply(temp2);
        }
        if (bd.scale() != 0) {
            return bd.stripTrailingZeros();
        }
        return bd;
    }

    public static int getUnsignedByte(byte data) {
        return data & 0xFF;
    }

    public static BigDecimal convByteToBigDecimal(byte[] data_array, int start, boolean isLE) throws SQLException {
        if (data_array.length - start < NumberBuffer.size) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("ByteOrderConv::convByteToBigDecimal - because length < 22 !");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        int strStart = start;
        int pos = 0;
        NumberTypeInfo.SIGN sign = NumberTypeInfo.SIGN.ZERO;
        short v = 0;
        int e = ByteOrderConv.ConvByteToShortLE(data_array, strStart);
        if (e >= XCloudNumber.ZERO_INDEX_BASE) {
            sign = NumberTypeInfo.SIGN.POSITIVE;
            e -= XCloudNumber.S_POSITIVE_INDEX_BASE;
        } else {
            sign = NumberTypeInfo.SIGN.NAGETIVE;
            e = XCloudNumber.S_NEGATIVE_INDEX_BASE - e;
        }
        pos = strStart + 2;
        ArrayList<Short> sig_list = new ArrayList<Short>();
        int sig_count = 0;
        while ((v = isLE ? ByteOrderConv.ConvByteToShortLE(data_array, pos) : ByteBuffer.wrap(data_array, pos, 2).getShort()) != XCloudNumber.S_POSITIVE_TAIL && v != XCloudNumber.S_NEGATIVE_TAIL) {
            if (sign == NumberTypeInfo.SIGN.POSITIVE) {
                v = (short)(v - XCloudNumber.S_POSITIVE_BASE);
            } else if (sign == NumberTypeInfo.SIGN.NAGETIVE) {
                v = (short)(XCloudNumber.S_NEGATIVE_BASE - v);
            }
            sig_list.add(v);
            pos += 2;
            if (XCloudNumber.NUMBER_MEMORY_TAIL_LENTH != ++sig_count) continue;
        }
        NumberTypeInfo nti = new NumberTypeInfo(sign, sig_list, e, sig_count);
        return ByteOrderConv.convToBigDecimal(nti);
    }

    public static byte[] ConvIntToByteLE(int n) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            b[i] = (byte)(n >> 8 * i & 0xFF);
        }
        return b;
    }

    public static void ConvIntToByteLE(int n, byte[] array, int pos) throws SQLException {
        if (array.length - pos < 4) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("ByteOrderConv::ConvIntToByteLE - because length < 4 !");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        for (int i = pos; i < pos + 4; ++i) {
            array[i] = (byte)(n >> 8 * (i - pos) & 0xFF);
        }
    }

    public static void ConvShortToByteLE(short n, byte[] array, int pos) throws SQLException {
        if (array.length - pos < 2) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("ByteOrderConv::ConvShortToByteLE - because length < 2 !");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        for (int i = pos; i < pos + 2; ++i) {
            array[i] = (byte)(n >> 8 * (i - pos) & 0xFF);
        }
    }

    public static byte[] ConvLongToByteLE(long n) {
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            b[i] = (byte)(n >> 8 * i & 0xFFL);
        }
        return b;
    }

    public static byte[] ConvDoubleToByteLE(double n) {
        byte[] b = new byte[8];
        long ln = Double.doubleToLongBits(n);
        for (int i = 0; i < 8; ++i) {
            b[i] = (byte)(ln >> 8 * i & 0xFFL);
        }
        return b;
    }
}

