/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.context.builder;

import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.convert.ByteOrderConv;
import com.bonc.xcloud.sql.parser.ColumnInfo;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BatchInsertContentBuilder {
    private byte[] m_array = null;
    private int m_current_row = 0;
    private int m_pos = 0;
    private HashMap<Integer, Element> m_index_value_bak;
    private HashMap<String, Integer> m_name_index_map;
    private List<ByteBuffer> m_buffer = null;
    private String m_serverCharset = null;

    public BatchInsertContentBuilder(int capacity, ArrayList<ColumnInfo> column_list, String serverCharset) throws SQLException {
        try {
            this.m_array = new byte[capacity];
        }
        catch (OutOfMemoryError ex) {
            ExceptionMgr.throwSQLExp("out of Memory at contentbuilder");
        }
        this.m_serverCharset = serverCharset;
        this.m_index_value_bak = new HashMap();
        this.m_name_index_map = new HashMap();
        for (int i = 0; i < column_list.size(); ++i) {
            this.m_name_index_map.put(column_list.get(i).getColumnName(), i);
        }
        this.m_buffer = new ArrayList<ByteBuffer>();
    }

    public BatchInsertContentBuilder(int capacity, ArrayList<ColumnInfo> column_list) throws SQLException {
        try {
            this.m_array = new byte[capacity];
        }
        catch (OutOfMemoryError ex) {
            ExceptionMgr.throwSQLExp("out of Memory at contentbuilder");
        }
        this.m_index_value_bak = new HashMap();
        this.m_name_index_map = new HashMap();
        for (int i = 0; i < column_list.size(); ++i) {
            this.m_name_index_map.put(column_list.get(i).getColumnName(), i);
        }
        this.m_buffer = new ArrayList<ByteBuffer>();
    }

    private byte[] getByte(int i) throws SQLException {
        Element e;
        byte[] value = null;
        if (!this.m_index_value_bak.containsKey(i)) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Lost IN/OUT parameter:" + i);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        if ((e = this.m_index_value_bak.get(i)).value == null) {
            return value;
        }
        switch (e.type) {
            case 4: {
                value = ((Integer)e.value).toString().getBytes();
                break;
            }
            case -5: {
                value = ((Long)e.value).toString().getBytes();
                break;
            }
            case 8: {
                value = ((Double)e.value).toString().getBytes();
                break;
            }
            case 1: 
            case 12: {
                try {
                    value = ((String)e.value).getBytes(this.m_serverCharset);
                }
                catch (UnsupportedEncodingException e1) {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("char/varchar transfer byte error");
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                break;
            }
            case 93: {
                String v = ((Timestamp)e.value).toString();
                value = v.getBytes();
                break;
            }
            case 91: {
                Date date = (Date)e.value;
                String v = date.toString();
                int index_of_point = v.indexOf(46);
                if (-1 != index_of_point) {
                    v = v.substring(0, index_of_point);
                }
                value = v.getBytes();
                break;
            }
            default: {
                String retMsg = ExceptionMgr.getConvertedErrorMsg("Not Support Type");
                ExceptionMgr.throwSQLExp(retMsg);
            }
        }
        return value;
    }

    private int calcCurrentRowLength() throws SQLException {
        int length = 0;
        byte[] value = null;
        for (int i = 0; i < this.m_name_index_map.size(); ++i) {
            value = this.getByte(i + 1);
            length += 4;
            if (value == null) continue;
            length += value.length;
        }
        return length;
    }

    private void fillArray() throws SQLException {
        byte[] value = null;
        int start = this.m_pos;
        for (int i = 0; i < this.m_name_index_map.size(); ++i) {
            value = this.getByte(i + 1);
            if (value != null) {
                ByteOrderConv.ConvIntToByteLE(value.length, this.m_array, this.m_pos);
                this.m_pos += 4;
                System.arraycopy(value, 0, this.m_array, this.m_pos, value.length);
                this.m_pos += value.length;
                continue;
            }
            ByteOrderConv.ConvIntToByteLE(0, this.m_array, this.m_pos);
            this.m_pos += 4;
        }
        if (this.m_pos != start) {
            ByteBuffer bb = ByteBuffer.wrap(this.m_array, start, this.m_pos - start);
            this.m_buffer.add(bb);
        }
    }

    public void setObject(int index, int type, Object value) throws SQLException {
        if (index > this.m_name_index_map.size()) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("invalid index : " + this.m_name_index_map.size());
            ExceptionMgr.throwSQLExp(retMsg);
        }
        Element e = new Element(type, value);
        this.m_index_value_bak.put(index, e);
    }

    public boolean generateOneRow() throws SQLException {
        int current_length = this.calcCurrentRowLength();
        if (this.m_array.length - this.m_pos >= current_length) {
            this.fillArray();
            ++this.m_current_row;
            this.m_index_value_bak.clear();
            return false;
        }
        if (this.m_current_row == 0) {
            this.m_array = null;
            this.m_array = new byte[current_length];
        }
        this.m_current_row = 0;
        this.m_pos = 0;
        return true;
    }

    public List<ByteBuffer> getBuffer() {
        return this.m_buffer;
    }

    public void clearBuffer() {
        this.m_current_row = 0;
        this.m_buffer.clear();
    }

    public class Element {
        private int type;
        private Object value;

        public Element(int t, Object v) {
            this.type = t;
            this.value = v;
        }

        public int getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

