/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.component;

import com.bonc.xcloud.common.ConnInfo;
import com.bonc.xcloud.common.ConnInfoPack;
import com.bonc.xcloud.common.Counter;
import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.common.StmtInfoPack;
import com.bonc.xcloud.log.XCloudJDBCLogger;
import com.bonc.xcloud.xserver.SessionService;
import com.bonc.xcloud.xserver.TDBMetaResult;
import com.bonc.xcloud.xserver.TLobResultSet;
import com.bonc.xcloud.xserver.TLoginInfo;
import com.bonc.xcloud.xserver.TLoginResult;
import com.bonc.xcloud.xserver.TMemDataPack;
import com.bonc.xcloud.xserver.TOpenLobResult;
import com.bonc.xcloud.xserver.TQuery;
import com.bonc.xcloud.xserver.TRequestResult;
import com.bonc.xcloud.xserver.TResultSet;
import com.bonc.xcloud.xserver.TResultSetMetaData;
import com.bonc.xcloud.xserver.TRowCountResult;
import com.bonc.xcloud.xserver.TStatus;
import com.bonc.xcloud.xserver.TUniqueId;
import com.bonc.xcloud.xserver.TUserInfo;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.List;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManager {
    private static Logger logger = LoggerFactory.getLogger(ServiceManager.class);
    private SessionService.Client m_ssClient = null;
    private TTransport m_transport = null;
    private ConnInfoPack m_infoPack = null;
    private boolean m_connAlreadyDie = false;
    private XCloudJDBCLogger m_jdbcLogger = null;

    public ServiceManager(ConnInfoPack infoPack, XCloudJDBCLogger jdbcLogger) {
        this.m_infoPack = infoPack;
        this.m_jdbcLogger = jdbcLogger;
    }

    public void setClient(SessionService.Client ssclient) {
        this.m_ssClient = ssclient;
    }

    public SessionService.Client getClient() {
        return this.m_ssClient;
    }

    public ConnInfoPack getConnInfoPack() {
        return this.m_infoPack;
    }

    public boolean ConnectServer(ConnInfo info) throws TTransportException, SQLException {
        if (logger.isDebugEnabled()) {
            String retMsg = ExceptionMgr.getConvertedThriftCallerMsg("ConnectServer");
            logger.debug(retMsg);
        }
        boolean ret = false;
        Counter cn = new Counter();
        this.m_transport = new TSocket(info.getRemoteIp(), info.getRemotePort(), this.m_infoPack.getSocketTimeOut());
        TBinaryProtocol tmp_protocol = null;
        cn.start();
        this.m_transport.open();
        cn.stop();
        if (this.m_transport.isOpen()) {
            tmp_protocol = new TBinaryProtocol(this.m_transport);
            this.m_ssClient = new SessionService.Client((TProtocol)tmp_protocol);
            info.setIsUsed(true);
            this.m_infoPack.setCurrentRemoteIP(info.getRemoteIp());
            this.m_infoPack.setCurrentRemotePort(info.getRemotePort());
            ret = true;
            this.m_connAlreadyDie = false;
            this.writeRpcLog("Socket Open", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.OK);
        } else {
            this.m_connAlreadyDie = true;
            this.writeRpcLog("Socket Open", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.FAIL);
        }
        return ret;
    }

    public synchronized void Disconnect() throws SQLException {
        Counter cn = new Counter();
        if (this.m_transport != null) {
            this.m_connAlreadyDie = true;
            cn.start();
            this.m_transport.close();
            cn.stop();
            this.writeRpcLog("Disconnect", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.OK);
        }
    }

    public synchronized String getBEVersion() throws SQLException {
        String version = null;
        Counter cn = new Counter();
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                version = this.m_ssClient.getBEVersion();
                cn.stop();
                this.writeRpcLog("getBEVersion", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.OK);
            } else {
                this.writeRpcLog("getBEVersion", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog("getBEVersion", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, null);
        }
        return version;
    }

    public synchronized TRequestResult execute(TQuery query, StmtInfoPack stmtInfo) throws SQLException {
        Counter cn = new Counter();
        TRequestResult trr = null;
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                trr = this.m_ssClient.execute(query);
                cn.stop();
                this.writeRpcLog("execute", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.OK);
                StringBuffer queryID = new StringBuffer();
                queryID.append(Integer.toHexString(trr.query_handle.getIp())).append(":").append(Integer.toHexString(trr.query_handle.getTimestamp())).append(":").append(Integer.toHexString(trr.query_handle.getSeqno())).append(":").append(Integer.toHexString(trr.query_handle.getReserve()));
                stmtInfo.setCurrentQueryID(queryID.toString());
            } else {
                this.writeRpcLog("execute", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog("execute", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, stmtInfo);
        }
        return trr;
    }

    public synchronized TStatus close(TUniqueId handle, CloseUser ur) throws SQLException {
        Counter cn = new Counter();
        TStatus ts = null;
        String methodName = "";
        StringBuffer queryID = new StringBuffer();
        queryID.append(Integer.toHexString(handle.getIp())).append(":").append(Integer.toHexString(handle.getTimestamp())).append(":").append(Integer.toHexString(handle.getSeqno())).append(":").append(Integer.toHexString(handle.getReserve()));
        StmtInfoPack stmtInfo = new StmtInfoPack();
        stmtInfo.setCurrentQueryID(queryID.toString());
        methodName = ur == CloseUser.STMT ? "Statement close handle" : (ur == CloseUser.RES ? "Result close handle" : (ur == CloseUser.CONN ? "Connection close handle" : "close"));
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                ts = this.m_ssClient.close(handle);
                cn.stop();
                this.writeRpcLog(methodName, cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.OK);
            } else {
                this.writeRpcLog(methodName, cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog(methodName, cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, stmtInfo);
        }
        return ts;
    }

    public synchronized TMemDataPack fetch(TUniqueId handle) throws SQLException {
        Counter cn = new Counter();
        TMemDataPack tmdp = null;
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                tmdp = this.m_ssClient.fetch(handle);
                cn.stop();
                this.writeRpcLog("fetch", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.OK);
            } else {
                this.writeRpcLog("fetch", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog("fetch", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, null);
        }
        return tmdp;
    }

    public synchronized TResultSet fetchResultSet(TUniqueId handle, int fetchSize) throws SQLException {
        Counter cn = new Counter();
        TResultSet trs = null;
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                trs = this.m_ssClient.fetchResultSet(handle);
            } else {
                this.writeRpcLog("fetchResultSet", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog("fetchResultSet", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, null);
        }
        return trs;
    }

    public synchronized TResultSet fetchResultSet_N(TUniqueId handle, int fetchSize, StmtInfoPack stmtInfo) throws SQLException {
        Counter cn = new Counter();
        TResultSet trs = null;
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                trs = this.m_ssClient.fetchResultSet_N(handle, fetchSize);
            } else {
                this.writeRpcLog("fetchResultSet_N", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog("fetchResultSet_N", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, stmtInfo);
        }
        return trs;
    }

    public synchronized TResultSetMetaData getResultsetMetaData(TUniqueId handle, StmtInfoPack stmtInfo) throws SQLException {
        Counter cn = new Counter();
        TResultSetMetaData trsmd = null;
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                trsmd = this.m_ssClient.getResultSetMetaData(handle);
                cn.stop();
                this.writeRpcLog("getResultsetMetaData", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.OK);
            } else {
                this.writeRpcLog("getResultsetMetaData", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog("getResultsetMetaData", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, stmtInfo);
        }
        return trsmd;
    }

    public synchronized TRowCountResult getRowCount(TUniqueId handle, StmtInfoPack stmtInfo) throws SQLException {
        Counter cn = new Counter();
        TRowCountResult trcr = null;
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                trcr = this.m_ssClient.getRowCount(handle);
                cn.stop();
                this.writeRpcLog("getRowCount", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.OK);
            } else {
                this.writeRpcLog("getRowCount", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog("getRowCount", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, stmtInfo);
        }
        return trcr;
    }

    public synchronized TStatus login(TUserInfo user) throws SQLException {
        Counter cn = new Counter();
        TStatus ts = null;
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                ts = this.m_ssClient.login(user);
                cn.stop();
                this.writeRpcLog("login", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.OK);
            } else {
                this.writeRpcLog("login", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog("login", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, null);
        }
        return ts;
    }

    public synchronized TLoginResult login_new(TLoginInfo tInfo) throws SQLException {
        Counter cn = new Counter();
        TLoginResult tlr = null;
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                tlr = this.m_ssClient.login_new(tInfo);
                cn.stop();
                if (tlr.isSetSession_id()) {
                    this.m_infoPack.setSessionID(tlr.getSession_id());
                }
                this.writeRpcLog("login_new", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.OK);
            } else {
                this.writeRpcLog("login_new", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog("login_new", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, null);
        }
        return tlr;
    }

    public synchronized TStatus logout() throws SQLException {
        Counter cn = new Counter();
        TStatus ts = null;
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                ts = this.m_ssClient.logout();
                cn.stop();
                this.writeRpcLog("logout", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.OK);
            } else {
                this.writeRpcLog("logout", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog("logout", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, null);
        }
        return ts;
    }

    public synchronized TStatus sendData_binarys(TUniqueId handle, StmtInfoPack stmtInfo, List<ByteBuffer> strData, Boolean isEof) throws SQLException {
        Counter cn = new Counter();
        TStatus ts = null;
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                ts = this.m_ssClient.sendData_binarys(handle, strData, isEof);
                cn.stop();
                this.writeRpcLog("sendData_binarys", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.OK);
            } else {
                this.writeRpcLog("sendData_binarys", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog("sendData_binarys", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, null);
        }
        return ts;
    }

    public synchronized TDBMetaResult getDBMeta() throws SQLException {
        Counter cn = new Counter();
        TDBMetaResult tdbdr = null;
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                tdbdr = this.m_ssClient.getDBMeta();
                cn.stop();
                this.writeRpcLog("getDBMeta", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.OK);
            } else {
                this.writeRpcLog("getDBMeta", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog("getDBMeta", cn, this.m_infoPack, null, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, null);
        }
        return tdbdr;
    }

    public synchronized TStatus queryState(TUniqueId handle, StmtInfoPack stmtInfo) throws SQLException {
        Counter cn = new Counter();
        TStatus ts = null;
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                ts = this.m_ssClient.queryState(handle);
                cn.stop();
                this.writeRpcLog("queryState", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.OK);
            } else {
                this.writeRpcLog("queryState", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog("queryState", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, stmtInfo);
        }
        return ts;
    }

    public synchronized TOpenLobResult openLobFile(ByteBuffer tlob, StmtInfoPack stmtInfo) throws SQLException {
        Counter cn = new Counter();
        TOpenLobResult tplr = null;
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                tplr = this.m_ssClient.openLobFile(tlob);
                cn.stop();
                this.writeRpcLog("openLobFile", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.OK);
            } else {
                this.writeRpcLog("openLobFile", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog("openLobFile", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, stmtInfo);
        }
        return tplr;
    }

    public synchronized TLobResultSet fetchLobData(TUniqueId lob_handle, int fetchSize, StmtInfoPack stmtInfo) throws SQLException {
        Counter cn = new Counter();
        TLobResultSet tlrs = null;
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                tlrs = this.m_ssClient.fetchLobData(lob_handle, fetchSize);
                cn.stop();
                this.writeRpcLog("fetchLobData", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.OK);
            } else {
                this.writeRpcLog("fetchLobData", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog("fetchLobData", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, stmtInfo);
        }
        return tlrs;
    }

    public synchronized TStatus closeLobFile(TUniqueId lob_handle, StmtInfoPack stmtInfo) throws SQLException {
        Counter cn = new Counter();
        TStatus ts = null;
        try {
            if (!this.m_connAlreadyDie) {
                cn.start();
                ts = this.m_ssClient.closeLobFile(lob_handle);
                cn.stop();
                this.writeRpcLog("closeLobFile", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.OK);
            } else {
                this.writeRpcLog("closeLobFile", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.DIE);
            }
        }
        catch (TException te) {
            cn.stop();
            this.writeRpcLog("closeLobFile", cn, this.m_infoPack, stmtInfo, ExceptionMgr.RPCStatus.ERROR);
            this.throwError(te, stmtInfo);
        }
        return ts;
    }

    private void throwError(TException te, StmtInfoPack stmtInfo) throws SQLException {
        this.m_connAlreadyDie = true;
        ExceptionMgr.throwError(te, this.m_infoPack, stmtInfo);
    }

    public boolean isOpen() {
        return !this.m_connAlreadyDie;
    }

    protected void writeRpcLog(String thriftName, Counter cn, ConnInfoPack infoPack, StmtInfoPack stmtInfo, ExceptionMgr.RPCStatus status) throws SQLException {
        String logMsg = ExceptionMgr.getConvertedThriftCallerMsg(thriftName, cn, infoPack, stmtInfo, status);
        XCloudJDBCLogger.Write_Log(logMsg);
        if (logger.isDebugEnabled()) {
            logger.debug(logMsg);
        }
    }

    public static enum CloseUser {
        RES,
        CONN,
        STMT;

    }
}

