/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.common;

import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.common.LocalBuffer;
import com.bonc.xcloud.convert.ByteOrderConv;
import com.bonc.xcloud.enumdef.CharSet;
import com.bonc.xcloud.util.VarcharTypeInfo;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrVarcharBuffer
extends LocalBuffer {
    private List<VarcharTypeInfo> m_posBuff = null;
    private static Logger logger = LoggerFactory.getLogger(StrVarcharBuffer.class);

    public StrVarcharBuffer(boolean isLittleEnd) {
        super(isLittleEnd);
        this.typeSize = -1;
        this.m_posBuff = new ArrayList<VarcharTypeInfo>();
    }

    public StrVarcharBuffer(int ts, boolean isLittleEnd) {
        super(isLittleEnd);
        this.typeSize = ts;
        this.m_posBuff = new ArrayList<VarcharTypeInfo>();
    }

    public void createPosBuffer(boolean isLE) throws SQLException {
        this.m_posBuff.clear();
        int lenByte = 4;
        int count = 0;
        count = isLE ? ByteOrderConv.ConvByteToIntLE(this.m_array, 0) : ByteBuffer.wrap(this.m_array, 0, lenByte).getInt();
        int strStart = (count + 1) * lenByte;
        int pos = 0;
        int len = 0;
        for (int i = 0; i < count; ++i) {
            pos = strStart;
            len = isLE ? ByteOrderConv.ConvByteToIntLE(this.m_array, (i + 1) * lenByte) : ByteBuffer.wrap(this.m_array, (i + 1) * lenByte, lenByte).getInt();
            this.m_posBuff.add(i, new VarcharTypeInfo(pos, len));
            strStart += len;
        }
    }

    @Override
    public Object get(int row, boolean isLE, CharSet cs) throws SQLException {
        String ret = null;
        boolean isNull = this.isNULL(row);
        if (isNull) {
            return null;
        }
        VarcharTypeInfo vcharInfo = this.m_posBuff.get(row);
        int pos = vcharInfo.pos;
        int reallen = 0;
        switch (cs) {
            case UTF16BE: {
                reallen = vcharInfo.len;
                try {
                    ret = new String(this.m_array, pos, reallen, "UTF-16BE");
                }
                catch (UnsupportedEncodingException e) {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("Varchar get with UTF16BE: UnsupportedEncodingException:[pos=" + pos + ", len=" + reallen + ", typeSize=" + this.typeSize + "]");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                break;
            }
            case UTF16LE: {
                reallen = vcharInfo.len;
                try {
                    ret = new String(this.m_array, pos, reallen, "UTF-16LE");
                }
                catch (UnsupportedEncodingException e) {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("Varchar get with UTF16LE: UnsupportedEncodingException:[pos=" + pos + ", len=" + reallen + ", typeSize=" + this.typeSize + "]");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                break;
            }
            case UTF8: {
                reallen = vcharInfo.len;
                try {
                    ret = new String(this.m_array, pos, reallen, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("Varchar get with UTF8: UnsupportedEncodingException:[pos=" + pos + ", len=" + reallen + ", typeSize=" + this.typeSize + "]");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                break;
            }
            case GB18030: {
                reallen = vcharInfo.len;
                try {
                    ret = new String(this.m_array, pos, reallen, "GB18030");
                }
                catch (UnsupportedEncodingException e) {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("Varchar get with GB18030: UnsupportedEncodingException:[pos=" + pos + ", len=" + reallen + ", typeSize=" + this.typeSize + "]");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
                break;
            }
        }
        return ret;
    }

    @Override
    public void arrayUpdate() throws SQLException {
        this.createPosBuffer(this.isLittleEnd);
    }
}

