/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.common;

import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.common.LocalBuffer;
import com.bonc.xcloud.enumdef.CharSet;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrBuffer
extends LocalBuffer {
    private static Logger logger = LoggerFactory.getLogger(StrBuffer.class);

    public StrBuffer(boolean isLittleEnd) {
        super(isLittleEnd);
        this.typeSize = -1;
    }

    public StrBuffer(int ts, boolean isLittleEnd) {
        super(isLittleEnd);
        this.typeSize = ts;
    }

    @Override
    public Object get(int row, boolean isLE, CharSet cs) throws SQLException {
        String ret = null;
        boolean isNull = this.isNULL(row);
        if (isNull) {
            return null;
        }
        if (this.typeSize != -1) {
            int pos = row * this.typeSize;
            int reallen = 0;
            switch (cs) {
                case UTF16BE: {
                    try {
                        ret = new String(this.m_array, pos, this.typeSize, "UTF-16BE");
                    }
                    catch (UnsupportedEncodingException e) {
                        String retMsg = ExceptionMgr.getConvertedErrorMsg("Char get with UTF16BE: UnsupportedEncodingException:[row=" + row + ", len=" + reallen + ", typeSize=" + this.typeSize + "]");
                        logger.error(retMsg);
                        ExceptionMgr.throwSQLExp(retMsg);
                    }
                    break;
                }
                case UTF16LE: {
                    try {
                        ret = new String(this.m_array, pos, this.typeSize, "UTF-16LE");
                    }
                    catch (UnsupportedEncodingException e) {
                        String retMsg = ExceptionMgr.getConvertedErrorMsg("Char get with UTF16LE: UnsupportedEncodingException:[row=" + row + ", len=" + reallen + ", typeSize=" + this.typeSize + "]");
                        logger.error(retMsg);
                        ExceptionMgr.throwSQLExp(retMsg);
                    }
                    break;
                }
                case UTF8: {
                    try {
                        ret = new String(this.m_array, pos, this.typeSize, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        String retMsg = ExceptionMgr.getConvertedErrorMsg("Char get with UTF8: UnsupportedEncodingException:[row=" + row + ", len=" + reallen + ", typeSize=" + this.typeSize + "]");
                        logger.error(retMsg);
                        ExceptionMgr.throwSQLExp(retMsg);
                    }
                    break;
                }
                case GB18030: {
                    try {
                        ret = new String(this.m_array, pos, this.typeSize, "GB18030");
                    }
                    catch (UnsupportedEncodingException e) {
                        String retMsg = ExceptionMgr.getConvertedErrorMsg("Char get with GB18030: UnsupportedEncodingException:[row=" + row + ", len=" + reallen + ", typeSize=" + this.typeSize + "]");
                        logger.error(retMsg);
                        ExceptionMgr.throwSQLExp(retMsg);
                    }
                    break;
                }
            }
        }
        return ret;
    }

    @Override
    public void arrayUpdate() throws SQLException {
    }
}

