/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.common;

import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.common.LobBuffer;
import com.bonc.xcloud.xserver.TPrimitiveType;
import com.bonc.xcloud.xserver.TResultSetMetaData;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryInfoMgr {
    private static Logger logger = LoggerFactory.getLogger(MemoryInfoMgr.class);
    private int m_buffMemory = 0;
    private int m_efftRows = 0;
    private int m_rowCapacity = 0;
    private int m_rowsCapacity = 0;
    private int m_columnBvCnt = 0;
    private int m_columnsBvCapacity = 0;
    private int m_buffMemoryTemp = 0;
    private boolean m_throwInsufficientMemoryExceptionSwitch = true;

    public MemoryInfoMgr(int buffMemory) {
        this.m_buffMemoryTemp = buffMemory;
    }

    public int getEfftRows() {
        return this.m_efftRows;
    }

    public void setEfftRows(int efftRows) {
        this.m_efftRows = efftRows;
    }

    public void setThrowInsufficientMemoryExceptionSwitch(boolean throwInsufficientMemoryExceptionSwitch) {
        this.m_throwInsufficientMemoryExceptionSwitch = throwInsufficientMemoryExceptionSwitch;
    }

    private int getRowCapacity() {
        return this.m_rowCapacity;
    }

    private int getRowsCapacity() {
        return this.m_rowsCapacity;
    }

    public int getColumnBvCnt() {
        return this.m_columnBvCnt;
    }

    private int getColumnsBvCapacity() {
        return this.m_columnsBvCapacity;
    }

    private void setRowCapacity(int rowCapacity) {
        this.m_rowCapacity = rowCapacity;
    }

    private void setRowsCapacity(int rowsCapacity) {
        this.m_rowsCapacity = rowsCapacity;
    }

    private void setColumnBvCnt(int columnBvCnt) {
        this.m_columnBvCnt = columnBvCnt;
    }

    private void setColumnsBvCapacity(int columnsBvCapacity) {
        this.m_columnsBvCapacity = columnsBvCapacity;
    }

    private void calcRowCapacity(TResultSetMetaData meta) throws SQLException {
        this.m_rowCapacity = 0;
        block6: for (int i = 0; i < meta.columndescs.size(); ++i) {
            TPrimitiveType col_type = meta.columndescs.get(i).getColtype();
            int width = meta.columndescs.get(i).getColwidth();
            switch (col_type) {
                case NULLTYPE: {
                    this.m_rowCapacity += 0;
                    continue block6;
                }
                case INTEGER: 
                case LONG: 
                case DOUBLE: 
                case CHAR: 
                case DATETIME: 
                case YMINTERVAL: 
                case DSINTERVAL: 
                case TIMESTAMP: 
                case NUMBER: {
                    this.m_rowCapacity += width;
                    continue block6;
                }
                case BLOB: 
                case CLOB: {
                    this.m_rowCapacity += LobBuffer.LOB_INLINE_SIZE + LobBuffer.LOB_INFO_SIZE + 4;
                    continue block6;
                }
                case VARCHAR: {
                    this.m_rowCapacity += width + 4;
                    continue block6;
                }
                default: {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("\nunknown type for MemoryInfoMgr to calc useful memory.");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
            }
        }
    }

    private void dealError(int columnCount) throws SQLException {
        String retMsg = ExceptionMgr.getConvertedErrorMsg("\nCalculate the effective rows but not enough memory !\nMax Memory:" + this.m_buffMemory + "\n" + "Columndesc count:" + columnCount + "\n" + "Row Capacity" + this.m_rowCapacity);
        logger.error(retMsg);
        ExceptionMgr.throwSQLExp(retMsg);
    }

    private void logInfo(int columnCount) {
        if (logger.isDebugEnabled()) {
            logger.debug("Max Memory =[" + this.m_buffMemory + "]");
            logger.debug("Columndescs size =[" + columnCount + "]");
            logger.debug("Row Capacity =[" + this.m_rowCapacity + "]");
            logger.debug("Rows Capacity =[" + this.m_rowsCapacity + "]");
            logger.debug("Column Bv Cnt =[" + this.m_columnBvCnt + "]");
            logger.debug("Columns Bv Capacity =[" + this.m_columnsBvCapacity + "]");
            logger.debug("Effective Rows =[" + this.m_efftRows + "]");
        }
    }

    private long getUnusedMemory() {
        return Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
    }

    private void dealEffectiveRowsWithAllNullColumn(TResultSetMetaData meta) throws SQLException {
        int columnCount = meta.columndescs.size();
        this.m_efftRows = 8 * this.m_buffMemory / columnCount - 8;
        if (this.m_efftRows <= 0) {
            this.dealError(columnCount);
        }
        if (this.m_efftRows > 4096) {
            this.m_efftRows = 4096;
        }
        this.m_columnBvCnt = (this.m_efftRows + 8) / 8;
        this.m_columnsBvCapacity = this.m_columnBvCnt * columnCount;
        this.m_rowsCapacity = 0;
        this.logInfo(columnCount);
    }

    public void calcEffectiveRows(TResultSetMetaData meta) throws SQLException {
        this.m_buffMemory = this.m_buffMemoryTemp;
        for (int i = 0; i < meta.columndescs.size(); ++i) {
            if (meta.columndescs.get(i).getColtype() != TPrimitiveType.VARCHAR) continue;
            this.m_buffMemory -= 4;
        }
        long unusedMem = this.getUnusedMemory();
        if ((long)this.m_buffMemory >= unusedMem) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("\nSetting BufferMemory Is Bigger Than Java Virtual Machine Total Memory!\nJava Virtual Machine Unused Memory:" + unusedMem + "\n" + "Java Virtual Machine MaxMemory :" + Runtime.getRuntime().maxMemory() + "\n" + "Java Virtual Machine totalMemory :" + Runtime.getRuntime().totalMemory() + "\n" + "Java Virtual Machine freeMemory :" + Runtime.getRuntime().freeMemory() + "\n" + "BuffMemory:" + this.m_buffMemory + "\n" + "Please Close Some Edit Window.");
            logger.error(retMsg);
            if (this.m_throwInsufficientMemoryExceptionSwitch) {
                ExceptionMgr.throwSQLExp(retMsg);
            }
        }
        this.calcRowCapacity(meta);
        if (this.m_rowCapacity == 0) {
            this.dealEffectiveRowsWithAllNullColumn(meta);
            return;
        }
        this.m_efftRows = this.m_buffMemory / this.m_rowCapacity;
        if (this.m_efftRows <= 0) {
            this.dealError(meta.columndescs.size());
        }
        this.m_rowsCapacity = this.m_rowCapacity * this.m_efftRows;
        if (this.m_rowsCapacity < 0) {
            this.dealError(meta.columndescs.size());
        }
        this.m_columnBvCnt = (this.m_efftRows + 8) / 8;
        this.m_columnsBvCapacity = this.m_columnBvCnt * meta.columndescs.size();
        int bvRowsCount = 1;
        while (this.m_rowsCapacity + this.m_columnsBvCapacity > this.m_buffMemory) {
            this.m_rowsCapacity -= this.m_rowCapacity;
            if (bvRowsCount == 8) {
                --this.m_columnBvCnt;
                this.m_columnsBvCapacity = this.m_columnBvCnt * meta.columndescs.size();
                bvRowsCount = 1;
                continue;
            }
            ++bvRowsCount;
        }
        this.m_efftRows = this.m_rowsCapacity / this.m_rowCapacity;
        if (this.m_efftRows <= 0) {
            this.dealError(meta.columndescs.size());
        }
        if (this.m_efftRows > 4096) {
            this.m_efftRows = 4096;
            this.m_rowsCapacity = this.m_rowCapacity * this.m_efftRows;
            this.m_columnBvCnt = (this.m_efftRows + 8) / 8;
            this.m_columnsBvCapacity = this.m_columnBvCnt * meta.columndescs.size();
        }
        this.logInfo(meta.columndescs.size());
    }

    public void calcEffectiveRowsExplain(TResultSetMetaData meta) throws SQLException {
        this.calcRowCapacity(meta);
        this.m_efftRows = 1;
        this.m_columnBvCnt = (this.m_efftRows + 8) / 8;
        this.m_columnsBvCapacity = this.m_columnBvCnt * meta.columndescs.size();
        this.m_rowsCapacity = this.m_rowCapacity * this.m_efftRows;
        long unusedMem = this.getUnusedMemory();
        long allCapacity = (long)this.m_rowsCapacity + (long)this.m_columnsBvCapacity;
        if (allCapacity >= unusedMem) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("\nExplain SQL Rows Capacity Is Bigger Than Java Virtual Machine Total Memory!\nJava Virtual Machine Total Memory:" + unusedMem + "\n" + "Rows Capacity:" + allCapacity + "Please Close Some Edit Window.");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        this.logInfo(meta.columndescs.size());
    }
}

