/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.common;

import com.bonc.xcloud.common.DataLocate;
import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.enumdef.CharSet;
import com.bonc.xcloud.util.NullValue;
import com.bonc.xcloud.xserver.TPrimitiveType;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalBuffer
implements DataLocate {
    private static Logger logger = LoggerFactory.getLogger(LocalBuffer.class);
    private static byte[] mask = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    protected byte[] m_array = null;
    protected byte[] m_bv = null;
    protected int m_array_length = 0;
    protected int typeSize = -1;
    protected TPrimitiveType dbType;
    protected boolean isLittleEnd = false;

    public LocalBuffer() {
    }

    public LocalBuffer(boolean isLittleEnd) {
        this.isLittleEnd = isLittleEnd;
    }

    public void AllocateArray(int data_len, int bv_len) throws SQLException {
        String retMsg;
        try {
            this.m_array = new byte[data_len];
        }
        catch (OutOfMemoryError ex) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("Allocate " + data_len + "bytes, out of Memory, try smaller fetchsize!");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        try {
            if (bv_len == 0) {
                return;
            }
            this.m_bv = new byte[bv_len];
        }
        catch (OutOfMemoryError ex) {
            retMsg = ExceptionMgr.getConvertedErrorMsg("Allocate " + bv_len + "bytes, out of Memory, try smaller fetchsize!");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
    }

    public void resizeArray(int data_len) throws SQLException {
        try {
            this.m_array = null;
            this.m_array = new byte[data_len];
        }
        catch (OutOfMemoryError ex) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("ReAllocate " + data_len + "bytes, out of Memory, try smaller fetchsize!");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
    }

    public byte[] getArray() {
        return this.m_array;
    }

    public byte[] getBV() {
        return this.m_bv;
    }

    public int getArraySize() {
        return this.m_array_length;
    }

    public void setArraySize(int length) {
        this.m_array_length = length;
    }

    public void SetDBType(TPrimitiveType tpp) {
        this.dbType = tpp;
    }

    public TPrimitiveType getDBType() {
        return this.dbType;
    }

    public void SetTypeSize(int ts) {
        this.typeSize = ts;
    }

    public int GetTypeSize() {
        return this.typeSize;
    }

    public boolean isNULL(int row) {
        boolean isnull = true;
        if (this.m_bv == null) {
            return false;
        }
        byte rowBV = this.m_bv[row / 8];
        byte maskBV = mask[row % 8];
        isnull = (rowBV & maskBV) != 0;
        return isnull;
    }

    @Override
    public int getInt(int row, boolean isLE, CharSet cs, NullValue wasNull) throws SQLException {
        return 0;
    }

    @Override
    public boolean getBool(int row, boolean isLE, CharSet cs) {
        return false;
    }

    @Override
    public char getChar(int row, boolean isLE, CharSet cs) {
        return '\u0000';
    }

    @Override
    public byte getByte(int row, boolean isLE, CharSet cs) {
        return 0;
    }

    @Override
    public short getShort(int row, boolean isLE, CharSet cs) {
        return 0;
    }

    @Override
    public long getLong(int row, boolean isLE, CharSet cs, NullValue wasNull) throws SQLException {
        return 0L;
    }

    @Override
    public double getDouble(int row, boolean isLE, CharSet cs, NullValue wasNull) throws SQLException {
        return 0.0;
    }

    @Override
    public float getFloat(int row, boolean isLE, CharSet cs) {
        return 0.0f;
    }

    public abstract void arrayUpdate() throws SQLException;

    @Override
    public abstract Object get(int var1, boolean var2, CharSet var3) throws SQLException;
}

