/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.common;

import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.common.LocalBuffer;
import com.bonc.xcloud.component.ServiceManager;
import com.bonc.xcloud.convert.ByteOrderConv;
import com.bonc.xcloud.enumdef.CharSet;
import com.bonc.xcloud.type.XCloudBLOB;
import com.bonc.xcloud.type.XCloudCLOB;
import com.bonc.xcloud.util.VarcharTypeInfo;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LobBuffer
extends LocalBuffer {
    private static Logger logger = LoggerFactory.getLogger(LobBuffer.class);
    public static int LOB_INLINE_SIZE = 4096;
    public static int LOB_INFO_SIZE = 40;
    public static int LOB_LENGTH_OFFSET = 16;
    public static int LOB_CHLENGTH_OFFSET = 8;
    public static int LOB_STORAGE_TYPE_OFFSET = 1;
    private CharSet m_cs = null;
    private LOBTYPE m_lobType = LOBTYPE.UNKNOWN;
    private ServiceManager m_serviceManager;
    private List<VarcharTypeInfo> m_posBuff = null;

    public LobBuffer(ServiceManager serviceManager, LOBTYPE lobType, int ts, boolean isLittleEnd, CharSet cs) {
        super(isLittleEnd);
        this.m_serviceManager = serviceManager;
        this.m_lobType = lobType;
        this.typeSize = ts;
        this.m_posBuff = new ArrayList<VarcharTypeInfo>();
        this.m_cs = cs;
    }

    public void CreatePosBuffer(boolean isLE) throws SQLException {
        this.m_posBuff.clear();
        int lenByte = 4;
        int count = 0;
        count = isLE ? ByteOrderConv.ConvByteToIntLE(this.m_array, 0) : ByteBuffer.wrap(this.m_array, 0, lenByte).getInt();
        int strStart = (count + 1) * lenByte;
        int pos = 0;
        int len = 0;
        for (int i = 0; i < count; ++i) {
            pos = strStart;
            len = isLE ? ByteOrderConv.ConvByteToIntLE(this.m_array, (i + 1) * lenByte) : ByteBuffer.wrap(this.m_array, (i + 1) * lenByte, lenByte).getInt();
            this.m_posBuff.add(i, new VarcharTypeInfo(pos, len));
            strStart += len;
        }
    }

    @Override
    public Object get(int row, boolean isLE, CharSet cs) throws SQLException {
        String retMsg;
        boolean isNull = this.isNULL(row);
        if (isNull) {
            return null;
        }
        VarcharTypeInfo vcharInfo = this.m_posBuff.get(row);
        int pos = vcharInfo.pos;
        int reallen = vcharInfo.len;
        LOBSTORAGETYPE lobStorageType = LOBSTORAGETYPE.UNKNOWN;
        long length = 0L;
        length = ByteOrderConv.ConvByteToLongLE(this.m_array, pos + LOB_LENGTH_OFFSET);
        long chLength = 0L;
        chLength = ByteOrderConv.ConvByteToIntLE(this.m_array, pos + LOB_CHLENGTH_OFFSET);
        byte lobType = this.m_array[pos + LOB_STORAGE_TYPE_OFFSET];
        if (1 == lobType) {
            lobStorageType = LOBSTORAGETYPE.LOCATOR;
        } else if (0 == lobType) {
            lobStorageType = LOBSTORAGETYPE.INLINE;
            pos += LOB_INFO_SIZE;
            reallen -= LOB_INFO_SIZE;
        } else {
            retMsg = ExceptionMgr.getConvertedErrorMsg("LobBuffer has wrong Lob Storage Type");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
        if (LOBTYPE.BLOB == this.m_lobType) {
            return new XCloudBLOB(this.m_array, pos, reallen, this.m_serviceManager, lobStorageType, length, chLength, cs);
        }
        if (LOBTYPE.CLOB == this.m_lobType) {
            return new XCloudCLOB(this.m_array, pos, reallen, this.m_serviceManager, lobStorageType, length, chLength, cs);
        }
        retMsg = ExceptionMgr.getConvertedErrorMsg("LobBuffer has wrong Lob Type");
        logger.error(retMsg);
        ExceptionMgr.throwSQLExp(retMsg);
        return null;
    }

    @Override
    public void arrayUpdate() throws SQLException {
        this.CreatePosBuffer(this.isLittleEnd);
    }

    public static enum LOBSTORAGETYPE {
        UNKNOWN,
        INLINE,
        LOCATOR;

    }

    public static enum LOBTYPE {
        UNKNOWN,
        BLOB,
        CLOB;

    }
}

