/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.common;

import com.bonc.xcloud.common.ConnInfoPack;
import com.bonc.xcloud.common.Counter;
import com.bonc.xcloud.common.StmtInfoPack;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionMgr {
    private static Logger logger = LoggerFactory.getLogger(ExceptionMgr.class);

    private static TExpMsg findByValue(TExpCode code, int idx) {
        TExpMsg ret = TExpMsg.JDBC_UNKNOWN;
        switch (idx) {
            case 0: {
                if (code.getValue() == TExpCode.TT_Exp.getValue()) {
                    ret = TExpMsg.TT_UNKNOWN;
                    break;
                }
                if (code.getValue() == TExpCode.TA_Exp.getValue()) {
                    ret = TExpMsg.TA_UNKNOWN;
                    break;
                }
                if (code.getValue() != TExpCode.TP_Exp.getValue()) break;
                ret = TExpMsg.TP_UNKNOWN;
                break;
            }
            case 1: {
                if (code.getValue() == TExpCode.TT_Exp.getValue()) {
                    ret = TExpMsg.TT_NOT_OPEN;
                    break;
                }
                if (code.getValue() == TExpCode.TA_Exp.getValue()) {
                    ret = TExpMsg.TA_UNKNOWN_METHOD;
                    break;
                }
                if (code.getValue() != TExpCode.TP_Exp.getValue()) break;
                ret = TExpMsg.TP_INVALID_DATA;
                break;
            }
            case 2: {
                if (code.getValue() == TExpCode.TT_Exp.getValue()) {
                    ret = TExpMsg.TT_ALREADY_OPEN;
                    break;
                }
                if (code.getValue() == TExpCode.TA_Exp.getValue()) {
                    ret = TExpMsg.TA_INVALID_MESSAGE_TYPE;
                    break;
                }
                if (code.getValue() != TExpCode.TP_Exp.getValue()) break;
                ret = TExpMsg.TP_NEGATIVE_SIZE;
                break;
            }
            case 3: {
                if (code.getValue() == TExpCode.TT_Exp.getValue()) {
                    ret = TExpMsg.TT_TIMED_OUT;
                    break;
                }
                if (code.getValue() == TExpCode.TA_Exp.getValue()) {
                    ret = TExpMsg.TA_WRONG_METHOD_NAME;
                    break;
                }
                if (code.getValue() != TExpCode.TP_Exp.getValue()) break;
                ret = TExpMsg.TP_SIZE_LIMIT;
                break;
            }
            case 4: {
                if (code.getValue() == TExpCode.TT_Exp.getValue()) {
                    ret = TExpMsg.TT_END_OF_FILE;
                    break;
                }
                if (code.getValue() == TExpCode.TA_Exp.getValue()) {
                    ret = TExpMsg.TA_BAD_SEQUENCE_ID;
                    break;
                }
                if (code.getValue() != TExpCode.TP_Exp.getValue()) break;
                ret = TExpMsg.TP_BAD_VERSION;
                break;
            }
            case 5: {
                if (code.getValue() == TExpCode.TA_Exp.getValue()) {
                    ret = TExpMsg.TA_MISSING_RESULT;
                    break;
                }
                if (code.getValue() != TExpCode.TP_Exp.getValue()) break;
                ret = TExpMsg.TP_NOT_IMPLEMENTED;
                break;
            }
            case 6: {
                if (code.getValue() != TExpCode.TA_Exp.getValue()) break;
                ret = TExpMsg.TA_INTERNAL_ERROR;
                break;
            }
            case 7: {
                if (code.getValue() != TExpCode.TA_Exp.getValue()) break;
                ret = TExpMsg.TA_PROTOCOL_ERROR;
            }
        }
        return ret;
    }

    public static void throwError(TException te, ConnInfoPack infoPack, StmtInfoPack stmtInfo) throws SQLException {
        int exceptionStatCode = 0;
        TExpCode tCode = TExpCode.JDBC_UNKNOWN;
        TExpMsg tMsg = TExpMsg.JDBC_UNKNOWN;
        String exceptionStateMsg = "JDBC_UNKNOWN";
        String SQLState = "08001";
        String expName = te.getClass().getName();
        if (te instanceof TTransportException) {
            tCode = TExpCode.TT_Exp;
            exceptionStatCode = ((TTransportException)te).getType();
        } else if (te instanceof TProtocolException) {
            tCode = TExpCode.TP_Exp;
            exceptionStatCode = ((TProtocolException)te).getType();
        } else if (te instanceof TApplicationException) {
            tCode = TExpCode.TA_Exp;
            exceptionStatCode = ((TApplicationException)te).getType();
        }
        tMsg = ExceptionMgr.findByValue(tCode, exceptionStatCode);
        String expContext = "";
        if (te.getMessage() != null && te.getMessage().length() > 0) {
            Object t = te;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            expContext = t.getMessage();
        } else {
            expContext = tMsg.getName();
        }
        String expMsg = "[Error-" + tMsg.getValue() + ":" + " DataBase didn't connected: " + expContext + "]";
        String throwMsg = null;
        throwMsg = stmtInfo == null ? ExceptionMgr.getErrorContent(Thread.currentThread().getId(), infoPack.getCurrentConnID(), infoPack.getCurrentRemoteIP(), "", expName, expMsg, "", "", infoPack.getSessionID()) : ExceptionMgr.getErrorContent(Thread.currentThread().getId(), infoPack.getCurrentConnID(), infoPack.getCurrentRemoteIP(), stmtInfo.getCurrentQueryID(), expName, expMsg, stmtInfo.getCurrentExecuteTime(), stmtInfo.getCurrentExecuteSQL(), infoPack.getSessionID());
        StringBuffer stackMsg = new StringBuffer();
        stackMsg.append("\n").append(throwMsg.toString()).append("\n");
        stackMsg.append("IP List =[\n" + infoPack.getConnInfoMsg() + "]").append("\n");
        stackMsg.append(ExceptionMgr.getStackTrace((Exception)te)).append("\n");
        logger.error(stackMsg.toString());
        ExceptionMgr.throwSQLExp(throwMsg.toString(), SQLState, te);
    }

    public static String getStackTrace(Exception ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        String exceptionAsString = sw.toString();
        if (exceptionAsString.length() == 0 && exceptionAsString == null) {
            return "Stack Trace is Empty";
        }
        return "Stack Trace=[\n" + exceptionAsString + "\n]";
    }

    public static String getConvertedErrorMsg(String msg) {
        return "JDBC error mssage =[" + msg + "]";
    }

    public static String getConvertedJDBCCallerMsg(String msg) {
        return "[Execute JDBC API] --" + msg;
    }

    public static String getConvertedThriftCallerMsg(String msg) {
        return "[Execute Thrift API] --" + msg;
    }

    public static String getConvertedThriftCallerMsg(String msg, Counter cn, ConnInfoPack infoPack, StmtInfoPack stmtInfo, RPCStatus status) {
        StringBuffer retMsg = new StringBuffer();
        long tid = Thread.currentThread().getId();
        retMsg.append("[Execute Thrift API]--");
        retMsg.append(msg);
        retMsg.append(", ");
        retMsg.append("jid:").append(tid);
        retMsg.append(",").append(infoPack.getCurrentConnID());
        retMsg.append(" ");
        if (stmtInfo != null) {
            if (stmtInfo.getCurrentQueryID() != null && stmtInfo.getCurrentQueryID().length() != 0) {
                retMsg.append("qid:").append(stmtInfo.getCurrentQueryID());
            } else {
                retMsg.append("qid:0");
            }
        } else {
            retMsg.append("qid:0");
        }
        retMsg.append(", ");
        if (infoPack.getSessionID() != null && infoPack.getSessionID().length() != 0) {
            retMsg.append("sid:").append(infoPack.getSessionID());
        } else {
            retMsg.append("sid:0");
        }
        retMsg.append(",");
        switch (status) {
            case OK: {
                retMsg.append("RPC Satus:OK");
                retMsg.append(", ");
                retMsg.append("Call Time:[").append(cn.getStartTime());
                retMsg.append(" - ").append(cn.getStopTime()).append("] ");
                retMsg.append("Elapsed:").append(cn.timeElapsed()).append("s");
                break;
            }
            case FAIL: {
                retMsg.append("RPC Satus:FAIL");
                retMsg.append(", ");
                retMsg.append("Call Time:[").append(cn.getStartTime());
                retMsg.append(" - ").append(cn.getStopTime()).append("] ");
                retMsg.append("Elapsed:").append(cn.timeElapsed()).append("s");
                break;
            }
            case ERROR: {
                retMsg.append("RPC Satus:ERROR");
                retMsg.append(", ");
                retMsg.append("Call Time:[").append(cn.getStartTime());
                retMsg.append(" - ").append(cn.getStopTime()).append("] ");
                retMsg.append("Elapsed:").append(cn.timeElapsed()).append("s");
                break;
            }
            case DIE: {
                retMsg.append("RPC Satus:DIE");
            }
        }
        return retMsg.toString();
    }

    public static void throwSQLExp(String msg) throws SQLException {
        throw new SQLException(msg);
    }

    public static void throwSQLRecoverableExp(String msg) throws SQLException {
        throw new SQLRecoverableException(msg);
    }

    public static void throwSQLExp(String msg, String sql_state, int error_code) throws SQLException {
        throw new SQLException(msg, sql_state, error_code);
    }

    private static void throwSQLExp(String msg, String sql_state, TException te) throws SQLException {
        throw new SQLException(msg, sql_state, (Throwable)te);
    }

    public static String getErrorContent(long tid, long cid, String remoteIP, String queryID, String expName, String expMsg, String exeTime, String exeSql, String sessionID) {
        StringBuffer errMsg = new StringBuffer();
        errMsg.append("RIP = [" + remoteIP + "] \n");
        errMsg.append("JID = [" + tid + "," + cid + "] \n");
        errMsg.append("QID = [" + queryID + "] \n");
        errMsg.append("SID = [" + sessionID + "] \n");
        errMsg.append("Exp = [" + expName + "]\n");
        errMsg.append("Msg = [" + expMsg + "]\n");
        errMsg.append("Exe SQL Time = [" + exeTime + "] \n");
        errMsg.append("Exe SQL = [\n" + exeSql + "]");
        return errMsg.toString();
    }

    private static enum TExpMsg {
        JDBC_UNKNOWN(999, "JDBC_UNKNOWN"),
        TT_UNKNOWN(TExpCode.TT_Exp.getValue() + 0, "UNKNOWN"),
        TT_NOT_OPEN(TExpCode.TT_Exp.getValue() + 1, "NOT_OPEN"),
        TT_ALREADY_OPEN(TExpCode.TT_Exp.getValue() + 2, "ALREADY_OPEN"),
        TT_TIMED_OUT(TExpCode.TT_Exp.getValue() + 3, "TIMED_OUT"),
        TT_END_OF_FILE(TExpCode.TT_Exp.getValue() + 4, "END_OF_FILE"),
        TA_UNKNOWN(TExpCode.TA_Exp.getValue() + 0, "UNKNOWN"),
        TA_UNKNOWN_METHOD(TExpCode.TA_Exp.getValue() + 1, "UNKNOWN_METHOD"),
        TA_INVALID_MESSAGE_TYPE(TExpCode.TA_Exp.getValue() + 2, "INVALID_MESSAGE_TYPE"),
        TA_WRONG_METHOD_NAME(TExpCode.TA_Exp.getValue() + 3, "WRONG_METHOD_NAME"),
        TA_BAD_SEQUENCE_ID(TExpCode.TA_Exp.getValue() + 4, "BAD_SEQUENCE_ID"),
        TA_MISSING_RESULT(TExpCode.TA_Exp.getValue() + 5, "MISSING_RESULT"),
        TA_INTERNAL_ERROR(TExpCode.TA_Exp.getValue() + 6, "INTERNAL_ERROR"),
        TA_PROTOCOL_ERROR(TExpCode.TA_Exp.getValue() + 7, "PROTOCOL_ERROR"),
        TP_UNKNOWN(TExpCode.TP_Exp.getValue() + 0, "UNKNOWN"),
        TP_INVALID_DATA(TExpCode.TP_Exp.getValue() + 1, "INVALID_DATA"),
        TP_NEGATIVE_SIZE(TExpCode.TP_Exp.getValue() + 2, "NEGATIVE_SIZE"),
        TP_SIZE_LIMIT(TExpCode.TP_Exp.getValue() + 3, "SIZE_LIMIT"),
        TP_BAD_VERSION(TExpCode.TP_Exp.getValue() + 4, "BAD_VERSION"),
        TP_NOT_IMPLEMENTED(TExpCode.TP_Exp.getValue() + 5, "NOT_IMPLEMENTED");

        private final int m_value;
        private final String m_name;

        private TExpMsg(int value, String name) {
            this.m_value = value;
            this.m_name = name;
        }

        public int getValue() {
            return this.m_value;
        }

        public String getName() {
            return this.m_name;
        }
    }

    private static enum TExpCode {
        JDBC_UNKNOWN(200),
        TT_Exp(210),
        TA_Exp(220),
        TP_Exp(230);

        private final int m_value;

        private TExpCode(int value) {
            this.m_value = value;
        }

        public int getValue() {
            return this.m_value;
        }
    }

    public static enum RPCStatus {
        OK,
        FAIL,
        ERROR,
        DIE;

    }
}

