/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.common;

import com.bonc.xcloud.common.BasicTypeBuffer;
import com.bonc.xcloud.common.DateTimeBuffer;
import com.bonc.xcloud.common.ExceptionMgr;
import com.bonc.xcloud.common.IntervalDSBuffer;
import com.bonc.xcloud.common.IntervalYMBuffer;
import com.bonc.xcloud.common.LobBuffer;
import com.bonc.xcloud.common.LocalBuffer;
import com.bonc.xcloud.common.NullTypeBuffer;
import com.bonc.xcloud.common.NumberBuffer;
import com.bonc.xcloud.common.StrBuffer;
import com.bonc.xcloud.common.StrVarcharBuffer;
import com.bonc.xcloud.common.TimestampBuffer;
import com.bonc.xcloud.component.ServiceManager;
import com.bonc.xcloud.enumdef.CharSet;
import com.bonc.xcloud.enumdef.CursorModeType;
import com.bonc.xcloud.util.BaseString;
import com.bonc.xcloud.util.NullValue;
import com.bonc.xcloud.util.TypeSafeTransCheck;
import com.bonc.xcloud.xserver.TPrimitiveType;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferFactory {
    private int rows;
    private int cursor;
    private int cols;
    private int typeSize;
    private CharSet serverEncode;
    private boolean isLE;
    private ServiceManager m_serviceManager = null;
    private static Logger logger = LoggerFactory.getLogger(BufferFactory.class);
    private HashMap<Integer, LocalBuffer> lbs;

    public BufferFactory(ServiceManager serviceManager) throws SQLException {
        this.rows = 0;
        this.cursor = 0;
        this.cols = 0;
        this.isLE = false;
        this.lbs = new HashMap();
        this.typeSize = 0;
        this.m_serviceManager = serviceManager;
        String se = this.m_serviceManager.getDBMeta().getLanguage_encode();
        logger.debug("BufferFactory get CharSet \uff1a " + se);
        if ("GB18030".equalsIgnoreCase(se)) {
            this.serverEncode = CharSet.GB18030;
        } else if ("UTF-8".equalsIgnoreCase(se)) {
            this.serverEncode = CharSet.UTF8;
        } else if ("UTF-16BE".equalsIgnoreCase(se)) {
            this.serverEncode = CharSet.UTF16BE;
        } else if ("UTF-16LE".equalsIgnoreCase(se)) {
            this.serverEncode = CharSet.UTF16LE;
        } else if ("UTF-16".equalsIgnoreCase(se)) {
            this.serverEncode = CharSet.UTF16;
        } else {
            ExceptionMgr.throwSQLExp("Unsupport charset! \n JDBC Driver can't support charset like " + se);
        }
    }

    public BufferFactory(ServiceManager serviceManager, boolean isLittleEnd) throws SQLException {
        this.rows = 0;
        this.cursor = 0;
        this.cols = 0;
        this.m_serviceManager = serviceManager;
        String se = this.m_serviceManager.getDBMeta().getLanguage_encode();
        logger.debug("BufferFactory get CharSet \uff1a " + se);
        if ("GB18030".equalsIgnoreCase(se)) {
            this.serverEncode = CharSet.GB18030;
        } else if ("UTF-8".equalsIgnoreCase(se)) {
            this.serverEncode = CharSet.UTF8;
        } else if ("UTF-16BE".equalsIgnoreCase(se)) {
            this.serverEncode = CharSet.UTF16BE;
        } else if ("UTF-16LE".equalsIgnoreCase(se)) {
            this.serverEncode = CharSet.UTF16LE;
        } else if ("UTF-16".equalsIgnoreCase(se)) {
            this.serverEncode = CharSet.UTF16;
        } else {
            ExceptionMgr.throwSQLExp("Unsupport charset! \n JDBC Driver can't support charset like " + se);
        }
        this.isLE = isLittleEnd;
        this.lbs = new HashMap();
        this.typeSize = 0;
    }

    public BufferFactory(CharSet se, boolean LE) {
        logger.debug("BufferFactory get CharSet \uff1a " + (Object)((Object)se));
        this.rows = 0;
        this.cursor = 0;
        this.cols = 0;
        this.serverEncode = se;
        this.isLE = LE;
        this.lbs = new HashMap();
        this.typeSize = 0;
    }

    public HashMap getBuffers() {
        return this.lbs;
    }

    public void SetServerEncode(String scode) {
        if (scode.equalsIgnoreCase("UTF-8")) {
            this.serverEncode = CharSet.UTF8;
        } else if (scode.equalsIgnoreCase("UTF-16")) {
            this.serverEncode = this.isLE ? CharSet.UTF16LE : CharSet.UTF16BE;
        } else if (scode.equalsIgnoreCase("GB18030")) {
            this.serverEncode = CharSet.GB18030;
        }
    }

    public CharSet GetServerEncode() {
        return this.serverEncode;
    }

    public void SetLE(boolean LE) {
        this.isLE = LE;
    }

    public boolean isServerLE() {
        return this.isLE;
    }

    public void SetRowCount(int rcs) {
        this.rows = rcs;
    }

    public int GetRowCount() {
        return this.rows;
    }

    public void SetCursor(int sc) {
        this.cursor = sc;
    }

    public int GetCursor() {
        return this.cursor;
    }

    public void SetTypeSize(int ts) {
        this.typeSize = ts;
    }

    public int GetTypeSize() {
        return this.typeSize;
    }

    public void moveCursor(CursorModeType cm) {
        if (cm == CursorModeType.FORWARD) {
            ++this.cursor;
        } else if (cm == CursorModeType.BACK) {
            --this.cursor;
        } else {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("Not supported other move cursor action!");
            throw new RuntimeException(retMsg);
        }
    }

    public boolean isLastRow() {
        return this.cursor == this.rows;
    }

    public void Reset() {
        this.rows = 0;
        this.cursor = 0;
        this.cols = 0;
    }

    public void produce(int colIndex, TPrimitiveType type, int colWidth) throws SQLException {
        LocalBuffer lb = null;
        boolean alreadyexist = false;
        if (this.lbs.containsKey(colIndex)) {
            alreadyexist = true;
        }
        if (alreadyexist) {
            return;
        }
        switch (type) {
            case INTEGER: 
            case DOUBLE: 
            case LONG: {
                lb = new BasicTypeBuffer(this.isLE);
                break;
            }
            case CHAR: {
                lb = new StrBuffer(colWidth, this.isLE);
                break;
            }
            case VARCHAR: {
                lb = new StrVarcharBuffer(colWidth, this.isLE);
                break;
            }
            case DATETIME: {
                lb = new DateTimeBuffer(colWidth, this.isLE);
                break;
            }
            case YMINTERVAL: {
                lb = new IntervalYMBuffer(colWidth, this.isLE);
                break;
            }
            case DSINTERVAL: {
                lb = new IntervalDSBuffer(colWidth, this.isLE);
                break;
            }
            case TIMESTAMP: {
                lb = new TimestampBuffer(colWidth, this.isLE);
                break;
            }
            case NUMBER: {
                lb = new NumberBuffer(colWidth, this.isLE);
                break;
            }
            case NULLTYPE: {
                lb = new NullTypeBuffer(this.isLE);
                break;
            }
            case BLOB: {
                lb = new LobBuffer(this.m_serviceManager, LobBuffer.LOBTYPE.BLOB, colWidth, this.isLE, this.serverEncode);
                break;
            }
            case CLOB: {
                lb = new LobBuffer(this.m_serviceManager, LobBuffer.LOBTYPE.CLOB, colWidth, this.isLE, this.serverEncode);
                break;
            }
            default: {
                String retMsg = ExceptionMgr.getConvertedJDBCCallerMsg("Type Unknown Not Support yet");
                logger.error(retMsg);
                ExceptionMgr.throwSQLExp(retMsg);
            }
        }
        lb.SetDBType(type);
        this.lbs.put(colIndex, lb);
    }

    public int getInt(int col, NullValue wasNull) throws SQLException {
        TPrimitiveType typeDB = this.lbs.get(col).getDBType();
        int ret = 0;
        switch (typeDB) {
            case INTEGER: {
                ret = this.lbs.get(col).getInt(this.cursor - 1, this.isLE, this.serverEncode, wasNull);
                break;
            }
            case LONG: {
                long tmp = this.lbs.get(col).getLong(this.cursor - 1, this.isLE, this.serverEncode, wasNull);
                TypeSafeTransCheck.safeLongInIntRange(tmp);
                ret = (int)tmp;
                break;
            }
            case DOUBLE: {
                double tmp = this.lbs.get(col).getDouble(this.cursor - 1, this.isLE, this.serverEncode, wasNull);
                TypeSafeTransCheck.safeDoubleInIntRange(tmp);
                ret = (int)tmp;
                break;
            }
            case NUMBER: {
                Object tmp = this.get(col, 2, wasNull);
                ret = ((BigDecimal)tmp).intValue();
                break;
            }
            default: {
                Object tmp = this.get(col, 4, wasNull);
                try {
                    ret = Integer.parseInt(tmp.toString());
                    break;
                }
                catch (NumberFormatException nfe) {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("Can not Transfer to Int!");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
            }
        }
        return ret;
    }

    public short getShort(int col, NullValue wasNull) throws SQLException {
        TPrimitiveType typeDB = this.lbs.get(col).getDBType();
        short ret = 0;
        switch (typeDB) {
            case INTEGER: {
                int tmp = this.lbs.get(col).getInt(this.cursor - 1, this.isLE, this.serverEncode, wasNull);
                TypeSafeTransCheck.safeIntInShortRange(tmp);
                ret = (short)tmp;
                break;
            }
            case LONG: {
                long tmp = this.lbs.get(col).getLong(this.cursor - 1, this.isLE, this.serverEncode, wasNull);
                TypeSafeTransCheck.safeLongInIntRange(tmp);
                ret = (short)tmp;
                break;
            }
            case DOUBLE: {
                double tmp = this.lbs.get(col).getDouble(this.cursor - 1, this.isLE, this.serverEncode, wasNull);
                TypeSafeTransCheck.safeDoubleInIntRange(tmp);
                ret = (short)tmp;
                break;
            }
            case NUMBER: {
                Object tmp = this.get(col, 2, wasNull);
                ret = ((BigDecimal)tmp).shortValue();
                break;
            }
            default: {
                Object tmp = this.get(col, 4, wasNull);
                try {
                    ret = Short.parseShort(tmp.toString());
                    break;
                }
                catch (NumberFormatException nfe) {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("Can not Transfer to Short!");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
            }
        }
        return ret;
    }

    public long getLong(int col, NullValue wasNull) throws SQLException {
        TPrimitiveType typeDB = this.lbs.get(col).getDBType();
        long ret = 0L;
        switch (typeDB) {
            case INTEGER: {
                int tmp = this.lbs.get(col).getInt(this.cursor - 1, this.isLE, this.serverEncode, wasNull);
                ret = tmp;
                break;
            }
            case LONG: {
                ret = this.lbs.get(col).getLong(this.cursor - 1, this.isLE, this.serverEncode, wasNull);
                break;
            }
            case DOUBLE: {
                double tmp = this.lbs.get(col).getDouble(this.cursor - 1, this.isLE, this.serverEncode, wasNull);
                TypeSafeTransCheck.safeDoubleInLongRange(tmp);
                ret = (long)tmp;
                break;
            }
            case NUMBER: {
                Object tmp = this.get(col, 2, wasNull);
                ret = ((BigDecimal)tmp).longValue();
                break;
            }
            default: {
                Object tmp = this.get(col, -5, wasNull);
                try {
                    ret = Long.parseLong(tmp.toString());
                    break;
                }
                catch (NumberFormatException nfe) {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("Can not Transfer to Long!");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
            }
        }
        return ret;
    }

    public double getDouble(int col, NullValue wasNull) throws SQLException {
        TPrimitiveType typeDB = this.lbs.get(col).getDBType();
        double ret = 0.0;
        switch (typeDB) {
            case INTEGER: {
                int tmp = this.lbs.get(col).getInt(this.cursor - 1, this.isLE, this.serverEncode, wasNull);
                ret = tmp;
                break;
            }
            case LONG: {
                long tmp = this.lbs.get(col).getLong(this.cursor - 1, this.isLE, this.serverEncode, wasNull);
                ret = tmp;
                break;
            }
            case DOUBLE: {
                ret = this.lbs.get(col).getDouble(this.cursor - 1, this.isLE, this.serverEncode, wasNull);
                break;
            }
            case NUMBER: {
                Object tmp = this.get(col, 2, wasNull);
                if (wasNull.getValue()) break;
                ret = ((BigDecimal)tmp).doubleValue();
                break;
            }
            default: {
                Object tmp = this.get(col, 8, wasNull);
                try {
                    ret = Double.parseDouble(tmp.toString());
                    break;
                }
                catch (NumberFormatException nfe) {
                    String retMsg = ExceptionMgr.getConvertedErrorMsg("Can not Transfer to Double!");
                    logger.error(retMsg);
                    ExceptionMgr.throwSQLExp(retMsg);
                }
            }
        }
        return ret;
    }

    protected final void checkColumnBounds(int columnIndex) throws SQLException {
        if (!this.lbs.containsKey(columnIndex)) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("invalid column Index");
            logger.error(retMsg);
            ExceptionMgr.throwSQLExp(retMsg);
        }
    }

    public Object get(int col, int typeOut, NullValue wasNull) throws SQLException {
        this.checkColumnBounds(col);
        LocalBuffer colBuffer = this.lbs.get(col);
        switch (colBuffer.getDBType()) {
            case INTEGER: {
                int tmpint = colBuffer.getInt(this.cursor - 1, this.isLE, this.serverEncode, wasNull);
                switch (typeOut) {
                    case 1: {
                        return Integer.toString(tmpint);
                    }
                    case 2000: {
                        return new Integer(tmpint);
                    }
                    case 2: {
                        return new BigDecimal(tmpint);
                    }
                }
                String retMsg = ExceptionMgr.getConvertedErrorMsg("Type transfer is wrong!");
                logger.error(retMsg);
                ExceptionMgr.throwSQLExp(retMsg);
            }
            case LONG: {
                long tmplong = colBuffer.getLong(this.cursor - 1, this.isLE, this.serverEncode, wasNull);
                switch (typeOut) {
                    case 1: {
                        return Long.toString(tmplong);
                    }
                    case 2000: {
                        return new Long(tmplong);
                    }
                    case 2: {
                        return new BigDecimal(tmplong);
                    }
                }
                String retMsg = ExceptionMgr.getConvertedErrorMsg("Type transfer is wrong!");
                logger.error(retMsg);
                ExceptionMgr.throwSQLExp(retMsg);
            }
            case DOUBLE: {
                double tmpdouble = colBuffer.getDouble(this.cursor - 1, this.isLE, this.serverEncode, wasNull);
                switch (typeOut) {
                    case 1: {
                        return Double.toString(tmpdouble);
                    }
                    case 2000: {
                        return new Double(tmpdouble);
                    }
                    case 2: {
                        return new BigDecimal(tmpdouble);
                    }
                }
                String retMsg = ExceptionMgr.getConvertedErrorMsg("Type transfer is wrong!");
                logger.error(retMsg);
                ExceptionMgr.throwSQLExp(retMsg);
            }
            case TIMESTAMP: {
                Object tmpo = colBuffer.get(this.cursor - 1, this.isLE, this.serverEncode);
                if (null == tmpo) {
                    wasNull.setValue(true);
                    return tmpo;
                }
                if (typeOut == 1) {
                    return ((Timestamp)tmpo).toString();
                }
                return tmpo;
            }
            case DATETIME: {
                Object tmpo = colBuffer.get(this.cursor - 1, this.isLE, this.serverEncode);
                if (null == tmpo) {
                    wasNull.setValue(true);
                    return tmpo;
                }
                if (typeOut == 1) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(((Timestamp)tmpo).getYear() + 1900).append("-").append(BaseString.toStr(((Timestamp)tmpo).getMonth() + 1)).append("-").append(BaseString.toStr(((Timestamp)tmpo).getDate())).append(" ").append(BaseString.toStr(((Timestamp)tmpo).getHours())).append(":").append(BaseString.toStr(((Timestamp)tmpo).getMinutes())).append(":").append(BaseString.toStr(((Timestamp)tmpo).getSeconds()));
                    return sb.toString();
                }
                return tmpo;
            }
            case YMINTERVAL: 
            case DSINTERVAL: 
            case NUMBER: {
                Object tmpo = colBuffer.get(this.cursor - 1, this.isLE, this.serverEncode);
                if (null == tmpo) {
                    wasNull.setValue(true);
                    return tmpo;
                }
                if (typeOut == 1) {
                    return tmpo.toString();
                }
                return tmpo;
            }
            case CHAR: 
            case VARCHAR: 
            case NULLTYPE: 
            case BLOB: 
            case CLOB: {
                Object tmpo = colBuffer.get(this.cursor - 1, this.isLE, this.serverEncode);
                if (null == tmpo) {
                    wasNull.setValue(true);
                }
                return tmpo;
            }
        }
        return null;
    }
}

